/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.ExpansionUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.Decomposition;
import chemaxon.sss.search.DuplicateCheck;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.RGroupDecomposition;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.ratom.LigandHandler;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;

public class MarkushGenerator {
    private RGroupDecomposition rgdecomp = new RGroupDecomposition();
    private Molecule[] targets = null;
    private boolean[] skipped = null;
    private DuplicateCheck duplicateChecker = null;
    public static final String NO_UNDEF_RGROUP = "The query should contain at least one undefined R-atom.";

    public MarkushGenerator() {
        this.rgdecomp.setSearchOptions(new MolSearchOptions(4));
        this.rgdecomp.setAttachmentType(1);
    }

    public void setSearchOptions(SearchOptions options) {
        this.rgdecomp.setSearchOptions(options);
    }

    public MolSearchOptions getSearchOptions() {
        return this.rgdecomp.getSearchOptions();
    }

    public void setStandardizer(Standardizer st, boolean bq, boolean bt) {
        this.rgdecomp.setStandardizer(st, bq, bt);
    }

    public void setQuery(Molecule query) throws SearchException, IllegalArgumentException {
        if (!SearchUtil.hasUndefinedRAtom(query)) {
            throw new SearchException(NO_UNDEF_RGROUP);
        }
        if (ExpansionUtil.containsMulticenter(query) || ExpansionUtil.containsLinkNode(query) || ExpansionUtil.containsRepeatingUnit(query)) {
            throw new IllegalArgumentException("Markush query is not handled by MarkushGenerator.");
        }
        this.rgdecomp.setQuery(query);
        this.skipped = null;
    }

    public Molecule getQuery() {
        return this.rgdecomp.getQuery();
    }

    public void setTargets(Molecule[] targets) {
        this.targets = targets;
        this.skipped = null;
    }

    public Molecule[] getTargets() {
        if (this.targets == null) {
            return null;
        }
        Molecule[] res = new Molecule[this.targets.length];
        System.arraycopy(this.targets, 0, res, 0, this.targets.length);
        return res;
    }

    public RgMolecule generate() throws SearchException {
        this.skipped = new boolean[this.targets.length];
        RgMolecule rgmol = null;
        Molecule query = this.rgdecomp.getRGroupedQuery();
        if (query instanceof RgMolecule) {
            rgmol = (RgMolecule)query.clone();
        } else {
            rgmol = new RgMolecule();
            rgmol.setRoot(query);
        }
        boolean cleanNeeded = false;
        for (int t = 0; t < this.targets.length; ++t) {
            if (this.targets[t].getDim() == 0) {
                cleanNeeded = true;
            }
            this.rgdecomp.setTarget(this.targets[t]);
            Decomposition decomp = this.rgdecomp.findDecomposition();
            if (decomp == null) {
                this.skipped[t] = true;
                continue;
            }
            Molecule[] rligands = decomp.getLigands();
            for (int i = 0; i < rligands.length; ++i) {
                if (rligands[i] == null) continue;
                assert (query.getAtom(i).getAtno() == 134);
                int rid = query.getAtom(i).getRgroup();
                assert (rid > 0);
                if (LigandHandler.isHLigand(rligands[i])) {
                    MarkushGenerator.fixHCharge(rligands[i]);
                }
                this.addRgroupMember(rgmol, rid, rligands[i]);
            }
        }
        if (cleanNeeded) {
            Cleaner.clean(rgmol, 2, null);
        } else {
            CleanUtil.arrangeComponents(rgmol);
        }
        return rgmol;
    }

    private static void fixHCharge(MoleculeGraph mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            if (mol.getAtom(i).getAtno() != 1) continue;
            mol.getAtom(i).setCharge(0);
        }
    }

    private boolean addRgroupMember(RgMolecule rgmol, int rid, Molecule member) throws SearchException {
        if (this.duplicateChecker == null) {
            this.duplicateChecker = new DuplicateCheck();
        }
        if (this.duplicateChecker.containsRgroupMember(rgmol, rid, member)) {
            return false;
        }
        rgmol.addRgroup(rid, member);
        return true;
    }

    public int[] getSkippedTargetIndexes() {
        if (this.skipped == null) {
            return null;
        }
        IntVector v = new IntVector();
        for (int i = 0; i < this.skipped.length; ++i) {
            if (!this.skipped[i]) continue;
            v.add(i);
        }
        return v.toArray();
    }
}

