/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchOptions;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;

public class MarkushMCSSearch
extends HomologySGSearch {
    private int imagIndex = Integer.MAX_VALUE;
    private long lowestPenalty = Long.MAX_VALUE;
    private int[] graphUnionWalkLenV = null;
    private final int imagAtomPenalty = 30;
    private ArrayList<SearchHit> hitList = null;
    private int lastHitInd = -1;
    private final boolean isCheckingCommutativity = false;
    private final float maxPropOfNonMatched = 0.3f;

    public MarkushMCSSearch() {
        this.isZeroLineProhibited = true;
    }

    @Override
    public void setQuery(Molecule mol) {
        this.init();
        super.setQuery(mol);
    }

    @Override
    public void setTarget(Molecule mol) {
        this.init();
        super.setTarget(mol);
    }

    @Override
    public void setSearchOptions(SearchOptions options) {
        super.setSearchOptions(options);
        this.searchOptions.setSearchType(2);
        this.searchOptions.setKeepQueryOrder(true);
    }

    @Override
    protected SearchHit findFirstHit() throws SearchException {
        this.init();
        SearchHit hit = null;
        this.hitList = new ArrayList();
        while ((hit = super.findNextHit()) != null) {
            this.hitList.add(hit);
        }
        if (this.hitList.size() == 0) {
            return null;
        }
        this.lastHitInd = this.hitList.size() - 1;
        return this.hitList.get(this.lastHitInd);
    }

    @Override
    protected SearchHit findNextHit() throws SearchException {
        if (this.hitList == null) {
            return this.findFirst0();
        }
        if (this.lastHitInd > 0) {
            return this.hitList.get(--this.lastHitInd);
        }
        return null;
    }

    @Override
    protected SearchHit[] findAllHits() throws SearchException {
        this.findFirstHit();
        SearchHit[] hits = new SearchHit[this.hitList.size()];
        for (int i = 0; i < this.hitList.size(); ++i) {
            hits[i] = this.hitList.get(i);
        }
        return hits;
    }

    @Override
    protected void clearRowColumn(int qAtom, int tAtom) {
        boolean targetHgOrMCS = this.isHomologyAtom(tAtom) || tAtom == this.imagIndex;
        boolean queryHg = this.isOtherAtomHomology(qAtom);
        if (!queryHg) {
            this.map.clearRowExcept(qAtom, tAtom);
        }
        if (!targetHgOrMCS) {
            this.map.clearColumnExcept(qAtom, tAtom);
        }
    }

    @Override
    protected void initMaps() throws SearchException {
        ++this.strAtoms;
        this.imagIndex = this.strAtoms - 1;
        super.initMaps();
    }

    private void init() {
        this.lowestPenalty = Long.MAX_VALUE;
        this.graphUnionWalkLenV = null;
        this.hitList = null;
    }

    @Override
    protected boolean statCheck() {
        return true;
    }

    @Override
    protected boolean compareHydrogens(int queryAtom, int targetAtom) {
        return true;
    }

    @Override
    protected boolean compareAtoms(int queryAtom, int targetAtom) throws SearchException {
        if (targetAtom == this.imagIndex) {
            return true;
        }
        return super.compareAtoms(queryAtom, targetAtom);
    }

    @Override
    protected int getUserDefParent(int t) {
        if (t == this.imagIndex) {
            return -1;
        }
        return super.getUserDefParent(t);
    }

    @Override
    protected boolean isUnMappableHit(int i) {
        if (i == this.imagIndex) {
            return true;
        }
        return super.isUnMappableHit(i);
    }

    @Override
    public boolean canBeNonMapped(int currAtom) {
        return this.map.getMap(currAtom, this.imagIndex);
    }

    @Override
    protected boolean findNextSNforThisQN(int d) {
        if (super.findNextSNforThisQN(d)) {
            long penalty;
            if (!this.isCommutativityOK()) {
                this.map.clearMap(d, this.idx[d]);
            }
            if (this.lowestPenalty > (penalty = this.getPenaltyOfMap()) && (float)penalty < (float)(this.qryAtoms * 30) * 0.3f) {
                return true;
            }
            this.map.clearMap(d, this.idx[d]);
            return true;
        }
        return false;
    }

    private boolean isCommutativityOK() {
        return true;
    }

    @Override
    protected boolean isCompatibleIdx(int d) {
        if (this.idx[d] == this.imagIndex) {
            return true;
        }
        return super.isCompatibleIdx(d);
    }

    @Override
    protected boolean canSkipCTChecking(int ta1, int ta2, int ta3, int ta4) {
        if (ta2 == this.imagIndex || ta3 == this.imagIndex || ta1 == this.imagIndex || ta4 == this.imagIndex) {
            return true;
        }
        return super.canSkipCTChecking(ta1, ta2, ta3, ta4);
    }

    private long getPenaltyOfMap() {
        int i;
        long penalty = 0L;
        for (i = 0; i < this.depth; ++i) {
            penalty += this.getPenalty(this.idx[i] - 1);
        }
        if (this.depth < this.sub.matomLength) {
            penalty += this.getPenalty(this.idx[this.depth]);
        }
        for (i = this.depth + 1; i < this.sub.matomLength; ++i) {
            long atomPenalty = 30L;
            for (int t = 0; t < this.matomLength; ++t) {
                long p;
                if (!this.map.getMap(i, t) || (p = this.getPenalty(t)) >= atomPenalty) continue;
                atomPenalty = p;
            }
            penalty += atomPenalty;
        }
        return penalty;
    }

    @Override
    protected boolean isValidHit(SearchHit hit) throws SearchException {
        long penalty = this.getPenaltyOfMap();
        if (penalty >= this.lowestPenalty) {
            return false;
        }
        boolean validationRes = super.isValidHit(hit);
        if (validationRes) {
            this.lowestPenalty = penalty;
        }
        return validationRes;
    }

    private long getPenalty(int i) {
        if (i == this.imagIndex) {
            return 30L;
        }
        if (this.graphUnionWalkLenV == null) {
            this.graphUnionWalkLenV = new int[this.matomLength];
            Arrays.fill(this.graphUnionWalkLenV, -1);
        }
        if (this.graphUnionWalkLenV[i] == -1) {
            int sgIndex = this.atomIdxInAtomsArray[i];
            this.graphUnionWalkLenV[i] = this.sg.getGraphUnionWalk(sgIndex).length - 1;
        }
        return this.graphUnionWalkLenV[i];
    }

    @Override
    protected boolean testNode(int i, int j) throws SearchException {
        boolean mapHasChanged = false;
        if (j == this.imagIndex) {
            return false;
        }
        int qi = this.sub.bondidx[i];
        int si = this.bondidx[j];
        int hashCode = this.abonds[j] < 16 ? this.sub.abonds[i] * 16 + this.abonds[j] : -1;
        switch (hashCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
            case 17: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.isMappableToHomology(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 18: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.isMappableToHomology(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 19: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.areCompatibleBondsAndMapped(qi, si + 2) || this.isMappableToHomology(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            case 20: {
                if (this.areCompatibleBondsAndMapped(qi, si) || this.areCompatibleBondsAndMapped(qi, si + 1) || this.areCompatibleBondsAndMapped(qi, si + 2) || this.areCompatibleBondsAndMapped(qi, si + 3) || this.isMappableToHomology(this.sub.bto[qi], j)) break;
                mapHasChanged = true;
                this.map.clearMap(i, j);
                break;
            }
            default: {
                int dep = 0;
                boolean notFinishedBacktrack = true;
                Arrays.fill(this.sub.ind, 0);
                Arrays.fill(this.usd, 0, this.usdLength, false);
                boolean found = false;
                while (notFinishedBacktrack) {
                    if (dep < this.sub.abonds[i]) {
                        if (this.sub.ind[dep] < this.usdLength) {
                            if (this.isMappableToHomology(this.sub.bto[qi + dep], j)) {
                                this.sub.ind[dep] = this.usdLength;
                                found = true;
                            } else {
                                found = false;
                                while (!found && this.sub.ind[dep] < this.abonds[j]) {
                                    found = !this.usd[this.sub.ind[dep]] && this.areCompatibleBondsAndMapped(qi + dep, si + this.sub.ind[dep]) && this.isCompatibleWithTheRest(dep, si, this.bto[si + this.sub.ind[dep]]);
                                    int n = dep;
                                    this.sub.ind[n] = this.sub.ind[n] + 1;
                                }
                            }
                            if (!found && this.map.getMap(this.sub.bto[qi + dep], this.imagIndex) && this.hasOtherNeighNotMatchedToMCS(i, qi, dep, j)) {
                                this.sub.ind[dep] = this.usdLength;
                                found = true;
                            }
                        }
                        if (found) {
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] - 1;
                            this.usd[this.sub.ind[dep]] = true;
                            ++dep;
                            continue;
                        }
                        this.sub.ind[dep] = 0;
                        if (--dep >= 0) {
                            this.usd[this.sub.ind[dep]] = false;
                            int n = dep;
                            this.sub.ind[n] = this.sub.ind[n] + 1;
                            continue;
                        }
                        this.map.clearMap(i, j);
                        mapHasChanged = true;
                        notFinishedBacktrack = false;
                        continue;
                    }
                    notFinishedBacktrack = false;
                }
                break block0;
            }
        }
        if (!this.map.getMap(i, j) && this.isHomologyAtom(j)) {
            this.homologyMatchers[j].prohibitMatching(i);
        }
        return mapHasChanged;
    }

    private boolean hasOtherNeighNotMatchedToMCS(int q, int qi, int d, int t) {
        for (int n = 0; n < this.sub.abonds[q]; ++n) {
            if ((this.sub.ind[n] == this.usdLength - 1 || n == d) && !this.isMappableToHomology(this.sub.bto[qi + n], t)) continue;
            return true;
        }
        return false;
    }

    private boolean isMappableToHomology(int q, int t) {
        return this.isHomologyAtom(t) && this.map.getMap(q, t);
    }

    private boolean isMappableToMCSAtom(int q) {
        return this.map.getMap(q, this.imagIndex);
    }

    @Override
    protected boolean checkMapOfMatched() {
        for (int i = 0; i < this.depth; ++i) {
            if (this.map.getMap(i, this.idx[i] - 1) || this.isMappableToMCSAtom(i)) continue;
            this.foundZeroLineInMap = true;
            return false;
        }
        return true;
    }
}

