/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.SearchConstants;
import java.io.Serializable;
import java.security.InvalidParameterException;

public class MatchCountOptions
implements Serializable,
SearchConstants {
    boolean matchCountIncludesZero;
    int mode;
    int matchCountLowLimit;
    int matchCountHighLimit;
    boolean matchCountLowLimitInclusive;
    boolean matchCountHighLimitInclusive;
    int matchCounthitLimit;
    String matchCountRelation;
    static String optionSeparator = "_";

    public MatchCountOptions(int hitLimitLow, boolean isLowerLimitIncluded, int hitLimitHigh, boolean isHigherLimitIncluded) {
        this.mode = 0;
        this.matchCountLowLimit = hitLimitLow;
        this.matchCountHighLimit = hitLimitHigh;
        this.matchCountLowLimitInclusive = isLowerLimitIncluded;
        this.matchCountHighLimitInclusive = isHigherLimitIncluded;
        int hl = hitLimitLow;
        int hh = hitLimitHigh;
        if (!isLowerLimitIncluded) {
            ++hl;
        }
        if (!isHigherLimitIncluded && hh != Integer.MAX_VALUE) {
            --hh;
        }
        this.matchCountIncludesZero = hl <= 0 && 0 <= hh;
    }

    public MatchCountOptions(String relation, int hitLimit) {
        this.mode = 1;
        this.matchCountRelation = relation;
        this.matchCounthitLimit = hitLimit;
        if (relation.equals("=")) {
            this.matchCountIncludesZero = hitLimit == 0;
        } else if (relation.equals("<")) {
            this.matchCountIncludesZero = hitLimit > 0;
        } else if (relation.equals(">")) {
            this.matchCountIncludesZero = hitLimit < 0;
        } else if (relation.equals("<=")) {
            this.matchCountIncludesZero = hitLimit >= 0;
        } else if (relation.equals(">=")) {
            this.matchCountIncludesZero = hitLimit <= 0;
        }
    }

    public int getMatchCountHighLimit() {
        return this.matchCountHighLimit;
    }

    public void setMatchCountHighLimit(int matchCountHighLimit) {
        this.matchCountHighLimit = matchCountHighLimit;
    }

    public boolean isMatchCountHighLimitInclusive() {
        return this.matchCountHighLimitInclusive;
    }

    public void setMatchCountHighLimitInclusive(boolean matchCountHighLimitInclusive) {
        this.matchCountHighLimitInclusive = matchCountHighLimitInclusive;
    }

    public int getMatchCounthitLimit() {
        return this.matchCounthitLimit;
    }

    public void setMatchCounthitLimit(int matchCounthitLimit) {
        this.matchCounthitLimit = matchCounthitLimit;
    }

    public boolean isMatchCountIncludesZero() {
        return this.matchCountIncludesZero;
    }

    public void setMatchCountIncludesZero(boolean matchCountIncludesZero) {
        this.matchCountIncludesZero = matchCountIncludesZero;
    }

    public int getMatchCountLowLimit() {
        return this.matchCountLowLimit;
    }

    public void setMatchCountLowLimit(int matchCountLowLimit) {
        this.matchCountLowLimit = matchCountLowLimit;
    }

    public boolean isMatchCountLowLimitInclusive() {
        return this.matchCountLowLimitInclusive;
    }

    public void setMatchCountLowLimitInclusive(boolean matchCountLowLimitInclusive) {
        this.matchCountLowLimitInclusive = matchCountLowLimitInclusive;
    }

    public int getMode() {
        return this.mode;
    }

    public String getMatchCountRelation() {
        return this.matchCountRelation;
    }

    public void setMatchCountRelation(String matchCountRelation) {
        this.matchCountRelation = matchCountRelation;
    }

    public String toString() {
        switch (this.mode) {
            case 0: {
                return this.matchCountLowLimit + optionSeparator + this.matchCountLowLimitInclusive + optionSeparator + this.matchCountHighLimit + optionSeparator + this.matchCountHighLimitInclusive;
            }
            case 1: {
                return this.matchCountRelation + optionSeparator + this.matchCounthitLimit;
            }
        }
        throw new InvalidParameterException("Unknown match count mode!");
    }
}

