/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.ExpansionUtil;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.formats.MolFormatException;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.Standardizer;
import chemaxon.jep.context.SearchContext;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.MarkushMCSSearch;
import chemaxon.sss.search.MarkushPerfectSearch;
import chemaxon.sss.search.MarkushSGSearch;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.RGroupDecomposition;
import chemaxon.sss.search.ReactionSearch;
import chemaxon.sss.search.RgSearch;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.StructureSearch;
import chemaxon.sss.search.TautomerUtil;
import chemaxon.sss.search.UndefinedRAtomSearch;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.Dumper;
import chemaxon.util.MolHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MolSearch
extends Search
implements Licensable {
    private static final int UKNOWN_SEARCH_MODE = 0;
    private static final int SUBSTRUCTURE_SEARCH_MODE = 1;
    private static final int RGROUP_SEARCH_MODE = 2;
    private static final int REACTION_SEARCH_MODE = 3;
    private static final int MARKUSH_SEARCH_MODE = 4;
    private static final int MARKUSH_DUPLICATE_SEARCH_MODE = 5;
    private static final int MARKUSH_HOMOLOGY_SEARCH_MODE = 6;
    private static final int HOMOLOGY_QUERY_SEARCH_MODE = 7;
    private static final int UNDEFINED_RATOM_SEARCH_MODE = 8;
    private static final int MARKUSH_MCS_SEARCH_MODE = 9;
    private int searchMode = 0;
    private boolean queryInitialized = false;
    private boolean targetInitialized = false;
    private boolean parametersInitialized = false;
    private boolean searcherInitialized = false;
    private Molecule target;
    private Molecule query;
    private String queryAsString = "";
    private int[] excludedTargetAtoms;
    private int[] excludedQueryAtoms;
    private RgSearch rgSearch;
    private ReactionSearch reactionSearch;
    private StructureSearch structureSearch;
    private MarkushSGSearch markushSearch = null;
    private StructureSearch markushPerfectSearch = null;
    private HomologySGSearch markushHomologySearch = null;
    private UndefinedRAtomSearch undefinedRAtomSearch = null;
    private MarkushMCSSearch markushMCSSearch = null;
    private Search searcher;
    private boolean prevSuperstructureSearch = false;
    private String filteringExpression = null;
    private SearchContext filteringContext = null;
    private ChemJEP filteringJEP = null;
    private Evaluator filteringEvaluator = null;
    private int filteringLevel = 0;
    private boolean filteringOK = true;
    private boolean filterInitialized = false;
    private SearchEnumerator molEnum = null;
    private Molecule nextQuery = null;
    private chemaxon.reaction.Standardizer standardizer = null;
    private File evaluatorConfig = null;
    protected boolean isQueryStandardizable = false;
    protected boolean isTargetStandardizable = false;
    protected boolean isOrigTargetMayBeMarkush = true;
    private Molecule unStandardizedTarget = null;
    private boolean isQueryEnumerable = false;
    private boolean findFirstState = true;
    private String licenseEnvironment = "";
    private boolean isQueryInString = false;
    private static final Logger logger = Logger.getLogger(MolSearch.class.getName());
    private boolean isTautomerDuplicateFiltering = false;
    private Molecule enumQuery;
    private int elapsedTime = 0;

    @Override
    public void setTarget(Molecule mol) {
        if (mol == null) {
            this.unStandardizedTarget = mol;
            this.target = mol;
            if (this.searcher != null) {
                if (this.searchOptions.isSuperstructureSearch()) {
                    this.searcher.setQuery(mol);
                } else {
                    this.searcher.setTarget(mol);
                }
            }
        } else {
            this.unStandardizedTarget = mol.getSimplifiedMolecule();
            this.target = null;
        }
        this.clearMatch();
        this.excludedTargetAtoms = null;
        this.targetInitialized = false;
        this.findFirstState = true;
    }

    @Override
    public void setTarget(Molecule mol, int[] exclude) {
        this.setTarget(mol);
        this.excludedTargetAtoms = exclude;
    }

    @Override
    public Molecule getTarget() {
        return this.unStandardizedTarget;
    }

    @Override
    public void setQuery(Molecule mol) {
        this.checkLicense();
        this.query = mol.getSimplifiedMolecule();
        this.isQueryInString = false;
        this.resetPreconditions();
    }

    private void resetPreconditions() {
        this.clearMatch();
        this.excludedQueryAtoms = null;
        this.queryInitialized = false;
        this.findFirstState = true;
    }

    @Override
    public void setQuery(Molecule mol, int[] exclude) {
        this.setQuery(mol);
        this.excludedQueryAtoms = exclude;
    }

    @Override
    public Molecule getQuery() {
        return this.query;
    }

    public void setQuery(String queryString) {
        this.queryAsString = queryString;
        this.isQueryInString = true;
        this.resetPreconditions();
    }

    public void setStandardizer(chemaxon.reaction.Standardizer st, boolean bq, boolean bt) {
        this.standardizer = st;
        this.isQueryStandardizable = bq;
        this.isTargetStandardizable = bt;
    }

    public void setFilterConfig(File config) throws SearchException {
        this.evaluatorConfig = config;
    }

    public void setFilter(String filteringExpression) throws SearchException {
        this.filteringExpression = filteringExpression;
        this.filteringLevel = 0;
        this.filteringContext = null;
        this.filteringJEP = null;
        this.filterInitialized = false;
    }

    public String getFilter() {
        return this.filteringExpression;
    }

    public void setSearchOptions(MolSearchOptions options) {
        if (options.isHitIncludesRNodes() != this.searchOptions.isHitIncludesRNodes()) {
            this.parametersInitialized = false;
        }
        options.clonecopy(this.searchOptions);
    }

    @Override
    public Molecule getMatchingQuery() {
        if (this.searchOptions.isSuperstructureSearch()) {
            return this.query;
        }
        if (this.nextQuery != null) {
            return this.nextQuery;
        }
        return this.query;
    }

    public Molecule getMatchingTarget() {
        if (this.searchOptions.isSuperstructureSearch()) {
            if (this.nextQuery == null) {
                return this.target;
            }
            return this.nextQuery;
        }
        return this.target;
    }

    public void addComparator(MolComparator mc) {
        this.searchOptions.addUserComparator(mc);
    }

    public void removeComparator(MolComparator mc) {
        this.searchOptions.deleteUserComparator(mc);
    }

    public void clearComparators() {
        this.searchOptions.deleteAllUserComparators();
    }

    private void checkTautomerStandardization() {
        if (this.searchOptions.getTautomerSearch() == 1) {
            this.isQueryStandardizable = true;
        }
    }

    protected boolean hasFilter() {
        return this.hasHitFilter() || this.filteringExpression != null;
    }

    protected boolean hasHitFilter() {
        return this.filteringLevel == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMatching() throws SearchException {
        try {
            if (this.hasFilter()) {
                if (this.findFirst() == null) return false;
                return true;
            }
            if (!this.initSearch()) return false;
            if (!this.isEnumInitializedOk()) {
                return false;
            }
            try {
                while (true) {
                    long startTime = this.changeSearchersTimeoutByElapsed();
                    if (this.searcher.isMatching()) {
                        boolean bl = true;
                        return bl;
                    }
                    this.incrementElapsedTime(startTime);
                    if (!this.stepEnumeration()) {
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                    break;
                }
            }
            catch (SearchException se) {
                throw se;
            }
            catch (LicenseException le) {
                throw le;
            }
            catch (Exception e) {
                throw this.getWrapperSearchException(e);
            }
            finally {
                this.resetElapsedTime();
            }
        }
        catch (SearchException se) {
            throw se;
        }
        catch (LicenseException le) {
            throw le;
        }
        catch (Exception e) {
            throw this.getWrapperSearchException(e);
        }
    }

    private SearchException getWrapperSearchException(Exception e) {
        String message = "An error occured during search:" + e.toString() + "\n";
        this.logException(logger, message);
        String exceptionMessage = message + "\nQuery:" + MolSearch.getShortString(this.getQueryToPrint(), true) + "\n  Target:" + MolSearch.getShortString(this.getTargetToPrint(), false);
        return new SearchException(exceptionMessage, e);
    }

    @Override
    public SearchHit findFirstHit() throws SearchException {
        try {
            this.findFirstState = false;
            SearchHit hit = null;
            if (this.initSearch()) {
                hit = this.findNextFilteredHit(true);
            }
            return hit;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (LicenseException le) {
            throw le;
        }
        catch (Exception e) {
            throw this.getWrapperSearchException(e);
        }
    }

    @Override
    public SearchHit findNextHit() throws SearchException {
        try {
            SearchHit hit = null;
            if (this.initSearch()) {
                hit = this.findNextFilteredHit(this.findFirstState);
            }
            this.findFirstState = false;
            return hit;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (LicenseException le) {
            throw le;
        }
        catch (Exception e) {
            throw this.getWrapperSearchException(e);
        }
    }

    @Override
    public SearchHit[] findAllHits() throws SearchException {
        try {
            SearchHit[] hits = null;
            if (this.initSearch()) {
                ArrayList<SearchHit> v = new ArrayList<SearchHit>();
                SearchHit hit = this.findFirstHit();
                while (hit != null) {
                    v.add(hit);
                    hit = this.findNextHit();
                }
                if (v.size() > 0) {
                    hits = new SearchHit[v.size()];
                    hits = v.toArray(hits);
                }
            }
            return hits;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (LicenseException le) {
            throw le;
        }
        catch (Exception e) {
            throw this.getWrapperSearchException(e);
        }
    }

    @Override
    public void stop() {
        if (this.searcher != null) {
            this.searcher.stop();
        }
    }

    private SearchHit findNextFilteredHit(boolean first) throws SearchException {
        SearchHit hit = null;
        if (this.filteringOK) {
            if (first && !this.isEnumInitializedOk()) {
                return null;
            }
            hit = this.findNextEnumeratedHit(first);
            if (this.hasHitFilter()) {
                while (!this.filter(hit)) {
                    hit = this.findNextEnumeratedHit(false);
                }
            }
        }
        return hit;
    }

    private boolean isEnumInitializedOk() throws SearchException {
        boolean enumOk = true;
        if (this.isQueryEnumerable) {
            this.molEnum = new SearchEnumerator(this.getEnumerationOption(), this.enumQuery);
            this.setStoringNonEnumIfNeeded();
            if (this.molEnum.hasMoreElements()) {
                this.nextQuery = this.molEnum.nextElement();
                this.nextQuery = this.standardize(this.nextQuery, true);
                this.standardizeNonEnum();
                this.setEnumerated();
            } else {
                enumOk = false;
                this.molEnum = null;
                this.nextQuery = this.query;
            }
        } else {
            this.molEnum = null;
        }
        return enumOk;
    }

    private void setStoringNonEnumIfNeeded() {
        if (this.searchOptions.getVagueBondLevel() >= 2 && this.searchOptions.getCheckSpHyb()) {
            this.molEnum.setOrigNeeded(true);
        }
    }

    private void standardizeNonEnum() throws SearchException {
        if (this.molEnum != null && this.molEnum.isOrigNeeded() && this.nextQuery.getPropertyObject("nonEnumeratedMol") != null) {
            Molecule nonEnum = (Molecule)this.nextQuery.getPropertyObject("nonEnumeratedMol");
            nonEnum = this.standardize(nonEnum, true);
            this.nextQuery.setPropertyObject("nonEnumeratedMol", nonEnum);
        }
    }

    private Molecule standardize(Molecule molecule, boolean isQuery) throws SearchException {
        Molecule newMol = molecule;
        if (isQuery && !this.isQueryStandardizable) {
            return newMol;
        }
        if (!isQuery && !this.isTargetStandardizable) {
            return newMol;
        }
        if (!isQuery || this.searchOptions.getSearchType() == 5) {
            newMol = this.standardizeTarget(molecule);
        } else {
            newMol = (Molecule)molecule.clone();
            if (this.standardizer == null) {
                newMol.aromatize();
            } else {
                this.standardizer.setActiveGroup("query");
                this.standardizer.setInactiveTasks("removeexplicith");
                this.standardizer.standardize(newMol);
            }
        }
        return newMol;
    }

    private Molecule standardizeTarget(Molecule molecule) throws SearchException {
        Molecule newMol;
        if (molecule instanceof Supergraph) {
            return molecule;
        }
        if (this.searchOptions.isMarkushEnabled() && Supergraph.isMarkushMolecule(molecule)) {
            MarkushAromata ma = new MarkushAromata();
            newMol = (Molecule)molecule.clone();
            int[][] ambigRings = ma.aromatize(newMol);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Markush aromatization: ambiguous rings: " + Dumper.dumpIntIntArray(ambigRings));
            }
        } else {
            newMol = (Molecule)molecule.clone();
            if (this.standardizer == null) {
                newMol.aromatize();
            } else {
                this.standardizer.setActiveGroup("target");
                this.standardizer.standardize(newMol);
            }
        }
        return newMol;
    }

    private SearchHit findNextEnumeratedHit(boolean first) throws SearchException {
        try {
            while (true) {
                SearchHit hit;
                long startTime = this.changeSearchersTimeoutByElapsed();
                if (first) {
                    hit = this.searcher.findFirstHit();
                    first = false;
                } else {
                    hit = this.searcher.findNextHit();
                }
                this.incrementElapsedTime(startTime);
                if (hit != null) {
                    SearchHit searchHit = hit;
                    return searchHit;
                }
                if (this.stepEnumeration()) continue;
                SearchHit searchHit = null;
                return searchHit;
            }
        }
        finally {
            this.resetElapsedTime();
        }
    }

    private void resetElapsedTime() {
        this.elapsedTime = 0;
    }

    private void incrementElapsedTime(long startTime) {
        this.elapsedTime = (int)((long)this.elapsedTime + (System.currentTimeMillis() - startTime));
    }

    private long changeSearchersTimeoutByElapsed() {
        long startTime = System.currentTimeMillis();
        this.searcher.getSearchOptions().setTimeoutLimitMilliseconds(this.searchOptions.getTimeoutLimitMilliseconds() - this.elapsedTime);
        return startTime;
    }

    private boolean stepEnumeration() throws SearchException {
        if (this.molEnum == null || !this.molEnum.hasMoreElements()) {
            return false;
        }
        this.nextQuery = this.molEnum.nextElement();
        this.nextQuery = this.standardize(this.nextQuery, true);
        this.setEnumerated();
        return true;
    }

    private void setEnumerated() throws SearchException {
        int[] exQ = this.searchOptions.isSuperstructureSearch() ? this.excludedTargetAtoms : this.excludedQueryAtoms;
        this.setNextQueryInSearcher(exQ);
        if (this.searchOptions.verbose) {
            try {
                System.err.println("Next enumerated: " + this.nextQuery.toFormat("cxsmarts"));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Next enumerated: " + this.nextQuery.toFormat("mrv"));
            }
        }
    }

    private void setNextQueryInSearcher(int[] exQ) throws SearchException {
        Molecule searcherQuery = this.nextQuery;
        int savePreMatchLength = this.searcher.preMatchLength;
        int[] savePreMatchQueryAtoms = this.searcher.preMatchQueryAtoms;
        int[] savePreMatchTargetAtoms = this.searcher.preMatchTargetAtoms;
        this.searcher.setQuery(searcherQuery, exQ);
        this.searcher.preMatchLength = savePreMatchLength;
        this.searcher.preMatchQueryAtoms = savePreMatchQueryAtoms;
        this.searcher.preMatchTargetAtoms = savePreMatchTargetAtoms;
    }

    private int selectSearchMode() throws SearchException {
        boolean handleQHomology;
        int st = this.searchOptions.getSearchType();
        int undefRAtom = this.searchOptions.getUndefinedRAtom();
        if (this.searchOptions.getSearchType() == 8) {
            return 9;
        }
        Molecule q = !this.searchOptions.isSuperstructureSearch() ? this.query.getSimplifiedMolecule() : this.target.getSimplifiedMolecule();
        if (this.searchOptions.isUndefinedRAtomMatchingGroup() && SearchUtil.hasUndefinedRAtom(q)) {
            if (this.searchOptions.isMarkushEnabled() && this.isMarkushTarget(HomologyConstants.containsHomology(this.target))) {
                throw new IllegalArgumentException("Undefined R-atom matching group is not supported for Markush search. Please choose any atom option for undefined R-atom matching.");
            }
            if (st != 5 && !this.searchOptions.isExactQueryAtomMatching()) {
                return 8;
            }
            if (undefRAtom == 2) {
                this.searchOptions.setUndefinedRAtom(0);
            } else {
                if (st == 5) {
                    throw new SearchException("Undefined R-atom matching group is inconsistent with duplicate search.");
                }
                if (this.searchOptions.isExactQueryAtomMatching()) {
                    throw new SearchException("Undefined R-atom matching group is inconsistent with exact query atom matching.");
                }
            }
        }
        if (this.searchOptions.isMarkushEnabled()) {
            boolean tHasHomology = HomologyConstants.containsHomology(this.target);
            if ((st == 2 || st == 4 || st == 7) && this.isMarkushTarget(tHasHomology)) {
                boolean handleQHomology2;
                boolean qHasHomology = HomologyConstants.containsHomology(q);
                if (!tHasHomology && !qHasHomology) {
                    return 4;
                }
                if (undefRAtom == 3 || undefRAtom == 4) {
                    throw new SearchException("Undefined R-atom matching group is not implemented for Markush homology search.");
                }
                if (undefRAtom == 2) {
                    this.searchOptions.setUndefinedRAtom(0);
                }
                boolean bl = handleQHomology2 = this.searchOptions.getHomologyNarrowTranslation() == HomologyTranslationOption.ALL;
                if (this.isRgSearchMode(q, handleQHomology2) && !this.isMarkushMoleculeExceptHomology(this.target)) {
                    return 2;
                }
                return 6;
            }
        }
        if (st == 5 && this.isOrigTargetMayBeMarkush && (Supergraph.isMarkushMolecule(this.target) || Supergraph.isMarkushMolecule(this.query))) {
            if (undefRAtom == 3 || undefRAtom == 4) {
                throw new SearchException("Undefined R-atom matching group is not implemented for Markush duplicate search.");
            }
            if (undefRAtom == 2) {
                this.searchOptions.setUndefinedRAtom(0);
            }
            return 5;
        }
        boolean bl = handleQHomology = this.searchOptions.getHomologyNarrowTranslation() == HomologyTranslationOption.ALL;
        if (this.isRgSearchMode(q, handleQHomology)) {
            return 2;
        }
        if (q instanceof RxnMolecule) {
            return 3;
        }
        if (handleQHomology && HomologyConstants.containsHomology(q)) {
            return 7;
        }
        return 1;
    }

    private boolean isMarkushTarget(boolean tHasHomology) {
        return this.target instanceof Supergraph || Supergraph.isMarkushMolecule(this.target) || tHasHomology || SearchUtil.hasMarkushQueryAtom(this.target);
    }

    private boolean isMarkushMoleculeExceptHomology(Molecule target) {
        if (target instanceof Supergraph) {
            return ((Supergraph)target).hasExpandedMarkushFeature(true);
        }
        return ExpansionUtil.isMarkushMoleculeExceptHomology(target);
    }

    private boolean isRgSearchMode(Molecule q, boolean handleQHomology) {
        return q instanceof RgMolecule && ((RgMolecule)q).getRgroupCount() > 0 || HomologyConstants.containsQueryConvertibleHomology(q) && handleQHomology;
    }

    private void setSearchMode(int mode) {
        if (this.searchMode != mode) {
            this.searchMode = mode;
            this.searcherInitialized = false;
        }
    }

    private boolean initSearch() throws SearchException {
        boolean isSuper = this.searchOptions.isSuperstructureSearch();
        boolean bl = this.isTautomerDuplicateFiltering = this.searchOptions.getSearchType() == 5 && (this.searchOptions.getTautomerSearch() == 1 || this.searchOptions.isTautomerDuplicateFiltering());
        if (this.searchOptions.isDirty()) {
            this.parametersInitialized = false;
            this.checkTautomerStandardization();
        }
        if (this.isQueryInString || this.searchOptions.isDirty() && !this.queryAsString.equals("")) {
            boolean isQuerySMARTS = !isSuper && this.searchOptions.getSearchType() != 5 && this.searchOptions.getSearchType() != 4;
            try {
                this.query = new MolHandler(this.queryAsString, isQuerySMARTS).getMolecule();
            }
            catch (MolFormatException e) {
                throw this.getWrapperSearchException(e);
            }
        }
        if (this.prevSuperstructureSearch != isSuper) {
            this.parametersInitialized = false;
            this.targetInitialized = false;
            this.queryInitialized = false;
            this.filteringLevel = 0;
            this.prevSuperstructureSearch = isSuper;
        }
        if (this.queryInitialized && this.targetInitialized) {
            if (this.parametersInitialized && this.searcherInitialized) {
                return true;
            }
        } else {
            this.standardizeTarget();
            this.setSearchMode(this.selectSearchMode());
        }
        if (!this.searcherInitialized && !this.initSearcher()) {
            return false;
        }
        if (!this.parametersInitialized) {
            this.setParameters();
        }
        if (!this.queryInitialized) {
            this.setQueryOnSearcher(isSuper);
        }
        if (!this.targetInitialized) {
            this.setTargetOnSearcher(isSuper);
        }
        this.setPreMatchOnSearcher();
        if (!this.filterInitialized) {
            this.initFilter();
        }
        if (this.target instanceof Supergraph && !this.getSearchOptions().isMarkushEnabled()) {
            throw new IllegalArgumentException("MolSearch: Target is Supergraph but markushEnabled is false!");
        }
        return true;
    }

    private boolean initSearcher() {
        Search newsearcher = this.selectSearcher(this.searchMode);
        if (newsearcher == null) {
            return false;
        }
        if (this.searcher == null || this.searcher != newsearcher) {
            this.searcher = newsearcher;
            this.queryInitialized = false;
            this.targetInitialized = false;
            this.filteringLevel = 0;
            this.parametersInitialized = false;
        }
        this.searcherInitialized = true;
        return true;
    }

    private void setTargetOnSearcher(boolean isSuper) throws SearchException {
        if (isSuper) {
            this.initSubSearcherQuery(this.unStandardizedTarget, this.excludedTargetAtoms);
            this.enumQuery = this.target = this.nextQuery;
        } else {
            Molecule targetToSet = this.target.getSimplifiedMolecule();
            if (this.isTautomerDuplicateFiltering) {
                targetToSet = this.calcGenericTautomer(targetToSet);
            }
            this.searcher.setTarget(targetToSet, this.excludedTargetAtoms);
        }
        if (this.filteringLevel >= 1) {
            this.filteringContext.setTarget(this.target);
            this.filterInitialized = false;
        }
        this.targetInitialized = true;
    }

    private void setQueryOnSearcher(boolean isSuper) throws SearchException {
        if (isSuper) {
            Molecule targetToSet = this.query;
            if (this.isTautomerDuplicateFiltering) {
                targetToSet = this.calcGenericTautomer(targetToSet);
            }
            this.searcher.setTarget(targetToSet, this.excludedQueryAtoms);
        } else {
            this.initSubSearcherQuery(this.query, this.excludedQueryAtoms);
            this.enumQuery = this.query;
        }
        if (this.filteringLevel >= 2) {
            this.filteringContext.setQuery(this.query);
            this.filterInitialized = false;
        }
        this.queryInitialized = true;
    }

    private void setPreMatchOnSearcher() {
        this.searcher.clearMatch();
        this.searcher.addMatch(this.preMatchQueryAtoms, this.preMatchTargetAtoms, this.preMatchLength);
    }

    private Search selectSearcher(int searchMode2) {
        switch (this.searchMode) {
            case 1: {
                if (this.structureSearch == null) {
                    this.structureSearch = new StructureSearch();
                }
                return this.structureSearch;
            }
            case 2: {
                if (this.rgSearch == null) {
                    this.rgSearch = new RgSearch();
                    this.rgSearch.setLicenseEnvironment(this.licenseEnvironment);
                }
                return this.rgSearch;
            }
            case 3: {
                if (this.reactionSearch == null) {
                    this.reactionSearch = new ReactionSearch();
                }
                return this.reactionSearch;
            }
            case 4: {
                if (this.markushSearch == null) {
                    this.markushSearch = new MarkushSGSearch();
                    this.markushSearch.setLicenseEnvironment(this.licenseEnvironment);
                }
                return this.markushSearch;
            }
            case 5: {
                if (this.markushPerfectSearch == null) {
                    this.markushPerfectSearch = new MarkushPerfectSearch();
                }
                return this.markushPerfectSearch;
            }
            case 6: {
                if (this.markushHomologySearch == null) {
                    this.markushHomologySearch = new HomologySGSearch();
                }
                return this.markushHomologySearch;
            }
            case 7: {
                if (this.markushHomologySearch == null) {
                    this.markushHomologySearch = new HomologySGSearch(true);
                }
                return this.markushHomologySearch;
            }
            case 8: {
                if (this.undefinedRAtomSearch == null) {
                    this.undefinedRAtomSearch = new UndefinedRAtomSearch();
                    this.undefinedRAtomSearch.setKeepGroupOrder(this instanceof RGroupDecomposition);
                }
                return this.undefinedRAtomSearch;
            }
            case 9: {
                if (this.markushMCSSearch == null) {
                    this.markushMCSSearch = new MarkushMCSSearch();
                    this.markushMCSSearch.setLicenseEnvironment(this.licenseEnvironment);
                }
                return this.markushMCSSearch;
            }
        }
        return null;
    }

    private void initSubSearcherQuery(Molecule q, int[] exQ) throws SearchException {
        int enO = this.getEnumerationOption();
        SearchUtil.cacheAromatizationMethod(q, this.searchOptions, this.standardizer);
        this.isQueryEnumerable = this.isTautomerDuplicateFiltering || enO == 0 ? false : SearchEnumerator.isEnumerable(q, enO);
        q.setPropertyObject("AROMATIZATION_METHOD", null);
        if (this.isQueryEnumerable) {
            this.nextQuery = q.getSimplifiedMolecule();
        } else {
            this.nextQuery = this.standardize(q.getSimplifiedMolecule(), true);
            if (this.isTautomerDuplicateFiltering) {
                this.nextQuery = this.calcGenericTautomer(this.nextQuery);
            }
        }
        this.setNextQueryInSearcher(exQ);
    }

    private Molecule calcGenericTautomer(Molecule mol) throws SearchException {
        Molecule ret = null;
        try {
            ret = TautomerUtil.createGenericTautomer(mol, true, (this.searchOptions.getTautomerSearch() == 1 || this.searchOptions.isTautomerDuplicateFiltering()) && this.searchOptions.isSwitchOffAllProtectsForTDF(), this.searchOptions.getIsotopeMatching() == 2);
        }
        catch (PluginException e) {
            e.printStackTrace();
            throw new SearchException(e);
        }
        return ret;
    }

    private void standardizeTarget() throws SearchException {
        if (this.searchOptions.isSuperstructureSearch()) {
            if (!this.queryInitialized) {
                this.query = this.standardize(this.query, false);
            }
            if (!this.targetInitialized) {
                this.target = this.unStandardizedTarget;
            }
        } else if (!this.targetInitialized) {
            this.target = this.standardize(this.unStandardizedTarget, false);
        }
    }

    private void forceImpliedSettings(MolSearchOptions sso) {
        if (this.searchOptions.getChargeMatching() == 2 && this.searchOptions.getSearchType() == 5) {
            sso.setImplicitHMatching(3);
        }
    }

    private void setParameters() {
        MolSearchOptions sso = new MolSearchOptions(2);
        this.searchOptions.clonecopy(sso);
        if (this.searchOptions.isSuperstructureSearch()) {
            sso.setQueryAbsoluteStereo(this.searchOptions.isTargetAbsoluteStereo());
            sso.setTargetAbsoluteStereo(this.searchOptions.isQueryAbsoluteStereo());
            sso.setSuperstructureSearch(false);
        }
        this.forceImpliedSettings(sso);
        this.searcher.setSearchOptions(sso);
        this.parametersInitialized = true;
        this.searchOptions.setDirty(false);
        int st = this.searchOptions.getSearchType();
        if (st != 2 && st != 6 && st != 4 && st != 7 && st != 5 && st != 0 && st != 8) {
            throw new IllegalArgumentException("MolSearch: Unknown search type: " + st);
        }
    }

    private void initFilter() throws SearchException {
        if (this.filteringExpression == null) {
            this.filteringOK = true;
            this.filterInitialized = true;
            return;
        }
        if (this.filteringJEP == null) {
            try {
                this.filteringEvaluator = this.evaluatorConfig != null || this.standardizer != null ? new Evaluator(this.evaluatorConfig, (Standardizer)this.standardizer) : new Evaluator();
                this.filteringJEP = this.filteringEvaluator.compile(this.filteringExpression, SearchContext.class);
                this.filteringContext = new SearchContext();
            }
            catch (ParseException e) {
                throw new SearchException(e);
            }
        }
        boolean result = true;
        if (this.filteringLevel == 0) {
            this.filteringLevel = 1;
            this.filteringContext.setTarget(this.target);
        }
        try {
            result = this.filteringJEP.evaluate_boolean(this.filteringContext);
        }
        catch (ParseException e) {
            if (this.filteringLevel < 2) {
                this.filteringLevel = 2;
                this.filteringContext.setQuery(this.query);
            }
            try {
                result = this.filteringJEP.evaluate_boolean(this.filteringContext);
            }
            catch (ParseException f) {
                this.filteringLevel = 3;
            }
        }
        this.filteringOK = result || this.filteringLevel == 3;
        this.filterInitialized = true;
    }

    @Override
    public void addMatch(int queryAtom, int targetAtom) {
        super.addMatch(queryAtom, targetAtom);
        this.parametersInitialized = false;
    }

    @Override
    public void addMatch(int[] queryAtoms, int[] targetAtoms, int length) {
        super.addMatch(queryAtoms, targetAtoms, length);
        this.parametersInitialized = false;
    }

    @Override
    public void clearMatch() {
        super.clearMatch();
        this.parametersInitialized = false;
    }

    private void setHitInFilter(SearchHit hit) {
        int[] singleHit = hit.getSingleHit();
        if (this.searchOptions.isSuperstructureSearch()) {
            int[] invSingleHit = new int[this.query.getAtomCount()];
            Arrays.fill(invSingleHit, Integer.MAX_VALUE);
            for (int i = 0; i < singleHit.length; ++i) {
                if (singleHit[i] < 0) continue;
                invSingleHit[singleHit[i]] = i;
            }
            this.filteringContext.setHit(invSingleHit);
        } else {
            this.filteringContext.setHit(singleHit);
        }
    }

    protected boolean filter(SearchHit hit) throws SearchException {
        if (this.filteringJEP == null || hit == null) {
            return true;
        }
        this.setHitInFilter(hit);
        try {
            return this.filteringJEP.evaluate_boolean(this.filteringContext);
        }
        catch (ParseException e) {
            if (this.searchOptions.isIgnoreCTExceptions() && e.getMessage().startsWith("Error while evaluating expression:")) {
                return false;
            }
            throw new SearchException(e);
        }
    }

    public static void checkFilter(String filteringExpression) throws ParseException {
        MolSearch.checkFilter(filteringExpression, null);
    }

    public static void checkFilter(String filteringExpression, File config) throws ParseException {
        new Evaluator(config).compile(filteringExpression, SearchContext.class);
    }

    @Override
    Hashtable<String, Boolean> getStereoMatchingDirections(int[] hit) {
        return this.searcher.getStereoMatchingDirections(hit);
    }

    private int getEnumerationOption() {
        int result = SearchUtil.getEnumerationOption(this.searchOptions.isExactQueryAtomMatching(), this.searchOptions.isExactBondMatching(), this.searchOptions.getTautomerSearch() == 1, this.searchOptions.getVagueBondLevel());
        if (this.searcher instanceof MarkushSGSearch) {
            return result | 8;
        }
        return result;
    }

    public void setOrigTargetMayBeMarkush(boolean value) {
        this.isOrigTargetMayBeMarkush = value;
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Structure Search", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Structure Search", this.licenseEnvironment);
    }
}

