/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class OccurenceParser {
    private String ostr = null;
    private ArrayList<String> conditions = new ArrayList();

    public void setOccurenceString(String s) throws IllegalArgumentException {
        if (s.length() == 0) {
            throw new IllegalArgumentException("Empty occurence string.");
        }
        this.ostr = s;
        StringTokenizer st = new StringTokenizer(this.ostr, ",");
        while (st.hasMoreTokens()) {
            this.conditions.add(st.nextToken().trim());
        }
    }

    private boolean testCondition(String s, int n) throws IllegalArgumentException, NumberFormatException {
        int p = s.indexOf(45);
        if (p != -1) {
            if (p == s.length() - 1) {
                throw new IllegalArgumentException("Upper bound not specified.");
            }
            String minString = s.substring(0, p);
            String maxString = s.substring(p + 1);
            int minValue = Integer.parseInt(minString);
            int maxValue = Integer.parseInt(maxString);
            return minValue <= n && n <= maxValue;
        }
        char ch = s.charAt(0);
        if (ch == '<' || ch == '>') {
            if (s.length() == 1) {
                throw new IllegalArgumentException("Bound not specified.");
            }
            String boundString = s.substring(1);
            int bound = Integer.parseInt(boundString);
            return ch == '<' && n < bound || ch == '>' && n > bound;
        }
        int value = Integer.parseInt(s);
        return n == value;
    }

    public boolean test(int n) {
        for (int x = 0; x < this.conditions.size(); ++x) {
            String cond = this.conditions.get(x);
            if (!this.testCondition(cond, n)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            OccurenceParser op = new OccurenceParser();
            op.setOccurenceString("3, 6-8 ,>18, <2");
            for (int x = 0; x < 21; ++x) {
                System.out.println(x + " : " + op.test(x));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

