/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.sss.search.MolComparator;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.Arrays;

public class ReactingCenterComparator
extends MolComparator {
    int[] qRc;
    int[] tRc;
    Reaction reaction = null;
    private boolean isReaction = true;

    private boolean hasRc(Molecule m) {
        int nb = m.getBondCount();
        for (int i = 0; i < nb; ++i) {
            MolBond b = m.getBond(i);
            int rc = b.getFlags() & 0xF000;
            if (rc == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTarget(Molecule t) {
        super.setTarget(t);
        if (t != null) {
            this.initialize();
        }
    }

    public void initialize() {
        this.initReaction(this.target);
    }

    private void initReaction(Molecule t) {
        if (!(t instanceof RxnMolecule)) {
            this.reaction = null;
            this.isReaction = false;
            return;
        }
        this.isReaction = true;
        this.reaction = new Reaction();
        try {
            this.reaction.setRequiredData(2);
            this.reaction.setReaction(t, false, false, false);
        }
        catch (ReactionException e) {
            e.printStackTrace();
        }
        int[][] cbd = this.reaction.getChangingBondData(false);
        int bc = t.getBondCount();
        this.tRc = ArrayTools.initArray(this.tRc, bc);
        Arrays.fill(this.tRc, 0, bc, 0);
        for (int i = 0; i < cbd.length; ++i) {
            int[] cbdr = cbd[i];
            int reactantBond = cbdr[0];
            int productBond = cbdr[3];
            if (reactantBond == -1 && productBond == -1) continue;
            if (reactantBond == -1) {
                this.tRc[productBond] = 8192;
                continue;
            }
            if (productBond == -1) {
                this.tRc[reactantBond] = 8192;
                continue;
            }
            this.tRc[reactantBond] = 12288;
            this.tRc[productBond] = 12288;
        }
    }

    @Override
    public boolean compareBonds(int b1, int b2) {
        int b1m = this.getOrigQueryBond(b1);
        if (b1m == -1) {
            return true;
        }
        MolBond b = this.query.getBond(b1m);
        int rc = b.getFlags() & 0xF000;
        if (rc == 0 || !this.isReaction) {
            return true;
        }
        int b2m = this.getOrigTargetBond(b2);
        int trcv = b2m == -1 ? this.calculateImplicitHReactingCenterValue(b2) : this.tRc[b2m];
        switch (rc) {
            case 12288: {
                return trcv == 12288;
            }
            case 8192: {
                return trcv == 8192;
            }
            case 20480: 
            case 24576: {
                return trcv == 0;
            }
            case 4096: 
            case 16384: {
                return trcv != 0;
            }
            case 28672: {
                break;
            }
        }
        return true;
    }

    private int calculateImplicitHReactingCenterValue(int bInt) {
        MolAtom corrMA;
        int hCount2;
        int a1 = this.getOrigTargetAtom1(bInt);
        int a2 = this.getOrigTargetAtom2(bInt);
        int heavyAtom = a1;
        if (heavyAtom == -1) {
            heavyAtom = a2;
        }
        if (heavyAtom == -1) {
            return 0;
        }
        MolAtom heavyMA = this.target.getAtom(heavyAtom);
        int heavyMap = heavyMA.getAtomMap();
        if (heavyMap == 0) {
            return 0;
        }
        int corrHeavyAtom = this.getCorrespondingAtom(heavyMap, heavyAtom);
        if (corrHeavyAtom == -1) {
            return 0;
        }
        int hCount1 = heavyMA.getImplicitHcount() + heavyMA.getExplicitHcount();
        if (hCount1 != (hCount2 = (corrMA = this.target.getAtom(corrHeavyAtom)).getImplicitHcount() + corrMA.getExplicitHcount())) {
            return 8192;
        }
        return 0;
    }

    private int getCorrespondingAtom(int heavyMap, int heavyAtom) {
        int corrHeavyAtom = -1;
        for (int i = 0; i < this.target.getAtomCount(); ++i) {
            int map2 = this.target.getAtom(i).getAtomMap();
            if (map2 != heavyMap || i == heavyAtom) continue;
            corrHeavyAtom = i;
        }
        return corrHeavyAtom;
    }

    @Override
    public int isUsefulForQuery() {
        if (!this.searcher.searchOptions.isExactBondMatching() && this.hasRc(this.query)) {
            return 1;
        }
        return 2;
    }

    @Override
    public int isUsefulForTarget() {
        if (this.target.getSimplifiedMolecule() instanceof RxnMolecule) {
            return 0;
        }
        return 2;
    }
}

