/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.Decomposition;
import chemaxon.sss.search.MarkushGenerator;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.RGroupDecomposition;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;

public class RgDecompResults {
    private Molecule query = null;
    private Molecule[] targets = null;
    private MolSearchOptions searchOptions = new MolSearchOptions(2);
    private int attachmentType = 1;
    private int[] originalIds = null;
    private Molecule scaffold = null;
    private int noLigands = Integer.MIN_VALUE;
    private Molecule[][] rgDecomps = null;
    private Molecule[][] rgDecompTable = null;
    private RgMolecule markush = null;
    private int[] skipped = null;
    private boolean hasResults = false;

    public RgDecompResults(Molecule scaffold, int noLigands, Molecule[][] rgDecomps, RgMolecule markush, int[] skippedIds) {
        this(scaffold, noLigands, rgDecomps, markush, skippedIds, null);
    }

    public RgDecompResults(Molecule scaffold, int noLigands, Molecule[][] rgDecomps, RgMolecule markush, int[] skippedIds, int[] originalIds) {
        this.scaffold = scaffold;
        this.noLigands = noLigands;
        this.rgDecomps = rgDecomps;
        this.markush = markush;
        this.skipped = skippedIds;
        this.originalIds = originalIds;
        this.searchOptions.setHitOrdering(1);
        this.hasResults = true;
    }

    public RgDecompResults(Molecule query, Molecule[] targets, SearchOptions options, int attachmentType) {
        this(query, targets, options, attachmentType, (int[])null);
    }

    public RgDecompResults(Molecule query, Molecule[] targets, SearchOptions options, int attachmentType, int[] originalIds) {
        this.query = query;
        this.targets = targets;
        options.clonecopy(this.searchOptions);
        this.searchOptions.setHitOrdering(1);
        this.attachmentType = attachmentType;
        this.originalIds = originalIds;
    }

    public Molecule getScaffold() {
        if (this.hasResults) {
            return this.scaffold;
        }
        return null;
    }

    public int getLigandsNumber() {
        if (this.hasResults) {
            return this.noLigands;
        }
        return Integer.MIN_VALUE;
    }

    public Molecule[][] getHitsAsRgDecomp() {
        if (this.hasResults) {
            return this.rgDecomps;
        }
        return null;
    }

    public Molecule[][] getHitsAsTable() {
        if (this.hasResults && this.rgDecompTable[0] != null) {
            return this.rgDecompTable;
        }
        return null;
    }

    public RgMolecule getHitsAsMarkush() {
        if (this.hasResults) {
            return this.markush;
        }
        return null;
    }

    public int[] getSkippedIds() {
        if (this.hasResults) {
            if (this.originalIds == null) {
                return this.skipped;
            }
            int[] ret = new int[this.skipped.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.originalIds[this.skipped[i]];
            }
            return ret;
        }
        return null;
    }

    public int[] getIncludedIds() {
        if (this.hasResults) {
            int i;
            boolean orig = this.originalIds != null;
            int sk = this.skipped.length - 1;
            int[] ret = new int[i - sk];
            int r = i - sk - 1;
            for (i = this.targets.length - 1; i >= 0; --i) {
                if (sk >= 0 && this.skipped[sk] == i) {
                    --sk;
                    continue;
                }
                ret[r--] = orig ? this.originalIds[i] : i;
            }
            return ret;
        }
        return null;
    }

    public void run() throws SearchException {
        if (!this.hasResults) {
            MarkushGenerator mg;
            block6: {
                mg = new MarkushGenerator();
                mg.setSearchOptions(this.searchOptions);
                try {
                    mg.setQuery(this.query);
                }
                catch (SearchException e) {
                    if (!e.getMessage().equals("The query should contain at least one undefined R-atom.")) break block6;
                    RGroupDecomposition rgd = new RGroupDecomposition();
                    rgd.setQuery(this.query);
                    this.query = rgd.getRGroupedQuery();
                    mg.setQuery(this.query);
                }
            }
            mg.setTargets(this.targets);
            this.markush = mg.generate();
            this.skipped = mg.getSkippedTargetIndexes();
            RGroupDecomposition rgd = new RGroupDecomposition();
            rgd.setSearchOptions(this.searchOptions);
            rgd.setAttachmentType(this.attachmentType);
            rgd.setQuery(this.query);
            Decomposition d = null;
            int sk = this.skipped.length - 1;
            int nr = this.targets.length;
            this.rgDecomps = new Molecule[nr][];
            this.rgDecompTable = new Molecule[nr - sk][];
            this.noLigands = 0;
            for (int i = this.targets.length - 1; i >= 0; --i) {
                if (sk >= 0 && this.skipped[sk] == i) {
                    --sk;
                    this.rgDecomps[--nr] = null;
                    continue;
                }
                rgd.setTarget(this.targets[i]);
                d = rgd.findDecomposition();
                this.rgDecompTable[nr] = rgd.findLigandTableRow(1);
                this.rgDecomps[--nr] = d.getLigands();
                if (this.rgDecompTable[0] == null) {
                    this.rgDecompTable[0] = rgd.getLigandTableHeader(1, 1);
                }
                this.noLigands = this.rgDecomps[nr].length;
            }
            this.scaffold = this.targets.length > this.skipped.length ? d.getQuery() : this.query;
            this.hasResults = true;
        }
    }

    public void setQuery(Molecule query) {
        this.query = query;
        this.hasResults = false;
    }

    public void setTargets(Molecule[] targets) {
        this.targets = targets;
        this.hasResults = false;
    }

    public void setSearchOptions(SearchOptions options) {
        options.clonecopy(this.searchOptions);
        this.hasResults = false;
    }

    public void setAttachmentType(int attachmentType) {
        this.attachmentType = attachmentType;
        this.hasResults = false;
    }

    public void setOriginalIds(int[] originalIds) {
        this.originalIds = originalIds;
    }

    public boolean hasResults() {
        return this.hasResults;
    }
}

