/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.common.util.ArrayTools;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.SearchOptions;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.StereoConstants;
import chemaxon.util.search.MolSearcher;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Search
implements StereoConstants,
SearchConstants,
MolSearcher {
    protected final MolSearchOptions searchOptions = new MolSearchOptions(2);
    protected int[] preMatchQueryAtoms = null;
    protected int[] preMatchTargetAtoms = null;
    protected int preMatchLength = 0;
    protected static final Level MRV_OUTPUT_LEVEL = Level.FINE;

    @Override
    public abstract void setTarget(Molecule var1);

    public abstract void setTarget(Molecule var1, int[] var2);

    public abstract Molecule getTarget();

    @Override
    public abstract void setQuery(Molecule var1);

    public abstract void setQuery(Molecule var1, int[] var2);

    public abstract Molecule getQuery();

    public abstract boolean isMatching() throws SearchException;

    public final int[] findFirst() throws SearchException {
        SearchHit hit = this.findFirstHit();
        return hit != null ? hit.getSingleHit() : null;
    }

    @Override
    public final int[] findNext() throws SearchException {
        SearchHit hit = this.findNextHit();
        return hit != null ? hit.getSingleHit() : null;
    }

    public final int[][] findAll() throws SearchException {
        SearchHit[] hits = this.findAllHits();
        if (hits == null) {
            return null;
        }
        int[][] singleHits = new int[hits.length][];
        for (int i = 0; i < hits.length; ++i) {
            singleHits[i] = hits[i].getSingleHit();
        }
        return singleHits;
    }

    public final int[][] findFirstGroup() throws SearchException {
        SearchHit hit = this.findFirstHit();
        return hit != null ? hit.getGroupHit() : (int[][])null;
    }

    public final int[][] findNextGroup() throws SearchException {
        SearchHit hit = this.findNextHit();
        return hit != null ? hit.getGroupHit() : (int[][])null;
    }

    public final int[][][] findAllGroups() throws SearchException {
        SearchHit[] hits = this.findAllHits();
        if (hits == null) {
            return null;
        }
        int[][][] groupHits = new int[hits.length][][];
        for (int i = 0; i < hits.length; ++i) {
            groupHits[i] = hits[i].getGroupHit();
        }
        return groupHits;
    }

    protected abstract SearchHit findFirstHit() throws SearchException;

    protected abstract SearchHit findNextHit() throws SearchException;

    protected SearchHit[] findAllHits() throws SearchException {
        ArrayList<SearchHit> v = new ArrayList<SearchHit>();
        SearchHit hit = this.findFirstHit();
        if (hit == null) {
            return null;
        }
        do {
            v.add(hit);
        } while ((hit = this.findNextHit()) != null);
        SearchHit[] hits = new SearchHit[v.size()];
        return v.toArray(hits);
    }

    public static boolean areMatchingBondTypes(int q, int t) {
        return Search.areMatchingBondTypes(q, t, false);
    }

    protected static boolean areMatchingBondTypes(int q, int t, boolean exactMatch) {
        if (exactMatch) {
            return t == q;
        }
        if (q == 0) {
            return true;
        }
        switch (q) {
            case 5: {
                return t == 1 || t == 2;
            }
            case 6: {
                return t == 1 || t == 4;
            }
            case 7: {
                return t == 2 || t == 4;
            }
        }
        return q == t;
    }

    protected static int getAtomStereo(MolAtom atom, int parity) {
        switch (parity) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 32;
            }
            case 3: {
                int i;
                int c = atom.getBondCount();
                for (i = 0; i < c && atom.getBond(i).getStereo1(atom) != 48; ++i) {
                }
                if (i == c) {
                    return 0;
                }
                return 64;
            }
        }
        return 0;
    }

    public void addMatch(int queryAtom, int targetAtom) {
        this.preMatchQueryAtoms = ArrayTools.extendArray(this.preMatchQueryAtoms, this.preMatchLength + 1);
        this.preMatchTargetAtoms = ArrayTools.extendArray(this.preMatchTargetAtoms, this.preMatchLength + 1);
        this.preMatchQueryAtoms[this.preMatchLength] = queryAtom;
        this.preMatchTargetAtoms[this.preMatchLength] = targetAtom;
        ++this.preMatchLength;
    }

    public void addMatch(int[] queryAtoms, int[] targetAtoms, int length) {
        this.preMatchQueryAtoms = ArrayTools.extendArray(this.preMatchQueryAtoms, this.preMatchLength + length);
        this.preMatchTargetAtoms = ArrayTools.extendArray(this.preMatchTargetAtoms, this.preMatchLength + length);
        for (int i = 0; i < length; ++i) {
            this.preMatchQueryAtoms[this.preMatchLength] = queryAtoms[i];
            this.preMatchTargetAtoms[this.preMatchLength] = targetAtoms[i];
            ++this.preMatchLength;
        }
    }

    public void clearMatch() {
        this.preMatchLength = 0;
    }

    public boolean isMatchCountInRelation(String relation, int hitLimit) throws SearchException {
        int hitToCollect;
        int foundHits = 0;
        if (relation.equals("=") || relation.equals("<=") || relation.equals(">")) {
            hitToCollect = hitLimit + 1;
        } else if (relation.equals("<") || relation.equals(">=")) {
            hitToCollect = hitLimit;
        } else {
            throw new SearchException("Illegal relation parameter\"" + relation + "\".");
        }
        int[] hit = this.findFirst();
        while (hit != null && ++foundHits < hitToCollect) {
            hit = this.findNext();
        }
        if (relation.equals("=")) {
            return foundHits == hitLimit;
        }
        if (relation.equals("<")) {
            return foundHits < hitLimit;
        }
        if (relation.equals("<=")) {
            return foundHits <= hitLimit;
        }
        if (relation.equals(">")) {
            return foundHits > hitLimit;
        }
        return foundHits >= hitLimit;
    }

    public boolean isMatchCountBetween(int hitLimitLow, boolean isLowerLimitIncluded, int hitLimitHigh, boolean isHigherLimitIncluded) throws SearchException {
        int foundHits = 0;
        if (!isLowerLimitIncluded) {
            ++hitLimitLow;
        }
        if (!isHigherLimitIncluded && hitLimitHigh != Integer.MAX_VALUE) {
            --hitLimitHigh;
        }
        if (hitLimitLow > hitLimitHigh) {
            return false;
        }
        if (hitLimitHigh == Integer.MAX_VALUE) {
            return this.isMatchCountInRelation(">=", hitLimitLow);
        }
        int hitToCollect = hitLimitHigh + 1;
        int[] hit = this.findFirst();
        while (hit != null && foundHits < hitToCollect) {
            ++foundHits;
            hit = this.findNext();
        }
        return hitLimitLow <= foundHits && foundHits <= hitLimitHigh;
    }

    public int getMatchCount() throws SearchException {
        int foundHits = 0;
        int[] hit = this.findFirst();
        while (hit != null) {
            ++foundHits;
            hit = this.findNext();
        }
        return foundHits;
    }

    BitSet getMatchingAtoms() throws SearchException {
        BitSet appears = new BitSet(this.getTarget().getAtomCount());
        int[] hit = this.findFirst();
        while (hit != null) {
            for (int i = 0; i < hit.length; ++i) {
                if (hit[i] == -1) continue;
                appears.set(hit[i]);
            }
            hit = this.findNext();
        }
        return appears;
    }

    BitSet getMatchingAtoms(int queryAtomNo) throws SearchException {
        BitSet appears = new BitSet(this.getTarget().getAtomCount());
        int[] hit = this.findFirst();
        while (hit != null) {
            if (hit[queryAtomNo] >= 0) {
                appears.set(hit[queryAtomNo]);
            } else {
                int heavyNeighbour = hit[queryAtomNo] != Integer.MIN_VALUE ? -hit[queryAtomNo] : 0;
                appears.set(heavyNeighbour + this.getTarget().getAtomCount());
            }
            hit = this.findNext();
        }
        return appears;
    }

    public boolean isVerbose() {
        return this.searchOptions.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.searchOptions.setVerbose(verbose);
    }

    public abstract void stop();

    Hashtable<String, Boolean> getStereoMatchingDirections(int[] hit) {
        return null;
    }

    public Molecule getMatchingQuery() {
        return this.getQuery();
    }

    public MolSearchOptions getSearchOptions() {
        return this.searchOptions;
    }

    public void setSearchOptions(SearchOptions options) {
        options.clonecopy(this.searchOptions);
    }

    protected Molecule getQueryToPrint() {
        return this.getQuery();
    }

    protected Molecule getTargetToPrint() {
        Molecule m = this.getTarget();
        if (m instanceof Supergraph) {
            Supergraph sg = (Supergraph)m;
            m = sg.getMolecule();
        }
        return m;
    }

    protected String getTargetAsString() {
        String ts;
        Molecule tToPrint = this.getTargetToPrint();
        if (tToPrint == null) {
            return "null";
        }
        try {
            ts = tToPrint.toFormat("cxsmiles");
        }
        catch (Exception e) {
            ts = "\n" + tToPrint.toFormat("mrv");
        }
        return ts;
    }

    protected String getQueryAsString() {
        String qs;
        Molecule qToPrint = this.getQueryToPrint();
        if (qToPrint == null) {
            return "null";
        }
        try {
            qs = this.searchOptions.isPerfectSearchType() ? qToPrint.toFormat("cxsmiles") : qToPrint.toFormat("cxsmarts");
        }
        catch (Exception e) {
            qs = "\n" + qToPrint.toFormat("mrv");
        }
        return qs;
    }

    static String getShortString(Molecule mol, boolean isQuery) {
        String molStr;
        try {
            molStr = mol.getName();
            if (molStr != null && !molStr.isEmpty()) {
                return molStr;
            }
            molStr = isQuery ? mol.toFormat("cxsmarts") : mol.toFormat("cxsmiles");
        }
        catch (Exception e) {
            molStr = "Molecule can be seen on the logger output at level " + MRV_OUTPUT_LEVEL.toString();
        }
        return molStr;
    }

    protected void logException(Logger logger, String message) {
        String queryShortString = Search.getShortString(this.getQueryToPrint(), true);
        String targetShortString = Search.getShortString(this.getTargetToPrint(), false);
        if (logger.isLoggable(Level.INFO)) {
            logger.info(message + "\nQuery:" + queryShortString + "\n  Target:" + targetShortString);
        }
        if (logger.isLoggable(MRV_OUTPUT_LEVEL)) {
            String queryString = this.getQueryAsString();
            String targetString = this.getTargetAsString();
            if (!targetString.equals(targetShortString) || !queryString.equals(queryShortString)) {
                logger.log(MRV_OUTPUT_LEVEL, message + "\nQuery:" + queryString + "\n  Target:" + targetString);
            }
        }
    }
}

