/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.SearchMap;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.Molecule;
import java.util.BitSet;

public class SearchAtomTypeMatcher
implements MoleculeMatcher {
    private StructureSearch searcher;
    private BitSet[] atomTypeMapping;

    @Override
    public void setTarget(Molecule molecule) {
        this.atomTypeMapping = null;
    }

    @Override
    public void setQuery(Molecule molecule) {
    }

    @Override
    public void setSearcher(StructureSearch searcher) {
        this.searcher = searcher;
    }

    @Override
    public void compareAllAtoms() {
        int[] matom = this.searcher.matom;
        this.initAtomTypeMapping(matom);
        int[] subMatom = this.searcher.sub.matom;
        SearchMap map = this.searcher.map;
        int qLength = subMatom.length;
        for (int qInd = 0; qInd < qLength; ++qInd) {
            int qAtomType = subMatom[qInd];
            if (qAtomType >= 109) continue;
            map.andRowNoLog(qInd, this.atomTypeMapping[qAtomType]);
        }
    }

    private void initAtomTypeMapping(int[] matom) {
        int matomLength = matom.length;
        if (this.atomTypeMapping == null || this.atomTypeMapping[0].length() != matomLength) {
            this.atomTypeMapping = new BitSet[109];
            for (int atomTypeInd = 0; atomTypeInd < this.atomTypeMapping.length; ++atomTypeInd) {
                this.atomTypeMapping[atomTypeInd] = new BitSet(matomLength);
            }
            for (int atomIndex = 0; atomIndex < matomLength; ++atomIndex) {
                int atomType = matom[atomIndex];
                if (atomType < 109) {
                    this.atomTypeMapping[atomType].set(atomIndex);
                    continue;
                }
                for (int i = 0; i < this.atomTypeMapping.length; ++i) {
                    this.atomTypeMapping[i].set(atomIndex);
                }
            }
        }
    }

    @Override
    public boolean isSpecialQueryH(int atomInd) {
        return false;
    }

    @Override
    public boolean isSpecialTargetH(int atomInd) {
        return false;
    }

    @Override
    public boolean refine() {
        return false;
    }
}

