/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.search.SearchUtil;

public class SearchHit {
    private int[] singleHit = null;
    private int[][] groupHit = null;

    private SearchHit() {
    }

    public SearchHit(int[] singleHit) {
        this(singleHit, null);
    }

    public SearchHit(int[][] groupHit) {
        this(null, groupHit);
    }

    public SearchHit(int[] singleHit, int[][] groupHit) {
        assert (singleHit != null || groupHit != null);
        this.singleHit = singleHit;
        this.groupHit = groupHit;
    }

    public void setSingleHit(int[] singleHit) {
        this.singleHit = singleHit;
    }

    public void setGroupHit(int[][] groupHit) {
        this.groupHit = groupHit;
    }

    public int[] getSingleHit() {
        return this.singleHit != null ? this.singleHit : SearchUtil.convertToSingleHit(this.groupHit);
    }

    public int[][] getGroupHit() {
        return this.groupHit != null ? this.groupHit : SearchUtil.convertToGroupHit(this.singleHit);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.groupHit != null) {
            for (int[] a : this.groupHit) {
                b.append("{");
                for (int x : a) {
                    b.append("" + (x + 1) + " ");
                }
                b.append("} ");
            }
            if (this.singleHit != null) {
                b.append("Single: ");
            }
        }
        if (this.singleHit != null) {
            for (int x : this.singleHit) {
                b.append("" + (x + 1) + " ");
            }
        }
        return b.toString();
    }
}

