/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.MolComparator;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.sss.search.options.SetOfSmallestRingsOption;
import chemaxon.util.CxOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class SearchOptions
implements SearchConstants,
Cloneable,
Serializable {
    private static final String[] optionNames = new String[]{"t", "orderSensitive", "exactStereoSearch", "stereoSearchType", "ignoreTetrahedralStereo", "ignoreDoubleBondStereo", "ignoreAxialStereo", "ignoreAlleneStereo", "ignoreSynAntiStereo", "keepQueryOrder", "exactBondMatching", "exactQueryAtomMatching", "checkSpHyb", "doubleBondStereo", "HCountMatching", "implicitHMatching", "reactionUnpairedMap", "vagueBond", "completeHG", "charge", "isotope", "radical", "valence", "mix", "polymer", "homologyNarrowTranslation", "homologyBroadTranslation", "ssrType", "endGroupMatching", "transformMonomer", "phaseShift", "copolymerMatching", "stereoModel", "undefinedRAtom", "hitOrdering", "chemTermsFilter", "chemTermsFilterConfig", "attachedDataMatch", "attachedDataPrefixes", "exactSpecialAtomMatching", "bridgingRAllowed", "RLigandEqualityCheck", "ignoreCTExceptions", "exhaustiveModeLimit", "timeoutLimitMilliseconds", "tdf", "tautomerSearch"};
    protected boolean dirty = false;
    private boolean exactQueryAtomMatching = false;
    private int doubleBondStereoMatchingMode = 1;
    private int HCountMatching = 0;
    public boolean verbose = false;
    private boolean superstructureSearch = false;
    protected int[] options = new int[13];
    private int searchType = 2;
    private int vagueBondLevel = 0;
    private boolean completeHG = true;
    private boolean exactTopologyMatching = false;
    private boolean exactBondMatching = false;
    private boolean orderSensitiveSearch = false;
    private boolean keepQueryOrder = false;
    private boolean exactFragment = false;
    private boolean tautomerSearch = false;
    private int tautomerSearchOption = 2;
    private boolean tautomerSearchOptionLeftDefault = true;
    private int isotopeMatching = 0;
    private int chargeMatching = 0;
    private boolean valenceMatching = true;
    private int radicalMatching = 0;
    private boolean mixSgroupMatching = true;
    private boolean polymerMatching = true;
    private boolean endGroupMatching = true;
    private boolean transformMonomer = true;
    private boolean phaseShift = true;
    private boolean copolymerMatching = false;
    private HomologyTranslationOption homologyNarrowTranslation = HomologyTranslationOption.NONE;
    private HomologyTranslationOption homologyBroadTranslation = HomologyTranslationOption.NONE;
    private SetOfSmallestRingsOption ssrOption = SetOfSmallestRingsOption.SSSR;
    private int stereoModel = 3;
    private int stereoSearchType = 0;
    private boolean ignoreTetrahedralStereo = false;
    private boolean ignoreDoubleBondStereo = false;
    private boolean ignoreAxialStereo = true;
    private boolean ignoreAlleneStereo = true;
    private boolean ignoreSynAntiStereo = true;
    private boolean checkSpHyb = false;
    private int implicitHMatching = 0;
    private boolean reactionUnpairedMapMatching = true;
    private String chemTermsFilter;
    private String chemTermsFilterConfig;
    private int undefinedRAtom = 2;
    private boolean undefinedRAtomUserDefined = false;
    private boolean bridgingRAllowed = false;
    private boolean RLigandEqualityCheck = true;
    private int hitOrdering = 0;
    private int attachedDataMatch = 0;
    private String attachedDataPrefixes = null;
    private String exactSpecialAtomMatching = "";
    private boolean ignoreCTExceptions = false;
    private boolean changedUserComparator = false;
    private ArrayList<MolComparator> userComparators = null;
    private int exhaustiveModeLimit = -1;
    private int timeoutLimitSteps = 10000000;
    private int timeoutLimitMilliseconds = 120000;
    private boolean throwExceptionOnTimeout = false;
    @Deprecated
    private boolean tautomerDuplicateFiltering = false;

    @Deprecated
    public SearchOptions() {
        this.setSearchType0(2);
    }

    public SearchOptions(int searchType) {
        this.setSearchType0(searchType);
    }

    public final boolean isExactQueryAtomMatching() {
        return this.exactQueryAtomMatching;
    }

    public void setExactQueryAtomMatching(boolean isExact) {
        if (this.exactQueryAtomMatching != isExact) {
            this.exactQueryAtomMatching = isExact;
            this.setDirty(true);
        }
    }

    public void setDoubleBondStereoMatchingMode(int value) {
        if (value == 2 || value == 1 || value == 0) {
            if (this.doubleBondStereoMatchingMode != value) {
                this.doubleBondStereoMatchingMode = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setDoubleBondStereoMatchingMode " + value);
        }
    }

    public final int getDoubleBondStereoMatchingMode() {
        return this.doubleBondStereoMatchingMode;
    }

    @Deprecated
    public void setSearchType(int searchType) {
        this.searchType = searchType;
        boolean isP = searchType == 5;
        boolean subgraphSearch = searchType != 4 && searchType != 5;
        this.setSubgraphSearch(subgraphSearch);
        this.superstructureSearch = searchType == 6;
        this.setFullFragment(searchType == 7 || searchType == 4 || searchType == 5);
        this.setStereoSearchType(isP ? 2 : 0);
        this.setChargeMatching(isP ? 1 : 0);
        this.setIsotopeMatching(isP ? 1 : 0);
        this.setExactQueryAtomMatching(searchType == 5);
        this.setRadicalMatching(isP ? 1 : 0);
        this.setValenceMatching(true);
        this.setCheckSpHyb(false);
        this.setMonomerTransform(!isP);
        this.setExactBondMatching(isP);
    }

    protected void setSearchType0(int searchType) {
        this.searchType = searchType;
        boolean isP = searchType == 5;
        boolean subgraphSearch = searchType != 4 && searchType != 5;
        this.setSubgraphSearch(subgraphSearch);
        this.superstructureSearch = searchType == 6;
        this.setFullFragment(searchType == 7 || searchType == 4 || searchType == 5);
        this.setStereoSearchType(isP ? 2 : 0);
        this.setChargeMatching(isP ? 1 : 0);
        this.setIsotopeMatching(isP ? 1 : 0);
        this.setExactQueryAtomMatching(searchType == 5);
        this.setRadicalMatching(isP ? 1 : 0);
        this.setValenceMatching(true);
        this.setCheckSpHyb(false);
        this.setMonomerTransform(!isP);
        this.setExactBondMatching(isP);
    }

    public final int getSearchType() {
        return this.searchType;
    }

    public final boolean isPerfectSearchType() {
        return this.searchType == 5;
    }

    public boolean isSubgraphSearch() {
        return !this.exactTopologyMatching;
    }

    public void setSubgraphSearch(boolean value) {
        if (this.exactTopologyMatching == value) {
            this.exactTopologyMatching = !value;
            this.setDirty(true);
        }
    }

    public final int getHCountMatching() {
        return this.HCountMatching;
    }

    public void setHCountMatching(int value) {
        if (0 == value || 1 == value || 2 == value) {
            if (this.HCountMatching != value) {
                this.HCountMatching = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setHCountMatching " + value);
        }
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verboseP) {
        this.verbose = verboseP;
    }

    public static int getSearchType(String searchTypeValue) {
        if ("s".equalsIgnoreCase(searchTypeValue)) {
            return 2;
        }
        if ("d".equalsIgnoreCase(searchTypeValue)) {
            return 5;
        }
        if ("f".equalsIgnoreCase(searchTypeValue)) {
            return 4;
        }
        if ("ff".equalsIgnoreCase(searchTypeValue)) {
            return 7;
        }
        if ("u".equalsIgnoreCase(searchTypeValue)) {
            return 6;
        }
        if ("i".equalsIgnoreCase(searchTypeValue)) {
            return 3;
        }
        if ("t".equalsIgnoreCase(searchTypeValue)) {
            return 3;
        }
        if ("r".equalsIgnoreCase(searchTypeValue)) {
            return 6;
        }
        if ("na".equalsIgnoreCase(searchTypeValue)) {
            return 1;
        }
        if ("ns".equalsIgnoreCase(searchTypeValue)) {
            return 0;
        }
        if ("e".equalsIgnoreCase(searchTypeValue)) {
            return 4;
        }
        if ("ef".equalsIgnoreCase(searchTypeValue)) {
            return 7;
        }
        if ("p".equalsIgnoreCase(searchTypeValue)) {
            return 5;
        }
        if ("mcs".equalsIgnoreCase(searchTypeValue)) {
            return 8;
        }
        throw new IllegalArgumentException("error: search type: t:" + searchTypeValue + "\nUse -h for help.");
    }

    public void setOptions(String optionString) {
        CxOptions jco;
        String searchTypeValue;
        if (optionString != null && optionString.indexOf("\n") != -1 && !optionString.startsWith("sep=")) {
            optionString = "sep=\n " + optionString;
        }
        if ((searchTypeValue = (jco = new CxOptions(optionString)).getStringValue("t")) != null) {
            this.setSearchType0(SearchOptions.getSearchType(searchTypeValue));
            jco.removeOption("t");
        }
        Iterator optionNameIt = jco.optionNames();
        while (optionNameIt.hasNext()) {
            String name = (String)optionNameIt.next();
            String value = jco.getStringValue(name);
            this.setOption(name, value);
        }
    }

    public final boolean isSuperstructureSearch() {
        return this.superstructureSearch;
    }

    public void setSuperstructureSearch(boolean value) {
        this.superstructureSearch = value;
    }

    public void setOrderSensitiveSearch(boolean value) {
        if (this.orderSensitiveSearch != value) {
            this.orderSensitiveSearch = value;
            this.setDirty(true);
        }
    }

    public final boolean isOrderSensitiveSearch() {
        return this.orderSensitiveSearch;
    }

    public final boolean isExactBondMatching() {
        return this.exactBondMatching;
    }

    public void setExactBondMatching(boolean value) {
        if (this.exactBondMatching != value) {
            this.exactBondMatching = value;
            this.setDirty(true);
        }
    }

    public void setVagueBondLevel(int value) {
        if (value == 0 || value == 2 || value == 3 || value == 4 || value == 5 || value == 1) {
            if (this.vagueBondLevel != value) {
                this.vagueBondLevel = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setVagueBondLevel " + value);
        }
    }

    public final int getVagueBondLevel() {
        return this.vagueBondLevel;
    }

    public void setCompleteHG(boolean completeStr) {
        if (this.completeHG != completeStr) {
            this.completeHG = completeStr;
            this.setDirty(true);
        }
    }

    public final boolean getCompleteHG() {
        return this.completeHG;
    }

    public final boolean hasChangesInUserComparators() {
        return this.changedUserComparator;
    }

    public final void clearChangesInUserComparators() {
        this.changedUserComparator = false;
    }

    public final boolean hasUserComparators() {
        return this.userComparators != null;
    }

    public void addUserComparator(MolComparator mc) {
        if (!this.hasUserComparators()) {
            this.userComparators = new ArrayList(1);
        }
        this.userComparators.add(mc);
        this.setDirty(true);
        this.changedUserComparator = true;
    }

    public void deleteUserComparator(MolComparator mc) {
        if (mc != null && this.hasUserComparators() && this.userComparators.remove(mc)) {
            this.setDirty(true);
            this.changedUserComparator = true;
            if (this.userComparators.isEmpty()) {
                this.userComparators = null;
            }
        }
    }

    public void deleteAllUserComparators() {
        if (this.hasUserComparators()) {
            this.userComparators = null;
            this.setDirty(true);
            this.changedUserComparator = true;
        }
    }

    public MolComparator[] getUserComparators() {
        if (this.userComparators == null) {
            return null;
        }
        return this.userComparators.toArray(new MolComparator[this.userComparators.size()]);
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean v) {
        this.dirty = v;
    }

    public Object clone() throws CloneNotSupportedException {
        SearchOptions so = (SearchOptions)super.clone();
        this.clonecopy(so);
        return so;
    }

    public void clonecopy(SearchOptions other) {
        other.searchType = this.searchType;
        this.clonecopyOptions(other);
    }

    public void clonecopyOptions(SearchOptions other) {
        other.exactTopologyMatching = this.exactTopologyMatching;
        other.exactQueryAtomMatching = this.exactQueryAtomMatching;
        other.doubleBondStereoMatchingMode = this.doubleBondStereoMatchingMode;
        other.HCountMatching = this.HCountMatching;
        other.verbose = this.verbose;
        other.superstructureSearch = this.superstructureSearch;
        other.exactBondMatching = this.exactBondMatching;
        other.checkSpHyb = this.checkSpHyb;
        other.orderSensitiveSearch = this.orderSensitiveSearch;
        other.userComparators = this.userComparators;
        other.changedUserComparator = this.changedUserComparator;
        other.vagueBondLevel = this.vagueBondLevel;
        other.completeHG = this.completeHG;
        other.keepQueryOrder = this.keepQueryOrder;
        other.exactFragment = this.exactFragment;
        other.tautomerSearch = this.tautomerSearch;
        other.tautomerSearchOption = this.tautomerSearchOption;
        other.tautomerSearchOptionLeftDefault = this.tautomerSearchOptionLeftDefault;
        other.isotopeMatching = this.isotopeMatching;
        other.chargeMatching = this.chargeMatching;
        other.valenceMatching = this.valenceMatching;
        other.radicalMatching = this.radicalMatching;
        other.mixSgroupMatching = this.mixSgroupMatching;
        other.polymerMatching = this.polymerMatching;
        other.endGroupMatching = this.endGroupMatching;
        other.transformMonomer = this.transformMonomer;
        other.phaseShift = this.phaseShift;
        other.copolymerMatching = this.copolymerMatching;
        other.homologyNarrowTranslation = this.homologyNarrowTranslation;
        other.homologyBroadTranslation = this.homologyBroadTranslation;
        other.ssrOption = this.ssrOption;
        other.stereoModel = this.stereoModel;
        other.stereoSearchType = this.stereoSearchType;
        other.ignoreTetrahedralStereo = this.ignoreTetrahedralStereo;
        other.ignoreDoubleBondStereo = this.ignoreDoubleBondStereo;
        other.ignoreAxialStereo = this.ignoreAxialStereo;
        other.ignoreAlleneStereo = this.ignoreAlleneStereo;
        other.ignoreSynAntiStereo = this.ignoreSynAntiStereo;
        other.implicitHMatching = this.implicitHMatching;
        other.reactionUnpairedMapMatching = this.reactionUnpairedMapMatching;
        other.attachedDataMatch = this.attachedDataMatch;
        other.attachedDataPrefixes = this.attachedDataPrefixes;
        other.exactSpecialAtomMatching = this.exactSpecialAtomMatching;
        other.chemTermsFilter = this.chemTermsFilter;
        other.chemTermsFilterConfig = this.chemTermsFilterConfig;
        other.undefinedRAtom = this.undefinedRAtom;
        other.bridgingRAllowed = this.bridgingRAllowed;
        other.RLigandEqualityCheck = this.RLigandEqualityCheck;
        other.hitOrdering = this.hitOrdering;
        other.exhaustiveModeLimit = this.exhaustiveModeLimit;
        other.timeoutLimitSteps = this.timeoutLimitSteps;
        other.timeoutLimitMilliseconds = this.timeoutLimitMilliseconds;
        other.throwExceptionOnTimeout = this.throwExceptionOnTimeout;
        other.tautomerDuplicateFiltering = this.tautomerDuplicateFiltering;
        other.setDirty(true);
    }

    public void setTautomerSearch(int value) {
        if (value == 2 || value == 0 || value == 1) {
            if (this.tautomerSearchOption != value) {
                this.tautomerSearchOption = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setTautomerSearch(int): " + value);
        }
    }

    public final int getTautomerSearch() {
        return this.tautomerSearchOption;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String name, String value) {
        if ("orderSensitive".equalsIgnoreCase(name)) {
            this.setOrderSensitiveSearch(SearchOptions.getBoolean(value));
            return;
        } else if ("tautomer".equalsIgnoreCase(name)) {
            this.setTautomerSearch(SearchOptions.getBoolean(value) ? 1 : 0);
            return;
        } else if ("tautomerSearch".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setTautomerSearch(2);
                return;
            } else if ("y".equalsIgnoreCase(value)) {
                this.setTautomerSearch(1);
                return;
            } else {
                if (!"n".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setTautomerSearch(0);
            }
            return;
        } else if ("exactStereoSearch".equalsIgnoreCase(name) || "exactStereoMatching".equalsIgnoreCase(name)) {
            this.setStereoSearchType(SearchOptions.getBoolean(value) ? 2 : (this.getStereoSearchType() == 2 ? 0 : this.getStereoSearchType()));
            return;
        } else if ("stereoSearch".equalsIgnoreCase(name)) {
            this.setStereoSearchType(SearchOptions.getBoolean(value) ? 0 : 1);
            return;
        } else if ("stereoSearchType".equalsIgnoreCase(name)) {
            if ("I".equalsIgnoreCase(value)) {
                this.setStereoSearchType(1);
                return;
            } else if ("S".equalsIgnoreCase(value)) {
                this.setStereoSearchType(0);
                return;
            } else if ("E".equalsIgnoreCase(value)) {
                this.setStereoSearchType(2);
                return;
            } else if ("D".equalsIgnoreCase(value)) {
                this.setStereoSearchType(3);
                return;
            } else {
                if (!"A".equalsIgnoreCase(value)) return;
                this.setStereoSearchType(4);
            }
            return;
        } else if ("ignoreTetrahedralStereo".equalsIgnoreCase(name)) {
            this.setIgnoreTetrahedralStereo(SearchOptions.getBoolean(value));
            return;
        } else if ("ignoreDoubleBondStereo".equalsIgnoreCase(name)) {
            this.setIgnoreDoubleBondStereo(SearchOptions.getBoolean(value));
            return;
        } else if ("ignoreAxialStereo".equalsIgnoreCase(name)) {
            this.setIgnoreAxialStereo(SearchOptions.getBoolean(value));
            return;
        } else if ("ignoreAlleneStereo".equalsIgnoreCase(name)) {
            this.setIgnoreAlleneStereo(SearchOptions.getBoolean(value));
            return;
        } else if ("ignoreSynAntiStereo".equalsIgnoreCase(name)) {
            this.setIgnoreSynAntiStereo(SearchOptions.getBoolean(value));
            return;
        } else if ("keepQueryOrder".equalsIgnoreCase(name)) {
            this.setKeepQueryOrder(SearchOptions.getBoolean(value));
            return;
        } else if ("exactAtomMatching".equalsIgnoreCase(name)) {
            if (SearchOptions.getBoolean(value)) {
                this.setRadicalMatching(1);
                this.setIsotopeMatching(1);
                this.setChargeMatching(1);
                this.setExactQueryAtomMatching(true);
                return;
            } else {
                if (this.getRadicalMatching() == 1) {
                    this.setRadicalMatching(0);
                }
                if (this.getIsotopeMatching() == 1) {
                    this.setIsotopeMatching(0);
                }
                if (this.getChargeMatching() == 1) {
                    this.setChargeMatching(0);
                }
                this.setExactQueryAtomMatching(false);
            }
            return;
        } else if ("exactBondMatching".equalsIgnoreCase(name)) {
            this.setExactBondMatching(SearchOptions.getBoolean(value));
            return;
        } else if ("exactQueryAtomMatching".equalsIgnoreCase(name)) {
            this.setExactQueryAtomMatching(SearchOptions.getBoolean(value));
            return;
        } else if ("exactRadicalMatching".equalsIgnoreCase(name)) {
            if (SearchOptions.getBoolean(value)) {
                this.setRadicalMatching(1);
                return;
            } else {
                if (this.getRadicalMatching() != 1) return;
                this.setRadicalMatching(0);
            }
            return;
        } else if ("exactIsotopeMatching".equalsIgnoreCase(name)) {
            if (SearchOptions.getBoolean(value)) {
                this.setIsotopeMatching(1);
                return;
            } else {
                if (this.getIsotopeMatching() != 1) return;
                this.setIsotopeMatching(0);
            }
            return;
        } else if ("exactChargeMatching".equalsIgnoreCase(name)) {
            if (SearchOptions.getBoolean(value)) {
                this.setChargeMatching(1);
                return;
            } else {
                if (this.getChargeMatching() != 1) return;
                this.setChargeMatching(0);
            }
            return;
        } else if ("checkSpHyb".equalsIgnoreCase(name)) {
            this.setCheckSpHyb(SearchOptions.getBoolean(value));
            return;
        } else if ("doubleBondStereo".equalsIgnoreCase(name)) {
            int iValue;
            if ("M".equalsIgnoreCase(value)) {
                iValue = 1;
            } else if ("N".equalsIgnoreCase(value)) {
                iValue = 2;
            } else {
                if (!"A".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + "\nUse -h for help.");
                iValue = 0;
            }
            this.setDoubleBondStereoMatchingMode(iValue);
            return;
        } else if ("HCountMatching".equalsIgnoreCase(name)) {
            if ("G".equalsIgnoreCase(value)) {
                this.setHCountMatching(2);
                return;
            } else if ("E".equalsIgnoreCase(value)) {
                this.setHCountMatching(1);
                return;
            } else {
                if (!"A".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + "\nUse -h for help.");
                this.setHCountMatching(0);
            }
            return;
        } else if ("t".equalsIgnoreCase(name)) {
            if ("s".equalsIgnoreCase(value)) {
                this.setSearchType0(2);
                return;
            } else if ("d".equalsIgnoreCase(value)) {
                this.setSearchType0(5);
                return;
            } else if ("f".equalsIgnoreCase(value)) {
                this.setSearchType0(4);
                return;
            } else if ("ff".equalsIgnoreCase(value)) {
                this.setSearchType0(7);
                return;
            } else if ("u".equalsIgnoreCase(value)) {
                this.setSearchType0(6);
                return;
            } else if ("i".equalsIgnoreCase(value)) {
                this.setSearchType0(3);
                return;
            } else if ("na".equalsIgnoreCase(value)) {
                this.setSearchType0(1);
                return;
            } else if ("ns".equalsIgnoreCase(value)) {
                this.setSearchType0(0);
                return;
            } else if ("e".equalsIgnoreCase(value)) {
                this.setSearchType0(4);
                return;
            } else if ("ef".equalsIgnoreCase(value)) {
                this.setSearchType0(7);
                return;
            } else if ("p".equalsIgnoreCase(value)) {
                this.setSearchType0(5);
                return;
            } else {
                if (!"mcs".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: search type: " + name + ":" + value + "\nUse -h for help.");
                this.setSearchType0(8);
            }
            return;
        } else if ("implicitHMatching".equalsIgnoreCase(name)) {
            if ("D".equalsIgnoreCase(value)) {
                this.setImplicitHMatching(0);
                return;
            } else if ("Y".equalsIgnoreCase(value)) {
                this.setImplicitHMatching(1);
                return;
            } else if ("N".equalsIgnoreCase(value)) {
                this.setImplicitHMatching(2);
                return;
            } else {
                if (!"I".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setImplicitHMatching(3);
            }
            return;
        } else if ("reactionUnpairedMap".equalsIgnoreCase(name)) {
            if ("all".equalsIgnoreCase(value)) {
                this.setReactionUnpairedMapMatching(true);
                return;
            } else {
                if (!"unpairedOnly".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setReactionUnpairedMapMatching(false);
            }
            return;
        } else if ("vagueBond".equalsIgnoreCase(name)) {
            if ("1".equalsIgnoreCase(value)) {
                this.setVagueBondLevel(0);
                return;
            } else if ("n".equalsIgnoreCase(value)) {
                this.setVagueBondLevel(1);
                return;
            } else if ("2".equalsIgnoreCase(value)) {
                this.setVagueBondLevel(2);
                return;
            } else if ("3".equalsIgnoreCase(value)) {
                this.setVagueBondLevel(3);
                return;
            } else {
                if (!"4".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + "\nUse -h for help.");
                this.setVagueBondLevel(4);
            }
            return;
        } else if ("completeHG".equalsIgnoreCase(name)) {
            this.setCompleteHG(SearchOptions.getBoolean(value));
            return;
        } else if ("charge".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setChargeMatching(0);
                return;
            } else if ("e".equalsIgnoreCase(value)) {
                this.setChargeMatching(1);
                return;
            } else {
                if (!"i".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setChargeMatching(2);
            }
            return;
        } else if ("isotope".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setIsotopeMatching(0);
                return;
            } else if ("e".equalsIgnoreCase(value)) {
                this.setIsotopeMatching(1);
                return;
            } else {
                if (!"i".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setIsotopeMatching(2);
            }
            return;
        } else if ("radical".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setRadicalMatching(0);
                return;
            } else if ("e".equalsIgnoreCase(value)) {
                this.setRadicalMatching(1);
                return;
            } else {
                if (!"i".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setRadicalMatching(2);
            }
            return;
        } else if ("valence".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setValenceMatching(true);
                return;
            } else {
                if (!"i".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setValenceMatching(false);
            }
            return;
        } else if ("mix".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setMixSgroupMatching(true);
                return;
            } else {
                if (!"i".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setMixSgroupMatching(false);
            }
            return;
        } else if ("polymer".equalsIgnoreCase(name)) {
            if ("d".equalsIgnoreCase(value)) {
                this.setPolymerMatching(true);
                return;
            } else {
                if (!"i".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setPolymerMatching(false);
            }
            return;
        } else if ("endGroupMatching".equalsIgnoreCase(name)) {
            if ("y".equalsIgnoreCase(value)) {
                this.setEndgroupMatching(true);
                return;
            } else {
                if (!"n".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setEndgroupMatching(false);
            }
            return;
        } else if ("transformMonomer".equalsIgnoreCase(name)) {
            if ("y".equalsIgnoreCase(value)) {
                this.setMonomerTransform(true);
                return;
            } else {
                if (!"n".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setMonomerTransform(false);
            }
            return;
        } else if ("phaseShift".equalsIgnoreCase(name)) {
            if ("y".equalsIgnoreCase(value)) {
                this.setPhaseShiftedMatching(true);
                return;
            } else {
                if (!"n".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setPhaseShiftedMatching(false);
            }
            return;
        } else if ("copolymerMatching".equalsIgnoreCase(name)) {
            if ("y".equalsIgnoreCase(value)) {
                this.setCopolymerMatching(true);
                return;
            } else {
                if (!"n".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setCopolymerMatching(false);
            }
            return;
        } else if ("homologyHandling".equalsIgnoreCase(name)) {
            if ("y".equalsIgnoreCase(value)) {
                this.setHomologyNarrowTranslation(HomologyTranslationOption.ALL);
                return;
            } else {
                if (!"n".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setHomologyNarrowTranslation(HomologyTranslationOption.NONE);
            }
            return;
        } else if ("homologyNarrowTranslation".equalsIgnoreCase(name)) {
            HomologyTranslationOption option = HomologyTranslationOption.fromString(value);
            if (option == null) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
            this.setHomologyNarrowTranslation(option);
            return;
        } else if ("homologyBroadTranslation".equalsIgnoreCase(name)) {
            HomologyTranslationOption option = HomologyTranslationOption.fromString(value);
            if (option == null) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
            this.setHomologyBroadTranslation(option);
            return;
        } else if ("ssrType".equalsIgnoreCase(name)) {
            SetOfSmallestRingsOption option = SetOfSmallestRingsOption.fromString(value);
            if (option == null) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
            this.setSSRType(option);
            return;
        } else if ("stereoModel".equalsIgnoreCase(name)) {
            if ("l".equalsIgnoreCase(value)) {
                this.setStereoModel(0);
                return;
            } else if ("c".equalsIgnoreCase(value)) {
                this.setStereoModel(1);
                return;
            } else if ("g".equalsIgnoreCase(value)) {
                this.setStereoModel(2);
                return;
            } else {
                if (!"d".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setStereoModel(3);
            }
            return;
        } else if ("undefinedRAtom".equalsIgnoreCase(name)) {
            if ("a".equalsIgnoreCase(value)) {
                this.setUndefinedRAtom(0);
                return;
            } else if ("u".equalsIgnoreCase(value)) {
                this.setUndefinedRAtom(1);
                return;
            } else if ("g".equalsIgnoreCase(value)) {
                this.setUndefinedRAtom(2);
                return;
            } else if ("gh".equalsIgnoreCase(value)) {
                this.setUndefinedRAtom(3);
                return;
            } else {
                if (!"ghe".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setUndefinedRAtom(4);
            }
            return;
        } else if ("bridgingRAllowed".equalsIgnoreCase(name)) {
            this.setBridgingRAllowed(SearchOptions.getBoolean(value));
            return;
        } else if ("RLigandEqualityCheck".equalsIgnoreCase(name)) {
            this.setRLigandEqualityCheck(SearchOptions.getBoolean(value));
            return;
        } else if ("hitOrdering".equalsIgnoreCase(name)) {
            if ("n".equalsIgnoreCase(value)) {
                this.setHitOrdering(0);
                return;
            } else {
                if (!"g".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setHitOrdering(1);
            }
            return;
        } else if ("attachedDataMatch".equalsIgnoreCase(name)) {
            if ("i".equalsIgnoreCase(value)) {
                this.setAttachedDataMatch(0);
                return;
            } else if ("g".equalsIgnoreCase(value)) {
                this.setAttachedDataMatch(1);
                return;
            } else {
                if (!"e".equalsIgnoreCase(value)) throw new IllegalArgumentException("error: unknown flag: " + name + ":" + value + "\nUse -h for help.");
                this.setAttachedDataMatch(2);
            }
            return;
        } else if ("attachedDataPrefixes".equalsIgnoreCase(name)) {
            this.setAttachedDataPrefixes(value);
            return;
        } else if ("exactSpecialAtomMatching".equalsIgnoreCase(name)) {
            this.setExactSpecialAtomMatching(value);
            return;
        } else if ("chemTermsFilter".equalsIgnoreCase(name)) {
            this.setChemTermsFilter(value);
            return;
        } else if ("chemTermsFilterConfig".equalsIgnoreCase(name)) {
            this.setChemTermsFilterConfig(value);
            return;
        } else if ("ignoreCTExceptions".equalsIgnoreCase(name)) {
            this.setIgnoreCTExceptions(SearchOptions.getBoolean(value));
            return;
        } else if ("exhaustiveModeLimit".equalsIgnoreCase(name)) {
            this.setExhaustiveModeLimit(Integer.parseInt(value));
            return;
        } else if ("throwExceptionOnTimeout".equalsIgnoreCase(name)) {
            this.setThrowExceptionOnTimeout(SearchOptions.getBoolean(value));
            return;
        } else if ("timeoutLimit".equalsIgnoreCase(name)) {
            this.setTimeoutLimit(Integer.parseInt(value));
            return;
        } else if ("timeoutLimitMilliseconds".equalsIgnoreCase(name)) {
            this.setTimeoutLimitMilliseconds(Integer.parseInt(value));
            return;
        } else {
            if (!"tdf".equalsIgnoreCase(name)) throw new IllegalArgumentException("error: unknown option name: " + name + "\nUse -h for help.");
            this.setTautomerDuplicateFiltering(SearchOptions.getBoolean(value));
        }
    }

    public String getOption(String name) {
        if ("orderSensitive".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isOrderSensitiveSearch());
        }
        if ("tautomer".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.getTautomerSearch() == 1);
        }
        if ("tautomerSearch".equalsIgnoreCase(name)) {
            int iValue = this.getTautomerSearch();
            if (iValue == 2) {
                return "d";
            }
            if (iValue == 1) {
                return "y";
            }
            if (iValue == 0) {
                return "n";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("exactStereoSearch".equalsIgnoreCase(name) || "exactStereoMatching".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.getStereoSearchType() == 2);
        }
        if ("stereoSearch".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.getStereoSearchType() != 1);
        }
        if ("stereoSearchType".equalsIgnoreCase(name)) {
            int i = this.getStereoSearchType();
            if (i == 1) {
                return "i";
            }
            if (i == 0) {
                return "s";
            }
            if (i == 2) {
                return "e";
            }
            if (i == 3) {
                return "d";
            }
            if (i == 4) {
                return "a";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("ignoreTetrahedralStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isIgnoreTetrahedralStereo());
        }
        if ("ignoreDoubleBondStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isIgnoreDoubleBondStereo());
        }
        if ("ignoreAlleneStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isIgnoreAlleneStereo());
        }
        if ("ignoreAxialStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isIgnoreAxialStereo());
        }
        if ("ignoreSynAntiStereo".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isIgnoreSynAntiStereo());
        }
        if ("keepQueryOrder".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isKeepQueryOrder());
        }
        if ("exactBondMatching".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isExactBondMatching());
        }
        if ("exactQueryAtomMatching".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isExactQueryAtomMatching());
        }
        if ("doubleBondStereo".equalsIgnoreCase(name)) {
            int iValue = this.getDoubleBondStereoMatchingMode();
            if (iValue == 1) {
                return "M";
            }
            if (iValue == 2) {
                return "N";
            }
            if (iValue == 0) {
                return "A";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("checkSpHyb".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.getCheckSpHyb());
        }
        if ("HCountMatching".equalsIgnoreCase(name)) {
            if (this.HCountMatching == 2) {
                return "G";
            }
            if (this.HCountMatching == 1) {
                return "E";
            }
            if (this.HCountMatching == 0) {
                return "A";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("t".equalsIgnoreCase(name)) {
            int iValue = this.getSearchType();
            if (iValue == 2) {
                return "s";
            }
            if (iValue == 4) {
                return "f";
            }
            if (iValue == 7) {
                return "ff";
            }
            if (iValue == 6) {
                return "u";
            }
            if (iValue == 5) {
                return "d";
            }
            if (iValue == 3) {
                return "i";
            }
            if (iValue == 1) {
                return "na";
            }
            if (iValue == 8) {
                return "mcs";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("implicitHMatching".equalsIgnoreCase(name)) {
            int iValue = this.getImplicitHMatching();
            if (iValue == 0) {
                return "D";
            }
            if (iValue == 1) {
                return "Y";
            }
            if (iValue == 2) {
                return "N";
            }
            if (iValue == 3) {
                return "I";
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("reactionUnpairedMap".equalsIgnoreCase(name)) {
            if (this.isReactionUnpairedMapMatching()) {
                return "all";
            }
            return "unpairedOnly";
        }
        if ("vagueBond".equalsIgnoreCase(name)) {
            switch (this.getVagueBondLevel()) {
                case 1: {
                    return "n";
                }
                case 0: {
                    return "1";
                }
                case 2: {
                    return "2";
                }
                case 3: {
                    return "3";
                }
                case 4: {
                    return "4";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("completeHG".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.getCompleteHG());
        }
        if ("charge".equalsIgnoreCase(name)) {
            switch (this.getChargeMatching()) {
                case 0: {
                    return "d";
                }
                case 1: {
                    return "e";
                }
                case 2: {
                    return "i";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("isotope".equalsIgnoreCase(name)) {
            switch (this.getIsotopeMatching()) {
                case 0: {
                    return "d";
                }
                case 1: {
                    return "e";
                }
                case 2: {
                    return "i";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("radical".equalsIgnoreCase(name)) {
            switch (this.getRadicalMatching()) {
                case 0: {
                    return "d";
                }
                case 1: {
                    return "e";
                }
                case 2: {
                    return "i";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("valence".equalsIgnoreCase(name)) {
            if (this.isValenceMatching()) {
                return "d";
            }
            return "i";
        }
        if ("mix".equalsIgnoreCase(name)) {
            if (this.isMixSgroupMatching()) {
                return "d";
            }
            return "i";
        }
        if ("polymer".equalsIgnoreCase(name)) {
            if (this.isPolymerMatching()) {
                return "d";
            }
            return "i";
        }
        if ("endGroupMatching".equalsIgnoreCase(name)) {
            if (this.isEndgroupMatching()) {
                return "y";
            }
            return "n";
        }
        if ("transformMonomer".equalsIgnoreCase(name)) {
            if (this.areMonomersTransformed()) {
                return "y";
            }
            return "n";
        }
        if ("phaseShift".equalsIgnoreCase(name)) {
            if (this.isPhaseShiftedMatching()) {
                return "y";
            }
            return "n";
        }
        if ("copolymerMatching".equalsIgnoreCase(name)) {
            if (this.isCopolymerMatching()) {
                return "y";
            }
            return "n";
        }
        if ("homologyNarrowTranslation".equalsIgnoreCase(name) || "homologyHandling".equalsIgnoreCase(name)) {
            return this.getHomologyNarrowTranslation().toString();
        }
        if ("homologyBroadTranslation".equalsIgnoreCase(name)) {
            return this.getHomologyBroadTranslation().toString();
        }
        if ("ssrType".equalsIgnoreCase(name)) {
            return this.ssrOption.toString();
        }
        if ("stereoModel".equalsIgnoreCase(name)) {
            switch (this.getStereoModel()) {
                case 0: {
                    return "l";
                }
                case 1: {
                    return "c";
                }
                case 2: {
                    return "g";
                }
                case 3: {
                    return "d";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("undefinedRAtom".equalsIgnoreCase(name)) {
            switch (this.getUndefinedRAtom()) {
                case 0: {
                    return "a";
                }
                case 1: {
                    return "u";
                }
                case 2: {
                    return "g";
                }
                case 3: {
                    return "gh";
                }
                case 4: {
                    return "ghe";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("bridgingRAllowed".equalsIgnoreCase(name)) {
            if (this.isBridgingRAllowed()) {
                return "y";
            }
            return "n";
        }
        if ("RLigandEqualityCheck".equalsIgnoreCase(name)) {
            if (this.getRLigandEqualityCheck()) {
                return "y";
            }
            return "n";
        }
        if ("hitOrdering".equalsIgnoreCase(name)) {
            switch (this.getHitOrdering()) {
                case 0: {
                    return "n";
                }
                case 1: {
                    return "g";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("attachedDataMatch".equalsIgnoreCase(name)) {
            switch (this.getAttachedDataMatch()) {
                case 0: {
                    return "i";
                }
                case 1: {
                    return "g";
                }
                case 2: {
                    return "e";
                }
            }
            throw new IllegalArgumentException("Illegal value for option " + name);
        }
        if ("attachedDataPrefixes".equalsIgnoreCase(name)) {
            return this.getAttachedDataPrefixes();
        }
        if ("exactSpecialAtomMatching".equalsIgnoreCase(name)) {
            return this.getExactSpecialAtomMatching();
        }
        if ("chemTermsFilter".equalsIgnoreCase(name)) {
            return this.getChemTermsFilter();
        }
        if ("chemTermsFilterConfig".equalsIgnoreCase(name)) {
            return this.getChemTermsFilterConfig();
        }
        if ("ignoreCTExceptions".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isIgnoreCTExceptions());
        }
        if ("exhaustiveModeLimit".equalsIgnoreCase(name)) {
            return String.valueOf(this.getExhaustiveModeLimit());
        }
        if ("throwExceptionOnTimeout".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isThrowExceptionOnTimeout());
        }
        if ("timeoutLimit".equalsIgnoreCase(name)) {
            return String.valueOf(this.getTimeoutLimitMilliseconds());
        }
        if ("timeoutLimitMilliseconds".equalsIgnoreCase(name)) {
            return String.valueOf(this.getTimeoutLimitMilliseconds());
        }
        if ("tdf".equalsIgnoreCase(name)) {
            return this.returnOptionString(this.isTautomerDuplicateFiltering());
        }
        throw new IllegalArgumentException("Unknown option " + name + "\nUse -h for help.");
    }

    protected static boolean getBoolean(String value) {
        if (value == null || "".equals(value) || "y".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("n".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("No boolean value: " + value);
    }

    protected String returnOptionString(boolean value) {
        return value ? "y" : "n";
    }

    public final boolean isKeepQueryOrder() {
        return this.keepQueryOrder;
    }

    public void setKeepQueryOrder(boolean value) {
        if (this.keepQueryOrder != value) {
            this.keepQueryOrder = value;
            this.setDirty(true);
        }
    }

    @Deprecated
    public final boolean isExactFragment() {
        return this.isFullFragment();
    }

    @Deprecated
    public void setExactFragment(boolean value) {
        this.setFullFragment(value);
    }

    public final boolean isFullFragment() {
        return this.searchType == 4 || this.searchType == 7 || this.searchType == 5;
    }

    @Deprecated
    public void setFullFragment(boolean value) {
        if (this.exactFragment != value) {
            this.exactFragment = value;
            this.setDirty(true);
        }
    }

    public final int getIsotopeMatching() {
        return this.isotopeMatching;
    }

    public void setIsotopeMatching(int value) {
        if (value == 0 || value == 1 || value == 2) {
            if (this.isotopeMatching != value) {
                this.isotopeMatching = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setIsotopeMatching " + value);
        }
    }

    public final int getChargeMatching() {
        return this.chargeMatching;
    }

    public void setChargeMatching(int value) {
        if (value == 0 || value == 1 || value == 2) {
            if (this.chargeMatching != value) {
                this.chargeMatching = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setChargeMatching " + value);
        }
    }

    public final boolean isValenceMatching() {
        return this.valenceMatching;
    }

    public void setValenceMatching(boolean value) {
        if (this.valenceMatching != value) {
            this.valenceMatching = value;
            this.setDirty(true);
        }
    }

    public final int getRadicalMatching() {
        return this.radicalMatching;
    }

    public void setRadicalMatching(int value) {
        if (value == 0 || value == 1 || value == 2) {
            if (this.radicalMatching != value) {
                this.radicalMatching = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setRadicalMatching " + value);
        }
    }

    public final boolean isMixSgroupMatching() {
        return this.mixSgroupMatching;
    }

    public void setMixSgroupMatching(boolean value) {
        if (this.mixSgroupMatching != value) {
            this.mixSgroupMatching = value;
            this.setDirty(true);
        }
    }

    public final boolean isPolymerMatching() {
        return this.polymerMatching;
    }

    public void setPolymerMatching(boolean value) {
        if (this.polymerMatching != value) {
            this.polymerMatching = value;
            this.setDirty(true);
        }
    }

    public final boolean isEndgroupMatching() {
        return this.endGroupMatching;
    }

    public void setEndgroupMatching(boolean value) {
        if (this.endGroupMatching != value) {
            this.endGroupMatching = value;
            this.setDirty(true);
        }
    }

    public final boolean areMonomersTransformed() {
        return this.transformMonomer;
    }

    public void setMonomerTransform(boolean value) {
        if (this.transformMonomer != value) {
            this.transformMonomer = value;
            this.setDirty(true);
        }
    }

    public final boolean isPhaseShiftedMatching() {
        return this.phaseShift;
    }

    public void setPhaseShiftedMatching(boolean value) {
        if (this.phaseShift != value) {
            this.phaseShift = value;
            this.setDirty(true);
        }
    }

    public final boolean isCopolymerMatching() {
        return this.copolymerMatching;
    }

    public void setCopolymerMatching(boolean value) {
        if (this.copolymerMatching != value) {
            this.copolymerMatching = value;
            this.setDirty(true);
        }
    }

    @Deprecated
    public final boolean isQHomologyHandling() {
        return this.homologyNarrowTranslation != HomologyTranslationOption.NONE;
    }

    @Deprecated
    public void setQHomologyHandling(boolean value) {
        if (this.homologyNarrowTranslation != HomologyTranslationOption.ALL) {
            this.homologyNarrowTranslation = HomologyTranslationOption.ALL;
            this.setDirty(true);
        }
    }

    public final HomologyTranslationOption getHomologyNarrowTranslation() {
        return this.homologyNarrowTranslation;
    }

    public void setHomologyNarrowTranslation(HomologyTranslationOption value) {
        if (this.homologyNarrowTranslation != value) {
            this.homologyNarrowTranslation = value;
            this.setDirty(true);
        }
    }

    public final HomologyTranslationOption getHomologyBroadTranslation() {
        return this.homologyBroadTranslation;
    }

    public void setHomologyBroadTranslation(HomologyTranslationOption value) {
        if (this.homologyBroadTranslation != value) {
            this.homologyBroadTranslation = value;
            this.setDirty(true);
        }
    }

    public void setSSRType(SetOfSmallestRingsOption value) {
        if (this.ssrOption != value) {
            this.ssrOption = value;
            this.setDirty(true);
        }
    }

    public SetOfSmallestRingsOption getSSRType() {
        return this.ssrOption;
    }

    public final int getStereoModel() {
        return this.stereoModel;
    }

    public void setStereoModel(int value) {
        if (value == 0 || value == 1 || value == 2 || value == 3) {
            if (this.stereoModel != value) {
                this.stereoModel = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setStereoModel " + value);
        }
    }

    public final void setStereoSearchType(int value) {
        if (value == 0 || value == 1 || value == 2 || value == 3 || value == 4) {
            if (this.stereoSearchType != value) {
                this.stereoSearchType = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setStereoSearchType " + value);
        }
    }

    public final int getStereoSearchType() {
        return this.stereoSearchType;
    }

    public final void setIgnoreTetrahedralStereo(boolean value) {
        if (this.ignoreTetrahedralStereo != value) {
            this.ignoreTetrahedralStereo = value;
            this.setDirty(true);
        }
    }

    public final boolean isIgnoreTetrahedralStereo() {
        return this.ignoreTetrahedralStereo;
    }

    public final void setIgnoreDoubleBondStereo(boolean value) {
        if (this.ignoreDoubleBondStereo != value) {
            this.ignoreDoubleBondStereo = value;
            this.setDirty(true);
        }
    }

    public final boolean isIgnoreDoubleBondStereo() {
        return this.ignoreDoubleBondStereo;
    }

    public final void setIgnoreAlleneStereo(boolean value) {
        if (this.ignoreAlleneStereo != value) {
            this.ignoreAlleneStereo = value;
            this.setDirty(true);
        }
    }

    public final boolean isIgnoreAlleneStereo() {
        return this.ignoreAlleneStereo;
    }

    public final void setIgnoreAxialStereo(boolean value) {
        if (this.ignoreAxialStereo != value) {
            this.ignoreAxialStereo = value;
            this.setDirty(true);
        }
    }

    public final boolean isIgnoreAxialStereo() {
        return this.ignoreAxialStereo;
    }

    public final void setIgnoreSynAntiStereo(boolean value) {
        if (this.ignoreSynAntiStereo != value) {
            this.ignoreSynAntiStereo = value;
            this.setDirty(true);
        }
    }

    public final boolean isIgnoreSynAntiStereo() {
        return this.ignoreSynAntiStereo;
    }

    public final boolean getCheckSpHyb() {
        return this.checkSpHyb;
    }

    public void setCheckSpHyb(boolean checkSp) {
        if (this.checkSpHyb != checkSp) {
            this.checkSpHyb = checkSp;
            this.setDirty(true);
        }
    }

    public final int getImplicitHMatching() {
        return this.implicitHMatching;
    }

    public void setImplicitHMatching(int value) {
        if (value == 0 || value == 2 || value == 1 || value == 3) {
            if (this.implicitHMatching != value) {
                this.implicitHMatching = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setImplicitHMatching " + value);
        }
    }

    public final boolean isReactionUnpairedMapMatching() {
        return this.reactionUnpairedMapMatching;
    }

    public void setReactionUnpairedMapMatching(boolean value) {
        if (this.reactionUnpairedMapMatching != value) {
            this.reactionUnpairedMapMatching = value;
            this.setDirty(true);
        }
    }

    public void setChemTermsFilter(String value) {
        if (this.chemTermsFilter == null && value == null) {
            return;
        }
        if (this.chemTermsFilter == null || value == null || !this.chemTermsFilter.equals(value)) {
            this.chemTermsFilter = value;
            this.setDirty(true);
        }
    }

    public final String getChemTermsFilter() {
        return this.chemTermsFilter;
    }

    public void setChemTermsFilterConfig(String value) {
        if (this.chemTermsFilterConfig == null && value == null) {
            return;
        }
        if (this.chemTermsFilterConfig == null || value == null || !this.chemTermsFilterConfig.equals(value)) {
            this.chemTermsFilterConfig = value;
            this.setDirty(true);
        }
    }

    public final String getChemTermsFilterConfig() {
        return this.chemTermsFilterConfig;
    }

    public void setUndefinedRAtom(int value) {
        this.setUndefinedRAtom(value, true);
    }

    void setUndefinedRAtom(int value, boolean userDefined) {
        if (value == 0 || value == 1 || value == 2 || value == 3 || value == 4) {
            this.undefinedRAtomUserDefined = userDefined;
            if (this.undefinedRAtom != value) {
                this.undefinedRAtom = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setUndefinedRAtom: " + value);
        }
    }

    boolean isUndefinedRAtomUserDefined() {
        return this.undefinedRAtomUserDefined;
    }

    public final int getUndefinedRAtom() {
        return this.undefinedRAtom;
    }

    public final boolean isUndefinedRAtomMatchingGroup() {
        return this.undefinedRAtom == 2 || this.undefinedRAtom == 3 || this.undefinedRAtom == 4;
    }

    public void setBridgingRAllowed(boolean value) {
        if (this.bridgingRAllowed != value) {
            this.bridgingRAllowed = value;
            this.setDirty(true);
        }
    }

    public final boolean isBridgingRAllowed() {
        return this.bridgingRAllowed;
    }

    public void setRLigandEqualityCheck(boolean value) {
        if (this.RLigandEqualityCheck != value) {
            this.RLigandEqualityCheck = value;
            this.setDirty(true);
        }
    }

    public final boolean getRLigandEqualityCheck() {
        return this.RLigandEqualityCheck;
    }

    public void setHitOrdering(int value) {
        if (value == 0 || value == 1) {
            if (this.hitOrdering != value) {
                this.hitOrdering = value;
                this.setDirty(true);
            }
        } else {
            throw new IllegalArgumentException("Illegal value for setHitOrdering: " + value);
        }
    }

    public int getHitOrdering() {
        return this.hitOrdering;
    }

    public void setAttachedDataMatch(int value) {
        if (this.attachedDataMatch != value) {
            this.attachedDataMatch = value;
            this.setDirty(true);
        }
    }

    public final int getAttachedDataMatch() {
        return this.attachedDataMatch;
    }

    public void setAttachedDataPrefixes(String value) {
        if (this.attachedDataPrefixes != value) {
            this.attachedDataPrefixes = value;
            this.setDirty(true);
        }
    }

    public final String getAttachedDataPrefixes() {
        return this.attachedDataPrefixes;
    }

    public void setExactSpecialAtomMatching(String value) {
        if (!this.exactSpecialAtomMatching.equalsIgnoreCase(value)) {
            this.exactSpecialAtomMatching = value.toUpperCase();
            this.setDirty(true);
        }
    }

    public final String getExactSpecialAtomMatching() {
        return this.exactSpecialAtomMatching;
    }

    public final boolean isIgnoreCTExceptions() {
        return this.ignoreCTExceptions;
    }

    public void setIgnoreCTExceptions(boolean value) {
        this.ignoreCTExceptions = value;
    }

    public final int getExhaustiveModeLimit() {
        return this.exhaustiveModeLimit;
    }

    public void setExhaustiveModeLimit(int value) {
        this.exhaustiveModeLimit = value;
    }

    @Deprecated
    public final int getTimeoutLimit() {
        return this.timeoutLimitSteps;
    }

    @Deprecated
    public void setTimeoutLimit(int value) {
        this.timeoutLimitSteps = value;
    }

    public final int getTimeoutLimitMilliseconds() {
        return this.timeoutLimitMilliseconds;
    }

    public void setTimeoutLimitMilliseconds(int value) {
        this.timeoutLimitMilliseconds = value;
    }

    public final boolean isThrowExceptionOnTimeout() {
        return this.throwExceptionOnTimeout;
    }

    public void setThrowExceptionOnTimeout(boolean value) {
        this.throwExceptionOnTimeout = value;
    }

    @Deprecated
    public void setTautomerDuplicateFiltering(boolean value) {
        if (this.tautomerDuplicateFiltering != value) {
            this.tautomerDuplicateFiltering = value;
            this.setDirty(true);
        }
    }

    @Deprecated
    public final boolean isTautomerDuplicateFiltering() {
        return this.tautomerDuplicateFiltering;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String sep) {
        ArrayList<String> al = this.toList();
        if (al.size() == 0) {
            return "";
        }
        if (sep == null) {
            sep = this.findAppropriateSeparator(al);
        }
        StringBuffer b = new StringBuffer();
        if (!sep.equals("\n")) {
            b.append("sep=" + sep + " ");
        }
        b.append(al.get(0));
        for (int i = 1; i < al.size(); ++i) {
            b.append(sep + al.get(i));
        }
        return new String(b);
    }

    private String findAppropriateSeparator(ArrayList<String> al) {
        String seps = ",;><*-!#*^*%@~`_/?$&";
        String sep = "";
        for (int l = 1; l < 4; ++l) {
            for (int i = 0; i < seps.length() - l + 1; ++i) {
                sep = seps.substring(i, i + l);
                boolean found = false;
                for (int j = 0; j < al.size(); ++j) {
                    if (al.get(j).indexOf(sep) < 0) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return sep;
            }
        }
        throw new IllegalArgumentException("Unable to find a valid separator.");
    }

    public String getAllOptionsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String optionName : this.getOptionNames()) {
            sb.append(optionName + ":" + this.getOption(optionName) + " ");
        }
        String optionsString = sb.toString().trim();
        return optionsString;
    }

    public String getAllOptionsAsString(String sep) {
        return SearchOptions.addSeparator(this.getAllOptionsAsString(), sep);
    }

    private static String addSeparator(String optionsString, String sep) {
        if (sep != null) {
            optionsString.replaceAll(" ", sep);
            optionsString = "sep=" + sep + " " + optionsString;
        }
        return optionsString;
    }

    public ArrayList<String> toList() {
        ArrayList<String> ret = new ArrayList<String>();
        SearchOptions so = new SearchOptions(2);
        String searchType = this.getOption("t");
        if (!searchType.equalsIgnoreCase(so.getOption("t"))) {
            ret.add("t:" + searchType);
            so.setOption("t", searchType);
        }
        this.fillOptionList(ret, so);
        return ret;
    }

    protected String[] getOptionNames() {
        return optionNames;
    }

    void fillOptionList(ArrayList<String> ret, SearchOptions so) {
        this.fillOptionList(ret, so, this.getOptionNames());
    }

    private void fillOptionList(ArrayList<String> ret, SearchOptions so, String[] optNames) {
        for (int i = 0; i < optNames.length; ++i) {
            String defaultValue = so.getOption(optNames[i]);
            String thisValue = this.getOption(optNames[i]);
            if (thisValue == null || defaultValue != null && defaultValue.equalsIgnoreCase(thisValue)) continue;
            ret.add(optNames[i] + ":" + thisValue);
        }
    }
}

