/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.enumeration.SelectionUtil;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerUtil;
import chemaxon.sss.SearchConstants;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;

public class SearchUtil
implements SearchConstants {
    public static final int DEFAULT_ENUMERATION = SearchUtil.getEnumerationOption(false, false, false, 0);
    public static final int SEARCHHIT_CACHE_SIZE = 100;

    public static int getEnumerationOption(boolean exactQueryAtomMatching, boolean exactBondMatching, boolean tautomerSearch, int vagueBondLevel) {
        return SearchUtil.getEnumerationOption(exactQueryAtomMatching, exactBondMatching, tautomerSearch, vagueBondLevel, false);
    }

    public static int getEnumerationOption(boolean exactQueryAtomMatching, boolean exactBondMatching, boolean tautomerSearch, int vagueBondLevel, boolean queryOptimizing) {
        int enOptions = 1;
        if (exactQueryAtomMatching) {
            enOptions &= 0xFFFFFFFE;
        }
        if (tautomerSearch) {
            enOptions |= 2;
        }
        if (!exactBondMatching) {
            if (vagueBondLevel == 5) {
                enOptions |= 4;
            } else if (vagueBondLevel == 0) {
                enOptions |= 4;
                enOptions |= 0x4000;
            } else if (vagueBondLevel == 2) {
                enOptions |= 4;
                enOptions |= 0x4000;
                enOptions |= 0x40;
            } else if (vagueBondLevel == 3) {
                enOptions |= 0xC0;
            } else if (vagueBondLevel == 4) {
                enOptions |= 0x140;
            }
            if (queryOptimizing && !exactQueryAtomMatching && !tautomerSearch) {
                enOptions |= 0x200;
            }
            enOptions |= 0x800;
        }
        return enOptions;
    }

    public static boolean hasUndefinedRAtom(Molecule mol) {
        RgMolecule rgmol = mol instanceof RgMolecule ? (RgMolecule)mol : null;
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            if (!SearchUtil.isUndefinedRAtom(mol.getAtom(i), rgmol)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUndefinedRAtom(MolAtom atom, RgMolecule rgmol) {
        return atom.getAtno() == 134 && (rgmol == null || rgmol.findRgroupIndex(atom.getRgroup()) == -1);
    }

    public static int[] convertToSingleHit(int[][] groupHit) {
        int[] hit = new int[groupHit.length];
        for (int i = 0; i < groupHit.length; ++i) {
            hit[i] = groupHit[i].length > 0 ? groupHit[i][0] : -2147483643;
        }
        return hit;
    }

    public static int[][] convertToGroupHit(int[] hit) {
        int[][] groupHit = new int[hit.length][];
        for (int i = 0; i < hit.length; ++i) {
            int[] nArray;
            if (hit[i] != -2147483643) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = hit[i];
            } else {
                nArray = new int[]{};
            }
            groupHit[i] = nArray;
        }
        return groupHit;
    }

    public static String getHitReportHeader(int matchCount) {
        return SearchUtil.getHitReportHeader(matchCount, -1);
    }

    public static String getHitReportHeader(int matchCount, int queryIndex) {
        return "    Query " + (queryIndex != -1 ? queryIndex + 1 + " " : "") + "has " + matchCount + (matchCount == 1 ? " match:" : " matches:");
    }

    public static void sprintHit(int[] hit, int index, StringBuffer sb) {
        sb.append("        Match " + (index + 1) + ":");
        sb.append("[ ");
        SearchUtil.sprint(hit, sb);
        sb.append("]");
    }

    public static void sprintGroupHit(int[][] groupHit, int index, StringBuffer sb) {
        SearchUtil.sprintHit(SearchUtil.convertToSingleHit(groupHit), index, sb);
        boolean g = false;
        for (int[] group : groupHit) {
            if (group.length <= 1) continue;
            if (!g) {
                g = true;
                sb.append("\n         Groups:{ ");
            } else {
                sb.append("\n                { ");
            }
            SearchUtil.sprint(group, sb);
            sb.append("}");
        }
    }

    private static void sprint(int[] a, StringBuffer sb) {
        for (int k = 0; k < a.length; ++k) {
            String si = SearchUtil.getHitSymbol(a[k]);
            if (si.length() < 4) {
                for (int l = 0; l < 4 - si.length(); ++l) {
                    sb.append(" ");
                }
            }
            sb.append(si);
            sb.append(",");
        }
        sb.setCharAt(sb.length() - 1, ' ');
    }

    public static String getHitSymbol(int value) {
        switch (value) {
            case -2147483648: {
                return "-1";
            }
            case -2147483647: {
                return "R";
            }
            case -2147483646: {
                return "M";
            }
            case -2147483645: {
                return "U";
            }
            case -2147483644: {
                return "LP";
            }
            case -2147483641: {
                return "EXCL";
            }
            case -2147483643: {
                return "E";
            }
        }
        return Integer.toString(value >= 0 ? value + 1 : value - 1);
    }

    public static void cacheAromatizationMethod(Molecule mol, SearchOptions searchOptions, Standardizer standardizer) throws SearchException {
        if (mol == null || mol.getPropertyObject("AROMATIZATION_METHOD") != null) {
            return;
        }
        int aromMeth = 2;
        if (searchOptions != null && standardizer != null && !Supergraph.containsMarkushFeatures(mol) && searchOptions.getTautomerSearch() != 1) {
            String[] actionStrV = new String[]{"aromatize:b", "aromatize:g", "aromatize:l"};
            int[] aromConstV = new int[]{1, 2, 3};
            for (int i = 0; i < actionStrV.length; ++i) {
                if (StandardizerUtil.getLastIndexOfTask(standardizer, "aromatize:b") == -1) continue;
                aromMeth = aromConstV[i];
                break;
            }
        }
        mol.setPropertyObject("AROMATIZATION_METHOD", aromMeth);
    }

    public static void selectStereoModel(SearchOptions searchOptions, SearchOptions searchOptionsToSet, Integer tableType, boolean isMarkushSearch) {
        int model = searchOptions.getStereoModel();
        int searchType = searchOptions.getSearchType();
        if (model == 3) {
            if (isMarkushSearch) {
                searchOptionsToSet.setStereoModel(0);
            } else if (searchType != 5) {
                searchOptionsToSet.setStereoModel(1);
            } else if (tableType != null && tableType == 4) {
                searchOptionsToSet.setStereoModel(0);
            } else {
                searchOptionsToSet.setStereoModel(2);
            }
        }
    }

    public static Molecule getMustFragment(Molecule mol) {
        if (mol instanceof RgMolecule) {
            return ((RgMolecule)mol).getRoot();
        }
        return mol;
    }

    public static boolean hasMarkushQueryAtom(MoleculeGraph m) {
        if (m instanceof RgMolecule) {
            RgMolecule rgm = (RgMolecule)m;
            if (SearchUtil.hasMarkushQueryAtom(rgm.getRoot())) {
                return true;
            }
            int rgCount = rgm.getRgroupCount();
            for (int rgInd = 0; rgInd < rgCount; ++rgInd) {
                int rgMemberCount = rgm.getRgroupMemberCount(rgInd);
                for (int rgMemberInd = 0; rgMemberInd < rgMemberCount; ++rgMemberInd) {
                    if (!SearchUtil.hasMarkushQueryAtom(rgm.getRgroupMemberG(rgInd, rgMemberInd))) continue;
                    return true;
                }
            }
        }
        int n = m.getAtomCount();
        for (int i = 0; i < n; ++i) {
            String aliasstr = m.getAtom(i).getAliasstr();
            if (aliasstr == null || StructureSearch.getSpecialPseudoIndex(aliasstr) == -1) continue;
            return true;
        }
        return false;
    }

    public static Molecule removeAllHomologies(Molecule target) {
        boolean removal = false;
        for (int i = 0; i < target.getAtomCount() && !removal; ++i) {
            MolAtom atom = target.getAtom(i);
            String alias = atom.getAliasstr();
            if ((alias == null || !atom.isPseudo() || !HomologyConstants.isHomology(alias) || !SelectionUtil.isSelected(atom)) && StructureSearch.getSpecialPseudoIndex(alias) == -1) continue;
            removal = true;
        }
        if (!removal) {
            return target;
        }
        Molecule m = target.cloneMolecule();
        ArrayList<MolAtom> toRemove = new ArrayList<MolAtom>();
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom atom = m.getAtom(i);
            String alias = atom.getAliasstr();
            if ((alias == null || !atom.isPseudo() || !HomologyConstants.isHomology(alias) || !SelectionUtil.isSelected(atom)) && StructureSearch.getSpecialPseudoIndex(alias) == -1) continue;
            toRemove.add(atom);
        }
        for (MolAtom molAtom : toRemove) {
            m.removeAtom(molAtom);
        }
        return m;
    }
}

