/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.marvin.modules.smarts.ParseException;
import chemaxon.marvin.modules.smarts.SimpleNode;
import chemaxon.marvin.modules.smarts.SmartsBondTreeParser;
import chemaxon.marvin.modules.smarts.SmartsBondTreeParserTreeConstants;
import chemaxon.sss.search.InitializationIndicator;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.StereoConstants;
import java.io.StringReader;

class SmartsBondMatcher
implements SmartsBondTreeParserTreeConstants,
StereoConstants {
    SmartsBondMatcher() {
    }

    static void prepareSMARTSTrees(StructureSearch s) throws ParseException {
        int index = 0;
        for (int i = 0; i < s.atomsLength; ++i) {
            if (null == s.atoms[i] || s.isExcluded(i)) continue;
            for (int j = 0; j < s.atoms[i].getBondCount(); ++j) {
                String queryStr = s.atoms[i].getBond(j).getQuerystr();
                if (null == queryStr) {
                    ++index;
                    continue;
                }
                if (null == s.smartsBondTrees) {
                    s.smartsBondTrees = new SimpleNode[s.btypLength];
                }
                StringReader sr = new StringReader(queryStr);
                SmartsBondTreeParser parser = new SmartsBondTreeParser(sr);
                s.smartsBondTrees[index] = parser.parseSmartsBondExpression();
                ++index;
            }
        }
    }

    public static void analyseTrees(StructureSearch s, InitializationIndicator ii) {
        if (null == s.smartsBondTrees) {
            return;
        }
        for (int i = 0; i < s.smartsBondTrees.length; ++i) {
            if (null == s.smartsBondTrees[i]) continue;
            SmartsBondMatcher.collectInitializationIndicator(s.smartsBondTrees[i], ii);
            if (ii.isDoubleBondStereoNeeded) {
                s.hasDoubleBondStereo = true;
            }
            s.hasQueryProperty = true;
        }
    }

    private static void collectInitializationIndicator(SimpleNode node, InitializationIndicator ii) {
        int id = node.getId();
        if (5 == id) {
            switch (node.getValue().charAt(0)) {
                case '/': 
                case '\\': {
                    ii.isDoubleBondStereoNeeded = true;
                    break;
                }
                case '@': {
                    ii.isRingMembershipNeeded = true;
                    break;
                }
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SmartsBondMatcher.collectInitializationIndicator((SimpleNode)node.jjtGetChild(i), ii);
        }
    }

    public static boolean evaluateSmartsBondTree(StructureSearch qs, SimpleNode node, int queryBond, StructureSearch ts, int targetBond) throws SearchException {
        boolean finalCheck = ts.depth == ts.qryAtoms;
        switch (node.getId()) {
            case 1: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    boolean value = SmartsBondMatcher.evaluateSmartsBondTree(qs, (SimpleNode)node.jjtGetChild(i), queryBond, ts, targetBond);
                    if (value) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    boolean value = SmartsBondMatcher.evaluateSmartsBondTree(qs, (SimpleNode)node.jjtGetChild(i), queryBond, ts, targetBond);
                    if (!value) continue;
                    return true;
                }
                return false;
            }
            case 4: {
                boolean value = SmartsBondMatcher.evaluateSmartsBondTree(qs, (SimpleNode)node.jjtGetChild(0), queryBond, ts, targetBond);
                return !value;
            }
            case 5: {
                char label = node.getValue().charAt(0);
                switch (label) {
                    case '-': {
                        return Search.areMatchingBondTypes(1, ts.btyp[targetBond], ts.searchOptions.isExactBondMatching());
                    }
                    case '=': {
                        return Search.areMatchingBondTypes(2, ts.btyp[targetBond], ts.searchOptions.isExactBondMatching());
                    }
                    case '#': {
                        return Search.areMatchingBondTypes(3, ts.btyp[targetBond], ts.searchOptions.isExactBondMatching());
                    }
                    case ':': {
                        return Search.areMatchingBondTypes(4, ts.btyp[targetBond], ts.searchOptions.isExactBondMatching());
                    }
                    case '~': {
                        return Search.areMatchingBondTypes(0, ts.btyp[targetBond], ts.searchOptions.isExactBondMatching());
                    }
                    case '@': {
                        int at1 = ts.atomIdxInAtomsArray[ts.bto[targetBond]];
                        int at2 = ts.atomIdxInAtomsArray[ts.bFrom[targetBond]];
                        if (-1 == at1 || -1 == at2) {
                            return false;
                        }
                        return ts.targetRingClassifier.isRingBond(at1, at2);
                    }
                    case '/': 
                    case '\\': {
                        if (finalCheck) {
                            return SmartsBondMatcher.checkUpOrDownBond(qs, node, queryBond, ts, targetBond);
                        }
                        return true;
                    }
                }
                throw new SearchException("Invalid query treenode value:\"" + node + "\"");
            }
        }
        throw new SearchException("Invalid treenode type: " + node);
    }

    private static boolean checkUpOrDownBond(StructureSearch qs, SimpleNode node, int queryBond, StructureSearch ts, int targetBond) throws SearchException {
        int atom2;
        int atom1;
        SimpleNode originalRoot = null;
        if (1 != ts.btyp[targetBond]) {
            return false;
        }
        if (qs.smartsBondTrees[queryBond] != node) {
            originalRoot = qs.smartsBondTrees[queryBond];
            qs.smartsBondTrees[queryBond] = node;
        }
        if (!SmartsBondMatcher.checkAllCTConfigs(qs, node, queryBond, ts, targetBond, atom1 = qs.bto[queryBond], atom2 = qs.bFrom[queryBond]) || !SmartsBondMatcher.checkAllCTConfigs(qs, node, queryBond, ts, targetBond, atom2, atom1)) {
            if (null != originalRoot) {
                qs.smartsBondTrees[queryBond] = originalRoot;
            }
            return false;
        }
        if (null != originalRoot) {
            qs.smartsBondTrees[queryBond] = originalRoot;
        }
        return true;
    }

    private static boolean checkAllCTConfigs(StructureSearch qs, SimpleNode node, int queryBond, StructureSearch ts, int targetBond, int queryAtom, int atom0) throws SearchException {
        if (ts.depth < queryAtom) {
            return true;
        }
        for (int i = 0; i < qs.abonds[queryAtom]; ++i) {
            int atom1;
            int bond1 = qs.bondidx[queryAtom] + i;
            if (2 != qs.btyp[bond1] || ts.depth < (atom1 = qs.bto[bond1])) continue;
            for (int j = 0; j < qs.abonds[atom1]; ++j) {
                int bond2 = qs.bondidx[atom1] + j;
                int atom2 = qs.bto[bond2];
                if (ts.depth < atom2 || null == qs.smartsBondTrees[bond2]) continue;
                int tAtom1 = SmartsBondMatcher.matchedAtom(ts, atom1);
                int tAtom2 = SmartsBondMatcher.matchedAtom(ts, atom2);
                int tBond2 = -1;
                for (int k = 0; k < ts.abonds[tAtom1]; ++k) {
                    if (ts.bto[ts.bondidx[tAtom1] + k] != tAtom2) continue;
                    tBond2 = ts.bondidx[tAtom1] + k;
                    break;
                }
                if (0 < qs.smartsBondTrees[bond2].jjtGetNumChildren()) {
                    if (SmartsBondMatcher.evaluateSmartsBondTree(qs, qs.smartsBondTrees[bond2], bond2, ts, tBond2)) continue;
                    return false;
                }
                int qCTFlag = 0;
                String bond2Value = qs.smartsBondTrees[bond2].getValue();
                char bond2ValueFirst = bond2Value.charAt(0);
                if ('/' != bond2ValueFirst && '\\' != bond2ValueFirst) continue;
                String nodeValue = node.getValue();
                if (bond2Value.length() > 1 || nodeValue.length() > 1) {
                    qCTFlag |= 0x100;
                }
                char nodeValueFirst = nodeValue.charAt(0);
                if ('/' == bond2ValueFirst && nodeValueFirst == '\\' || '\\' == bond2ValueFirst && '/' == nodeValueFirst) {
                    qCTFlag |= 0x80;
                }
                if ('/' == bond2ValueFirst && '/' == nodeValueFirst || '\\' == bond2ValueFirst && '\\' == nodeValueFirst) {
                    qCTFlag |= 0x40;
                }
                tAtom1 = ts.atomIdxInAtomsArray[SmartsBondMatcher.matchedAtom(ts, atom0)];
                tAtom2 = ts.atomIdxInAtomsArray[SmartsBondMatcher.matchedAtom(ts, queryAtom)];
                int tAtom3 = ts.atomIdxInAtomsArray[SmartsBondMatcher.matchedAtom(ts, atom1)];
                int tAtom4 = ts.atomIdxInAtomsArray[SmartsBondMatcher.matchedAtom(ts, atom2)];
                if (-1 == tAtom1 || -1 == tAtom2 || -1 == tAtom3 || -1 == tAtom4) {
                    return true;
                }
                int tCTFlag = ts.getTarget().getStereo2(tAtom1, tAtom2, tAtom3, tAtom4);
                if (ts.areMatchingCTITypes(qCTFlag, tCTFlag)) continue;
                return false;
            }
        }
        return true;
    }

    private static int matchedAtom(StructureSearch ts, int atom2) {
        return ts.idx[atom2] - 1;
    }
}

