/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search;

import chemaxon.calculations.stereo.BicycloStereoRecognizer;
import chemaxon.calculations.stereo.StereoRecognizer;
import chemaxon.common.util.IntVector;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.MoleculeMatcher;
import chemaxon.sss.search.StructureSearch;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.Dumper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class StereoMatcher
implements MoleculeMatcher {
    private static final int STEREO_TYPE_LEN = 5;
    public static final int BICYCLO_STEREO_INDEX = 4;
    private ArrayList<StereoRecord>[] queryStereoOrigIdx = null;
    private ArrayList<StereoRecord>[] queryStereoInternalIdx = null;
    private ArrayList<StereoRecord>[] targetStereoOrigIdx = null;
    private ArrayList<StereoRecord>[] targetStereoInternalIdx = null;
    private final int NON_MAPPABLE = -2;
    private final int MULTIPLE_MAPPING = -1;
    private int[] occurrenceNumAsBicycloPillar = null;
    private StructureSearch searcher = null;
    private MolSearchOptions searchOptions;
    private Molecule query = null;
    private Molecule target = null;
    private IntVector qHLigands = null;
    private IntVector tHLigands = null;
    private static Logger logger = Logger.getLogger(StereoMatcher.class.getName());

    StereoMatcher() {
    }

    @Override
    public void setSearcher(StructureSearch searcher) {
        this.searcher = searcher;
        this.searchOptions = searcher.getSearchOptions();
    }

    @Override
    public void setQuery(Molecule molecule) {
        this.query = molecule;
        this.queryStereoOrigIdx = null;
        this.queryStereoInternalIdx = null;
        this.qHLigands = null;
    }

    @Override
    public void setTarget(Molecule molecule) {
        this.target = molecule;
        this.targetStereoOrigIdx = null;
        this.targetStereoInternalIdx = null;
        this.tHLigands = null;
    }

    private boolean isSpecialH(int atomInd, boolean isQuery) {
        IntVector hAtoms;
        IntVector intVector = hAtoms = isQuery ? this.qHLigands : this.tHLigands;
        if (hAtoms == null) {
            this.getStereoDefinitions(isQuery);
            hAtoms = new IntVector();
            this.getFixHAtoms(isQuery, hAtoms);
            if (isQuery) {
                this.qHLigands = hAtoms;
            } else {
                this.tHLigands = hAtoms;
            }
        }
        return hAtoms.contains(atomInd);
    }

    private void getFixHAtoms(boolean isQuery, IntVector hLigands) {
        ArrayList<StereoRecord>[] stereoDefLists = isQuery ? this.queryStereoOrigIdx : this.targetStereoOrigIdx;
        Molecule mol = isQuery ? this.query : this.target;
        for (int stereoTypeInd = 2; stereoTypeInd < stereoDefLists.length; ++stereoTypeInd) {
            ArrayList<StereoRecord> stereoDefList = stereoDefLists[stereoTypeInd];
            for (StereoRecord record : stereoDefList) {
                for (int ligandInd = 0; ligandInd < record.ligands.length; ++ligandInd) {
                    int pillarAtom;
                    if (mol.getAtom(record.ligands[ligandInd]).getAtno() == 1) {
                        int ligandPair = record.otherLigands[ligandInd];
                        if (ligandPair != -1 && mol.getAtom(ligandPair).getAtno() != 1) {
                            record.otherLigands[ligandInd] = record.ligands[ligandInd];
                            record.ligands[ligandInd] = ligandPair;
                            record.value = StereoMatcher.getSwitchedStereoValue(record);
                        } else {
                            hLigands.add(record.ligands[ligandInd]);
                        }
                    }
                    if (record.type != 4 || mol.getAtom(pillarAtom = record.pillars[0]).getAtno() != 1) continue;
                    hLigands.add(pillarAtom);
                }
            }
        }
    }

    private static int getSwitchedStereoValue(StereoRecord record) {
        switch (record.type) {
            case 1: {
                if (record.value == 2) {
                    return 1;
                }
                if (record.value != 1) break;
                return 2;
            }
            case 2: {
                if (record.value == 128) {
                    return 64;
                }
                if (record.value != 64) break;
                return 128;
            }
            case 3: {
                if (record.value == 1) {
                    return 2;
                }
                if (record.value != 2) break;
                return 1;
            }
            case 4: {
                if (record.value == 4) {
                    return 5;
                }
                if (record.value != 5) break;
                return 4;
            }
        }
        assert (false) : "Illegal stereo type used: " + record.type;
        return record.value;
    }

    private void getStereoDefinitions(boolean isQuery) {
        int[][] stereoDefs;
        boolean ignoreRecognizersStereo;
        Molecule mol = isQuery ? this.query : this.target;
        boolean bl = ignoreRecognizersStereo = this.searchOptions.isIgnoreAlleneStereo() && this.searchOptions.isIgnoreAxialStereo();
        if (ignoreRecognizersStereo || mol.getDim() == 0) {
            stereoDefs = new int[0][0];
        } else {
            StereoRecognizer recognizer = new StereoRecognizer();
            recognizer.calculateStereoAtoms(mol);
            stereoDefs = recognizer.getStereoDefinitions();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Stereo definitions, isQuery:" + isQuery + "\n" + Dumper.dumpIntIntArray(stereoDefs));
            logger.finest("Molecule in mrv:\n" + mol.toFormat("mrv"));
        }
        ArrayList[] stereoOrigIdx = new ArrayList[5];
        for (int i = 0; i < 5; ++i) {
            stereoOrigIdx[i] = new ArrayList();
        }
        for (int[] stereoDef : stereoDefs) {
            int type = stereoDef[0];
            int value = stereoDef[1];
            if (type >= 4) {
                assert (false) : "Unhandled stereo type returned by StereoRecognizer: " + type;
                continue;
            }
            if (type == 1) continue;
            int[] pillars = new int[]{stereoDef[2], stereoDef[3]};
            MolBond bondBetweenPillars = mol.getAtom(stereoDef[2]).getBondTo(mol.getAtom(stereoDef[3]));
            if (bondBetweenPillars != null && bondBetweenPillars.getType() == 2 || type == 2 && this.searchOptions.isIgnoreAlleneStereo() || type == 3 && this.searchOptions.isIgnoreAxialStereo()) continue;
            int[] ligands = new int[]{stereoDef[4], stereoDef[5]};
            int[] otherLigands = Arrays.copyOfRange(stereoDef, 6, stereoDef.length);
            StereoRecord record = new StereoRecord(type, value, pillars, ligands, otherLigands);
            stereoOrigIdx[type].add(record);
        }
        if (!this.searchOptions.isIgnoreSynAntiStereo()) {
            this.calculateBicycloRecords(stereoOrigIdx, mol);
        }
        if (isQuery) {
            this.queryStereoOrigIdx = stereoOrigIdx;
        } else {
            this.targetStereoOrigIdx = stereoOrigIdx;
        }
    }

    private void calculateBicycloRecords(ArrayList<StereoRecord>[] stereoOrigIdx, Molecule mol) {
        BicycloStereoRecognizer bicycloStereoRecognizer = new BicycloStereoRecognizer();
        bicycloStereoRecognizer.calculateDescriptors(mol);
        HashMap<Integer, BicycloStereoDescriptor[]> descriptors = this.searchOptions.getStereoModel() == 2 ? bicycloStereoRecognizer.getDescriptors() : bicycloStereoRecognizer.getLocalDescriptors();
        for (Integer bicycloLigandIndex : descriptors.keySet()) {
            BicycloStereoDescriptor[] bicycloStereoDescriptors;
            for (BicycloStereoDescriptor bicycloStereoDescriptor : bicycloStereoDescriptors = descriptors.get(bicycloLigandIndex)) {
                int value = bicycloStereoDescriptor.getStereoValue();
                if (value == 6) continue;
                int[] pillars = new int[]{bicycloLigandIndex};
                int[] ligands = bicycloStereoDescriptor.getHighBridgeAtomIndexes();
                int[] otherLigands = bicycloStereoDescriptor.getLowBridgeAtomIndexes();
                stereoOrigIdx[4].add(new StereoRecord(4, value, pillars, ligands, otherLigands));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SynAntiRecognizer object: " + bicycloStereoRecognizer.toString());
            logger.fine("Syn-anti stereo centers:" + stereoOrigIdx[4].toString());
        }
    }

    @Override
    public void compareAllAtoms() {
        if (this.queryStereoOrigIdx == null) {
            this.getStereoDefinitions(true);
        }
        if (this.targetStereoOrigIdx == null) {
            this.getStereoDefinitions(false);
        }
        this.queryStereoInternalIdx = this.convert2InternalIndexes(this.queryStereoOrigIdx, true);
        this.targetStereoInternalIdx = this.convert2InternalIndexes(this.targetStereoOrigIdx, false);
        this.addInitializedLigands();
        this.calculateTargetPillarOccurrence();
        this.restrictMatchOnStereo(this.queryStereoInternalIdx, this.targetStereoInternalIdx, false);
        if (this.searchOptions.getStereoSearchType() == 2) {
            this.restrictMatchOnStereo(this.targetStereoInternalIdx, this.queryStereoInternalIdx, true);
        }
    }

    private void calculateTargetPillarOccurrence() {
        this.occurrenceNumAsBicycloPillar = new int[this.searcher.matomLength];
        for (StereoRecord record : this.targetStereoInternalIdx[4]) {
            int n = record.pillars[0];
            this.occurrenceNumAsBicycloPillar[n] = this.occurrenceNumAsBicycloPillar[n] + 1;
        }
    }

    private void addInitializedLigands() {
        boolean[] isQueryV;
        for (boolean isQuery : isQueryV = new boolean[]{true, false}) {
            int[] checkedStereoTypes;
            ArrayList<StereoRecord>[] stereoRecords = isQuery ? this.queryStereoInternalIdx : this.targetStereoInternalIdx;
            StructureSearch searcher2 = isQuery ? this.searcher.sub : this.searcher;
            for (int stereoType : checkedStereoTypes = new int[]{2, 3}) {
                for (StereoRecord record : stereoRecords[stereoType]) {
                    int[] otherLigands = new int[record.ligands.length];
                    Arrays.fill(otherLigands, -1);
                    otherLigands = Arrays.copyOfRange(record.otherLigands, 0, record.otherLigands.length);
                    for (int ligandPos = 0; ligandPos < record.ligands.length; ++ligandPos) {
                        int[] neighbours;
                        if (otherLigands[ligandPos] != -1) continue;
                        int pillar = record.pillars[ligandPos];
                        for (int neigh : neighbours = searcher2.getNeighbours(pillar)) {
                            if (searcher2.atomIdxInAtomsArray[neigh] != -1) continue;
                            otherLigands[ligandPos] = neigh;
                            record.otherLigands = otherLigands;
                        }
                    }
                }
            }
        }
    }

    private void restrictMatchOnStereo(ArrayList<StereoRecord>[] queryStereoRecords, ArrayList<StereoRecord>[] targetStereoRecords, boolean switchRoles) {
        int targetAtomNum = !switchRoles ? this.searcher.strAtoms : this.searcher.qryAtoms;
        for (int stereoTypeInd = 2; stereoTypeInd < queryStereoRecords.length; ++stereoTypeInd) {
            boolean[] hasTargetStereo = new boolean[targetAtomNum];
            for (StereoRecord record : targetStereoRecords[stereoTypeInd]) {
                for (int atom : record.pillars) {
                    hasTargetStereo[atom] = true;
                }
            }
            for (int targetAtom = 0; targetAtom < targetAtomNum; ++targetAtom) {
                if (hasTargetStereo[targetAtom]) continue;
                for (StereoRecord queryRecord : queryStereoRecords[stereoTypeInd]) {
                    for (int queryPillar : queryRecord.pillars) {
                        if (!switchRoles) {
                            this.searcher.map.clearMap(queryPillar, targetAtom);
                            continue;
                        }
                        this.searcher.map.clearMap(targetAtom, queryPillar);
                    }
                }
            }
        }
    }

    private ArrayList<StereoRecord>[] convert2InternalIndexes(ArrayList<StereoRecord>[] stereoOrigIdx, boolean isQuery) {
        ArrayList[] result = new ArrayList[stereoOrigIdx.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ArrayList();
        }
        for (int stereoTypeInd = 0; stereoTypeInd < stereoOrigIdx.length; ++stereoTypeInd) {
            for (StereoRecord record : stereoOrigIdx[stereoTypeInd]) {
                StereoRecord convRecord = new StereoRecord(record);
                int[] convIndexes = this.getConvertedIndex(convRecord.pillars, isQuery);
                if (this.hasMinusIndex(convIndexes)) continue;
                convRecord.pillars = convIndexes;
                convIndexes = this.getConvertedIndex(convRecord.ligands, isQuery);
                if (this.hasMinusIndex(convIndexes)) continue;
                convRecord.ligands = convIndexes;
                convIndexes = this.getConvertedIndex(convRecord.otherLigands, isQuery);
                if (stereoTypeInd == 4 && this.hasMinusIndex(convIndexes)) continue;
                convRecord.otherLigands = convIndexes;
                result[stereoTypeInd].add(convRecord);
            }
        }
        return result;
    }

    private boolean hasMinusIndex(int[] convIndexes) {
        for (int index : convIndexes) {
            if (index >= 0) continue;
            return true;
        }
        return false;
    }

    private int[] getConvertedIndex(int[] atomIndexes, boolean isQuery) {
        int[] mapperArray = isQuery ? this.searcher.sub.idxAtomInMatomArray : this.searcher.idxAtomInMatomArray;
        int[] converted = new int[atomIndexes.length];
        for (int i = 0; i < atomIndexes.length; ++i) {
            converted[i] = atomIndexes[i] == -1 ? -1 : mapperArray[atomIndexes[i]];
        }
        return converted;
    }

    @Override
    public boolean refine() {
        boolean changed = false;
        int[] numOfNonBannedAsPillar = (int[])this.occurrenceNumAsBicycloPillar.clone();
        for (int stereoTypeInd = 2; stereoTypeInd < this.queryStereoInternalIdx.length; ++stereoTypeInd) {
            for (StereoRecord qRecord : this.queryStereoInternalIdx[stereoTypeInd]) {
                if (StereoMatcher.areIndexesMatched(qRecord, this.searcher.depth)) continue;
                for (StereoRecord tRecord : this.targetStereoInternalIdx[stereoTypeInd]) {
                    int tVal = this.getMatchedTargetStereoValue(qRecord, tRecord);
                    if (tVal >= 0 && tVal != qRecord.value) {
                        if (stereoTypeInd != 4) {
                            this.eraseMapBetweenPillars(qRecord, tRecord);
                            changed = true;
                            continue;
                        }
                        int n = tRecord.pillars[0];
                        numOfNonBannedAsPillar[n] = numOfNonBannedAsPillar[n] - 1;
                        if (numOfNonBannedAsPillar[tRecord.pillars[0]] > 0) continue;
                        this.eraseMapBetweenPillars(qRecord, tRecord);
                        changed = true;
                        continue;
                    }
                    if (tVal != -2 || stereoTypeInd != 4 || this.occurrenceNumAsBicycloPillar[tRecord.pillars[0]] <= 1) continue;
                    int n = tRecord.pillars[0];
                    numOfNonBannedAsPillar[n] = numOfNonBannedAsPillar[n] - 1;
                    if (numOfNonBannedAsPillar[tRecord.pillars[0]] > 0 || !this.searcher.map.getMap(qRecord.pillars[0], tRecord.pillars[0])) continue;
                    this.eraseMapBetweenPillars(qRecord, tRecord);
                    changed = true;
                }
            }
        }
        return changed;
    }

    private void eraseMapBetweenPillars(StereoRecord qRecord, StereoRecord tRecord) {
        for (int qPillar : qRecord.pillars) {
            for (int tPillar : tRecord.pillars) {
                this.searcher.map.clearMap(qPillar, tPillar);
            }
        }
    }

    private int getMatchedTargetStereoValue(StereoRecord qRecord, StereoRecord tRecord) {
        for (int qPillar : qRecord.pillars) {
            int mappingPossibilities = 0;
            if ((mappingPossibilities += this.calculateMappingPossibilities(qPillar, tRecord.pillars)) == 1) continue;
            return mappingPossibilities == 0 ? -2 : -1;
        }
        int otherLigandUsageNum = 0;
        for (int qLigand : qRecord.ligands) {
            int mappingPossibilities = 0;
            mappingPossibilities += this.calculateMappingPossibilities(qLigand, tRecord.ligands);
            int otherLigandUsageForQLigand = this.calculateMappingPossibilities(qLigand, tRecord.otherLigands);
            otherLigandUsageNum += otherLigandUsageForQLigand;
            if ((mappingPossibilities += otherLigandUsageForQLigand) == 1) continue;
            return mappingPossibilities == 0 ? -2 : -1;
        }
        return this.isSwitchNeeded(otherLigandUsageNum, qRecord) ? StereoMatcher.getSwitchedStereoValue(tRecord) : tRecord.value;
    }

    private int calculateMappingPossibilities(int qAtom, int[] targetAtoms) {
        int mappingPossibilities = 0;
        for (int tAtom : targetAtoms) {
            if (tAtom == -1 || !this.searcher.map.getMap(qAtom, tAtom)) continue;
            ++mappingPossibilities;
        }
        return mappingPossibilities;
    }

    private boolean isSwitchNeeded(int otherLigandUsageNum, StereoRecord qRecord) {
        if (qRecord.type == 4) {
            return otherLigandUsageNum > 0;
        }
        return otherLigandUsageNum == 1;
    }

    private static boolean areIndexesMatched(StereoRecord qRecord, int depth) {
        for (int pillar : qRecord.pillars) {
            if (pillar < depth - 1) continue;
            return false;
        }
        for (int ligand : qRecord.ligands) {
            if (ligand < depth - 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSpecialQueryH(int atomInd) {
        return this.isSpecialH(atomInd, true);
    }

    @Override
    public boolean isSpecialTargetH(int atomInd) {
        return this.isSpecialH(atomInd, false);
    }

    private class StereoRecord {
        int type;
        int value;
        int[] pillars = null;
        int[] ligands = null;
        int[] otherLigands = null;

        StereoRecord(int type, int value, int[] pillars, int[] ligands, int[] otherLigands) {
            this.type = type;
            this.value = value;
            this.pillars = pillars;
            this.ligands = ligands;
            this.otherLigands = otherLigands;
        }

        StereoRecord(StereoRecord record) {
            this(record.type, record.value, (int[])record.pillars.clone(), (int[])record.ligands.clone(), (int[])record.otherLigands.clone());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Type:");
            builder.append(this.type);
            builder.append(" value:");
            builder.append(this.value);
            builder.append(" pillars:");
            builder.append(Arrays.toString(this.pillars));
            builder.append(" ligands:");
            builder.append(Arrays.toString(this.ligands));
            builder.append(" otherLigands:");
            builder.append(Arrays.toString(this.otherLigands));
            return builder.toString();
        }
    }
}

