/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.bracket;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.core.calculations.BondClassifier;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.sss.search.BracketComparator;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.bracket.PolymerMatcher;
import chemaxon.sss.search.bracket.PolymerizationUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;

class PolymerData {
    Molecule origMolecule = null;
    Molecule molecule = null;
    boolean isInitialized = false;
    PolymerizationUtil pu = null;
    int[] tr2Or = null;
    int[] or2Tr = null;
    int[][] crossBrack = null;
    IntVector[] borderAtoms = null;
    IntVector[] headTailBorder = null;
    int[][] sgInd = null;
    boolean[] hasEndGr = null;
    boolean[] hasJunction = null;
    private int[] phShiftable = null;
    boolean[] isNeighBorderAtom = null;
    int[][] ringNeighBef;
    private BondClassifier bClass = null;
    SearchOptions sOpts;

    PolymerData() {
    }

    void setPhShiftable(int sgroupInd, int value) {
        this.phShiftable[sgroupInd] = value;
    }

    boolean hasPhaseShiftBinding(int sgroupInd) {
        Sgroup lowestSg;
        if (this.phShiftable == null) {
            this.phShiftable = ArrayTools.initArrayAndFill(this.phShiftable, this.molecule.getSgroupCount(), -1);
            this.isNeighBorderAtom = ArrayTools.initBooleanArrayAndFill(this.isNeighBorderAtom, this.molecule.getSgroupCount(), false);
        }
        if ((lowestSg = this.molecule.getSgroup(sgroupInd)) instanceof RepeatingUnitSgroup) {
            int i;
            RepeatingUnitSgroup rSg = (RepeatingUnitSgroup)lowestSg;
            MolBond[] crossingBonds = rSg.findCrossingBonds();
            if (crossingBonds.length != 2 && crossingBonds.length != 4) {
                this.setPhShiftable(sgroupInd, 0);
                return false;
            }
            MolAtom[] innerAtoms = new MolAtom[crossingBonds.length];
            int starAtNo = MolAtom.numOf("*");
            for (i = 0; i < crossingBonds.length; ++i) {
                MolBond bond = crossingBonds[i];
                if (bond.getAtom1().getAtno() != starAtNo && bond.getAtom2().getAtno() != starAtNo && this.sOpts.isEndgroupMatching() && this.sOpts.isPerfectSearchType()) {
                    this.setPhShiftable(sgroupInd, 0);
                    return false;
                }
                innerAtoms[i] = bond.getAtom1().getAtno() == starAtNo ? bond.getAtom2() : bond.getAtom1();
            }
            for (i = 0; i < innerAtoms.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (innerAtoms[i] != innerAtoms[j] && !innerAtoms[i].isBoundTo(innerAtoms[j])) continue;
                    this.isNeighBorderAtom[sgroupInd] = true;
                    this.setPhShiftable(sgroupInd, 0);
                    return false;
                }
            }
            if (lowestSg.getConnectivity() != 2) {
                this.setPhShiftable(sgroupInd, 0);
                return false;
            }
            this.setPhShiftable(sgroupInd, 1);
            return true;
        }
        this.setPhShiftable(sgroupInd, 0);
        return false;
    }

    boolean isPhaseShiftable(int sgroupInd) {
        if (this.phShiftable == null || this.phShiftable[sgroupInd] == -1) {
            this.hasPhaseShiftBinding(sgroupInd);
        }
        if (this.phShiftable[sgroupInd] != -1) {
            return this.phShiftable[sgroupInd] == 1;
        }
        return false;
    }

    void unInitialize() {
        this.ringNeighBef = null;
        this.bClass = null;
        this.phShiftable = null;
        this.isNeighBorderAtom = null;
        this.isInitialized = false;
    }

    void storeRingBondInfo(Molecule mol, int sgInd) {
        Object neighInd = this.ringNeighBef;
        int atNum = mol.getAtomCount();
        if (neighInd == null) {
            neighInd = new int[atNum][];
        }
        if (this.bClass == null) {
            this.bClass = new BondClassifier();
            this.bClass.classify(mol);
        }
        SelectionMolecule sgroupGr = mol.getSgroup(sgInd).getSgroupGraph();
        for (int i = 0; i < sgroupGr.getAtomCount(); ++i) {
            MolAtom atom = sgroupGr.getAtom(i);
            int atomMolInd = mol.indexOf(atom);
            if (!this.bClass.isRingAtom(atomMolInd)) continue;
            IntVector ringNeighV = new IntVector();
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                if (!this.bClass.isRingBond(atomMolInd, j)) continue;
                ringNeighV.add(j);
            }
            neighInd[atomMolInd] = ringNeighV.toArray();
        }
        this.ringNeighBef = neighInd;
    }

    void bindPhaseShift(Molecule mol, IntVector[] borderAtoms) {
        for (int i = 0; i < borderAtoms.length; ++i) {
            int atNum = borderAtoms[i].size();
            if (atNum <= 0 || atNum != 2 && atNum != 4) continue;
            if (borderAtoms[i].size() > 2) {
                this.setPhShiftable(i, 0);
                continue;
            }
            this.storeRingBondInfo(mol, i);
            int atom1Ind = borderAtoms[i].get(0);
            int atom2Ind = borderAtoms[i].get(1);
            MolAtom atom1 = mol.getAtom(atom1Ind);
            MolAtom atom2 = mol.getAtom(atom2Ind);
            if (atom1.isBoundTo(atom2) || atom1 == atom2) continue;
            MolBond cyclBond = new MolBond(atom1, atom2);
            mol.add(cyclBond);
        }
    }

    void init() {
        int atNum = this.molecule.getGraphUnion().getAtomCount();
        IntVector types = new IntVector();
        PolymerUtil.getRelevantTypes(types);
        this.sgInd = null;
        this.sgInd = BracketComparator.initSgroupData(this.molecule, this.sgInd, types);
        this.crossBrack = null;
        this.crossBrack = new int[atNum][];
        this.hasEndGr = null;
        this.hasEndGr = ArrayTools.initBooleanArrayAndFill(this.hasEndGr, atNum, false);
        IntVector endGroups2remove = new IntVector();
        IntVector starAtoms = new IntVector();
        int starAtNo = MolAtom.numOf("*");
        this.borderAtoms = PolymerData.initIntVectForSgroups(this.molecule);
        this.headTailBorder = PolymerData.initIntVectForSgroups(this.molecule);
        for (int i = 0; i < atNum; ++i) {
            int extAInd = PolymerData.getExternalNeigh(this.molecule, i, this.sgInd);
            if (extAInd == -1 || this.sgInd[i] == null || this.sgInd[i].length == 0) continue;
            this.hasEndGr[i] = PolymerData.hasAtomEndgroup(this.molecule, i, extAInd, this.sgInd);
            if (this.hasEndGr[i] && !this.sOpts.isEndgroupMatching()) {
                PolymerData.addEndGrIndexes(endGroups2remove, this.molecule, extAInd, i, this.sgInd);
            }
            if (!this.hasEndGr[i] && this.molecule.getAtom(extAInd).getAtno() == starAtNo) {
                starAtoms.add(extAInd);
            }
            this.isPhaseShiftable(this.sgInd[i][0]);
            PolymerData.storeBorderAtomData(this.molecule, i, extAInd, this.sgInd, this.crossBrack, this.headTailBorder, this.borderAtoms);
        }
        this.bindPhaseShift(this.molecule, this.borderAtoms);
        IntVector tr2OrV = new IntVector();
        this.or2Tr = new int[atNum];
        for (int i = atNum - 1; i >= 0; --i) {
            if (starAtoms.contains(i) || endGroups2remove.contains(i)) {
                this.molecule.removeAtom(this.molecule.getAtom(i));
                this.or2Tr[i] = -1;
                continue;
            }
            tr2OrV.add(0, i);
        }
        int k = 0;
        for (int i = 0; i < this.or2Tr.length; ++i) {
            if (this.or2Tr[i] == -1) continue;
            this.or2Tr[i] = k++;
        }
        this.tr2Or = tr2OrV.toArray();
    }

    static void storeBorderAtomData(Molecule mol, int i, int extAInd, int[][] sgInd, int[][] crossBrack, IntVector[] headTailBorder, IntVector[] borderAtoms) {
        if (sgInd[i] == null || sgInd[i].length == 0) {
            return;
        }
        int currSgInd = sgInd[i][0];
        borderAtoms[currSgInd].add(i);
        int firstOuterBracket = sgInd[extAInd] != null && sgInd[extAInd].length > 0 ? sgInd[extAInd][0] : -1;
        IntVector crossedBr = new IntVector();
        for (int b = 0; b < sgInd[i].length && sgInd[i][b] != firstOuterBracket; ++b) {
            crossedBr.add(sgInd[i][b]);
        }
        crossBrack[i] = crossedBr.toArray();
        Sgroup sg = mol.getSgroup(currSgInd);
        if (sg.getConnectivity() != 0 && sg instanceof RepeatingUnitSgroup) {
            RepeatingUnitSgroup rsg = (RepeatingUnitSgroup)sg;
            MolBond[] headBonds = rsg.getHeadCrossingBonds();
            MolBond[] tailBonds = rsg.getTailCrossingBonds();
            if (headBonds != null && tailBonds != null) {
                MolAtom outerA;
                MolAtom borderA = mol.getAtom(i);
                MolBond crossingB = borderA.getBondTo(outerA = mol.getAtom(extAInd));
                if (crossingB == headBonds[0] || crossingB == headBonds[1]) {
                    headTailBorder[currSgInd].add(0);
                } else {
                    headTailBorder[currSgInd].add(1);
                }
            }
        }
    }

    static int getExternalNeigh(Molecule mol, int i, int[][] sgInd) {
        MolAtom atom = mol.getAtom(i);
        int[] sgV = sgInd[i];
        if (sgV == null || sgV.length == 0) {
            return -1;
        }
        for (int b = 0; b < atom.getBondCount(); ++b) {
            MolAtom other = atom.getBond(b).getOtherAtom(atom);
            int otherInd = mol.indexOf(other);
            int[] sgVOther = sgInd[otherInd];
            if (sgVOther == null || sgVOther.length == 0) {
                return otherInd;
            }
            if (sgV[0] == sgVOther[0] || sgV.length < sgVOther.length) continue;
            return otherInd;
        }
        return -1;
    }

    static boolean hasAtomEndgroup(Molecule mol, int i, int extAInd, int[][] sgInd) {
        Sgroup atomsSg;
        if (sgInd[i] != null && sgInd[i].length > 0 && !PolymerMatcher.isParentPolymer(atomsSg = mol.getSgroup(sgInd[i][0]))) {
            return mol.getAtom(extAInd).getAtno() != MolAtom.numOf("*");
        }
        return false;
    }

    static void addEndGrIndexes(IntVector endGroups, Molecule mol, int extAInd, int parentInd, int[][] sgInd) {
        endGroups.add(extAInd);
        MolAtom extAtom = mol.getAtom(extAInd);
        MolAtom parentAtom = mol.getAtom(parentInd);
        for (int i = 0; i < extAtom.getBondCount(); ++i) {
            int otherInd;
            MolAtom other = extAtom.getBond(i).getOtherAtom(extAtom);
            if (other == parentAtom || endGroups.contains(otherInd = mol.indexOf(other))) continue;
            PolymerData.addEndGrIndexes(endGroups, mol, otherInd, extAInd, sgInd);
        }
    }

    static IntVector[] initIntVectForSgroups(Molecule mol) {
        IntVector[] borderAtoms = new IntVector[mol.getSgroupCount()];
        for (int i = 0; i < borderAtoms.length; ++i) {
            borderAtoms[i] = new IntVector();
        }
        return borderAtoms;
    }
}

