/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.bracket;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.bracket.PolymerUtil;
import chemaxon.sss.search.BracketComparator;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.bracket.PolymerData;
import chemaxon.sss.search.bracket.PolymerizationUtil;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;

public class PolymerMatcher {
    private static final int[] SRUinRecent = new int[]{6, 15, 7};
    SearchOptions sOpts = null;
    private BracketComparator bComp = null;
    private PolymerData targetData = new PolymerData();
    private PolymerData queryData = new PolymerData();

    public static boolean areMatching(Sgroup qSg, Sgroup tSg, MolSearchOptions sOpts) {
        boolean isPerfectSearch = sOpts.isPerfectSearchType();
        boolean matching = PolymerMatcher.compareTypes(qSg, tSg, isPerfectSearch);
        matching &= qSg.getSubType() == 0 && !isPerfectSearch || qSg.getSubType() == tSg.getSubType();
        matching &= qSg.getConnectivity() == 0 && !isPerfectSearch || qSg.getConnectivity() == tSg.getConnectivity();
        matching &= qSg.getConnectivity() == 0 && !isPerfectSearch || PolymerUtil.getFlipping(qSg) == PolymerUtil.getFlipping(tSg);
        if (sOpts.isCopolymerMatching()) {
            matching &= !PolymerMatcher.isParentPolymer(tSg) || PolymerMatcher.isParentPolymer(qSg);
        }
        return matching &= PolymerMatcher.compareSRUs(qSg, tSg);
    }

    private static boolean compareTypes(Sgroup qSg, Sgroup tSg, boolean isPerfectSearch) {
        int tType;
        boolean matching;
        int qType = qSg.getType();
        boolean bl = matching = qType == (tType = tSg.getType());
        if (qType == 11 && !isPerfectSearch) {
            matching |= tType == 2 || tType == 3;
        }
        return matching;
    }

    private static boolean compareSRUs(Sgroup qSg, Sgroup tSg) {
        if (qSg instanceof RepeatingUnitSgroup && tSg instanceof RepeatingUnitSgroup) {
            RepeatingUnitSgroup qRSg = (RepeatingUnitSgroup)qSg;
            RepeatingUnitSgroup tRSg = (RepeatingUnitSgroup)tSg;
            return qRSg.getConnectivity() == 0 || qRSg.containsLadderTypePolymer() == tRSg.containsLadderTypePolymer();
        }
        return true;
    }

    public void transform(boolean transformQuery) {
        if ((!transformQuery || this.queryData.isInitialized) && (transformQuery || this.targetData.isInitialized)) {
            return;
        }
        PolymerData polymerData = transformQuery ? this.queryData : this.targetData;
        Molecule mol = polymerData.molecule;
        PolymerizationUtil pu = polymerData.pu;
        pu = new PolymerizationUtil();
        if (PolymerUtil.hasPolymerSgroup(mol)) {
            polymerData.origMolecule = mol.cloneMolecule();
            if (this.sOpts.areMonomersTransformed()) {
                pu.polymerize(mol);
            }
            polymerData.init();
            polymerData.pu = pu;
            polymerData.isInitialized = true;
        }
    }

    static boolean isParentPolymer(Sgroup sg) {
        Sgroup parent = sg.getParentSgroup();
        return parent != null && PolymerUtil.isPolymerSgroup(parent);
    }

    public void setSearchOptions(SearchOptions searchOptions) {
        this.sOpts = searchOptions;
        this.queryData.sOpts = searchOptions;
        this.targetData.sOpts = searchOptions;
    }

    public void setQuery(Molecule molecule) {
        this.queryData.molecule = molecule;
        this.queryData.origMolecule = molecule;
        this.queryData.unInitialize();
    }

    public void setTarget(Molecule molecule) {
        this.targetData.molecule = molecule;
        this.targetData.origMolecule = molecule;
        this.targetData.unInitialize();
    }

    public int[] restoreHitIndexes(int[] origHit) {
        if (!this.queryData.isInitialized && !this.targetData.isInitialized) {
            return origHit;
        }
        int[] newHit = null;
        int starHit = -2147483645;
        int origQLength = this.queryData.isInitialized ? (this.sOpts.areMonomersTransformed() ? this.queryData.pu.getMap(this.queryData.origMolecule).length : this.queryData.origMolecule.getAtomCount()) : origHit.length;
        newHit = ArrayTools.initArrayAndFill(newHit, origQLength, starHit);
        if (!this.queryData.isInitialized) {
            this.queryData.tr2Or = PolymerMatcher.getRangeTill(this.queryData.molecule.getAtomCount());
        }
        if (!this.targetData.isInitialized) {
            this.targetData.tr2Or = PolymerMatcher.getRangeTill(this.queryData.molecule.getAtomCount());
        }
        for (int i = 0; i < origHit.length; ++i) {
            int newTInd;
            int newQInd = this.queryData.tr2Or[i];
            newHit[newQInd] = origHit[i] < -this.targetData.tr2Or.length ? origHit[i] : (newTInd = origHit[i] >= 0 ? this.targetData.tr2Or[origHit[i]] : -this.targetData.tr2Or[-origHit[i] - 1] - 1);
        }
        if (this.sOpts.areMonomersTransformed()) {
            int[] nonPolymerizatedHit = null;
            int origAtomNumQ = this.queryData.isInitialized ? this.queryData.pu.getOrigAtomNum() : origQLength;
            nonPolymerizatedHit = ArrayTools.initArrayAndFill(nonPolymerizatedHit, origAtomNumQ, starHit);
            int[] or2nonPolyQ = this.queryData.isInitialized ? this.queryData.pu.getMap(this.queryData.origMolecule) : PolymerMatcher.getRangeTill(origQLength);
            int[] or2nonPolyT = this.targetData.isInitialized ? this.targetData.pu.getMap(this.targetData.origMolecule) : PolymerMatcher.getRangeTill(this.targetData.origMolecule.getAtomCount());
            for (int i = 0; i < newHit.length; ++i) {
                int nonPolQInd = or2nonPolyQ[i];
                if (nonPolQInd < -1) continue;
                int nonPolTInd = -1;
                nonPolTInd = newHit[i] >= -or2nonPolyT.length ? (newHit[i] >= 0 ? or2nonPolyT[newHit[i]] : -or2nonPolyT[-newHit[i] - 1] - 1) : newHit[i];
                nonPolymerizatedHit[nonPolQInd] = nonPolTInd;
            }
            newHit = nonPolymerizatedHit;
        }
        return newHit;
    }

    private static int[] getRangeTill(int len) {
        int[] tr2Or = new int[len];
        for (int i = 0; i < tr2Or.length; ++i) {
            tr2Or[i] = i;
        }
        return tr2Or;
    }

    public boolean compareCrossings(int qTrMol1, int tTrMol1) {
        if (!this.queryData.isInitialized) {
            return true;
        }
        if (!this.targetData.isInitialized) {
            return false;
        }
        int qOrMol = this.queryData.tr2Or[qTrMol1];
        int tOrMol = this.targetData.tr2Or[tTrMol1];
        int[] qCrossedBr = this.queryData.crossBrack[qOrMol];
        int[] tCrossedBr = this.targetData.crossBrack[tOrMol];
        int[] targetSgV = this.targetData.sgInd[tOrMol];
        int[] querySgV = this.queryData.sgInd[qOrMol];
        if (targetSgV != null && targetSgV.length > 0 && querySgV != null && querySgV.length > 0) {
            Sgroup qSg = this.queryData.molecule.getSgroup(querySgV[0]);
            if (this.targetData.isPhaseShiftable(targetSgV[0]) && this.queryData.isNeighBorderAtom != null && this.queryData.isNeighBorderAtom[querySgV[0]]) {
                return false;
            }
            if (this.targetData.isPhaseShiftable(targetSgV[0]) && !PolymerMatcher.isParentPolymer(qSg) && this.sOpts.isPhaseShiftedMatching() && (this.queryData.isPhaseShiftable(querySgV[0]) || qSg.getConnectivity() == 0)) {
                return true;
            }
        }
        if (qCrossedBr == null) {
            return true;
        }
        if (tCrossedBr == null) {
            return false;
        }
        return qCrossedBr.length <= tCrossedBr.length;
    }

    public boolean compareEndGrExistence(int qTrMol1, int tTrMol1) {
        return true;
    }

    public boolean checkHit(int[] internalHit, int internalHitLength) {
        if (!this.queryData.isInitialized) {
            return true;
        }
        if (!this.targetData.isInitialized) {
            return false;
        }
        if (!this.checkLadderType(internalHit, internalHitLength)) {
            return false;
        }
        return this.checkPhaseShift(internalHit, internalHitLength);
    }

    private boolean checkLadderType(int[] internalHit, int internalHitLength) {
        int origQIndexOther;
        int qIndexOther;
        int qIndex = internalHitLength - 1;
        int tIndex = internalHit[qIndex] - 1;
        int origQIndex = this.searchInd2OrigPolimerizatedInd(qIndex, true);
        int origTIndex = this.searchInd2OrigPolimerizatedInd(tIndex, false);
        if (origQIndex == -1 || origTIndex == -1) {
            return true;
        }
        if (this.queryData.sgInd[origQIndex] == null || this.queryData.sgInd[origQIndex].length == 0) {
            return true;
        }
        int qSgIndex = this.queryData.sgInd[origQIndex][0];
        if (this.queryData.headTailBorder[qSgIndex].size() != 4) {
            return true;
        }
        int bordIndLastQ = this.queryData.borderAtoms[qSgIndex].indexOf(origQIndex);
        if (bordIndLastQ == -1) {
            return true;
        }
        int headTail = this.queryData.headTailBorder[qSgIndex].get(bordIndLastQ);
        int bordIndOtherQ = -1;
        for (int i = 0; i < this.queryData.headTailBorder[qSgIndex].size(); ++i) {
            if (i == bordIndLastQ || this.queryData.headTailBorder[qSgIndex].get(i) != headTail) continue;
            bordIndOtherQ = i;
            break;
        }
        if ((qIndexOther = this.bComp.getSearchIndOfAtom(this.queryData.or2Tr[origQIndexOther = this.queryData.borderAtoms[qSgIndex].get(bordIndOtherQ)], true)) > qIndex) {
            return true;
        }
        int tIndexOther = internalHit[qIndexOther] - 1;
        int origTIndexOther = this.searchInd2OrigPolimerizatedInd(tIndexOther, false);
        int tSgIndex = this.targetData.sgInd[origTIndex][0];
        int bordIndT = this.targetData.borderAtoms[tSgIndex].indexOf(origTIndex);
        int bordIndTOther = this.targetData.borderAtoms[tSgIndex].indexOf(origTIndexOther);
        if (bordIndT == -1 || bordIndTOther == -1) {
            return false;
        }
        return this.targetData.headTailBorder[tSgIndex].get(bordIndT) == this.targetData.headTailBorder[tSgIndex].get(bordIndTOther);
    }

    public int searchInd2OrigInd(int index, boolean isQuery) {
        int transfInd;
        int n = transfInd = isQuery ? this.bComp.getOrigQueryAtom(index) : this.bComp.getOrigTargetAtom(index);
        if (transfInd == -1) {
            return -1;
        }
        return isQuery ? this.queryData.pu.getMap(this.queryData.origMolecule)[this.queryData.tr2Or[transfInd]] : this.targetData.pu.getMap(this.targetData.origMolecule)[this.targetData.tr2Or[transfInd]];
    }

    private int searchInd2OrigPolimerizatedInd(int index, boolean isQuery) {
        int transfInd;
        int n = transfInd = isQuery ? this.bComp.getOrigQueryAtom(index) : this.bComp.getOrigTargetAtom(index);
        if (transfInd == -1) {
            return -1;
        }
        return isQuery ? this.queryData.tr2Or[transfInd] : this.targetData.tr2Or[transfInd];
    }

    private boolean checkPhaseShift(int[] internalHit, int internalHitLength) {
        if (!this.checkCyclizationBond(internalHit, internalHitLength)) {
            return false;
        }
        if (this.queryData.ringNeighBef == null) {
            return true;
        }
        if (this.targetData.ringNeighBef == null) {
            return false;
        }
        int qIndex = internalHitLength - 1;
        int tIndex = internalHit[qIndex] - 1;
        int origQIndex = this.searchInd2OrigPolimerizatedInd(qIndex, true);
        int origTIndex = this.searchInd2OrigPolimerizatedInd(tIndex, false);
        if (origQIndex == -1 || origTIndex == -1) {
            return true;
        }
        int[] qNeigh = this.queryData.ringNeighBef[origQIndex];
        int[] tNeigh = this.targetData.ringNeighBef[origTIndex];
        if (qNeigh == null) {
            return true;
        }
        if (tNeigh == null) {
            return false;
        }
        if (tNeigh.length < qNeigh.length) {
            return false;
        }
        for (int i = 0; i < qNeigh.length; ++i) {
            int neighHitInd;
            int origNeighHitInd;
            int qOrNeighInd = qNeigh[i];
            int qNeighInd = this.bComp.getSearchIndOfAtom(this.queryData.or2Tr[qOrNeighInd], true);
            if (qNeighInd == -1 || qNeighInd >= qIndex || (origNeighHitInd = this.searchInd2OrigPolimerizatedInd(neighHitInd = internalHit[qNeighInd] - 1, false)) == -1 || ArrayTools.foundInArray(tNeigh, origNeighHitInd)) continue;
            return false;
        }
        return true;
    }

    private boolean checkCyclizationBond(int[] internalHit, int internalHitLength) {
        int sti = internalHit[internalHitLength - 1] - 1;
        int oti = this.searchInd2OrigPolimerizatedInd(sti, false);
        int oqi = this.searchInd2OrigPolimerizatedInd(internalHitLength - 1, true);
        if (oti == -1 || oqi == -1) {
            return true;
        }
        if (this.targetData.crossBrack == null || this.targetData.crossBrack[oti] == null || this.targetData.crossBrack[oti].length == 0) {
            return true;
        }
        if (this.targetData.sgInd[oti] == null || this.targetData.sgInd[oti].length == 0) {
            return true;
        }
        if (this.queryData.sgInd[oqi] == null || this.queryData.sgInd[oqi].length == 0) {
            return true;
        }
        int tSg = this.targetData.sgInd[oti][0];
        if (!this.targetData.isPhaseShiftable(tSg)) {
            return true;
        }
        int otni = this.getConnectedBorderAtom(oti, this.targetData.borderAtoms[tSg], false);
        int stni = this.bComp.getSearchIndOfAtom(this.targetData.or2Tr[otni], false);
        int sqni = -1;
        for (sqni = 0; sqni < internalHitLength && internalHit[sqni] - 1 != stni; ++sqni) {
        }
        if (sqni == internalHitLength) {
            return true;
        }
        int tqi = this.queryData.or2Tr[oqi];
        int tqni = this.bComp.getOrigQueryAtom(sqni);
        if (tqni == -1) {
            return true;
        }
        int oqni = this.queryData.tr2Or[tqni];
        if (this.queryData.molecule.getAtom(tqi).isBoundTo(this.queryData.molecule.getAtom(tqni))) {
            return true;
        }
        int qSg = this.queryData.sgInd[oqi][0];
        return !this.queryData.isPhaseShiftable(qSg) && this.queryData.crossBrack[oqi] != null && this.queryData.crossBrack[oqni] != null && this.queryData.crossBrack[oqi].length > 0 && this.queryData.crossBrack[oqni].length > 0;
    }

    private int getConnectedBorderAtom(int oi, IntVector borderAtoms, boolean isQuery) {
        if (borderAtoms.size() == 2) {
            return borderAtoms.get(0) == oi ? borderAtoms.get(1) : borderAtoms.get(0);
        }
        int[] or2Tr = isQuery ? this.queryData.or2Tr : this.targetData.or2Tr;
        Molecule mol = isQuery ? this.queryData.molecule : this.targetData.molecule;
        Molecule origMol = isQuery ? this.queryData.origMolecule : this.targetData.origMolecule;
        int ti = or2Tr[oi];
        for (int i = 0; i < borderAtoms.size(); ++i) {
            int coi = borderAtoms.get(i);
            if (coi == oi) continue;
            int cti = or2Tr[coi];
            if (!mol.getAtom(ti).isBoundTo(mol.getAtom(cti)) || origMol.getAtom(oi).isBoundTo(origMol.getAtom(coi))) continue;
            return coi;
        }
        return -1;
    }

    public void setComparator(BracketComparator comp) {
        this.bComp = comp;
    }

    public void setFingerprintOptions() {
        SearchOptions so = new SearchOptions(2);
        so.setPolymerMatching(true);
        so.setEndgroupMatching(false);
        so.setMonomerTransform(true);
        this.setSearchOptions(so);
    }

    public static Molecule getGeneralRepresentation(Molecule mol) {
        if (PolymerUtil.hasPolymerSgroup(mol)) {
            Molecule transformedMol = mol.cloneMolecule();
            PolymerMatcher pm = new PolymerMatcher();
            pm.setQuery(transformedMol);
            pm.setFingerprintOptions();
            pm.transform(true);
            return transformedMol;
        }
        return mol;
    }
}

