/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.bracket;

import chemaxon.common.util.ArrayTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;

class PolymerizationUtil {
    private int[] tr2Or = null;
    MolAtom[] atoms = null;

    PolymerizationUtil() {
    }

    public void polymerize(Molecule mol) {
        this.tr2Or = null;
        this.storeOrigAtoms(mol);
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (!this.isSgroupPolimerizable(sg) || !this.transform(mol, i)) continue;
            --i;
        }
        this.getMap(mol);
    }

    private boolean isSgroupPolimerizable(Sgroup sg) {
        if (sg.getType() == 3) {
            return true;
        }
        int type = sg.getType();
        return (type == 11 || type == 2) && sg.findCrossingBonds().length == 0;
    }

    public int[] getMap(Molecule mol) {
        if (this.tr2Or != null) {
            return this.tr2Or;
        }
        int nonMapableVal = -2147483645;
        this.tr2Or = ArrayTools.initArrayAndFill(this.tr2Or, mol.getAtomCount(), nonMapableVal);
        if (this.atoms == null) {
            return this.tr2Or;
        }
        for (int i = 0; i < this.atoms.length; ++i) {
            int trIdx = mol.indexOf(this.atoms[i]);
            if (trIdx == -1) continue;
            this.tr2Or[trIdx] = i;
        }
        return this.tr2Or;
    }

    private void storeOrigAtoms(Molecule mol) {
        this.atoms = mol.getAtomArray();
    }

    private boolean transform(Molecule mol, int i) {
        boolean classChanged = false;
        Sgroup sg = mol.getSgroup(i);
        MolAtom[] borderAtoms = this.transformDoubleBond(sg);
        if (borderAtoms == null) {
            borderAtoms = this.transformExit(mol, sg);
        }
        if (borderAtoms != null) {
            this.changeClass(mol, i);
            classChanged = true;
            i = mol.getSgroupCount() - 1;
            this.addStarAtoms(mol, i, borderAtoms);
        }
        return classChanged;
    }

    private void changeClass(Molecule mol, int sgInd) {
        Sgroup sg = mol.getSgroup(sgInd);
        RepeatingUnitSgroup rsg = new RepeatingUnitSgroup(mol, 2);
        rsg.setConnectivity(sg.getConnectivity());
        rsg.setSubscript("n");
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            rsg.add(sg.getAtom(i));
        }
        if (sg.getParentSgroup() != null) {
            Sgroup parentSg = sg.getParentSgroup();
            parentSg.addChildSgroup(rsg);
        }
        mol.addSgroup(rsg, true);
        mol.ungroupSgroup(sg);
    }

    private void addStarAtoms(Molecule mol, int sgInd, MolAtom[] borderAtoms) {
        Sgroup sg = mol.getSgroup(sgInd);
        Sgroup pSg = null;
        if (sg.getParentSgroup() != null) {
            pSg = sg.getParentSgroup();
        }
        int starNum = MolAtom.numOf("*");
        for (int i = 0; i < borderAtoms.length; ++i) {
            MolAtom starA = new MolAtom(starNum);
            MolBond bond = new MolBond(starA, borderAtoms[i]);
            mol.add(starA);
            mol.add(bond);
            if (pSg == null) continue;
            pSg.add(starA);
        }
    }

    private MolAtom[] transformExit(Molecule mol, Sgroup sg) {
        MolAtom acceptorA = this.findTerminal(sg, true, null);
        if (acceptorA == null) {
            return null;
        }
        MolAtom donorA = this.findTerminal(sg, false, acceptorA);
        if (donorA == null && ((donorA = this.findInnerDonor(sg, acceptorA)) == null || donorA == acceptorA)) {
            return null;
        }
        MolAtom acceptorNeigh = acceptorA.getBond(0).getOtherAtom(acceptorA);
        mol.removeAtom(acceptorA);
        MolAtom[] ret = new MolAtom[]{donorA, acceptorNeigh};
        return ret;
    }

    private MolAtom findInnerDonor(Sgroup sg, MolAtom acceptorA) {
        int[] donorTypes = new int[]{7};
        for (int i = 0; i < sg.getAtomCount(); ++i) {
            MolAtom atom = sg.getAtom(i);
            int atNo = atom.getAtno();
            if (!ArrayTools.foundInArray(donorTypes, atNo) || atom.getImplicitHcount() < 1 || atom == acceptorA) continue;
            return atom;
        }
        return null;
    }

    private MolAtom findTerminal(Sgroup sg, boolean acceptor, MolAtom acceptorA) {
        int atNo;
        MolAtom atom;
        int i;
        int[] acceptorTypes = new int[]{17};
        int[] donorTypes = new int[]{7, 16};
        int[] neededTypes = acceptor ? acceptorTypes : donorTypes;
        for (i = 0; i < sg.getAtomCount(); ++i) {
            atom = sg.getAtom(i);
            atNo = atom.getAtno();
            if (!ArrayTools.foundInArray(neededTypes, atNo) || atom.getBondCount() != 1 || atom.getBond(0).getType() != 1 || atom == acceptorA) continue;
            return atom;
        }
        for (i = 0; i < sg.getAtomCount(); ++i) {
            atom = sg.getAtom(i);
            atNo = atom.getAtno();
            if (atNo != 8 || atom.getBondCount() != 1 || atom.getBond(0).getType() != 1 || atom == acceptorA) continue;
            return atom;
        }
        return null;
    }

    private MolAtom[] transformDoubleBond(Sgroup rsg) {
        for (int i = 0; i < rsg.getAtomCount(); ++i) {
            MolBond bond;
            MolAtom atom = rsg.getAtom(i);
            if (atom.getAtno() != 6 || atom.getBondCount() != 1 || (bond = atom.getBond(0)).getType() != 2 || bond.getOtherAtom(atom).getAtno() != 6) continue;
            bond.setType(1);
            MolAtom[] ret = new MolAtom[]{bond.getAtom1(), bond.getAtom2()};
            return ret;
        }
        return null;
    }

    public int getOrigAtomNum() {
        if (this.atoms == null) {
            return 0;
        }
        return this.atoms.length;
    }
}

