/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.common.util.IntVector;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.struc.MolAtom;
import chemaxon.util.Dumper;
import java.util.logging.Level;
import java.util.logging.Logger;

class AlkenylMatcher
extends HomologyMatcher {
    protected IntVector critBondA1 = null;
    protected IntVector critBondA2 = null;
    protected int lastToProcLen = 0;
    private static Logger logger = Logger.getLogger(AlkenylMatcher.class.getName());

    AlkenylMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.lazyInit = true;
        this.multiOptional = false;
        this.neighbouringCritical = false;
        this.ligandOnOptional = true;
        this.homologyType = 4;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedCarbonicAtomType(atomNum)) {
            return false;
        }
        if (this.searcher.countRingBonds(atomIdx) > 0) {
            return false;
        }
        if (this.hasAromaticBond(atomIdx, false)) {
            return false;
        }
        if (!this.checkHMatching(atomIdx, false)) {
            return false;
        }
        if (this.hasIncompatibleDoubleOrTripleBond(atomIdx)) {
            return false;
        }
        return super.isInitialAtom(atomNum, atomIdx, atom);
    }

    protected boolean hasIncompatibleDoubleOrTripleBond(int atomIdx) {
        return this.queryHG && this.hasTripleBond(atomIdx, true) && !this.hasTripleBond(this.hgIndex, false);
    }

    @Override
    protected void expandCritical(int i) {
        this.lastToProcLen = Integer.MAX_VALUE;
        this.critBondA1 = new IntVector();
        this.critBondA2 = new IntVector();
        super.expandCritical(i);
        logger.finer("Expanding critical for alkenyl.");
        if (this.completeHG && !this.isMatchingOnSameHg(this.criticalParts[i][0])) {
            switch (this.critBondA1.size()) {
                case 0: {
                    logger.fine("No attainable double bond -> reject.");
                    this.clearHGMap(this.criticalParts[0][0]);
                    break;
                }
                case 1: {
                    int[] path = this.getPathToCrit(0, this.critBondA2.lastElement());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.finest("Clearing path to double bond: " + Dumper.dumpIntArray(path));
                    }
                    for (int j = 0; j < path.length - 1; ++j) {
                        this.allowOnlyHGMap(path[j]);
                    }
                    this.critBondA1.clear();
                    this.critBondA2.clear();
                    break;
                }
            }
        }
    }

    @Override
    protected boolean isExpansionBond(int parent, int currAtom) {
        int bondType;
        if (this.toProcessExp.size() < this.lastToProcLen || parent < 0) {
            this.lastToProcLen = Integer.MAX_VALUE;
        }
        if ((bondType = this.getBondType(parent = parent < 0 ? -parent - 1 : parent, currAtom)) == 1 || bondType == 6) {
            return true;
        }
        return this.checkEssentialBond(parent, currAtom, bondType);
    }

    protected boolean checkEssentialBond(int parent, int currAtom, int bondType) {
        if (bondType == 2 || bondType == 5 || bondType == 7) {
            if (this.completeHG && this.toProcessExp.size() < this.lastToProcLen) {
                this.lastToProcLen = this.toProcessExp.size();
                this.critBondA1.add(parent);
                this.critBondA2.add(currAtom);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void clearHGMap(int atom) {
        super.clearHGMap(atom);
        if (this.atomsAdded > 0 && atom == this.criticalParts[0][0]) {
            this.critBondA1.clear();
            this.critBondA2.clear();
        }
        if (this.critBondA1 != null && this.critBondA1.size() > 0 && (this.critBondA1.contains(atom) || this.critBondA2.contains(atom))) {
            int num = 0;
            for (int i = 0; i < this.critBondA1.size(); ++i) {
                if (!this.isHgMappable(this.critBondA1.get(i)) || !this.isHgMappable(this.critBondA2.get(i))) continue;
                ++num;
            }
            if (num == 0) {
                this.prohibitMatching(this.criticalParts[0][0]);
            }
        }
    }

    @Override
    protected void clearStructures() {
        super.clearStructures();
        this.critBondA1.clear();
        this.critBondA2.clear();
    }
}

