/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.struc.MolAtom;

class AlkylMatcher
extends HomologyMatcher {
    AlkylMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.lazyInit = true;
        this.multiOptional = false;
        this.neighbouringCritical = false;
        this.ligandOnOptional = true;
        this.homologyType = 1;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedCarbonicAtomType(atomNum)) {
            return false;
        }
        if (this.searcher.countRingBonds(atomIdx) > 0) {
            return false;
        }
        if (this.hasAromaticBond(atomIdx, false)) {
            return false;
        }
        if (!this.checkHMatching(atomIdx, false)) {
            return false;
        }
        if (this.queryHG) {
            if (this.hasDoubleBond(atomIdx, true) && !this.hasDoubleBond(this.hgIndex, false)) {
                return false;
            }
            if (this.hasTripleBond(atomIdx, true) && !this.hasTripleBond(this.hgIndex, false)) {
                return false;
            }
        }
        return super.isInitialAtom(atomNum, atomIdx, atom);
    }
}

