/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.sss.search.homology.HomologyRingMatcher;
import chemaxon.struc.MolAtom;

class ArylMatcher
extends HomologyRingMatcher {
    ArylMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 2;
        this.init();
    }

    @Override
    protected void init() {
        this.ligandOnOptional = false;
        this.multiOptional = this.completeHG && this.ligandOnOptional;
        if (!this.completeHG) {
            this.ligandOnOptional = true;
            this.lazyInit = true;
        } else {
            this.lazyInit = false;
        }
        this.aromatic = true;
        this.canAlkylSubstitute = false;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedCarbonicAtomType(atomNum)) {
            return false;
        }
        return super.isInitialAtom(atomNum, atomIdx, atom);
    }

    @Override
    protected boolean isRingTypeOK(int ringIndex) {
        if (!super.isRingTypeOK(ringIndex)) {
            return false;
        }
        boolean res = false;
        res = this.completeHG ? this.searcher.homologyRingClassifier.getAromatic(ringIndex) && this.searcher.homologyRingClassifier.getCarboHydro(ringIndex) : this.searcher.homologyRingClassifier.getCarboHydro(ringIndex);
        return res;
    }
}

