/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.struc.MolAtom;

public class CarbonTreeMatcher
extends HomologyMatcher {
    protected CarbonTreeMatcher(int hgIdx, HomologySGSearch searchObj) {
        super(hgIdx, searchObj);
        this.homologyType = 6;
        this.lazyInit = true;
        this.multiOptional = false;
        this.neighbouringCritical = false;
        this.ligandOnOptional = true;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (this.searcher.countRingBonds(atomIdx) > 0) {
            return false;
        }
        if (!HomologyMatcher.isAcceptedCarbonicAtomType(atomNum)) {
            return false;
        }
        if (this.hasAromaticBond(atomIdx, false)) {
            return false;
        }
        if (!this.checkHMatching(atomIdx, false)) {
            return false;
        }
        return super.isInitialAtom(atomNum, atomIdx, atom);
    }

    @Override
    protected boolean isExpansionBond(int parent, int currAtom) {
        return true;
    }
}

