/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.sss.search.homology.HomologyRingMatcher;
import chemaxon.struc.MolAtom;

class FusedHeteroMatcher
extends HomologyRingMatcher {
    FusedHeteroMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 9;
        this.init();
    }

    @Override
    protected void init() {
        this.ligandOnOptional = false;
        this.multiOptional = this.completeHG && this.ligandOnOptional;
        if (!this.completeHG) {
            this.ligandOnOptional = true;
            this.lazyInit = true;
        } else {
            this.lazyInit = false;
        }
        this.canAlkylSubstitute = false;
        this.canBeFused = true;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedHeteroAtomType(atomNum)) {
            return false;
        }
        if (!super.isInitialAtom(atomNum, atomIdx, atom)) {
            return false;
        }
        int ringBNum = this.searcher.countRingBonds(atomIdx);
        if (this.completeHG && ringBNum == 0 && atomNum != 6 && atomNum != 1) {
            return false;
        }
        return this.completeHG || ringBNum != 0 || atomNum == 6 || atomNum == 1 || this.isPossibleRingAtom(atomIdx, atomNum);
    }

    @Override
    public boolean isRingTypeOK(int ringIndex) {
        if (!super.isRingTypeOK(ringIndex)) {
            return false;
        }
        if (!this.completeHG) {
            return true;
        }
        return this.searcher.homologyRingClassifier.getHetero(ringIndex) && this.searcher.homologyRingClassifier.getFused(ringIndex);
    }
}

