/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;
import chemaxon.sss.search.homology.HomologyRingMatcher;
import chemaxon.struc.MolAtom;

class HeteroCycleMatcher
extends HomologyRingMatcher {
    HeteroCycleMatcher(int hgIdx, HomologySGSearch structureSearch) {
        super(hgIdx, structureSearch);
        this.homologyType = 8;
        this.init();
    }

    @Override
    protected void init() {
        this.canBeFused = false;
        this.ligandOnOptional = false;
        this.multiOptional = this.completeHG && this.ligandOnOptional;
        if (!this.completeHG) {
            this.ligandOnOptional = true;
            this.lazyInit = true;
        } else {
            this.lazyInit = false;
        }
        this.canAlkylSubstitute = false;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (!HomologyMatcher.isAcceptedHeteroAtomType(atomNum)) {
            return false;
        }
        if (!super.isInitialAtom(atomNum, atomIdx, atom)) {
            return false;
        }
        int ringBNum = this.searcher.countRingBonds(atomIdx);
        if (this.completeHG && ringBNum == 0 && atomNum != 6 && atomNum != 1) {
            return false;
        }
        if (!this.completeHG && ringBNum == 0 && atomNum != 6 && atomNum != 1 && !this.isPossibleRingAtom(atomIdx, atomNum)) {
            return false;
        }
        return !this.hasAromaticBond(atomIdx, false);
    }

    @Override
    protected boolean isRingTypeOK(int ringIndex) {
        if (!super.isRingTypeOK(ringIndex)) {
            return false;
        }
        boolean res = this.searcher.homologyRingClassifier.getAliphatic(ringIndex) && this.searcher.homologyRingClassifier.getHetero(ringIndex);
        return res;
    }
}

