/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.homology.HomologyProperties;
import chemaxon.enumeration.homology.HomologyPropertyChecker;
import chemaxon.enumeration.homology.HomologyPropertyStructureClassifier;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.AlkenylMatcher;
import chemaxon.sss.search.homology.AlkylMatcher;
import chemaxon.sss.search.homology.AlkynylMatcher;
import chemaxon.sss.search.homology.AnyCycleMatcher;
import chemaxon.sss.search.homology.ArylMatcher;
import chemaxon.sss.search.homology.CarbonTreeMatcher;
import chemaxon.sss.search.homology.CycloAlkylMatcher;
import chemaxon.sss.search.homology.FusedHeteroMatcher;
import chemaxon.sss.search.homology.HeteroArylMatcher;
import chemaxon.sss.search.homology.HeteroCycleMatcher;
import chemaxon.sss.search.homology.RingSegmentMatcher;
import chemaxon.sss.search.homology.UnknownMatcher;
import chemaxon.sss.search.homology.atomic.ActinideMatcher;
import chemaxon.sss.search.homology.atomic.AlkaliMetalMatcher;
import chemaxon.sss.search.homology.atomic.AnyAtomMatcher;
import chemaxon.sss.search.homology.atomic.LanthanideMatcher;
import chemaxon.sss.search.homology.atomic.MetalMatcher;
import chemaxon.sss.search.homology.atomic.OtherMetalMatcher;
import chemaxon.sss.search.homology.atomic.TransitionMetalMatcher;
import chemaxon.sss.search.options.HomologyTranslationOption;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.util.Dumper;
import chemaxon.util.IntRange;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HomologyMatcher
implements HomologyPropertyStructureClassifier {
    private static final Logger logger = Logger.getLogger(HomologyMatcher.class.getName());
    private static boolean[][] compatibilityMap = new boolean[22][22];
    protected HomologySGSearch searcher = null;
    protected boolean queryHG;
    protected int hgIndex = -1;
    private MolAtom hgAtom;
    protected HomologyProperties homologyProperties = null;
    private boolean hasNonApplicableProperties;
    protected int homologyType;
    protected int[][] criticalParts = null;
    protected int[][] optionalParts = null;
    protected int[][] innerNeighbour = null;
    protected int[][] borderAtoms = null;
    protected int atomsAdded = 0;
    protected IntVector toProcessExp = null;
    protected boolean lazyInit = false;
    protected boolean multiOptional = true;
    protected boolean ligandOnOptional = true;
    protected boolean neighbouringCritical = false;
    protected boolean completeHG = true;
    protected boolean initialChainCheck = false;
    protected boolean latterBranchingCheck = false;
    static final boolean flexibleStraightDef = true;

    protected HomologyMatcher(int hgIdx, HomologySGSearch searchObj) {
        this.hgIndex = hgIdx;
        this.searcher = searchObj;
        this.queryHG = this.searcher.isQuerySide();
    }

    public static HomologyMatcher createMatcher(MolAtom atom, int hgIdx, HomologySGSearch searchObj) {
        HomologyMatcher matcher;
        StringBuffer sb = new StringBuffer();
        sb.append(atom.getAliasstr());
        for (int sIndex = sb.length() - 1; sIndex >= 0; --sIndex) {
            if (!" ".equals(Character.valueOf(sb.charAt(sIndex)))) continue;
            sb.deleteCharAt(sIndex);
        }
        String pseudoStr = sb.toString();
        if (hgIdx < 0) {
            throw new IllegalArgumentException("Invalid atom index given on HomologyMatcher creation.");
        }
        int homologyType = HomologyConstants.getHomologyTypeIndex(pseudoStr);
        if (homologyType == -1) {
            return null;
        }
        switch (homologyType) {
            case 1: {
                matcher = new AlkylMatcher(hgIdx, searchObj);
                break;
            }
            case 2: {
                matcher = new ArylMatcher(hgIdx, searchObj);
                break;
            }
            case 3: {
                matcher = new CycloAlkylMatcher(hgIdx, searchObj);
                break;
            }
            case 4: {
                matcher = new AlkenylMatcher(hgIdx, searchObj);
                break;
            }
            case 5: {
                matcher = new AlkynylMatcher(hgIdx, searchObj);
                break;
            }
            case 6: {
                matcher = new CarbonTreeMatcher(hgIdx, searchObj);
                break;
            }
            case 7: {
                matcher = new HeteroArylMatcher(hgIdx, searchObj);
                break;
            }
            case 8: {
                matcher = new HeteroCycleMatcher(hgIdx, searchObj);
                break;
            }
            case 9: {
                matcher = new FusedHeteroMatcher(hgIdx, searchObj);
                break;
            }
            case 10: {
                matcher = new AnyCycleMatcher(hgIdx, searchObj);
                break;
            }
            case 11: {
                matcher = new RingSegmentMatcher(hgIdx, searchObj);
                break;
            }
            case 12: {
                matcher = new UnknownMatcher(hgIdx, searchObj);
                break;
            }
            case 13: {
                matcher = new MetalMatcher(hgIdx, searchObj);
                break;
            }
            case 14: {
                matcher = new AlkaliMetalMatcher(hgIdx, searchObj);
                break;
            }
            case 15: {
                matcher = new OtherMetalMatcher(hgIdx, searchObj);
                break;
            }
            case 16: {
                matcher = new TransitionMetalMatcher(hgIdx, searchObj);
                break;
            }
            case 17: {
                matcher = new LanthanideMatcher(hgIdx, searchObj);
                break;
            }
            case 18: {
                matcher = new ActinideMatcher(hgIdx, searchObj);
                break;
            }
            case 0: {
                matcher = new AnyAtomMatcher(hgIdx, searchObj);
                break;
            }
            default: {
                matcher = null;
            }
        }
        if (matcher != null) {
            HomologyProperties prop = searchObj.getSearchOptions().getCompleteHG() ? new HomologyProperties(atom) : new HomologyProperties();
            super.setAtom(atom);
            matcher.setProperties(prop);
        }
        return matcher;
    }

    private void setAtom(MolAtom atom) {
        this.hgAtom = atom;
    }

    protected void setProperties(HomologyProperties prop) {
        this.homologyProperties = prop;
        if (prop.getBranching() != null) {
            if (prop.getBranching() != HomologyProperties.BranchingType.STRAIGHT || this.searcher.getMarkushBondCount(this.hgIndex) < 3) {
                // empty if block
            }
            this.latterBranchingCheck = true;
        }
        this.hasNonApplicableProperties = HomologyPropertyChecker.hasNonApplicableProperties(this.homologyProperties, this.hgAtom);
    }

    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        if (this.initialChainCheck) {
            int[] neigh = this.searcher.getNeighbours(atomNum, true);
        }
        return !this.hasNonApplicableProperties;
    }

    public static boolean containsHomology(Molecule target) {
        return HomologyConstants.containsHomology(target);
    }

    protected void findCriticals() {
    }

    protected void expandCritical(int i) {
        IntVector nodes = new IntVector();
        IntVector nodeParents = new IntVector();
        IntVector borderAtomV = new IntVector();
        this.toProcessExp = new IntVector();
        IntVector toProcessParents = new IntVector();
        for (int c = 0; c < this.criticalParts[i].length; ++c) {
            int critA = this.criticalParts[i][c];
            int critAMinus = -critA - 1;
            int[] neighV = this.searcher.getNeighbours(critA, true);
            for (int neighI = 0; neighI < neighV.length; ++neighI) {
                int branchAtomNum = 0;
                this.toProcessExp.clear();
                toProcessParents.clear();
                this.toProcessExp.add(neighV[neighI]);
                toProcessParents.add(critAMinus);
                while (this.toProcessExp.size() > 0) {
                    int currAtom = this.toProcessExp.removeLast();
                    int parent = toProcessParents.removeLast();
                    if (this.isOutWardConnection(parent, currAtom, i)) {
                        if (this.searcher.canBeNonMapped(currAtom)) continue;
                        if (this.ligandOnOptional) {
                            borderAtomV.add(parent);
                            continue;
                        }
                        for (int bi = 0; bi < branchAtomNum; ++bi) {
                            this.clearHGMap(nodes.removeLast());
                            nodeParents.removeLast();
                        }
                        this.toProcessExp.clear();
                        borderAtomV.add(critAMinus);
                        continue;
                    }
                    if (this.getCritical(currAtom) >= 0 || this.searcher.countRingBonds(currAtom) > 0 && nodes.contains(currAtom)) continue;
                    nodes.add(currAtom);
                    nodeParents.add(parent);
                    ++branchAtomNum;
                    int[] neighVCurr = this.searcher.getNeighbours(currAtom, true);
                    for (int neighIc = 0; neighIc < neighVCurr.length; ++neighIc) {
                        if (neighVCurr[neighIc] == parent || neighVCurr[neighIc] == -parent - 1) continue;
                        this.toProcessExp.add(neighVCurr[neighIc]);
                        toProcessParents.add(currAtom);
                    }
                }
            }
        }
        if (this.optionalParts == null) {
            assert (false);
            this.createNonCritStructures();
        }
        this.optionalParts[i] = nodes.toArray();
        this.innerNeighbour[i] = nodeParents.toArray();
        this.borderAtoms[i] = borderAtomV.toArray();
    }

    protected boolean isOutWardConnection(int parent, int currAtom, int c) {
        int critInd = this.getCritical(currAtom);
        if (critInd == c) {
            return false;
        }
        boolean res = !this.isHgMappable(currAtom) || !this.isExpansionBond(parent, currAtom);
        res = res || critInd != c && critInd > -1;
        res = res || this.searcher.countRingBonds(currAtom) > 0;
        return res;
    }

    protected boolean isExpansionBond(int parent, int currAtom) {
        int bondType = this.getBondType(parent = parent < 0 ? -parent - 1 : parent, currAtom);
        return bondType == 1 || bondType == 6 || bondType == 5;
    }

    protected void clearHGMap(int atom) {
        logger.finest("Clearing: " + atom + " for hgAtom: " + this.hgIndex + " on q-side:" + this.searcher.isQuerySide());
        this.searcher.clearMapToHomology(atom, this.hgIndex);
    }

    protected boolean isHgMappable(int currAtom) {
        return this.searcher.getMapToHomology(currAtom, this.hgIndex);
    }

    protected int getCritical(int atomInd) {
        if (this.criticalParts == null) {
            return -1;
        }
        for (int i = 0; i < this.criticalParts.length; ++i) {
            if (ArrayTools.indexInArray(this.criticalParts[i], atomInd) <= -1) continue;
            return i;
        }
        return -1;
    }

    private int getOptional(int atomInd) {
        if (this.optionalParts == null) {
            return -1;
        }
        for (int i = 0; i < this.optionalParts.length; ++i) {
            if (ArrayTools.indexInArray(this.optionalParts[i], atomInd) <= -1) continue;
            return i;
        }
        return -1;
    }

    protected final int[] getAllOptional(int atomInd) {
        IntVector optV = new IntVector();
        if (this.optionalParts == null) {
            return optV.toArray();
        }
        for (int i = 0; i < this.optionalParts.length; ++i) {
            if (ArrayTools.indexInArray(this.optionalParts[i], atomInd) <= -1) continue;
            optV.add(i);
        }
        return optV.toArray();
    }

    private int[] getAllCritical(int atomInd) {
        IntVector critV = new IntVector();
        if (this.criticalParts == null) {
            return critV.toArray();
        }
        for (int i = 0; i < this.criticalParts.length; ++i) {
            if (ArrayTools.indexInArray(this.criticalParts[i], atomInd) <= -1) continue;
            critV.add(i);
        }
        return critV.toArray();
    }

    public void buildUpStructures() {
        this.findCriticals();
        if (!this.lazyInit) {
            this.createNonCritStructures();
            if (this.criticalParts != null) {
                for (int i = 0; i < this.criticalParts.length; ++i) {
                    this.expandCritical(i);
                }
            }
            this.clearNonStructAtoms();
        }
    }

    private void clearNonStructAtoms() {
        for (int i = 0; i < this.searcher.getAtomCountMatched(); ++i) {
            if (!this.searcher.getMapToHomology(i, this.hgIndex) || this.getCritical(i) >= 0 || this.getOptional(i) >= 0) continue;
            this.clearHGMap(i);
        }
    }

    private void createNonCritStructures() {
        if (this.criticalParts == null) {
            return;
        }
        this.optionalParts = new int[this.criticalParts.length][0];
        this.innerNeighbour = new int[this.criticalParts.length][0];
        this.borderAtoms = new int[this.criticalParts.length][0];
    }

    public void add(int q) {
        if (this.lazyInit && this.atomsAdded <= 0) {
            int critInd = 0;
            if (this.criticalParts == null || (critInd = this.getCritical(q)) <= -1) {
                this.criticalParts = new int[1][1];
                this.criticalParts[0][0] = q;
                this.createNonCritStructures();
                critInd = 0;
            }
            this.expandCritical(critInd);
            if (!this.checkLigands(critInd) || !this.checkLazyInitProperties(critInd, PropertyCheckingStage.EXPANSION)) {
                this.clearHGMap(q);
            } else {
                this.clearNonStructAtoms();
            }
            this.atomsAdded = 1;
            this.checkHMatching(q, true);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(" Matcher fields:\n Critical:" + Dumper.dumpIntArray(this.criticalParts[0]) + "\nOptional:" + Dumper.dumpIntArray(this.optionalParts[0]) + "\n");
            }
            return;
        }
        ++this.atomsAdded;
        int[] crits = this.getAllCritical(q);
        int[] opts = this.getAllOptional(q);
        boolean clearDone = false;
        boolean clearDoneForOptional = false;
        if (!this.multiOptional || crits.length < 2 && opts.length < 2) {
            int crit;
            if (opts.length > 0) {
                int[] path = this.getPathToCrit(opts[0], q);
                crit = opts[0];
                for (int i = 0; i < path.length; ++i) {
                    int pathA;
                    if (path[i] > -1) {
                        this.allowOnlyHGMap(path[i]);
                        this.enforceChainProperty(path, i);
                    }
                    int n = pathA = path[i] >= 0 ? path[i] : -path[i] - 1;
                    if (!this.searcher.isAtomAlreadyMatched(pathA)) continue;
                    clearDone = true;
                    if (path[i] <= -1) continue;
                    clearDoneForOptional = true;
                }
                if (!clearDoneForOptional && !this.ligandOnOptional) {
                    int[] outerBranch = this.getOuterBranch(crit, q);
                    for (int i = 0; i < outerBranch.length; ++i) {
                        this.allowOnlyHGMap(outerBranch[i]);
                    }
                }
                if (!this.checkLazyInitProperties(opts[0], PropertyCheckingStage.ADD)) {
                    this.clearCriticalAndOptional(opts[0]);
                }
            } else {
                crit = crits[0];
            }
            if (!clearDone) {
                for (int cAtom = 0; cAtom < this.criticalParts[crit].length; ++cAtom) {
                    this.allowOnlyHGMap(this.criticalParts[crit][cAtom]);
                    if (!this.searcher.isAtomAlreadyMatched(this.criticalParts[crit][cAtom])) continue;
                    clearDone = true;
                    return;
                }
            }
            if (!clearDone && !this.neighbouringCritical) {
                for (int c = 0; c < this.criticalParts.length; ++c) {
                    if (c == crit) continue;
                    this.clearCriticalAndOptional(c);
                }
            }
        } else {
            throw new IllegalArgumentException("multi optional isn't handled yet.");
        }
    }

    private boolean checkLazyInitProperties(int critInd, PropertyCheckingStage propertyCheckingStage) {
        int[] matchables;
        if (!this.lazyInit) {
            return true;
        }
        for (int atom : matchables = this.getMatchableAtoms(critInd)) {
            if (this.searcher.getCachedHomologyType(atom, true) == -1) continue;
            return true;
        }
        boolean correctionPossible = this.queryHG && this.searcher.getSearchOptions().getSearchType() == 2 && propertyCheckingStage == PropertyCheckingStage.FINAL;
        boolean violatingProperty = true;
        for (int i = 0; i < 1 || correctionPossible && violatingProperty; ++i) {
            violatingProperty = false;
            if (!this.checkBranching(critInd, propertyCheckingStage)) {
                violatingProperty = true;
            } else if (!this.checkSizeProperty(critInd, propertyCheckingStage)) {
                violatingProperty = true;
            } else if (!this.checkDTCountProperty(critInd, propertyCheckingStage)) {
                violatingProperty = true;
            } else if (!this.checkingTextNotes(critInd, propertyCheckingStage)) {
                violatingProperty = true;
            }
            if (!correctionPossible || !violatingProperty) continue;
            boolean hasRemoved = false;
            for (int a : matchables) {
                if (!this.isHgMappable(a) || this.getHgMappableNeighbours(a).length != 1 || this.getMappableNeighbours(a).length != 1) continue;
                this.clearHGMap(a);
                hasRemoved = true;
                break;
            }
            if (hasRemoved) continue;
            correctionPossible = false;
        }
        return !violatingProperty;
    }

    private boolean checkingTextNotes(int critInd, PropertyCheckingStage propertyCheckingStage) {
        return propertyCheckingStage != PropertyCheckingStage.FINAL || HomologyPropertyChecker.isTextNoteOK(this.homologyProperties, this, critInd);
    }

    private boolean checkDTCountProperty(int critInd, PropertyCheckingStage propertyCheckingStage) {
        if (this.homologyProperties.getNumberOfDeuteriums() == null && this.homologyProperties.getNumberOfTritiums() == null) {
            return true;
        }
        if (propertyCheckingStage == PropertyCheckingStage.FINAL && !HomologyPropertyChecker.isDTCountOK(this.homologyProperties, this, critInd, false)) {
            return false;
        }
        return propertyCheckingStage != PropertyCheckingStage.EXPANSION && propertyCheckingStage != PropertyCheckingStage.PROHIBIT || HomologyPropertyChecker.isDTCountOK(this.homologyProperties, this, critInd, true);
    }

    private boolean checkBranching(int critInd, PropertyCheckingStage propertyCheckingStage) {
        return !this.latterBranchingCheck || propertyCheckingStage != PropertyCheckingStage.FINAL && this.homologyProperties.getBranching() != HomologyProperties.BranchingType.BRANCHED || HomologyPropertyChecker.isBranchingOK(this.homologyProperties, this, critInd);
    }

    private boolean checkSizeProperty(int critInd, PropertyCheckingStage propertyCheckingStage) {
        if (this.homologyProperties.getNumberOfCarbonAtoms() == null) {
            return true;
        }
        int[] matchables = this.getMatchableAtoms(critInd);
        IntRange requiredRange = this.homologyProperties.getNumberOfCarbonAtoms();
        if (requiredRange.min() > matchables.length) {
            return false;
        }
        if (propertyCheckingStage == PropertyCheckingStage.FINAL && !HomologyPropertyChecker.isSizeOK(this.homologyProperties, this, critInd)) {
            return false;
        }
        if (propertyCheckingStage == PropertyCheckingStage.EXPANSION) {
            int maxNum = requiredRange.max();
            for (int m : matchables) {
                if (this.getPathToCrit(critInd, m).length <= maxNum) continue;
                this.clearHGMap(m);
            }
        }
        if (propertyCheckingStage == PropertyCheckingStage.ADD) {
            int alreadyMatched = 0;
            for (int m : matchables) {
                if (!this.searcher.isAtomAlreadyMatched(m) || this.getAtNoOfAtom(m) != 6) continue;
                ++alreadyMatched;
            }
            if (alreadyMatched > requiredRange.max()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int[] getMatchableAtoms(int critInd) {
        IntVector matchables = new IntVector();
        for (int a : this.criticalParts[critInd]) {
            if (!this.isHgMappable(a)) continue;
            matchables.add(a);
        }
        for (int a : this.optionalParts[critInd]) {
            if (!this.isHgMappable(a)) continue;
            matchables.add(a);
        }
        return matchables.toArray();
    }

    @Override
    public int getQuantityOfAtomType(int critInd, int type) {
        int[] matchables = this.getMatchableAtoms(critInd);
        int num = 0;
        for (int m : matchables) {
            if (this.searcher.getAtomTypeMatched(m, true) != type) continue;
            ++num;
        }
        return num;
    }

    @Override
    public int getQuantityOfBonds(int strIndex, int type) {
        int[] matchables;
        int num = 0;
        for (int m : matchables = this.getMatchableAtoms(strIndex)) {
            int[] neigh;
            for (int n : neigh = this.getHgMappableNeighbours(m)) {
                int btype;
                if (n <= m || (btype = this.getBondType(n, m)) != type) continue;
                ++num;
            }
        }
        return num += HomologyConversionUtil.getAdditionalBondsFromAromatic(strIndex, type, this);
    }

    @Override
    public int getAtNoOfAtom(int m) {
        return this.searcher.getAtomTypeMatched(m, true);
    }

    @Override
    public int getIsotopeOfAtom(int m) {
        return this.searcher.getIsotopeMatched(m, true);
    }

    private void enforceChainProperty(int[] path, int atomOnThePath) {
        for (int atom : path) {
            int mAtomIndex;
            int n = mAtomIndex = atom < 0 ? -atom - 1 : atom;
            if (this.searcher.getCachedHomologyType(mAtomIndex, true) == -1) continue;
            return;
        }
        if (this.latterBranchingCheck && this.homologyProperties.getBranching() == HomologyProperties.BranchingType.STRAIGHT) {
            int[] neighBours;
            if (atomOnThePath <= 0 || atomOnThePath >= path.length - 1) {
                return;
            }
            int atomInd = path[atomOnThePath];
            int innerNeigh = path[atomOnThePath + 1] < 0 ? -path[atomOnThePath + 1] - 1 : path[atomOnThePath + 1];
            int outerNeigh = path[atomOnThePath - 1];
            for (int n : neighBours = this.getHgMappableNeighbours(atomInd)) {
                if (n == innerNeigh || n == outerNeigh) continue;
                this.prohibitMatching(n);
            }
        }
    }

    boolean checkHMatching(int q, boolean enforceMatching) {
        if (this.searcher.getAtomTypeMatched(q, true) == 1) {
            if (this.searcher.getBondCount(q, true) != 1) {
                this.clearHGMap(q);
                return false;
            }
            int neigh = this.searcher.getNeighAtomMatched(q, 0);
            if (!this.isHgMappable(neigh)) {
                this.clearHGMap(q);
                return false;
            }
            if (enforceMatching) {
                this.allowOnlyHGMap(neigh);
            }
        }
        return true;
    }

    boolean isMatchingOnSameHg(int i) {
        int otherHomologyTypeIndex = this.searcher.getCachedHomologyType(i, true);
        if (otherHomologyTypeIndex == -1) {
            return false;
        }
        HomologyTranslationOption homologyBroadTranslation = this.searcher.getSearchOptions().getHomologyBroadTranslation();
        HomologyTranslationOption homologyNarrowTranslation = this.searcher.getSearchOptions().getHomologyNarrowTranslation();
        int targetType = this.queryHG ? otherHomologyTypeIndex : this.getHomologyType();
        int queryType = this.queryHG ? this.getHomologyType() : otherHomologyTypeIndex;
        return HomologyMatcher.areHomologyTypeIndexesMatching(homologyBroadTranslation, homologyNarrowTranslation, targetType, queryType);
    }

    void clearCriticalAndOptional(int c) {
        for (int cAtom = 0; cAtom < this.criticalParts[c].length; ++cAtom) {
            this.clearHGMap(this.criticalParts[c][cAtom]);
        }
        for (int oAtom = 0; oAtom < this.optionalParts[c].length; ++oAtom) {
            this.clearHGMap(this.optionalParts[c][oAtom]);
        }
    }

    protected void allowOnlyHGMap(int atomMatchingOnHG) {
        int t;
        if (this.searcher.isOtherAtomHomology(atomMatchingOnHG)) {
            return;
        }
        for (t = 0; t < this.hgIndex; ++t) {
            this.searcher.clearMapToHomology(atomMatchingOnHG, t);
        }
        int atomCount = this.searcher.getAtomCount(false);
        for (t = this.hgIndex + 1; t < atomCount; ++t) {
            this.searcher.clearMapToHomology(atomMatchingOnHG, t);
        }
    }

    private boolean checkLigands(int e) {
        int ligandNum = this.searcher.getBondCount(this.hgIndex, false);
        if (ligandNum >= this.borderAtoms[e].length && !this.searcher.isQuerySide()) {
            return true;
        }
        if (ligandNum > this.borderAtoms[e].length && this.searcher.isQuerySide() && !this.ligandOnOptional) {
            return false;
        }
        int[][] pathToC = new int[this.borderAtoms[e].length][];
        for (int b = 0; b < this.borderAtoms[e].length; ++b) {
            pathToC[b] = this.getPathToCrit(e, this.borderAtoms[e][b]);
        }
        int branchNum = 0;
        for (int b = 0; b < pathToC.length; ++b) {
            if (pathToC[b].length == 1) {
                ++branchNum;
                continue;
            }
            for (int b2 = 0; b2 < b; ++b2) {
                int bLen = pathToC[b].length;
                int b2Len = pathToC[b2].length;
                if (b2Len == 1 || pathToC[b2][b2Len - 2] != pathToC[b][bLen - 2]) continue;
                --branchNum;
                break;
            }
            ++branchNum;
        }
        return branchNum <= ligandNum || this.searcher.isQuerySide();
    }

    public void prohibitMatching(int q) {
        if (this.criticalParts == null) {
            this.clearHGMap(q);
            return;
        }
        int[] crits = this.getAllCritical(q);
        int[] opts = this.getAllOptional(q);
        if (!this.multiOptional || crits.length < 2 && opts.length < 2) {
            if (crits.length > 0) {
                this.clearCriticalAndOptional(crits[0]);
                return;
            }
            if (opts.length > 0) {
                int[] pathToCrit;
                int[] outerBranch = this.getOuterBranch(opts[0], q);
                for (int i = 0; i < outerBranch.length; ++i) {
                    this.clearHGMap(outerBranch[i]);
                }
                if (!this.ligandOnOptional && (pathToCrit = this.getPathToCrit(opts[0], q)).length > 2) {
                    this.prohibitMatching(pathToCrit[pathToCrit.length - 2]);
                }
                if (!this.checkLazyInitProperties(opts[0], PropertyCheckingStage.PROHIBIT)) {
                    this.clearCriticalAndOptional(opts[0]);
                }
            }
        } else {
            throw new IllegalArgumentException("Not defined for multioptional.!");
        }
    }

    public void removeFromHit(int q) {
        --this.atomsAdded;
        if (this.atomsAdded == 0 && this.lazyInit) {
            this.clearStructures();
        }
    }

    protected void clearStructures() {
        this.criticalParts = null;
        this.optionalParts = null;
        this.innerNeighbour = null;
        this.borderAtoms = null;
    }

    @Override
    public int[] getHgMappableNeighbours(int a) {
        int[] neigh = this.searcher.getNeighbours(a, true);
        IntVector mappables = new IntVector();
        for (int n : neigh) {
            if (!this.isHgMappable(n)) continue;
            mappables.add(n);
        }
        return mappables.toArray();
    }

    @Override
    public int[] getNeighbours(int a) {
        return this.searcher.getNeighbours(a, true);
    }

    private int[] getMappableNeighbours(int a) {
        int[] hgNeigh = this.searcher.getNeighbours(this.hgIndex, false);
        int[] neigh = this.searcher.getNeighbours(a, true);
        IntVector mappables = new IntVector();
        block0: for (int n : neigh) {
            for (int hgN : hgNeigh) {
                if (!this.searcher.getMapToHomology(n, hgN)) continue;
                mappables.add(n);
                continue block0;
            }
            if (!this.isHgMappable(n)) continue;
            mappables.add(n);
        }
        return mappables.toArray();
    }

    protected int getBondType(int fro, int to) {
        return this.searcher.getBTypeBetweenAtomsMatched(fro, to);
    }

    protected int[] getPathToCrit(int crit, int atom) {
        IntVector pathV = new IntVector();
        pathV.add(atom);
        while (atom > -1) {
            int ind = ArrayTools.indexInArray(this.optionalParts[crit], atom);
            if (ind >= 0) {
                atom = this.innerNeighbour[crit][ind];
                pathV.add(atom);
                continue;
            }
            atom = -1;
        }
        return pathV.toArray();
    }

    private int[] getOuterBranch(int crit, int q) {
        IntVector branch = new IntVector();
        IntVector toProcess = new IntVector();
        toProcess.add(q);
        while (toProcess.size() > 0) {
            int currAtom = toProcess.removeLast();
            branch.add(currAtom);
            int[] neighV = this.searcher.getNeighbours(currAtom, true);
            for (int i = 0; i < neighV.length; ++i) {
                if (this.getInnerNeighbour(crit, neighV[i]) != currAtom || !this.searcher.getMapToHomology(neighV[i], this.hgIndex)) continue;
                toProcess.add(neighV[i]);
            }
        }
        return branch.toArray();
    }

    private int getInnerNeighbour(int crit, int q) {
        int ind = ArrayTools.indexInArray(this.optionalParts[crit], q);
        if (ind < 0) {
            return Integer.MIN_VALUE;
        }
        int parent = this.innerNeighbour[crit][ind];
        return parent;
    }

    protected void addNewCritical(int[] ringAtoms) {
        if (this.criticalParts == null) {
            this.criticalParts = new int[1][];
            this.criticalParts[0] = ringAtoms;
        } else {
            int[][] tmp = new int[this.criticalParts.length + 1][];
            for (int i = 0; i < this.criticalParts.length; ++i) {
                tmp[i] = this.criticalParts[i];
            }
            tmp[tmp.length - 1] = ringAtoms;
            this.criticalParts = tmp;
        }
    }

    boolean hasAromaticBond(int atomIdx, boolean checkQuery) {
        int bondNum = this.searcher.getBondCount(atomIdx, true);
        boolean hasAromatic = false;
        for (int i = 0; i < bondNum; ++i) {
            int btyp = this.searcher.getBondType(atomIdx, i, true);
            if (btyp != 4 && (!checkQuery || btyp != 6 && btyp != 7 && btyp != 0)) continue;
            hasAromatic = true;
        }
        return hasAromatic;
    }

    boolean hasDoubleBond(int atomIdx, boolean otherSide) {
        int bondNum = this.searcher.getBondCount(atomIdx, otherSide);
        for (int i = 0; i < bondNum; ++i) {
            if (this.searcher.getBondType(atomIdx, i, otherSide) != 2) continue;
            return true;
        }
        return false;
    }

    boolean hasTripleBond(int atomIdx, boolean otherSide) {
        int bondNum = this.searcher.getBondCount(atomIdx, otherSide);
        for (int i = 0; i < bondNum; ++i) {
            if (this.searcher.getBondType(atomIdx, i, otherSide) != 3) continue;
            return true;
        }
        return false;
    }

    public void setCompleteHG(boolean completeStr) {
        if (completeStr != this.completeHG) {
            this.completeHG = completeStr;
            this.init();
        }
    }

    protected void init() {
    }

    public boolean getCompleteHG() {
        return this.completeHG;
    }

    public int getNumberOfCriticalParts() {
        return this.criticalParts == null ? 0 : this.criticalParts.length;
    }

    public int getCriticalAtom(int critInd, int atomInd) {
        if (this.criticalParts == null || this.criticalParts.length <= critInd || this.criticalParts[critInd].length <= atomInd) {
            return -1;
        }
        return this.criticalParts[critInd][atomInd];
    }

    public int[][] getPossibleBorderAtoms(int critInd) {
        int[] candidates;
        if (this.criticalParts == null || this.criticalParts.length <= critInd || this.criticalParts[critInd].length == 0 || !this.isHgMappable(this.criticalParts[critInd][0])) {
            return null;
        }
        if (this.ligandOnOptional) {
            candidates = new int[this.optionalParts[critInd].length + 1];
            candidates[0] = this.criticalParts[critInd][0];
            System.arraycopy(this.optionalParts[critInd], 0, candidates, 1, candidates.length - 1);
        } else {
            candidates = new int[this.borderAtoms[critInd].length];
            System.arraycopy(this.borderAtoms[critInd], 0, candidates, 0, candidates.length);
        }
        IntVector borderV = new IntVector();
        IntVector externalV = new IntVector();
        if (!this.ligandOnOptional) {
            for (int i = 0; i < this.innerNeighbour[critInd].length; ++i) {
                if (this.innerNeighbour[critInd][i] >= 0 || this.isHgMappable(this.optionalParts[critInd][i])) continue;
                borderV.add(-this.innerNeighbour[critInd][i] - 1);
                externalV.add(this.optionalParts[critInd][i]);
            }
        }
        Arrays.sort(candidates);
        int prevBorderAtom = -1;
        for (int i = 0; i < candidates.length; ++i) {
            int currA = candidates[i];
            currA = currA < 0 ? -currA - 1 : currA;
            int[] neighB = this.searcher.getNeighbours(currA, true);
            if (currA == prevBorderAtom || !this.isHgMappable(currA)) continue;
            for (int j = 0; j < neighB.length; ++j) {
                if (this.isHgMappable(neighB[j])) continue;
                borderV.add(currA);
                externalV.add(neighB[j]);
            }
            prevBorderAtom = currA;
        }
        int[][] ret = new int[][]{borderV.toArray(), externalV.toArray()};
        return ret;
    }

    public boolean hasLigandOnOptional() {
        return this.ligandOnOptional;
    }

    public boolean finalCheck() {
        if (this.criticalParts == null) {
            return true;
        }
        for (int i = 0; i < this.criticalParts.length; ++i) {
            if (!this.isHgMappable(this.criticalParts[i][0])) continue;
            return this.checkLazyInitProperties(i, PropertyCheckingStage.FINAL);
        }
        return true;
    }

    @Override
    public int[] getAttachAtoms(int strIndex) {
        return this.getPossibleBorderAtoms(strIndex)[0];
    }

    public static final boolean isAcceptedCarbonicAtomType(int atomNum) {
        return atomNum == 6 || atomNum == 1 || atomNum == 131;
    }

    public static final boolean isAcceptedHeteroAtomType(int atomNum) {
        return !PeriodicSystem.isAlkaliMetal(atomNum) && !PeriodicSystem.isNobleGas(atomNum);
    }

    public static boolean isHomologyOnHomologyMatching(HomologyMatcher targetMatcher, HomologyMatcher queryMatcher, HomologyTranslationOption homologyBroadTranslation, HomologyTranslationOption homologyNarrowTranslation) {
        int targetType = targetMatcher.homologyType;
        int queryType = queryMatcher.homologyType;
        return HomologyMatcher.areHomologyTypeIndexesMatching(homologyBroadTranslation, homologyNarrowTranslation, targetType, queryType);
    }

    public static boolean areHomologyTypeIndexesMatching(HomologyTranslationOption homologyBroadTranslation, HomologyTranslationOption homologyNarrowTranslation, int targetType, int queryType) {
        if (targetType == queryType) {
            return true;
        }
        if (homologyBroadTranslation == HomologyTranslationOption.ALL && HomologyMatcher.areInSubSetRelation(queryType, targetType)) {
            return true;
        }
        return homologyNarrowTranslation == HomologyTranslationOption.ALL && HomologyMatcher.areInSubSetRelation(targetType, queryType);
    }

    private static boolean areInSubSetRelation(int queryType, int targetType) {
        return compatibilityMap[queryType][targetType];
    }

    public final int getHomologyType() {
        return this.homologyType;
    }

    static {
        for (int i = 0; i < 22; ++i) {
            HomologyMatcher.compatibilityMap[i][i] = true;
        }
        for (int acyclicCarbons : HomologyConstants.ACYCLIC_CARBONS) {
            HomologyMatcher.compatibilityMap[acyclicCarbons][6] = true;
        }
        for (int cyclicGroups : HomologyConstants.CYCLIC_GROUPS) {
            HomologyMatcher.compatibilityMap[cyclicGroups][10] = true;
        }
        for (int metallicGroups : HomologyConstants.METALLIC_GROUPS) {
            HomologyMatcher.compatibilityMap[metallicGroups][13] = true;
            HomologyMatcher.compatibilityMap[metallicGroups][0] = true;
        }
        HomologyMatcher.compatibilityMap[20][0] = true;
    }

    static enum PropertyCheckingStage {
        EXPANSION,
        ADD,
        PROHIBIT,
        FINAL;

    }
}

