/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology.atomic;

import chemaxon.common.util.IntVector;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.HomologyMatcher;

public abstract class AtomicMatcher
extends HomologyMatcher {
    public AtomicMatcher(int hgIdx, HomologySGSearch searchObj) {
        super(hgIdx, searchObj);
        this.lazyInit = false;
        this.multiOptional = false;
        this.neighbouringCritical = false;
        this.ligandOnOptional = false;
    }

    @Override
    protected void findCriticals() {
        int i;
        IntVector atoms = new IntVector();
        for (i = 0; i < this.searcher.getAtomCountMatched(); ++i) {
            if (!this.isHgMappable(i)) continue;
            atoms.add(i);
        }
        this.criticalParts = new int[atoms.size()][1];
        for (i = 0; i < this.criticalParts.length; ++i) {
            this.criticalParts[i][0] = atoms.get(i);
        }
    }

    @Override
    protected void expandCritical(int i) {
    }

    @Override
    public int[][] getPossibleBorderAtoms(int critInd) {
        if (this.criticalParts == null || this.criticalParts.length <= critInd || this.criticalParts[critInd].length == 0 || !this.isHgMappable(this.criticalParts[critInd][0])) {
            return null;
        }
        int critAtom = this.criticalParts[critInd][0];
        int[] neighbours = this.searcher.getNeighbours(critAtom, true);
        int[][] ret = new int[2][neighbours.length];
        for (int i = 0; i < neighbours.length; ++i) {
            ret[0][i] = critAtom;
            ret[1][i] = neighbours[i];
        }
        return ret;
    }
}

