/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.homology.atomic;

import chemaxon.common.util.ArrayTools;
import chemaxon.sss.search.HomologySGSearch;
import chemaxon.sss.search.homology.atomic.AtomicMatcher;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;

public class MetalMatcher
extends AtomicMatcher {
    private static final String[] acceptedStrings = new String[]{"mh", "m", "ah", "qh"};

    public MetalMatcher(int hgIdx, HomologySGSearch searchObj) {
        super(hgIdx, searchObj);
        this.homologyType = 13;
    }

    @Override
    public boolean isInitialAtom(int atomNum, int atomIdx, MolAtom atom) {
        return MetalMatcher.isAcceptedAtomType(atomNum, atom);
    }

    public static final boolean isAcceptedAtomType(int atomNum, MolAtom atom) {
        String aliasstr = atom != null ? atom.getAliasstr() : null;
        return PeriodicSystem.isMetal(atomNum) || atomNum == 131 || atomNum == 132 || atomNum == 136 && ArrayTools.foundInArray(acceptedStrings, aliasstr.toLowerCase());
    }
}

