/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.ratom;

import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.ratom.LigandHandler;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class GroupHitHandler {
    private static final Logger logger = Logger.getLogger(GroupHitHandler.class.getName());
    private MolSearchOptions searchOptions = new MolSearchOptions(2);
    private boolean bridgingRAllowed = this.searchOptions.isBridgingRAllowed();
    private boolean RLigandEqualityCheck = this.searchOptions.getRLigandEqualityCheck();
    private boolean fullSearch = this.searchOptions.getSearchType() == 4;
    private MolSearch fullSearcher = null;
    private MolSearch ligandSearcher = null;
    private Molecule query = null;
    private Molecule target = null;
    private int[] excludedTargetAtoms = null;
    private int[] querySameRMap = null;
    private boolean querySameRMapInited = false;
    private boolean targetInitialized = false;
    private LigandHandler ligandHandler = new LigandHandler();

    public void setSearchOptions(SearchOptions options, boolean fullSearch) {
        options.clonecopy(this.searchOptions);
        this.bridgingRAllowed = this.searchOptions.isBridgingRAllowed();
        this.RLigandEqualityCheck = this.searchOptions.getRLigandEqualityCheck();
        this.fullSearch = fullSearch;
    }

    public void setQuery(Molecule query, int[] excludedQueryAtoms) {
        this.query = query;
        this.querySameRMap = null;
        this.querySameRMapInited = false;
        this.ligandHandler.setQuery(query);
        this.ligandHandler.setExcludedQueryAtoms(excludedQueryAtoms);
    }

    public void setTarget(Molecule target, int[] excludedTargetAtoms) {
        this.target = target;
        this.excludedTargetAtoms = excludedTargetAtoms;
        this.targetInitialized = false;
        this.ligandHandler.setTarget(target);
    }

    private void initQuerySameRMap() {
        int[] map = null;
        int count = this.query.getAtomCount();
        block0: for (int i = 0; i < count; ++i) {
            MolAtom atom = this.query.getAtom(i);
            if (atom.getAtno() != 134) continue;
            int rid = atom.getRgroup();
            if (map == null) {
                map = new int[count];
                Arrays.fill(map, -1);
                map[i] = i;
                continue;
            }
            map[i] = i;
            if (rid <= 0) continue;
            for (int j = 0; j < i; ++j) {
                if (map[j] != j || this.query.getAtom(j).getRgroup() != rid) continue;
                map[i] = j;
                this.querySameRMap = map;
                continue block0;
            }
        }
        this.querySameRMapInited = true;
    }

    public boolean isValidGroupHit(int[][] groupHit, boolean checkMatching) throws SearchException {
        if (!checkMatching && !this.fullSearch && (!this.RLigandEqualityCheck || this.querySameRMapInited && this.querySameRMap == null)) {
            return true;
        }
        if (!this.ligandHandler.convertToLigands(groupHit, this.fullSearch)) {
            logger.fine("convertToLigands() failed");
            return false;
        }
        if (this.RLigandEqualityCheck && !this.checkRLigandEquality()) {
            logger.fine("checkRLigandEquality() failed");
            return false;
        }
        return !checkMatching || this.isMatching(groupHit);
    }

    private boolean checkRLigandEquality() throws SearchException {
        if (!this.querySameRMapInited) {
            this.initQuerySameRMap();
        }
        if (this.querySameRMap == null) {
            return true;
        }
        Molecule[] queryToRLigand = this.ligandHandler.getQueryToRLigand();
        boolean[] processed = new boolean[this.querySameRMap.length];
        for (int i = this.querySameRMap.length - 1; i >= 0; --i) {
            int t = this.querySameRMap[i];
            if (t == -1 || t == i || processed[t]) continue;
            assert (t < i);
            assert (this.querySameRMap[t] == t);
            Molecule targetLigand = queryToRLigand[t];
            for (int j = i; j > t; --j) {
                Molecule queryLigand;
                if (this.querySameRMap[j] != t || (queryLigand = queryToRLigand[j]) == targetLigand || queryLigand.isEmpty() && targetLigand.isEmpty()) continue;
                if (this.ligandSearcher == null) {
                    this.ligandSearcher = new MolSearch();
                    this.searchOptions.setSearchType(5);
                    this.ligandSearcher.setSearchOptions(this.searchOptions);
                }
                if (!processed[t]) {
                    this.ligandSearcher.setTarget(targetLigand);
                    processed[t] = true;
                }
                this.ligandSearcher.setQuery(queryLigand);
                if (this.ligandSearcher.isMatching()) continue;
                return false;
            }
            processed[t] = true;
        }
        return true;
    }

    private boolean isMatching(int[][] groupHit) throws SearchException {
        int i;
        if (this.fullSearcher == null) {
            this.fullSearcher = new MolSearch();
            this.searchOptions.setSearchType(7);
            this.fullSearcher.setSearchOptions(this.searchOptions);
        }
        if (!this.targetInitialized) {
            this.fullSearcher.setTarget(this.target, this.excludedTargetAtoms);
            this.targetInitialized = true;
        }
        Molecule fullQuery = this.query.cloneMolecule();
        MolAtom[] baseQueryAtoms = fullQuery.getAtomArray();
        ArrayList<MolAtom> anyAtoms = new ArrayList<MolAtom>();
        Molecule[] queryToRLigand = this.ligandHandler.getQueryToRLigand();
        for (i = 0; i < queryToRLigand.length; ++i) {
            if (queryToRLigand[i] == null || this.bridgingRAllowed && GroupHitHandler.indexOf(queryToRLigand, queryToRLigand[i]) < i) continue;
            Molecule fragment = queryToRLigand[i].cloneMolecule();
            LigandHandler.getAttachmentAtoms(anyAtoms, fragment);
            fullQuery.fuse(fragment, false);
            for (MolAtom anyAtom : anyAtoms) {
                int queryIndex = LigandHandler.getAttachQueryIndex(anyAtom);
                MolAtom baseQueryLigand = baseQueryAtoms[queryIndex];
                assert (anyAtom.getBondCount() == 1);
                MolAtom attachAtom = anyAtom.getBond(0).getOtherAtom(anyAtom);
                MolBond attachQueryBond = baseQueryAtoms[i].getBondTo(baseQueryLigand);
                MolBond attachBond = attachQueryBond.cloneBond(attachAtom, baseQueryLigand);
                fullQuery.removeAtom(anyAtom);
                fullQuery.add(attachBond);
            }
            LigandHandler.clearAttachQueryIndexes(queryToRLigand[i]);
            fullQuery.removeAtom(baseQueryAtoms[i]);
        }
        this.fullSearcher.setQuery(fullQuery);
        for (i = 0; i < baseQueryAtoms.length; ++i) {
            MolAtom atom = baseQueryAtoms[i];
            if (atom.getAtno() == 134 || this.ligandHandler.isExcludedQueryAtomIndex(i)) continue;
            int index = fullQuery.indexOf(atom);
            assert (index != -1);
            assert (groupHit[i].length == 1);
            this.fullSearcher.addMatch(index, groupHit[i][0]);
        }
        return this.fullSearcher.isMatching();
    }

    public void reorderGroups(int[][] groupHit) {
        for (int[] group : groupHit) {
            if (group.length <= 1) continue;
            Arrays.sort(group);
        }
        this.ligandHandler.reorderGroups(this.target, groupHit);
    }

    private static int indexOf(Molecule[] mols, Molecule mol) {
        for (int i = 0; i < mols.length; ++i) {
            if (mols[i] != mol) continue;
            return i;
        }
        return -1;
    }
}

