/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.ratom;

import chemaxon.common.util.ArrayTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.IntMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;

public class HeavyMatchFirstSorter {
    private int[] ratomIndexes = null;
    private Molecule target = null;
    private Stack<int[][]> groupHitStack = new Stack();
    private TreeMap<int[], int[][]> groupHitMap = null;
    private static final Comparator<int[]> GROUPHIT_RMAP_COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] v1, int[] v2) {
            int d = 0;
            for (int i = 0; i < v1.length; ++i) {
                if ((v1[i] < 2 || v2[i] < 2) && v1[i] != v2[i]) {
                    return v1[i] - v2[i];
                }
                if (d != 0) continue;
                d = v1[i] - v2[i];
            }
            return d;
        }
    };

    public void clear() {
        this.groupHitStack.clear();
        if (this.groupHitMap != null) {
            this.groupHitMap.clear();
        }
    }

    public void setOrdering(boolean ordering) {
        if (ordering) {
            if (this.groupHitMap == null) {
                this.groupHitMap = new TreeMap(GROUPHIT_RMAP_COMPARATOR);
            }
        } else {
            this.groupHitMap = null;
        }
    }

    public void setQuery(Molecule query, int[] exclude) {
        this.groupHitStack.clear();
        if (query == null) {
            this.ratomIndexes = null;
            this.groupHitMap = null;
            return;
        }
        int count = query.getAtomCount();
        IntMap<Integer> rmap = new IntMap<Integer>();
        for (int i = 0; i < count; ++i) {
            MolAtom atom;
            if (ArrayTools.contains(exclude, i) || (atom = query.getAtom(i)).getAtno() != 134) continue;
            int rid = atom.getRgroup();
            if (rid == 0) {
                rid = Integer.MAX_VALUE;
            }
            rmap.put(i, -(rid * count + i));
        }
        this.ratomIndexes = new int[rmap.size()];
        List entries = rmap.getSortedEntriesDescending();
        for (int i = 0; i < this.ratomIndexes.length; ++i) {
            this.ratomIndexes[i] = (Integer)entries.get(i).getKey();
        }
    }

    public void setTarget(Molecule target) {
        this.target = target;
        this.groupHitStack.clear();
        if (this.groupHitMap != null) {
            this.groupHitMap.clear();
        }
    }

    public void push(int[][] groupHit) {
        if (this.groupHitMap == null) {
            this.groupHitStack.push(groupHit);
            return;
        }
        int[] value = this.calcSorterValue(groupHit);
        if (HeavyMatchFirstSorter.isOptimal(value)) {
            this.groupHitStack.push(groupHit);
            return;
        }
        this.groupHitMap.put(value, groupHit);
        while (this.groupHitMap.size() > 200) {
            this.groupHitMap.remove(this.groupHitMap.firstKey());
        }
    }

    private static boolean isOptimal(int[] value) {
        for (int i = value.length - 1; i >= 0; --i) {
            if (value[i] >= 2) continue;
            return false;
        }
        return true;
    }

    private int[] calcSorterValue(int[][] groupHit) {
        int[] value = new int[this.ratomIndexes.length + 1];
        for (int i = 0; i < this.ratomIndexes.length; ++i) {
            value[i] = this.getGroupValue(groupHit[this.ratomIndexes[i]]);
        }
        value[this.ratomIndexes.length] = 2;
        while (this.groupHitMap.containsKey(value)) {
            int n = value.length - 1;
            value[n] = value[n] + 1;
        }
        return value;
    }

    private int getGroupValue(int[] group) {
        int v = 0;
        for (int g : group) {
            v += this.getValue(g);
        }
        return v *= group.length;
    }

    private int getValue(int index) {
        if (index < 0) {
            return 1;
        }
        return this.target.getAtom(index).getAtno();
    }

    public int[][] pop() {
        return !this.groupHitStack.empty() ? this.groupHitStack.pop() : (int[][])null;
    }

    public int[][] peek() {
        return !this.groupHitStack.empty() ? this.groupHitStack.peek() : (int[][])null;
    }

    public void close() {
        if (this.groupHitMap == null) {
            return;
        }
        while (!this.groupHitStack.empty()) {
            int[][] groupHit = this.groupHitStack.pop();
            this.groupHitMap.put(this.calcSorterValue(groupHit), groupHit);
        }
        Iterator<int[][]> iterator = this.groupHitMap.values().iterator();
        while (iterator.hasNext()) {
            this.groupHitStack.push(iterator.next());
        }
        this.groupHitMap = null;
    }

    public boolean empty() {
        return this.groupHitStack.empty();
    }
}

