/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.rg;

import chemaxon.marvin.util.MolImportUtil;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Hashtable;

public class RgMember {
    public Molecule mol = null;
    public int[][] hitList = null;
    private ArrayList<int[][]> groupHitList = null;
    public Hashtable<String, Boolean>[] stereoList = null;
    public int[] attIndex = new int[2];

    public RgMember(Molecule mol) throws SearchException {
        this.mol = mol;
        for (int x = 0; x < this.attIndex.length; ++x) {
            this.attIndex[x] = -1;
        }
        int n = mol.getAtomCount();
        for (int i = 0; i < n; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getQPropAsInt("s") != -2) continue;
            atom.setQProp("s", atom.getBondCount() - atom.getExplicitHcount());
        }
        MolAtom[] attachAtoms = MolImportUtil.getAtomsWithAttachments(mol);
        MolImportUtil.clearAttachments(mol);
        for (int i = 0; i < attachAtoms.length; ++i) {
            if (attachAtoms[i] == null) continue;
            this.attIndex[i] = mol.indexOf(attachAtoms[i]);
        }
        if (this.attIndex[0] == -1) {
            throw new SearchException("No primary attachment point defined.");
        }
    }

    public void setHitList(int[][] hitList) {
        this.hitList = hitList;
    }

    public int[][] getHitList() {
        return this.hitList;
    }

    public void setStereoList(Hashtable<String, Boolean>[] stereoList) {
        this.stereoList = stereoList;
    }

    public Hashtable[] getStereoList() {
        return this.stereoList;
    }

    public void addGroupHit(int[][] groupHit) {
        if (this.groupHitList == null) {
            this.groupHitList = new ArrayList();
        }
        this.groupHitList.add(groupHit);
    }

    public int[][] getGroupHit(int i) {
        if (this.groupHitList == null || i < 0 || i >= this.groupHitList.size()) {
            return null;
        }
        return this.groupHitList.get(i);
    }

    public void clearHits() {
        this.hitList = null;
        this.groupHitList = null;
    }

    public void setMolecule(Molecule mol) {
        this.mol = mol;
    }

    public Molecule getMolecule() {
        return this.mol;
    }
}

