/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.rg;

import chemaxon.common.util.IntVector;
import chemaxon.core.util.BondTable;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.OccurenceParser;
import chemaxon.sss.search.RgSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchHit;
import chemaxon.sss.search.rg.RgGroup;
import chemaxon.sss.search.rg.RgMember;
import chemaxon.sss.search.rg.RgNode;
import chemaxon.sss.search.rg.RgSearchDescriptor;
import chemaxon.sss.search.rg.RgSearchUtil;
import chemaxon.sss.search.rg.RgSearcher;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.MolHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;

public class RgSearchComplex
implements RgSearcher {
    private RgSearchDescriptor descriptor;
    private RgSearch rgSearch;
    private MolSearch ms = null;
    private MolSearch rootSearch = null;
    private MolSearchOptions searchOptions;
    private BondTable targetBtab = null;
    private boolean substituentSearchReady = false;
    private boolean targetHydrogenized = false;
    private Molecule target = null;
    private Molecule input_target = null;
    private Molecule targetWithH = null;
    private int[] targetAtNo = null;
    int[] hitCombination;
    RgNode[] rgnodes;
    int rnodeCount;
    SearchHit hit = null;
    SearchHit lastHit = null;
    boolean lastHitInitialized = false;
    boolean[][][][] conflicts = null;
    int[] rOccurance = null;
    HashSet<Integer> hitBondIndexes = null;
    boolean[] hasValidHits = null;
    private int[] excludedTargetAtoms;
    private String licenseEnvironment;

    public RgSearchComplex(String licenseEnvironment, RgSearch rgSearch, RgSearchDescriptor descriptor, Molecule target, int[] excludedTargetAtoms) {
        this.licenseEnvironment = licenseEnvironment;
        this.rgSearch = rgSearch;
        this.searchOptions = descriptor.searchOptions;
        this.target = target;
        this.input_target = target;
        this.excludedTargetAtoms = excludedTargetAtoms;
        this.descriptor = descriptor;
        this.rgnodes = descriptor.rgnodes.toArray(new RgNode[0]);
        this.rnodeCount = this.rgnodes.length;
        this.initSearcher();
    }

    @Override
    public void setTarget(Molecule target, int[] excludedTargetAtoms) {
        this.excludedTargetAtoms = excludedTargetAtoms;
        this.input_target = target;
        this.target = target;
        this.targetWithH = null;
        this.targetBtab = null;
        this.targetAtNo = null;
        this.substituentSearchReady = false;
        this.lastHit = null;
        this.lastHitInitialized = false;
        this.initHydrogenizeTarget();
        if (this.rootSearch != null) {
            this.rootSearch.setTarget(target, excludedTargetAtoms);
        }
    }

    private void searchForSubstituents() throws SearchException {
        RgMember rm;
        int memberIndex;
        RgGroup rg;
        int groupIndex;
        this.ms.setTarget(this.target, this.excludedTargetAtoms);
        for (groupIndex = 0; groupIndex < this.descriptor.maxRGroupId + 1; ++groupIndex) {
            rg = this.descriptor.rgroups[groupIndex];
            if (rg == null) continue;
            for (memberIndex = 0; memberIndex < rg.members.size(); ++memberIndex) {
                rm = rg.members.get(memberIndex);
                rm.clearHits();
            }
        }
        for (groupIndex = 0; groupIndex < this.descriptor.maxRGroupId + 1; ++groupIndex) {
            rg = this.descriptor.rgroups[groupIndex];
            if (rg == null) continue;
            for (memberIndex = 0; memberIndex < rg.members.size(); ++memberIndex) {
                rm = rg.members.get(memberIndex);
                Molecule mol = rm.getMolecule();
                this.ms.setQuery(mol);
                SearchHit hit = null;
                ArrayList<int[]> hitList = new ArrayList<int[]>();
                ArrayList<Hashtable<String, Boolean>> stereoList = new ArrayList<Hashtable<String, Boolean>>();
                while ((hit = this.ms.findNextHit()) != null) {
                    hitList.add(hit.getSingleHit());
                    Hashtable<String, Boolean> stereoMatching = this.rgSearch.getStereoMatchingDirections(this.ms, hit.getSingleHit());
                    stereoList.add(stereoMatching);
                    rm.addGroupHit(hit.getGroupHit());
                }
                int[][] hits = new int[hitList.size()][];
                for (int hitIndex = 0; hitIndex < hitList.size(); ++hitIndex) {
                    int[][] mhit = rm.getGroupHit(hitIndex);
                    int count = 0;
                    for (int j = 0; j < mhit.length; ++j) {
                        count += mhit[j].length;
                    }
                    int[] lhit = new int[count];
                    count = 0;
                    for (int ghitIndex = 0; ghitIndex < mhit.length; ++ghitIndex) {
                        for (int k = 0; k < mhit[ghitIndex].length; ++k) {
                            lhit[count++] = mhit[ghitIndex][k];
                        }
                    }
                    hits[hitIndex] = lhit;
                }
                Hashtable[] stereo = new Hashtable[stereoList.size()];
                for (int i = 0; i < stereoList.size(); ++i) {
                    stereo[i] = (Hashtable)stereoList.get(i);
                }
                rm.setHitList(hits);
                rm.setStereoList(stereo);
            }
        }
    }

    @Override
    public SearchHit findNext() throws SearchException {
        while (true) {
            if (this.lastHit == null) {
                this.hit = this.rootSearch.findNextHit();
                this.substituentSearchReady = false;
                this.lastHitInitialized = false;
            }
            if (this.hit == null) {
                return null;
            }
            this.lastHit = new SearchHit((int[])this.hit.getSingleHit().clone(), (int[][])this.hit.getGroupHit().clone());
            int[] singleHitOld = this.lastHit.getSingleHit();
            int[][] groupHitOld = this.lastHit.getGroupHit();
            int[] singleHitNew = new int[singleHitOld.length + this.rnodeCount];
            int[][] groupHitNew = new int[singleHitOld.length + this.rnodeCount][];
            Hashtable<String, Boolean> hitStereo = this.rgSearch.getStereoMatchingDirections(this.rootSearch, singleHitOld);
            if (!this.substituentSearchReady) {
                this.searchForSubstituents();
                this.substituentSearchReady = true;
            }
            if (this.checkRootHit(this.lastHit, hitStereo)) {
                if (this.targetHydrogenized) {
                    int maxIndex = this.input_target.getAtomCount() - 1;
                    for (int hitIndex = 0; hitIndex < singleHitOld.length; ++hitIndex) {
                        if (singleHitOld[hitIndex] <= maxIndex) continue;
                        singleHitOld[hitIndex] = -this.target.getCtab()[singleHitOld[hitIndex]][0];
                        if (singleHitOld[hitIndex] != 0) continue;
                        singleHitOld[hitIndex] = Integer.MIN_VALUE;
                    }
                }
                Molecule query = this.rgSearch.getQuery();
                int atomCount = query.getAtomCount();
                int hitIndex = 0;
                for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
                    if (query.getAtom(atomIndex).getAtno() != 134) {
                        singleHitNew[atomIndex] = singleHitOld[hitIndex];
                        groupHitNew[atomIndex] = groupHitOld[hitIndex++];
                        continue;
                    }
                    singleHitNew[atomIndex] = -2147483647;
                }
                for (int rnIndex = 0; rnIndex < this.rnodeCount; ++rnIndex) {
                    int index;
                    if (this.hitCombination[rnIndex] + 1 == this.rgnodes[rnIndex].validHitCount && this.rgnodes[rnIndex].hasDummy) {
                        singleHitNew[this.rgnodes[rnIndex].idx] = -1;
                        groupHitNew[this.rgnodes[rnIndex].idx] = new int[]{-1};
                        continue;
                    }
                    int[] memberHit = this.rgnodes[rnIndex].validHits[this.hitCombination[rnIndex]];
                    RgMember rm = this.rgnodes[rnIndex].validHitMember[this.hitCombination[rnIndex]];
                    singleHitNew[this.rgnodes[rnIndex].idx] = index = memberHit[rm.attIndex[0]];
                    groupHitNew[this.rgnodes[rnIndex].idx] = new int[this.rgnodes[rnIndex].validHits[this.hitCombination[rnIndex]].length];
                    int groupHitIndex = 1;
                    groupHitNew[this.rgnodes[rnIndex].idx][0] = index;
                    for (int atomIndex = memberHit.length - 1; atomIndex >= 0; --atomIndex) {
                        if (memberHit[atomIndex] == index) continue;
                        groupHitNew[this.rgnodes[rnIndex].idx][groupHitIndex++] = memberHit[atomIndex];
                    }
                }
                this.lastHit.setSingleHit(singleHitNew);
                this.lastHit.setGroupHit(groupHitNew);
                return this.lastHit;
            }
            this.lastHit = null;
        }
    }

    public void setTarget(Molecule target) {
        this.setTarget(target, null);
    }

    private void initSearcher() {
        MolSearchOptions mso;
        this.initHydrogenizeTarget();
        if (this.rootSearch == null) {
            this.rootSearch = new MolSearch();
            this.rootSearch.setLicenseEnvironment(this.licenseEnvironment);
            this.searchOptions.setDirty(true);
        }
        if (this.searchOptions.isDirty()) {
            this.rootSearch.setSearchOptions(this.searchOptions);
            if (!this.descriptor.isSimpleCase) {
                mso = new MolSearchOptions(2);
                this.rootSearch.getSearchOptions().clonecopyOptions(mso);
                mso.setSubgraphSearch(true);
                mso.setOrderSensitiveSearch(true);
                this.rootSearch.setSearchOptions(mso);
            }
        }
        if (this.ms == null) {
            this.ms = new MolSearch();
            this.searchOptions.setDirty(true);
        }
        if (this.searchOptions.isDirty()) {
            mso = new MolSearchOptions(2);
            this.searchOptions.clonecopyOptions(mso);
            mso.setOrderSensitiveSearch(true);
            mso.setSubgraphSearch(true);
            this.ms.setSearchOptions(mso);
        }
        this.searchOptions.setDirty(false);
        this.rootSearch.setTarget(this.target, this.excludedTargetAtoms);
        this.rootSearch.setQuery(this.descriptor.root);
    }

    private boolean checkRootHit(SearchHit searchHit, Hashtable<String, Boolean> rootStereo) throws SearchException {
        int level;
        int[] hit = searchHit.getSingleHit();
        if (this.rnodeCount == 0) {
            return true;
        }
        boolean finished = false;
        if (!this.lastHitInitialized) {
            this.lastHitInitialized = true;
            BondTable queryTable = this.descriptor.root.getBondTable();
            BondTable targetTable = this.target.getBondTable();
            ArrayList<int[]> validHits = new ArrayList<int[]>();
            ArrayList<int[]> validHitAtt = new ArrayList<int[]>();
            ArrayList<RgMember> validHitMember = new ArrayList<RgMember>();
            ArrayList<Integer> validHitBondIndex = new ArrayList<Integer>();
            ArrayList<Integer> validHitAttachAtom = new ArrayList<Integer>();
            for (int rgnodeIndex = 0; rgnodeIndex < this.rnodeCount; ++rgnodeIndex) {
                RgNode rgnode = this.rgnodes[rgnodeIndex];
                validHits.clear();
                validHitAtt.clear();
                validHitMember.clear();
                validHitBondIndex.clear();
                validHitAttachAtom.clear();
                rgnode.validHitIdxInMember.clear();
                rgnode.validHitCount = 0;
                int id = rgnode.group;
                int[] attMap = rgnode.atomMap;
                int[] idOnRoot = new int[2];
                int[] attachIndex = new int[2];
                RgGroup rg = this.descriptor.rgroups[id - 1];
                if (rg == null) {
                    throw new SearchException("Undefined R-group: R" + id);
                }
                for (int z = 0; z < rgnode.connections; ++z) {
                    int am = attMap[z];
                    if (am == 0) {
                        if (z == 0) {
                            throw new SearchException("Primary attachment point not set.");
                        }
                        throw new SearchException("Secondary attachment point not set.");
                    }
                    if (am > 0) {
                        idOnRoot[z] = RgSearchUtil.getRealId(am, this.descriptor.root);
                        attachIndex[z] = hit[idOnRoot[z]];
                        continue;
                    }
                    attachIndex[z] = am;
                }
                ArrayList<RgMember> members = rg.members;
                for (int y = 0; y < members.size(); ++y) {
                    RgMember rm = members.get(y);
                    int[] memAtt = rm.attIndex;
                    int[][] mhits = rm.hitList;
                    if (mhits == null) continue;
                    int bondIndex = 0;
                    block8: for (int j = 0; j < mhits.length; ++j) {
                        Hashtable<String, Boolean> memberStereo;
                        int[] mhit = mhits[j];
                        if (RgSearchUtil.haveCommonNumbers(mhit, hit) || this.searchOptions.getStereoSearchType() != 1 && !this.checkEnhancedStereo(rootStereo, memberStereo = rm.stereoList[j])) continue;
                        int[] catt = new int[rgnode.connections];
                        for (int p = 0; p < rgnode.connections; ++p) {
                            int bondType;
                            int queryBondType;
                            int foundAtt;
                            int ma = memAtt[p];
                            if (ma == -1) {
                                if (attMap[p] == 0) continue;
                                throw new SearchException("An attachment point is not connected.");
                            }
                            catt[p] = foundAtt = mhit[ma];
                            if (attachIndex[p] < 0) continue;
                            bondIndex = targetTable.getBondIndex(attachIndex[p], foundAtt);
                            if (bondIndex < 0 || !RgSearchComplex.areMatchingBondTypes(queryBondType = rgnode.bondType[p], bondType = this.target.getBond(bondIndex).getType(), this.searchOptions.isExactBondMatching())) continue block8;
                            if (this.searchOptions.getStereoSearchType() == 1) continue;
                            for (int l = 0; l < rgnode.rootCT[p].size(); ++l) {
                                int node4;
                                int node3;
                                int node2;
                                int node1;
                                int cT;
                                int[] ct = rgnode.rootCT[p].get(l);
                                if (!RgSearchUtil.isMatchingCT(ct[0], cT = this.target.getStereo2(node1 = foundAtt, node2 = hit[RgSearchUtil.getRealId(ct[1], this.descriptor.root)], node3 = hit[RgSearchUtil.getRealId(ct[2], this.descriptor.root)], node4 = hit[RgSearchUtil.getRealId(ct[3], this.descriptor.root)]), this.searchOptions.getStereoSearchType() == 2)) continue block8;
                            }
                        }
                        validHits.add(mhit);
                        validHitAtt.add(catt);
                        validHitMember.add(rm);
                        validHitBondIndex.add(bondIndex);
                        validHitAttachAtom.add(attachIndex[0]);
                        rgnode.validHitIdxInMember.add(j);
                        ++rgnode.validHitCount;
                    }
                }
                validHits.add(new int[0]);
                rgnode.validHits = (int[][])validHits.toArray((T[])new int[0][0]);
                validHitAtt.add(new int[2]);
                rgnode.validHitAtt = (int[][])validHitAtt.toArray((T[])new int[0][0]);
                validHitMember.add(null);
                rgnode.validHitMember = validHitMember.toArray(new RgMember[0]);
                validHitBondIndex.add(-1);
                rgnode.validHitBondIndex = validHitBondIndex.toArray(new Integer[0]);
                validHitAttachAtom.add(-1);
                rgnode.validHitAttachAtom = validHitAttachAtom.toArray(new Integer[0]);
                rgnode.validHitIdxInMember.add(0);
                ++rgnode.validHitCount;
            }
            this.conflicts = new boolean[this.rnodeCount][this.rnodeCount][][];
            this.hasValidHits = new boolean[this.rnodeCount];
            for (int rgIndex = 0; rgIndex < this.rnodeCount; ++rgIndex) {
                this.rgnodes[rgIndex].hasConflict = false;
            }
            for (int rn1Index = 0; rn1Index < this.rnodeCount - 1; ++rn1Index) {
                this.hasValidHits[rn1Index] = this.rgnodes[rn1Index].validHitCount > 1;
                for (int rn2Index = rn1Index + 1; rn2Index < this.rnodeCount; ++rn2Index) {
                    this.conflicts[rn1Index][rn2Index] = new boolean[this.rgnodes[rn1Index].validHitCount][this.rgnodes[rn2Index].validHitCount];
                    this.conflicts[rn2Index][rn1Index] = new boolean[this.rgnodes[rn2Index].validHitCount][this.rgnodes[rn1Index].validHitCount];
                    int hit1Index = 0;
                    while (hit1Index + 1 < this.rgnodes[rn1Index].validHitCount) {
                        int[] hit1 = this.rgnodes[rn1Index].validHits[hit1Index];
                        int hit2Index = 0;
                        while (hit2Index + 1 < this.rgnodes[rn2Index].validHitCount) {
                            int[] hit2 = this.rgnodes[rn2Index].validHits[hit2Index];
                            if (RgSearchUtil.haveCommonNumbers(hit1, hit2) || !this.checkRREnhancedStereo(this.rgnodes[rn1Index], hit1Index, this.rgnodes[rn2Index], hit2Index)) {
                                this.conflicts[rn1Index][rn2Index][hit1Index][hit2Index] = true;
                                this.rgnodes[rn1Index].hasConflict = true;
                                this.rgnodes[rn2Index].hasConflict = true;
                            }
                            ++hit2Index;
                        }
                        ++hit1Index;
                    }
                }
            }
            for (int rnIndex = 0; rnIndex < this.rnodeCount; ++rnIndex) {
                if (!this.rgnodes[rnIndex].hasConflict && this.rgnodes[rnIndex].validHitCount > 1) {
                    this.rgnodes[rnIndex].hasDummy = false;
                    --this.rgnodes[rnIndex].validHitCount;
                    continue;
                }
                this.rgnodes[rnIndex].hasDummy = true;
            }
            this.checkRRCT(this.conflicts, this.rgnodes, hit);
            this.checkRRConnections(this.conflicts, this.rgnodes);
            this.hitBondIndexes = new HashSet();
            for (int fromIndex = 0; fromIndex < hit.length; ++fromIndex) {
                if (hit[fromIndex] < 0) continue;
                for (int toIndex = fromIndex + 1; toIndex < hit.length; ++toIndex) {
                    if (queryTable.getBondIndex(fromIndex, toIndex) < 0) continue;
                    this.hitBondIndexes.add(targetTable.getBondIndex(hit[fromIndex], hit[toIndex]));
                }
            }
            this.rOccurance = new int[this.descriptor.maxRGroupId + 1];
            this.hitCombination = new int[this.rnodeCount];
            Arrays.fill(this.hitCombination, -1);
            level = 0;
        } else {
            level = this.rnodeCount - 1;
        }
        do {
            if (level == -1) {
                finished = true;
                continue;
            }
            if (level < this.rnodeCount) {
                int selectedIndex = this.hitCombination[level];
                if (this.hitCombination[level] == -1) {
                    int n = this.rgnodes[level].group - 1;
                    this.rOccurance[n] = this.rOccurance[n] + 1;
                }
                if (this.hitCombination[level] + 1 < this.rgnodes[level].validHitCount) {
                    boolean compatible = false;
                    while (this.hitCombination[level] + 1 < this.rgnodes[level].validHitCount && !compatible) {
                        compatible = true;
                        int n = level;
                        this.hitCombination[n] = this.hitCombination[n] + 1;
                        for (int prevLevel = 0; prevLevel < level; ++prevLevel) {
                            if (!this.conflicts[prevLevel][level][this.hitCombination[prevLevel]][this.hitCombination[level]]) continue;
                            compatible = false;
                        }
                        if (this.hitCombination[level] + 1 != this.rgnodes[level].validHitCount || !this.rgnodes[level].hasDummy) continue;
                        int n2 = this.rgnodes[level].group - 1;
                        this.rOccurance[n2] = this.rOccurance[n2] - 1;
                    }
                    if (!compatible) continue;
                    if (selectedIndex > -1) {
                        this.hitBondIndexes.remove(this.rgnodes[level].validHitBondIndex[selectedIndex]);
                    }
                    selectedIndex = this.hitCombination[level];
                    this.hitBondIndexes.add(this.rgnodes[level].validHitBondIndex[selectedIndex]);
                    ++level;
                    continue;
                }
                if (selectedIndex > -1) {
                    this.hitBondIndexes.remove(this.rgnodes[level].validHitBondIndex[selectedIndex]);
                }
                if (!this.rgnodes[level].hasDummy) {
                    int n = this.rgnodes[level].group - 1;
                    this.rOccurance[n] = this.rOccurance[n] - 1;
                }
                this.hitCombination[level] = -1;
                --level;
                continue;
            }
            boolean fail = false;
            for (int rnIndex = 0; rnIndex < this.rnodeCount && !fail; ++rnIndex) {
                RgNode rgnode = this.rgnodes[rnIndex];
                RgGroup rggroup = this.descriptor.rgroups[rgnode.group - 1];
                if (this.hitCombination[rnIndex] + (this.rgnodes[rnIndex].hasDummy ? 1 : 0) < rgnode.validHitCount) {
                    if (!rggroup.restH) continue;
                    int atomIndex = rgnode.validHitAttachAtom[this.hitCombination[rnIndex]];
                    MolAtom atom = this.target.getAtom(atomIndex);
                    MolBond[] bonds = this.target.getBondArray();
                    for (int bondIndex = 0; bondIndex < bonds.length && !fail; ++bondIndex) {
                        MolAtom a1 = bonds[bondIndex].getAtom1();
                        MolAtom a2 = bonds[bondIndex].getAtom2();
                        if ((!atom.equals(a1) || a2.getAtno() == 1) && (!atom.equals(a2) || a1.getAtno() == 1) || this.hitBondIndexes.contains(bondIndex)) continue;
                        fail = true;
                    }
                    continue;
                }
                int hitIndex = 0;
                while (hitIndex + 1 < rgnode.validHitCount && !fail) {
                    if (!this.hitBondIndexes.contains(rgnode.validHitBondIndex[hitIndex])) {
                        fail = true;
                    }
                    ++hitIndex;
                }
            }
            if (!fail && this.searchOptions.getStereoSearchType() != 1) {
                Hashtable<String, Boolean> enhStereoList = new Hashtable<String, Boolean>();
                block25: for (int k = 0; k < this.descriptor.chirality.size() && !fail; ++k) {
                    boolean value;
                    Boolean prev;
                    int tAtomStereo;
                    int qAtomStereo;
                    int[] ch = this.descriptor.chirality.get(k);
                    int rootCenter = RgSearchUtil.getRealId(ch[0], this.descriptor.root);
                    int cent = hit[rootCenter];
                    MolAtom targetAtom = this.target.getAtom(rootCenter);
                    int rst = ch[8];
                    int tst = targetAtom.getStereoGroupType();
                    if (tst == 0 && (this.searchOptions.isTargetAbsoluteStereo() || this.target.isAbsStereo())) {
                        tst = 1;
                    }
                    if (rst != tst) {
                        if (rst == 1) {
                            fail = true;
                            continue;
                        }
                        if (rst == 2 && tst != 1) {
                            fail = true;
                            continue;
                        }
                    }
                    int[] i = new int[4];
                    for (int l = 0; l < 4; ++l) {
                        int idx = ch[l + 1];
                        if (idx == Integer.MAX_VALUE) {
                            i[l] = idx;
                            continue;
                        }
                        if (idx > 0) {
                            i[l] = hit[RgSearchUtil.getRealId(idx, this.descriptor.root)];
                            continue;
                        }
                        if (this.hitCombination[-idx] == 0) continue block25;
                        int prisec = 0;
                        if (idx <= -1000) {
                            prisec = 1;
                            idx += 1000;
                        }
                        RgNode rn = this.rgnodes[-idx];
                        int[] atts = rn.validHitAtt[this.hitCombination[-idx]];
                        i[l] = atts[prisec];
                    }
                    int parSign = MolAtom.paritySign(i[0], i[1], i[2], i[3]);
                    int par = this.target.getLocalParity(cent);
                    int chirality = RgSearchUtil.compareChiralities(ch[5], par, ch[6], parSign, qAtomStereo = ch[7], tAtomStereo = RgSearchComplex.getAtomStereo(this.target.getAtom(cent), par), this.searchOptions.getStereoSearchType() != 1);
                    if (chirality == 2) continue;
                    if (chirality == 0) {
                        fail = true;
                        continue;
                    }
                    if (rst == 1) {
                        if (chirality == 1) continue;
                        fail = true;
                        continue;
                    }
                    String key = "rel";
                    switch (rst) {
                        case 3: {
                            key = "&";
                            break;
                        }
                        case 2: {
                            key = "|";
                            break;
                        }
                        case 0: {
                            key = "rel";
                        }
                    }
                    if (rst != 0) {
                        key = key + ch[9];
                    }
                    if ((prev = enhStereoList.put(key, value = chirality == 1)) == null || ((Object)prev).equals(value)) continue;
                    fail = true;
                }
                if (fail) {
                    --level;
                    continue;
                }
                if (!this.checkEnhancedStereo(enhStereoList, rootStereo)) {
                    fail = true;
                    continue;
                }
                for (int rgnodeIndex = 0; rgnodeIndex < this.rnodeCount && !fail; ++rgnodeIndex) {
                    RgNode rgnode = this.rgnodes[rgnodeIndex];
                    if (this.hitCombination[rgnodeIndex] + (rgnode.hasDummy ? 1 : 0) >= rgnode.validHitCount) continue;
                    int[] rgHit = rgnode.validHits[this.hitCombination[rgnodeIndex]];
                    RgMember member = rgnode.validHitMember[this.hitCombination[rgnodeIndex]];
                    int y = Arrays.asList(member.hitList).indexOf(rgHit);
                    Hashtable<String, Boolean> memberStereo = member.stereoList[y];
                    if (this.checkEnhancedStereo(enhStereoList, memberStereo)) continue;
                    fail = true;
                }
            }
            if (fail) {
                --level;
                continue;
            }
            if (!this.searchOptions.isSubgraphSearch() && !this.checkExactGraph(this.rgnodes, this.hitCombination, searchHit)) {
                --level;
                continue;
            }
            int[] RHits = new int[this.descriptor.maxRGroupId + 1];
            ArrayList<MolAtom> attPointsInTarget = new ArrayList<MolAtom>();
            for (int rnIndex = 0; rnIndex < this.rnodeCount; ++rnIndex) {
                if (this.hitCombination[rnIndex] + (this.rgnodes[rnIndex].hasDummy ? 1 : 0) >= this.rgnodes[rnIndex].validHitCount) continue;
                RgNode node = this.rgnodes[rnIndex];
                int n = node.group - 1;
                RHits[n] = RHits[n] + 1;
                int[] attPoints = node.validHitAtt[this.hitCombination[rnIndex]];
                for (int conIndex = 0; conIndex < node.connections; ++conIndex) {
                    int idxTarget = attPoints[conIndex];
                    MolAtom atom = this.target.getAtom(idxTarget);
                    attPointsInTarget.add(atom);
                }
            }
            for (int sIndex = 0; sIndex < this.descriptor.sCounts.length && !fail; ++sIndex) {
                int count = this.descriptor.sCounts[sIndex];
                if (count == 0) continue;
                int indexInQuery = RgSearchUtil.getRealId(sIndex + 1, this.descriptor.root);
                int tIndex = hit[indexInQuery];
                MolAtom atom = this.target.getAtom(tIndex);
                int sCount = 0;
                int ligands = atom.getBondCount();
                for (int y = 0; y < ligands; ++y) {
                    MolAtom ligand = atom.getLigand(y);
                    if (ligand.getAtno() == 1 || attPointsInTarget.contains(ligand)) continue;
                    ++sCount;
                }
                if (count == sCount) continue;
                fail = true;
            }
            if (fail) {
                --level;
                continue;
            }
            if (this.checkOccurenceAndDependencies(RHits, this.hasValidHits)) {
                return true;
            }
            --level;
        } while (!finished);
        return false;
    }

    private boolean checkOccurenceAndDependencies(int[] RHits, boolean[] hasValidHit) {
        int t;
        boolean[] passed = new boolean[RHits.length];
        for (t = 0; t < RHits.length; ++t) {
            int num = RHits[t];
            RgGroup rg = this.descriptor.rgroups[t];
            if (rg == null) continue;
            String ost = rg.occurence;
            OccurenceParser op = new OccurenceParser();
            op.setOccurenceString(ost);
            if (!op.test(num)) continue;
            passed[t] = true;
        }
        for (t = 0; t < passed.length; ++t) {
            RgGroup rg;
            if (passed[t] || (rg = this.descriptor.rgroups[t]) == null) continue;
            boolean isDep = false;
            for (int rgroupIndex = 0; rgroupIndex < this.descriptor.rgroups.length; ++rgroupIndex) {
                RgGroup r = this.descriptor.rgroups[rgroupIndex];
                if (r == null || r.dependency != t + 1) continue;
                isDep = true;
                if (!passed[rgroupIndex]) continue;
                return false;
            }
            int dep = rg.dependency;
            if (!isDep && dep == 0) {
                return false;
            }
            if (!hasValidHit[t]) continue;
            return false;
        }
        return true;
    }

    private boolean checkEnhancedStereo(Hashtable<String, Boolean> list1, Hashtable<String, Boolean> list2) {
        return list2.entrySet().containsAll(list1.entrySet());
    }

    private boolean checkExactGraph(RgNode[] rgnodes, int[] hitCombination, SearchHit searchHit) {
        int qatoms = 0;
        int qbonds = 0;
        MolHandler mh = new MolHandler();
        for (int rgnodeIndex = 0; rgnodeIndex < rgnodes.length; ++rgnodeIndex) {
            RgNode rn = rgnodes[rgnodeIndex];
            if (hitCombination[rgnodeIndex] + (rgnodes[rgnodeIndex].hasDummy ? 1 : 0) == rn.validHitCount) continue;
            RgMember rm = rn.validHitMember[hitCombination[rgnodeIndex]];
            mh.setMolecule(rm.mol);
            qatoms += mh.getHeavyAtomCount();
            qbonds += rm.mol.getBondCount();
            qbonds -= RgSearchUtil.getHBondCount(rm.mol);
            qbonds += rn.connections;
            ArrayList<IntVector> groupHitAtoms = new ArrayList<IntVector>();
            int hitIdx = rn.validHitIdxInMember.get(hitCombination[rgnodeIndex]);
            qatoms += this.countGroupHitAtoms(rm.getGroupHit(hitIdx), groupHitAtoms);
            qbonds += this.countGroupHitBonds(groupHitAtoms);
        }
        mh.setMolecule(this.descriptor.root);
        qatoms += mh.getHeavyAtomCount();
        qbonds += this.descriptor.root.getBondCount();
        qbonds -= RgSearchUtil.getHBondCount(this.descriptor.root);
        ArrayList<IntVector> groupHitAtoms = new ArrayList<IntVector>();
        mh.setMolecule(this.target);
        int tatoms = mh.getHeavyAtomCount();
        int tbonds = this.target.getBondCount();
        return (qatoms += this.countGroupHitAtoms(searchHit.getGroupHit(), groupHitAtoms)) == tatoms && (qbonds += this.countGroupHitBonds(groupHitAtoms)) == (tbonds -= RgSearchUtil.getHBondCount(this.target));
    }

    private int countGroupHitAtoms(int[][] groupHit, ArrayList<IntVector> groupHitAtoms) {
        if (this.targetBtab == null) {
            this.targetBtab = this.target.getBondTable();
        }
        if (this.targetAtNo == null) {
            this.targetAtNo = new int[this.target.getAtomCount()];
            int n = this.target.getAtomCount();
            for (int i = 0; i < n; ++i) {
                this.targetAtNo[i] = this.target.getAtom(i).getAtno();
            }
        }
        int groupAtomNo = 0;
        if (groupHit == null) {
            return 0;
        }
        for (int[] hitV : groupHit) {
            if (hitV.length <= 1) continue;
            IntVector singleGroupHit = new IntVector();
            for (int i = 0; i < hitV.length; ++i) {
                int hit = hitV[i];
                if (hit >= this.targetAtNo.length || this.targetAtNo[hit] <= 1) continue;
                singleGroupHit.add(hit);
                if (i <= 0) continue;
                ++groupAtomNo;
            }
            groupHitAtoms.add(singleGroupHit);
        }
        return groupAtomNo;
    }

    private void checkRRCT(boolean[][][][] conflicts, RgNode[] rgnodes, int[] hit) {
        if (this.searchOptions.getStereoSearchType() != 1) {
            for (int rn1Index = 0; rn1Index < rgnodes.length; ++rn1Index) {
                RgNode rgnode1 = rgnodes[rn1Index];
                if (rgnode1.validHitCount == 1 && rgnode1.hasDummy) continue;
                for (int hit1Index = 0; hit1Index < rgnode1.validHitCount - 1; ++hit1Index) {
                    for (int conIndex = 0; conIndex < rgnode1.connections; ++conIndex) {
                        for (int ctrelIndex = 0; ctrelIndex < rgnode1.rNodeCT[conIndex].size(); ++ctrelIndex) {
                            int[] ct = rgnode1.rNodeCT[conIndex].get(ctrelIndex);
                            int[] atts1 = rgnode1.validHitAtt[hit1Index];
                            int node1 = atts1[conIndex];
                            int node2 = hit[RgSearchUtil.getRealId(ct[1], this.descriptor.root)];
                            int node3 = hit[RgSearchUtil.getRealId(ct[2], this.descriptor.root)];
                            int rn2Index = ct[3] - 1;
                            RgNode rgnode2 = rgnodes[rn2Index];
                            if (rgnode2.validHitCount == 1 && rgnode2.hasDummy) continue;
                            for (int hit2Index = 0; hit2Index < rgnode2.validHitCount - 1; ++hit2Index) {
                                int[] atts2 = rgnode2.validHitAtt[hit2Index];
                                int otherPriSec = ct[4];
                                int node4 = atts2[otherPriSec];
                                int cT = this.target.getStereo2(node1, node2, node3, node4);
                                if (RgSearchUtil.isMatchingCT(ct[0], cT, this.searchOptions.getStereoSearchType() == 2)) continue;
                                conflicts[rn1Index][rn2Index][hit1Index][hit2Index] = true;
                                conflicts[rn2Index][rn1Index][hit2Index][hit1Index] = true;
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean checkRREnhancedStereo(RgNode rgnode1, int hit1Index, RgNode rgnode2, int hit2Index) {
        if (this.searchOptions.getStereoSearchType() == 1) {
            return true;
        }
        int[] hit1 = rgnode1.validHits[hit1Index];
        RgMember rgmember1 = rgnode1.validHitMember[hit1Index];
        int index1 = Arrays.asList(rgmember1.hitList).indexOf(hit1);
        Hashtable<String, Boolean> stereo1 = rgmember1.stereoList[index1];
        int[] hit2 = rgnode2.validHits[hit2Index];
        RgMember rgmember2 = rgnode2.validHitMember[hit2Index];
        int index2 = Arrays.asList(rgmember2.hitList).indexOf(hit2);
        Hashtable<String, Boolean> stereo2 = rgmember2.stereoList[index2];
        return this.checkEnhancedStereo(stereo1, stereo2);
    }

    private void checkRRConnections(boolean[][][][] conflicts, RgNode[] rgnodes) {
        for (int rn1Index = 0; rn1Index < rgnodes.length; ++rn1Index) {
            RgNode rgnode1 = rgnodes[rn1Index];
            if (rgnode1.validHitCount == 1 && rgnode1.hasDummy) continue;
            for (int con1Index = 0; con1Index < rgnode1.connections; ++con1Index) {
                if (rgnode1.atomMap[con1Index] >= 0) continue;
                int hit1Index = 0;
                while (hit1Index + 1 < rgnode1.validHitCount) {
                    int[] att = rgnode1.validHitAtt[hit1Index];
                    int thisConn = att[con1Index];
                    int rn2Index = -rgnode1.atomMap[con1Index] - 1;
                    RgNode rgnode2 = rgnodes[rn2Index];
                    for (int con2Index = 0; con2Index < rgnode2.connections; ++con2Index) {
                        if (rgnode2.atomMap[con2Index] >= 0 || rgnode1 != rgnodes[-rgnode2.atomMap[con2Index] - 1]) continue;
                        int hit2Index = 0;
                        while (hit2Index + 1 < rgnode2.validHitCount) {
                            int thatConn = rgnode2.validHitAtt[hit2Index][con2Index];
                            int bondIndex = this.target.getBondTable().getBondIndex(thisConn, thatConn);
                            if (bondIndex < 0) {
                                conflicts[rn1Index][rn2Index][hit1Index][hit2Index] = true;
                                conflicts[rn2Index][rn1Index][hit2Index][hit1Index] = true;
                            } else {
                                int queryBondType = rgnode1.bondType[con1Index];
                                int bondType = this.target.getBond(bondIndex).getType();
                                if (!RgSearchComplex.areMatchingBondTypes(queryBondType, bondType, this.searchOptions.isExactBondMatching())) {
                                    conflicts[rn1Index][rn2Index][hit1Index][hit2Index] = true;
                                    conflicts[rn2Index][rn1Index][hit2Index][hit1Index] = true;
                                }
                            }
                            ++hit2Index;
                        }
                    }
                    ++hit1Index;
                }
            }
        }
    }

    private int countGroupHitBonds(ArrayList<IntVector> groupHitAtoms) {
        int groupHitBonds = 0;
        for (IntVector singleGroupHit : groupHitAtoms) {
            int n = singleGroupHit.size();
            for (int i = 0; i < n; ++i) {
                int atom1 = singleGroupHit.get(i);
                for (int j = i + 1; j < n; ++j) {
                    int atom2 = singleGroupHit.get(j);
                    if (this.targetBtab.getBondIndex(atom1, atom2) == -1) continue;
                    ++groupHitBonds;
                }
            }
        }
        return groupHitBonds;
    }

    protected static boolean areMatchingBondTypes(int q, int t, boolean exactMatch) {
        if (exactMatch) {
            return t == q;
        }
        if (q == 0) {
            return true;
        }
        switch (q) {
            case 5: {
                return t == 1 || t == 2;
            }
            case 6: {
                return t == 1 || t == 4;
            }
            case 7: {
                return t == 2 || t == 4;
            }
        }
        return q == t;
    }

    protected static int getAtomStereo(MolAtom atom, int parity) {
        switch (parity) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 32;
            }
            case 3: {
                int i;
                int c = atom.getBondCount();
                for (i = 0; i < c && atom.getBond(i).getStereo1(atom) != 48; ++i) {
                }
                if (i == c) {
                    return 0;
                }
                return 64;
            }
        }
        return 0;
    }

    private void initHydrogenizeTarget() {
        if (this.descriptor.queryHasExplicitH) {
            if (this.targetWithH == null) {
                this.targetWithH = this.input_target.cloneMolecule();
                this.targetWithH.hydrogenize(true);
            }
            this.target = this.targetWithH;
            this.targetHydrogenized = true;
        } else {
            this.target = this.input_target;
            this.targetHydrogenized = false;
        }
    }
}

