/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.search.rg;

import chemaxon.common.util.IntVector;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.RgSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.rg.RgGroup;
import chemaxon.sss.search.rg.RgMember;
import chemaxon.sss.search.rg.RgNode;
import chemaxon.sss.search.rg.RgSearchUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;

public class RgSearchDescriptor {
    public boolean isSimpleCase = false;
    public int combinations = 1;
    public int maxRGroupId = 0;
    public Molecule root;
    public RgGroup[] rgroups;
    public ArrayList<RgNode> rgnodes;
    public int[] sCounts = null;
    public ArrayList<int[]> chirality = null;
    public IntVector nonChiral = null;
    public RgMolecule query;
    public boolean queryHasExplicitH;
    public MolSearchOptions searchOptions;

    public RgSearchDescriptor(RgMolecule query, MolSearchOptions options) throws SearchException {
        this.query = query;
        this.searchOptions = options;
        this.init(query);
    }

    private void init(RgMolecule query) throws SearchException {
        this.root = query.getRoot().cloneMolecule();
        this.collectRNodeInformation(this.query);
        if (this.collectRgroupInformation()) {
            this.isSimpleCase = !RgSearch.enumerationModeDisabled && RgSearchUtil.rNodesAreUnique(query);
        }
        if (!this.isSimpleCase) {
            this.nonChiral = null;
            ArrayList<MolAtom> atoms = null;
            if (this.searchOptions.getStereoSearchType() != 1) {
                atoms = this.collectChiralityInformation(query);
            }
            this.collectSStarInfoAndRemoveSStarFromRoot();
            RgSearchUtil.removeRgroups(this.root);
            if (atoms != null) {
                this.nonChiral = new IntVector();
                for (int atomIndex = atoms.size() - 1; atomIndex >= 0; --atomIndex) {
                    MolAtom atom = atoms.get(atomIndex);
                    int index = this.root.indexOf(atom);
                    this.nonChiral.addElement(index);
                }
            }
        }
    }

    private void collectRNodeInformation(Molecule mol) throws SearchException {
        int atomIdx;
        int atomCount = mol.getAtomCount();
        int[] rgIndex = new int[atomCount];
        this.rgnodes = new ArrayList();
        this.sCounts = new int[atomCount];
        int found = 0;
        for (atomIdx = 0; atomIdx < atomCount; ++atomIdx) {
            MolAtom atom = mol.getAtom(atomIdx);
            if (atom.getAtno() != 134) continue;
            this.maxRGroupId = Math.max(this.maxRGroupId, atom.getRgroup());
            rgIndex[atomIdx] = ++found;
        }
        for (atomIdx = 0; atomIdx < atomCount; ++atomIdx) {
            if (rgIndex[atomIdx] <= 0) continue;
            this.collectRNodeAtomInformation(mol, atomIdx, rgIndex);
        }
    }

    private void collectRNodeAtomInformation(Molecule mol, int atomIdx, int[] rgIndex) throws SearchException {
        int i;
        MolAtom rgAtom = mol.getAtom(atomIdx);
        int edgeCount = rgAtom.getBondCount();
        if (edgeCount > 2) {
            throw new SearchException("Too many connections on R-group.");
        }
        RgNode rgnode = new RgNode(rgAtom.getRgroup());
        rgnode.idx = atomIdx;
        rgnode.map = RgSearchUtil.getAtomID(rgAtom);
        rgnode.connections = edgeCount;
        int maxIndex = 0;
        for (i = 0; i < edgeCount; ++i) {
            int index = mol.indexOf(rgAtom.getLigand(i));
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        for (i = 0; i < edgeCount; ++i) {
            int indexCT2;
            MolBond rgBond = rgAtom.getBond(i);
            MolAtom rgLigand = rgAtom.getLigand(i);
            int bondType = rgBond.getType();
            int mapId = RgSearchUtil.getAtomID(rgLigand);
            int index = mol.indexOf(rgLigand);
            if (rgLigand.getAtno() == 134) {
                mapId = -rgIndex[mol.indexOf(rgLigand)];
            }
            int prisec = 0;
            if (edgeCount > 1 && index == maxIndex) {
                prisec = 1;
                rgnode.setConnection(1, mapId, bondType);
            } else {
                rgnode.setConnection(0, mapId, bondType);
            }
            if (this.searchOptions.getStereoSearchType() == 1 || 2 == this.searchOptions.getDoubleBondStereoMatchingMode() || bondType != 1 || rgIndex[indexCT2 = index] > 0) continue;
            for (int j = 0; j < rgLigand.getBondCount(); ++j) {
                MolAtom ligand2;
                int indexCT3;
                int flags;
                MolBond bond2 = rgLigand.getBond(j);
                if (bond2.getType() != 2 || 1 == this.searchOptions.getDoubleBondStereoMatchingMode() && ((flags = bond2.getFlags()) & 0x200) == 0 && (flags & 0x100) == 0 || rgIndex[indexCT3 = mol.indexOf(ligand2 = rgLigand.getLigand(j))] > 0) continue;
                for (int k = 0; k < ligand2.getBondCount(); ++k) {
                    MolAtom ligand3;
                    int indexCT4;
                    int cT;
                    MolBond bond3 = ligand2.getBond(k);
                    if (bond3.getType() != 1 || !RgSearchUtil.isRelevantCT(cT = mol.getStereo2(atomIdx, indexCT2, indexCT3, indexCT4 = mol.indexOf(ligand3 = ligand2.getLigand(k))))) continue;
                    int[] ctInfo = new int[5];
                    ctInfo[0] = cT;
                    ctInfo[1] = RgSearchUtil.getAtomID(mol.getAtom(indexCT2));
                    ctInfo[2] = RgSearchUtil.getAtomID(mol.getAtom(indexCT3));
                    int prisecOther = 0;
                    if (mol.getAtom(indexCT4).getBondCount() > 1 && RgSearchUtil.getHighestLigand(mol, indexCT4) == indexCT3) {
                        prisecOther = 1;
                    }
                    ctInfo[4] = prisecOther;
                    if (rgIndex[indexCT4] > 0) {
                        ctInfo[3] = rgIndex[indexCT4];
                        rgnode.rNodeCT[prisec].add(ctInfo);
                        continue;
                    }
                    ctInfo[3] = RgSearchUtil.getAtomID(mol.getAtom(indexCT4));
                    rgnode.rootCT[prisec].add(ctInfo);
                }
            }
        }
        this.rgnodes.add(rgnode);
    }

    private boolean collectRgroupInformation() throws SearchException {
        this.isSimpleCase = true;
        this.rgroups = new RgGroup[this.maxRGroupId + 1];
        int rCount = this.query.getRgroupCount();
        boolean hasRNode = false;
        for (int rgroupIndex = 0; rgroupIndex < rCount; ++rgroupIndex) {
            int id = this.query.getRgroupId(rgroupIndex);
            if (!this.isRGroupFoundOnRoot(id)) continue;
            hasRNode = true;
            RgGroup r = new RgGroup();
            String occurence = this.query.getRlogicRange(rgroupIndex);
            boolean restH = (this.query.getRlogic(rgroupIndex) & Integer.MIN_VALUE) != 0;
            int dependency = (this.query.getRlogic(rgroupIndex) & 0x7FFF0000) >> 16;
            r.occurence = occurence;
            r.restH = restH;
            r.dependency = dependency;
            if (!occurence.equals(">0") || restH || dependency > 0) {
                this.isSimpleCase = false;
            }
            int mCount = this.query.getRgroupMemberCount(rgroupIndex);
            for (int y = 0; y < mCount; ++y) {
                Molecule memberMol = this.query.getRgroupMember(rgroupIndex, y);
                r.addMember(new RgMember(memberMol.cloneMolecule()));
            }
            if (this.rgroups[id - 1] == null) {
                this.rgroups[id - 1] = r;
                continue;
            }
            throw new SearchException("Duplicate R-group definition.");
        }
        MolAtom[] atoms = this.query.getAtomArray();
        for (int atomIndex = atoms.length - 1; atomIndex >= 0; --atomIndex) {
            if (atoms[atomIndex].getAtno() != 134) continue;
            int id = atoms[atomIndex].getRgroup();
            this.combinations *= this.rgroups[id - 1].members.size();
        }
        if (this.combinations > 10) {
            this.isSimpleCase = false;
        }
        if (!hasRNode) {
            this.isSimpleCase = false;
        }
        return this.isSimpleCase;
    }

    private boolean isRGroupFoundOnRoot(int id) {
        for (int i = 0; i < this.rgnodes.size(); ++i) {
            RgNode node = this.rgnodes.get(i);
            if (node.group != id) continue;
            return true;
        }
        return false;
    }

    private ArrayList<MolAtom> collectChiralityInformation(Molecule query) {
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        this.chirality = new ArrayList();
        int atomCount = query.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            int par;
            MolAtom atom = query.getAtom(atomIndex);
            int atomStereo = RgSearchDescriptor.getAtomStereo(atom, par = query.getLocalParity(atomIndex));
            if (atomStereo == 0) continue;
            boolean hasRligand = false;
            int bondCount = atom.getBondCount();
            int[] chiralAtomIndex = new int[4];
            int[] chiralInfo = new int[10];
            for (int y = 0; y < bondCount; ++y) {
                MolAtom ligand = atom.getLigand(y);
                int atno = ligand.getAtno();
                chiralAtomIndex[y] = query.indexOf(ligand);
                if (atno == 134) {
                    hasRligand = true;
                    chiralInfo[y + 1] = -this.getRNodeIndex(chiralAtomIndex[y]);
                    if (query.getAtom(chiralAtomIndex[y]).getBondCount() <= 1 || RgSearchUtil.getHighestLigand(query, chiralAtomIndex[y]) != atomIndex) continue;
                    int n = y + 1;
                    chiralInfo[n] = chiralInfo[n] - 1000;
                    continue;
                }
                if (atno == 1) {
                    chiralAtomIndex[y] = Integer.MAX_VALUE;
                }
                chiralInfo[y + 1] = RgSearchUtil.getAtomID(ligand);
            }
            if (!hasRligand) continue;
            if (atom.getImplicitHcount() > 0) {
                chiralAtomIndex[3] = Integer.MAX_VALUE;
                chiralInfo[4] = Integer.MAX_VALUE;
            }
            int parSign = MolAtom.paritySign(chiralAtomIndex[0], chiralAtomIndex[1], chiralAtomIndex[2], chiralAtomIndex[3]);
            for (int y = 0; y < bondCount; ++y) {
                MolBond bond = atom.getBond(y);
                bond.setFlags(bond.getFlags() & 0xFFFFFFCF);
            }
            chiralInfo[5] = par;
            chiralInfo[6] = parSign;
            chiralInfo[7] = atomStereo;
            chiralInfo[8] = atom.getStereoGroupType();
            chiralInfo[9] = atom.getStereoGroupNumber();
            atom.setStereoGroupType(0);
            chiralInfo[0] = RgSearchUtil.getAtomID(atom);
            atoms.add(atom);
            this.chirality.add(chiralInfo);
        }
        return atoms;
    }

    private int getRNodeIndex(int idx) {
        int rgnodeCount = this.rgnodes.size();
        for (int rgnodeIndex = 0; rgnodeIndex < rgnodeCount; ++rgnodeIndex) {
            if (this.rgnodes.get((int)rgnodeIndex).idx != idx) continue;
            return rgnodeIndex;
        }
        return -1;
    }

    private void collectSStarInfoAndRemoveSStarFromRoot() {
        int atomCount = this.root.getAtomCount();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            MolAtom atom = this.root.getAtom(atomIndex);
            int rNodeLigands = RgSearchUtil.getRNodeLigandsCount(atom);
            if (rNodeLigands == 0 || atom.getQPropAsInt("s") != -2) continue;
            atom.setQProp("s", -1);
            int sCount = atom.getBondCount() - atom.getExplicitHcount();
            this.sCounts[RgSearchUtil.getAtomID((MolAtom)atom) - 1] = sCount -= rNodeLigands;
        }
    }

    private static int getAtomStereo(MolAtom atom, int parity) {
        switch (parity) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 32;
            }
            case 3: {
                int i;
                int c = atom.getBondCount();
                for (i = 0; i < c && atom.getBond(i).getStereo1(atom) != 48; ++i) {
                }
                if (i == c) {
                    return 0;
                }
                return 64;
            }
        }
        return 0;
    }
}

