/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.stat;

import chemaxon.jchem.db.SettingsHandler;
import chemaxon.stat.ResultDBWriter;
import chemaxon.stat.ResultPrintStream;
import chemaxon.stat.ResultProcessor;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public abstract class Common {
    boolean onlyStat = false;
    boolean statsNeeded = false;
    int dimensions = 0;
    int fpSize = 0;
    float[] weights = null;
    boolean generateID = false;
    PrintStream statStream = System.out;
    static final String lineSep = System.getProperty("line.separator");
    static final String homeDir = System.getProperty("user.home");
    static final String configFile = new File(DotfileUtil.getDotDir(), ".jchem").getAbsolutePath();
    long startMemory = 0L;
    long startTime = 0L;
    ResultProcessor output = null;
    InputStream input = null;

    public void setOutput(Connection con, String insertSQL) throws SQLException {
        this.output = new ResultDBWriter(con, insertSQL);
    }

    public void setOutput(File file) throws FileNotFoundException {
        PrintStream fStream = null;
        try {
            fStream = new PrintStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.output = new ResultPrintStream(fStream);
        this.statStream = fStream;
    }

    public void setOutput(String fileName) throws FileNotFoundException {
        this.setOutput(new File(fileName));
    }

    public void setOutput(PrintStream ps) {
        this.output = new ResultPrintStream(ps);
    }

    public void setIdGeneration(boolean b) {
        this.generateID = b;
    }

    public boolean getIdGeneration() {
        return this.generateID;
    }

    public void setOnlyStat(boolean b) {
        this.onlyStat = b;
    }

    public boolean isOnlyStat() {
        return this.onlyStat;
    }

    public void setStatNeeded(boolean b) {
        this.statsNeeded = b;
    }

    public boolean isStatNeeded() {
        return this.statsNeeded;
    }

    public void setDimensions(int dim) {
        this.dimensions = dim;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setFpSize(int fpSize) {
        this.fpSize = fpSize;
    }

    public int getFpSize() {
        return this.fpSize;
    }

    public void setWeights(float[] weights) {
        this.weights = new float[weights.length + 1];
        for (int x = 0; x < weights.length; ++x) {
            this.weights[x + 1] = weights[x];
        }
        this.weights[0] = 1.0f;
    }

    public float[] getWeights() {
        if (this.weights == null) {
            return null;
        }
        if (this.weights.length < 2) {
            return null;
        }
        float[] result = new float[this.weights.length - 1];
        for (int x = 0; x < result.length; ++x) {
            result[x] = this.weights[x + 1];
        }
        return result;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void setStatStream(PrintStream pst) {
        this.statStream = pst;
    }

    public PrintStream getStatStream() {
        return this.statStream;
    }

    static void saveConfig(Properties props) throws IOException {
        SettingsHandler sh = new SettingsHandler();
        sh.save(props);
    }

    static ConnectionHandler openConn(CLQ clq) throws ArgumentException, SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ConnectionHandler conh = Common.getConnectionHandler(clq);
        conh.connect();
        return conh;
    }

    static ConnectionHandler getConnectionHandler(CLQ clq) throws ArgumentException {
        CLQ.Parameter driver = clq.lookup("-d", "--driver", "connection.jdbcDriver", 2, true, true);
        CLQ.Parameter url = clq.lookup("-u", "--dburl", "connection.jdbcUrl", 2, true, true);
        CLQ.Parameter login = clq.lookup("-l", "--login", "connection.login", 2, true, true);
        CLQ.Parameter pwd = clq.lookup("-p", "--password", "connection.password", 2, true, true);
        CLQ.Parameter prop = clq.lookup("-P", "--proptable", "connection.propertyTable", 2, true, true);
        ConnectionHandler conh = new ConnectionHandler();
        conh.setUrl(url.getString());
        conh.setDriver(driver.getString());
        conh.setLoginName(login.getString());
        conh.setPassword(pwd.getString());
        String propTable = prop.getString();
        if (propTable == null) {
            propTable = "JChemProperties";
        }
        conh.setPropertyTable(propTable);
        return conh;
    }

    void checkWeights() throws IllegalArgumentException {
        int wnum = 1 + this.dimensions;
        if (this.weights == null) {
            this.weights = new float[wnum];
            for (int i = 0; i < wnum; ++i) {
                this.weights[i] = 1.0f;
            }
        }
        if (this.weights.length != wnum) {
            throw new IllegalArgumentException("Incorrect number of weights.\nExpected: " + (wnum - 1) + "  Specified:" + (this.weights.length - 1));
        }
    }
}

