/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.stat;

import chemaxon.descriptors.MDReader;
import chemaxon.descriptors.MDReaderException;
import chemaxon.descriptors.MDSet;
import chemaxon.descriptors.MDSetParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.stat.Common;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Compare
extends Common {
    private boolean onlyDiss = false;
    private boolean listSimilar = false;
    private boolean diffId = false;
    private PrintStream statStream = null;
    private float threshold;
    private boolean orderSimilarObjects = false;
    private int maxSimilar = 0;
    private boolean generateID = false;
    float[] weights = null;
    int[] metricIndexes = null;
    static final String lineSep = System.getProperty("line.separator");
    static final String homeDir = System.getProperty("user.home");
    private ArrayList set1 = null;
    private ArrayList set2 = null;
    private MDReader input1 = null;
    private MDReader input2 = null;
    private int currentElement = 0;
    private ArrayList neighbors = null;
    private StatResult res = null;
    private StatResult allRes = null;
    private boolean writeResultToOutput = true;
    private boolean writeStatsToOutput = true;
    private boolean initialized = false;
    private String[] mdTypes = null;
    private String[] descSettings1 = null;
    private String[] descSettings2 = null;
    int[] startingColumns1 = null;
    int[] startingColumns2 = null;
    int[] nColumns1 = null;
    int[] nColumns2 = null;
    private static final String helptext = "Compare " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Diversity/dissimarity comparison of two libraries." + lineSep + "Usage:" + lineSep + "  compr [options]" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  -h  --help                    this help message" + lineSep + "  -d  --driver <JDBC driver>    JDBC driver" + lineSep + "  -u  --dburl <url>             URL of database" + lineSep + "  -l  --login <login>           login name" + lineSep + "  -p  --password <password>     password" + lineSep + "  -s  --saveconf                save settings into" + lineSep + "\"" + configFile + "\"" + lineSep + "" + lineSep + "Input options (default: standard input):" + lineSep + "  -i  --input <path1> <path2>   input files to compare (text file input)" + lineSep + "  -q  --query <sql1> <sql2>     SQL query strings for reading input " + lineSep + "                                (database input)" + lineSep + "Combined input (table vs. file comparison):" + lineSep + "  -i <path> -q <sql>" + lineSep + "" + lineSep + "" + "Output options (default: standard output):" + lineSep + "  -o  --output <filepath>       output file path (text file output)" + lineSep + "  -a  --statement <sql>         SQL statement for inserting results" + lineSep + "                                (database output)" + lineSep + "  -z  --stat                    print statistics on overall dissimilarity" + lineSep + "  -Z  --only-stat               statistics only on overall dissimilarity" + lineSep + "  -y  --only-dissimilar         print only dissimilar objects" + lineSep + "  -L  --list-similar            list similar objects from the first set" + lineSep + "" + lineSep + "" + "Data properties" + lineSep + "" + "  -m  --dimensions <dim>        number of floating-point descriptors" + lineSep + "  -f  --fingerprint-size <bits> fingerprint size in bits." + lineSep + "                                fpsize should be a multiple of 32" + lineSep + "  -w  --weights <w1>:<w2> ...   the weights of the floating-point descriptors" + lineSep + "  -g  --generate-id             generate id for each compound." + lineSep + "" + lineSep + "Conditions of calculation" + lineSep + "  -t  --threshold <threshold>   maximum dissimilarity of two compounds " + lineSep + "                                compounds (default: 1)" + lineSep + "  -D  --different-ids           don't compare compounds with the same id" + lineSep + "  -c  --max-count <count>       maximum number of similar objects listed" + lineSep + "  -r  --order                   sort similar objects by distance (closest first)" + lineSep;
    private float maxDist;
    private int maxIdx;

    public void setInput1(ConnectionHandler conh, String querySQL) {
    }

    public void setInput2(ConnectionHandler conh, String querySQL) {
    }

    public void setInput1(File file) throws MDReaderException {
    }

    public void setInput2(File file) throws MDReaderException {
    }

    public void setInput1(String path) throws MDReaderException {
        this.setInput1(new File(path));
    }

    public void setInput2(String path) throws MDReaderException {
        this.setInput2(new File(path));
    }

    public void setMDTypes(String[] mdTypes) {
        this.mdTypes = mdTypes;
    }

    public void getMDTypes(String[] cdTypes) {
        this.mdTypes = this.mdTypes;
    }

    public void setDescSettings1(String[] descSettings) {
        this.descSettings1 = descSettings;
    }

    public void setDescSettings2(String[] descSettings) {
        this.descSettings2 = descSettings;
    }

    public void setColumns1(int[] startingColumns, int[] nColumns) {
        this.startingColumns1 = startingColumns;
        this.nColumns1 = nColumns;
    }

    public void setColumns2(int[] startingColumns, int[] nColumns) {
        this.startingColumns2 = startingColumns;
        this.nColumns2 = nColumns;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setOnlyDissimilarListed(boolean b) {
        this.onlyDiss = b;
    }

    public boolean isOnlyDissimilarListed() {
        return this.onlyDiss;
    }

    public void setDifferentIdsOnly(boolean b) {
        this.diffId = b;
    }

    public boolean isDifferentIdsOnly() {
        return this.diffId;
    }

    @Override
    public void setWeights(float[] weights) {
        this.weights = weights;
    }

    @Override
    public float[] getWeights() {
        return this.weights;
    }

    public void setMetricIndexes(int[] metricIndexes) {
        this.metricIndexes = metricIndexes;
    }

    public int[] getMetricIndexes() {
        return this.metricIndexes;
    }

    @Override
    public void setIdGeneration(boolean b) {
        this.generateID = b;
    }

    @Override
    public boolean getIdGeneration() {
        return this.generateID;
    }

    public void setMaxSimilar(int maxSimilar) {
        this.maxSimilar = maxSimilar;
    }

    public int getMaxSimilar() {
        return this.maxSimilar;
    }

    public void setOrderSimilarObjects(boolean orderSimilarObjects) {
        this.orderSimilarObjects = orderSimilarObjects;
    }

    public boolean isOrderSimilarObjects() {
        return this.orderSimilarObjects;
    }

    public void init() {
        this.set1 = new ArrayList();
        this.set2 = new ArrayList();
        this.res = new StatResult();
        this.allRes = new StatResult();
        try {
            MDSet mdSet1 = new MDSet();
            MDSet mdSet2 = new MDSet();
            MolecularDescriptor[] descriptors1 = new MolecularDescriptor[this.mdTypes.length];
            MolecularDescriptor[] descriptors2 = new MolecularDescriptor[this.mdTypes.length];
            for (int x = 0; x < this.mdTypes.length; ++x) {
                descriptors1[x] = MolecularDescriptor.newInstance(this.mdTypes[x]);
                descriptors2[x] = descriptors1[x].clone();
                if (this.descSettings1 != null) {
                    descriptors1[x].setParameters(this.descSettings1[x]);
                }
                if (this.descSettings2 == null) continue;
                descriptors2[x].setParameters(this.descSettings2[x]);
            }
            mdSet1.setDescriptors(descriptors1);
            mdSet2.setDescriptors(descriptors2);
            if (this.weights == null) {
                this.weights = new float[this.mdTypes.length];
                for (int i = 0; i < this.weights.length; ++i) {
                    this.weights[i] = 1.0f;
                }
            }
            if (this.metricIndexes == null) {
                this.metricIndexes = new int[this.mdTypes.length];
            }
            MDSetParameters setParams = new MDSetParameters(this.weights, this.metricIndexes);
            mdSet1.setParameters(setParams);
            mdSet2.setParameters(setParams);
            this.input1.setGenerateId(this.generateID);
            this.input2.setGenerateId(this.generateID);
            this.input1.reset();
            while ((mdSet1 = this.input1.next()) != null) {
                this.set1.add(new MDSet(mdSet1));
            }
            this.input2.reset();
            while ((mdSet2 = this.input2.next()) != null) {
                this.set2.add(new MDSet(mdSet2));
            }
            this.currentElement = 0;
            if (this.writeResultToOutput && this.output != null) {
                if (this.writeStatsToOutput) {
                    this.output.writeHeader("id\tminD\tnneib\tsimcnt\tavgD\tmaxD" + (this.listSimilar ? "\tlist_of_similar_objects ..." : ""));
                } else if (this.onlyDiss) {
                    this.output.writeHeader("id");
                } else {
                    this.output.writeHeader("id\tminD\tnneib\tsimcnt" + (this.listSimilar ? "\tlist_of_similar_objects ..." : ""));
                }
            }
            this.initialized = true;
        }
        catch (MDReaderException e) {
            e.printStackTrace();
        }
    }

    public boolean next() {
        if (!this.initialized) {
            this.init();
        }
        if (this.currentElement >= this.set1.size()) {
            return false;
        }
        MDSet currE = (MDSet)this.set1.get(this.currentElement);
        if (this.neighbors == null) {
            this.neighbors = new ArrayList();
        } else {
            this.neighbors.clear();
        }
        this.res.init();
        this.maxDist = Float.MAX_VALUE;
        int id = currE.getId();
        int set2Size = this.set2.size();
        for (int i = 0; i < set2Size; ++i) {
            MDSet otherE = (MDSet)this.set2.get(i);
            if (this.diffId && id == otherE.getId() || !this.statsNeeded && !(currE.getLowerBound(otherE) <= this.threshold)) continue;
            this.setRes(this.res, this.neighbors, currE, otherE);
        }
        if (this.orderSimilarObjects) {
            distanceComparator c = new distanceComparator();
            Collections.sort(this.neighbors, c);
        }
        if (this.maxSimilar > 0 && this.maxSimilar < this.neighbors.size()) {
            int upper;
            for (int x = upper = this.neighbors.size() - 1; x >= this.maxSimilar; --x) {
                this.neighbors.remove(x);
            }
        }
        if (this.res.minDist < this.allRes.minDist) {
            this.allRes.minDist = this.res.minDist;
        }
        if (this.statsNeeded) {
            this.allRes.avgDist += this.res.avgDist;
            if (this.res.maxDist > this.allRes.maxDist) {
                this.allRes.maxDist = this.res.maxDist;
            }
        }
        this.res.avgDist /= (float)this.set2.size();
        ++this.currentElement;
        return true;
    }

    public ArrayList getNeighbors() {
        return this.neighbors;
    }

    public int getNumberOfNeighbors() {
        return this.neighbors.size();
    }

    public float getMinDistance() {
        return this.res.minDist;
    }

    public MDSet getNearestNeighbor() {
        return this.res.nearestNeighbor;
    }

    public MDSet getLastProcessed() {
        return (MDSet)this.set1.get(this.currentElement - 1);
    }

    public int getSizeOfSet1() {
        return this.set1.size();
    }

    public int getSizeOfSet2() {
        return this.set2.size();
    }

    public float getOverallMinDistance() {
        return this.allRes.minDist;
    }

    public float getOverallMaxDistance() {
        return this.allRes.maxDist;
    }

    public double getOverallAvgDistance() {
        return this.allRes.avgDist;
    }

    private void setRes(StatResult res, ArrayList neighbours, MDSet currE, MDSet otherE) {
        float dist = currE.getDissimilarity(otherE);
        if (this.statsNeeded || dist <= this.threshold) {
            if (dist < res.minDist) {
                res.minDist = dist;
                res.mostSimilar = otherE.getId();
                res.nearestNeighbor = otherE;
            }
            if (dist <= this.threshold) {
                ++res.similarCount;
                otherE.dissim = dist;
                if (this.maxSimilar > 0 && this.orderSimilarObjects) {
                    if (dist < this.maxDist) {
                        neighbours.add(otherE);
                        if (neighbours.size() >= this.maxSimilar + 1) {
                            neighbours.remove(this.maxIdx);
                            this.maxDist = Float.MIN_VALUE;
                            for (int x = 0; x < neighbours.size(); ++x) {
                                float d = ((MDSet)neighbours.get((int)x)).dissim;
                                if (!(d > this.maxDist)) continue;
                                this.maxDist = d;
                                this.maxIdx = x;
                            }
                        }
                    }
                } else {
                    neighbours.add(otherE);
                }
            }
            if (this.statsNeeded) {
                res.avgDist += dist;
                if (dist > res.maxDist) {
                    res.maxDist = dist;
                }
            }
        }
    }

    public static void main(String[] args) {
        ConnectionHandler conh = null;
        Properties p = new Properties();
        Compare cp = new Compare();
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (IOException exc) {
            // empty catch block
        }
        CLQ clq = new CLQ(args, p);
        try {
            String s;
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            CLQ.Parameter inputfiles = clq.lookup("-i", "--input", "", 2, false, false);
            CLQ.Parameter inputqueries = clq.lookup("-q", "--query", "", 2, false, false);
            if (inputfiles != null && inputqueries != null) {
                conh = Compare.openConn(clq);
                cp.setInput1(conh, inputqueries.getString(0));
                cp.setInput2(inputfiles.getString(0));
            } else {
                inputfiles = clq.lookup("-i", "--input", "", 3, false, false);
                inputqueries = clq.lookup("-q", "--query", "", 3, false, false);
                if (inputfiles == null && inputqueries == null) {
                    throw new ArgumentException("Input not defined");
                }
                if (inputfiles != null && inputqueries != null) {
                    throw new ArgumentException("Ambiguous input");
                }
                if (inputfiles != null) {
                    cp.setInput1(inputfiles.getString(0));
                    cp.setInput2(inputfiles.getString(1));
                } else if (inputqueries != null) {
                    conh = Compare.openConn(clq);
                    cp.setInput1(conh, inputqueries.getString(0));
                    cp.setInput2(conh, inputqueries.getString(1));
                }
            }
            CLQ.Parameter genid = clq.lookup("-g", "--generate-id", "", 1, false, false);
            CLQ.Parameter pweights = clq.lookup("-w", "--weights", "", 2, false, false);
            float[] weights = null;
            if (pweights != null) {
                weights = Compare.parseWeights(pweights.getString());
            }
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = pweights != null ? (float)pweights.getDouble(i) : 1.0f;
            }
            CLQ.Parameter stat = clq.lookup("-z", "--statistics", "", 1, false, false);
            CLQ.Parameter onlyStat = clq.lookup("-Z", "--only-statistics", "", 1, false, false);
            CLQ.Parameter onlyDiss = clq.lookup("-y", "--only-dissimilar", "", 1, false, false);
            if (onlyDiss != null && (stat != null || onlyStat != null)) {
                throw new ArgumentException("Ambiguous parameters");
            }
            CLQ.Parameter listSimilar = clq.lookup("-L", "--list-similar", "", 1, false, false);
            CLQ.Parameter diffId = clq.lookup("-D", "--different-ids", "", 1, false, false);
            CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
            CLQ.Parameter outputquery = clq.lookup("-a", "--statement", "", 2, false, false);
            if (outputfile == null && outputquery == null) {
                cp.setOutput(System.out);
            } else {
                if (outputfile != null && outputquery != null) {
                    throw new ArgumentException("Ambiguous output");
                }
                if (outputfile != null) {
                    cp.setOutput(outputfile.getString());
                } else if (outputquery != null) {
                    if (conh == null) {
                        conh = Compare.openConn(clq);
                    }
                    cp.setOutput(conh.getConnection(), outputquery.getString());
                }
            }
            CLQ.Parameter threshold = clq.lookup("-t", "--threshold", "compare.threshold", 2, false, false);
            CLQ.Parameter maxsim = clq.lookup("-c", "--max-count", "", 2, false, false);
            CLQ.Parameter ordersim = clq.lookup("-r", "--order", "", 1, false, false);
            CLQ.Parameter store = clq.lookup("-s", "--saveconf", "", 1, false, false);
            if (store != null) {
                settingsHandler.save(p);
            }
            if ((s = clq.notUsed()) != null) {
                throw new ArgumentException("Unknown or unnecessary parameter: " + s);
            }
            cp.setWeights(weights);
            cp.setIdGeneration(genid != null);
            cp.setThreshold(threshold == null ? 1.0f : (float)threshold.getDouble());
            cp.setStatNeeded(stat != null);
            cp.setOnlyStat(onlyStat != null);
            cp.setOnlyDissimilarListed(onlyDiss != null);
            cp.setMaxSimilar(maxsim == null ? 0 : maxsim.getInt());
            cp.setOrderSimilarObjects(ordersim != null);
            cp.setDifferentIdsOnly(diffId != null);
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static float[] parseWeights(String delimited) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(delimited, ":");
        int n = st.countTokens();
        if (n == 0) {
            return null;
        }
        float[] result = new float[n];
        for (int x = 0; x < n; ++x) {
            result[x] = new Float(st.nextToken()).floatValue();
        }
        return result;
    }

    private class StatResult {
        float avgDist;
        float minDist;
        float maxDist;
        int mostSimilar;
        int similarCount;
        MDSet nearestNeighbor = null;

        public StatResult() {
            this.init();
        }

        public void init() {
            this.avgDist = 0.0f;
            this.minDist = Float.MAX_VALUE;
            this.maxDist = Float.MIN_VALUE;
            this.mostSimilar = -1;
            this.similarCount = 0;
        }

        public boolean isInInitState() {
            return this.minDist == Float.MAX_VALUE;
        }
    }

    private class distanceComparator
    implements Comparator {
        private distanceComparator() {
        }

        public int compare(Object c1, Object c2) {
            float dist1 = ((MDSet)c1).dissim;
            float dist2 = ((MDSet)c2).dissim;
            return dist1 == dist2 ? 0 : (dist1 < dist2 ? -1 : 1);
        }
    }
}

