/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.StereoActivePart;

public class AtropStereoDescriptor
implements CIPStereoDescriptorIface {
    private final StereoActivePart[] activeParts = new StereoActivePart[2];
    private final CIPStereoDescriptorIface.CIPValue.AtropStereoValue stereoValue;

    public AtropStereoDescriptor(CIPStereoDescriptorIface.CIPValue.AtropStereoValue value, StereoActivePart activePart1, StereoActivePart activePart2) {
        this.activeParts[0] = activePart1;
        this.activeParts[1] = activePart2;
        this.stereoValue = value;
    }

    @Override
    public StereoActivePart[] getStereoActiveParts() {
        return this.activeParts;
    }

    @Override
    public CIPStereoDescriptorIface.CIPValue.AtropStereoValue getStereoValue() {
        return this.stereoValue;
    }

    public boolean equals(Object arg0) {
        if (arg0 != null && arg0 instanceof AtropStereoDescriptor) {
            AtropStereoDescriptor other = (AtropStereoDescriptor)arg0;
            return this.getStereoValue() == other.getStereoValue() && (this.getStereoActiveParts()[0].equals(other.getStereoActiveParts()[0]) && this.getStereoActiveParts()[1].equals(other.getStereoActiveParts()[1]) || this.getStereoActiveParts()[1].equals(other.getStereoActiveParts()[0]) && this.getStereoActiveParts()[0].equals(other.getStereoActiveParts()[1]));
        }
        return false;
    }

    @Override
    public boolean equalsTo(Object arg0, int[] map) {
        if (arg0 != null && arg0 instanceof AtropStereoDescriptor) {
            AtropStereoDescriptor other = (AtropStereoDescriptor)arg0;
            if (this.getStereoActiveParts()[0].equalsTo(other.getStereoActiveParts()[0], map) && this.getStereoActiveParts()[1].equalsTo(other.getStereoActiveParts()[1], map) || this.getStereoActiveParts()[1].equalsTo(other.getStereoActiveParts()[0], map) && this.getStereoActiveParts()[0].equalsTo(other.getStereoActiveParts()[1], map)) {
                if (this.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN && other.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.UNKNOWN || this.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.WIGGLY && other.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.WIGGLY) {
                    return true;
                }
                int[] firstPartLigands = this.getStereoActiveParts()[0].getLigands();
                int firstHigh = firstPartLigands[0] > firstPartLigands[1] ? firstPartLigands[0] : firstPartLigands[1];
                int firstLow = firstPartLigands[0] > firstPartLigands[1] ? firstPartLigands[1] : firstPartLigands[0];
                int[] secondPartLigands = this.getStereoActiveParts()[1].getLigands();
                int secondHigh = secondPartLigands[0] > secondPartLigands[1] ? secondPartLigands[0] : secondPartLigands[1];
                int secondLow = secondPartLigands[0] > secondPartLigands[1] ? secondPartLigands[1] : secondPartLigands[0];
                int inversion = 0;
                if (map[firstHigh] < map[firstLow]) {
                    ++inversion;
                    int otherFirstHigh = map[firstLow];
                } else {
                    int otherFirstHigh = map[firstHigh];
                }
                if (map[secondHigh] < map[secondLow]) {
                    ++inversion;
                    int otherSecondHigh = map[secondLow];
                } else {
                    int otherSecondHigh = map[secondHigh];
                }
                if (inversion % 2 == 0 ? this.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.EVEN && other.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.EVEN || this.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.ODD && other.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.ODD : this.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.EVEN && other.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.ODD || this.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.ODD && other.getStereoValue() == CIPStereoDescriptorIface.CIPValue.AtropStereoValue.EVEN) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 107;
        switch (this.stereoValue) {
            case ODD: {
                break;
            }
            case EVEN: {
                result *= 2;
                break;
            }
            case UNKNOWN: {
                result *= 3;
                break;
            }
            case WIGGLY: {
                result *= 4;
                break;
            }
        }
        for (StereoActivePart sap : this.activeParts) {
            result += sap.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AT: ");
        sb.append(this.activeParts[0]);
        sb.append(",");
        sb.append(this.activeParts[1]);
        sb.append(" ");
        sb.append(this.stereoValue);
        return sb.toString();
    }
}

