/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.StereoActivePart;

public class CisTransStereoDescriptor
implements CIPStereoDescriptorIface {
    private final StereoActivePart[] activeParts = new StereoActivePart[2];
    private final CIPStereoDescriptorIface.CIPValue.CisTransStereoValue stereoValue;

    public CisTransStereoDescriptor(CIPStereoDescriptorIface.CIPValue.CisTransStereoValue value, StereoActivePart activePart1, StereoActivePart activePart2) {
        this.activeParts[0] = activePart1;
        this.activeParts[1] = activePart2;
        this.stereoValue = value;
    }

    @Override
    public StereoActivePart[] getStereoActiveParts() {
        return this.activeParts;
    }

    @Override
    public CIPStereoDescriptorIface.CIPValue.CisTransStereoValue getStereoValue() {
        return this.stereoValue;
    }

    public int hashCode() {
        int result = 103;
        switch (this.stereoValue) {
            case CIS: {
                break;
            }
            case TRANS: {
                result *= 2;
                break;
            }
            case UNKNOWN: {
                result *= 3;
                break;
            }
            case WIGGLY: {
                result *= 4;
                break;
            }
        }
        for (StereoActivePart sap : this.activeParts) {
            result += sap.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CisTransStereoDescriptor)) {
            return false;
        }
        CisTransStereoDescriptor other = (CisTransStereoDescriptor)o;
        int minIndex = this.activeParts[0].getStereoActiveAtom() < this.activeParts[1].getStereoActiveAtom() ? 0 : 1;
        int maxIndex = 1 - minIndex;
        int otherMinIndex = other.activeParts[0].getStereoActiveAtom() < other.activeParts[1].getStereoActiveAtom() ? 0 : 1;
        int otherMaxIndex = 1 - otherMinIndex;
        return this.stereoValue == other.stereoValue && this.activeParts[minIndex].equals(other.activeParts[otherMinIndex]) && this.activeParts[maxIndex].equals(other.activeParts[otherMaxIndex]);
    }

    @Override
    public boolean equalsTo(Object o, int[] map) {
        if (o != null && o instanceof CisTransStereoDescriptor) {
            CisTransStereoDescriptor other = (CisTransStereoDescriptor)o;
            if (this.getStereoActiveParts()[0].equalsTo(other.getStereoActiveParts()[0], map) && this.getStereoActiveParts()[1].equalsTo(other.getStereoActiveParts()[1], map) || this.getStereoActiveParts()[1].equalsTo(other.getStereoActiveParts()[0], map) && this.getStereoActiveParts()[0].equalsTo(other.getStereoActiveParts()[1], map)) {
                if (this.stereoValue == CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.UNKNOWN || other.stereoValue == CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.UNKNOWN || this.stereoValue == CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.WIGGLY || other.stereoValue == CIPStereoDescriptorIface.CIPValue.CisTransStereoValue.WIGGLY) {
                    return this.stereoValue == other.stereoValue;
                }
                int inversion = 0;
                if (this.getStereoActiveParts()[0].getLigands().length == 2 && (this.getStereoActiveParts()[0].getLigands()[0] > this.getStereoActiveParts()[0].getLigands()[1] && map[this.getStereoActiveParts()[0].getLigands()[0]] < map[this.getStereoActiveParts()[0].getLigands()[1]] || this.getStereoActiveParts()[0].getLigands()[0] < this.getStereoActiveParts()[0].getLigands()[1] && map[this.getStereoActiveParts()[0].getLigands()[0]] > map[this.getStereoActiveParts()[0].getLigands()[1]])) {
                    ++inversion;
                }
                if (this.getStereoActiveParts()[1].getLigands().length == 2 && (this.getStereoActiveParts()[1].getLigands()[0] > this.getStereoActiveParts()[1].getLigands()[1] && map[this.getStereoActiveParts()[1].getLigands()[0]] < map[this.getStereoActiveParts()[1].getLigands()[1]] || this.getStereoActiveParts()[1].getLigands()[0] < this.getStereoActiveParts()[1].getLigands()[1] && map[this.getStereoActiveParts()[1].getLigands()[0]] > map[this.getStereoActiveParts()[1].getLigands()[1]])) {
                    ++inversion;
                }
                if (inversion == 1) {
                    return this.getStereoValue() != other.getStereoValue();
                }
                return this.getStereoValue() == other.getStereoValue();
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CT: ");
        sb.append(this.activeParts[0]);
        sb.append(",");
        sb.append(this.activeParts[1]);
        sb.append(" ");
        sb.append(this.stereoValue);
        return sb.toString();
    }
}

