/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Sgroup;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExtraAtomProperties
implements Serializable {
    private static final long serialVersionUID = -1980229820290558380L;
    public static final int Q_NONE = -1;
    public static final int Q_MAX = 254;
    public static final int Q_DEC = 255;
    public static final int Q_TRUE = 256;
    public static final int Q_INC = 257;
    public static final int ATNO_MIN = 200;
    public static final int SMARTS_H = 200;
    public static final int SMARTS_VAL = 201;
    public static final int SMARTS_CONN = 202;
    public static final int SMARTS_RINGS = 203;
    public static final int SMARTS_SRS = 204;
    public static final int SMARTS_ALIPHATIC = 205;
    public static final int SMARTS_AROMATIC = 206;
    public static final int SMARTS_STRING = 207;
    public static final int ATNO_ALIAS = 208;
    public static final int ATNO_VALUE = 209;
    public static final int ATNO_AAMAP = 209;
    public static final int ATNO_AIMAP = 210;
    public static final int MDL_SUBST = 211;
    public static final int MDL_RBCNT = 212;
    public static final int MDL_UNSAT = 213;
    public static final int SMARTS_IMP_HYDR = 214;
    public static final int SMARTS_EXP_CONN = 215;
    public static final int ATNO_MAX = 215;
    static final int RGROUP_MASK = Short.MAX_VALUE;
    static final int ATTACH_OFF = 0;
    static final int ATTACH_MASK = 3;
    static final int RXNSTEREO_OFF = 2;
    static final int RXNSTEREO_MASK = 12;
    static final int STGRP_TYPE_OFF = 10;
    static final int STGRP_TYPE_MASK = 3072;
    static final int ISOTOPE_SPEC_SYM_FLAG = 4096;
    static final int CHARGE_OFF = 0;
    static final int CHARGE_MASK = 255;
    private static final int CHARGE0 = 128;
    static final int HCOUNT_OFF = 8;
    static final int HCOUNT_MASK = 65280;
    static final int STGRP_NUMBER_OFF = 16;
    static final int STGRP_NUMBER_MASK = -65536;
    static final int LINKNODE_MINREP_MASK = 65535;
    static final int LINKNODE_MAXREP_OFF = 16;
    static final int LINKNODE_MAXREP_MASK = -65536;
    static final int LINKNODE_OUTERBOND_1_MASK = 65535;
    static final int LINKNODE_OUTERBOND_2_OFF = 16;
    static final int LINKNODE_OUTERBOND_2_MASK = -65536;
    static final int EXTRARGB_MASK = -1;
    static final int EXTRARGB_OFF = 32;
    public static final int LP_NOT_SET = -1;
    public static final int RD_NOT_SET = -2;
    public static final int UNDEFINED = -3;
    public static final int RD_INCREASE = -4;
    public static final int MAX_LP_COUNT = 4;
    Sgroup attachParentSgroup = null;
    short valence1 = 0;
    int order = 0;
    Map<String, Object> qprops = null;
    String querystr = null;
    String aliasstr = null;
    String extrastr = null;
    long extrargbs = 0L;
    private int[] list = null;
    private int flags = 0;
    private short rgroupId = 0;
    private int countFlags = 128;
    private int repetitionBits = 0;
    private int linkNodeOuterBonds = 0;
    private int electronProp = 0;
    private Map<String, Object> temporaryObjects = null;
    private BicycloStereoDescriptor[] bicycloStereoDescriptors;

    Object getQProp(String name) {
        Map<String, Object> q = this.qprops;
        return q != null ? q.get(name) : null;
    }

    int getQPropAsInt(String name) {
        Map<String, Object> q = this.qprops;
        Integer i = q != null ? (Integer)q.get(name) : null;
        return i != null ? i : -1;
    }

    int[] getList() {
        if (this.list == null || this.list.length == 0) {
            return null;
        }
        int[] l = new int[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            l[i] = this.list[i];
        }
        return l;
    }

    void setList(int[] l, int n) {
        if (l != null && n > 0) {
            this.list = new int[n];
            for (int i = 0; i < n; ++i) {
                this.list[i] = l[i];
            }
        } else {
            this.list = null;
        }
    }

    void setList(int[] l) {
        if (l != null) {
            this.setList(l, l.length);
        } else {
            this.list = null;
        }
    }

    void setQProp(String name, Object value) {
        Map<String, Object> q = this.qprops;
        if (value == null) {
            if (q != null) {
                q.remove(name);
                if (q.isEmpty()) {
                    this.qprops = null;
                }
            }
        } else {
            if (q == null) {
                q = this.qprops = new LinkedHashMap<String, Object>();
            }
            q.put(name, value);
        }
    }

    boolean isQuery() {
        return this.hasKnownQueryProps() || this.querystr != null;
    }

    boolean hasKnownQueryProps() {
        if (this.qprops == null) {
            return false;
        }
        for (String s : this.qprops.keySet()) {
            char c;
            if (!(s.length() == 1 ? "HXRrasuhDc".indexOf(c = s.charAt(0)) >= 0 : "rb".equals(s))) continue;
            return true;
        }
        return false;
    }

    int getRgroup() {
        return this.rgroupId & Short.MAX_VALUE;
    }

    void setRgroup(int r) {
        this.rgroupId = (short)r;
    }

    int getAttach() {
        return (this.flags & 3) >> 0;
    }

    void setAttach(int a) {
        this.flags = this.flags & 0xFFFFFFFC | a << 0 & 3;
    }

    int getReactionStereo() {
        return (this.flags & 0xC) >> 2;
    }

    void setReactionStereo(int r) {
        this.flags = this.flags & 0xFFFFFFF3 | r << 2 & 0xC;
    }

    public int getStereoGroupType() {
        return (this.flags & 0xC00) >> 10;
    }

    public void setStereoGroupType(int t) {
        int f0 = this.flags & 0xFFFFF3FF;
        this.flags = f0 | t << 10 & 0xC00;
    }

    public int getStereoGroupNumber() {
        return ((this.countFlags & 0xFFFF0000) >> 16) + 1;
    }

    public void setStereoGroupNumber(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid stereochemical group number " + n);
        }
        int f0 = this.countFlags & 0xFFFF;
        this.countFlags = f0 | n - 1 << 16 & 0xFFFF0000;
    }

    boolean isSpecIsotopeSymbolPreferred() {
        return (this.flags & 0x1000) != 0;
    }

    void setSpecIsotopeSymbolPreferred(boolean v) {
        this.flags = v ? (this.flags |= 0x1000) : (this.flags &= 0xFFFFEFFF);
    }

    int getCharge() {
        return ((this.countFlags & 0xFF) >> 0) - 128;
    }

    void setCharge(int c) {
        this.countFlags = this.countFlags & 0xFFFFFF00 | c + 128 << 0 & 0xFF;
    }

    int getImplicitHcount() {
        return (this.countFlags & 0xFF00) >> 8;
    }

    void setImplicitHcount(int h) {
        this.setNonQueryImplicitHcount(h);
        if (this.qprops != null) {
            this.qprops.remove("H");
        }
    }

    void setNonQueryImplicitHcount(int h) {
        this.countFlags = this.countFlags & 0xFFFF00FF | h << 8 & 0xFF00;
    }

    int getMinRepetitions() {
        return (this.repetitionBits & 0xFFFF) + 1;
    }

    void setMinRepetitions(int r) throws IllegalArgumentException {
        if (r < 1 || r > 65536) {
            throw new IllegalArgumentException("illegal link node minimum repetition value " + r);
        }
        this.repetitionBits = this.repetitionBits & 0xFFFF0000 | r - 1;
        if (this.getMaxRepetitions() < r) {
            this.setMaxRepetitions(r);
        }
    }

    int getMaxRepetitions() {
        return ((this.repetitionBits & 0xFFFF0000) >>> 16) + 1;
    }

    void setMaxRepetitions(int r) throws IllegalArgumentException {
        if (r < 1 || r > 65536) {
            throw new IllegalArgumentException("illegal link node maximum repetition value " + r);
        }
        this.repetitionBits = this.repetitionBits & 0xFFFF | r - 1 << 16;
        if (this.getMinRepetitions() > r) {
            this.setMinRepetitions(r);
        }
    }

    int getLinkNodeOuterBondIdx(int which) {
        int idx;
        if (which == 0) {
            idx = this.linkNodeOuterBonds & 0xFFFF;
        } else if (which == 1) {
            idx = (this.linkNodeOuterBonds & 0xFFFF0000) >>> 16;
        } else {
            throw new IllegalArgumentException("illegal link node outer bond index " + which);
        }
        return idx - 1;
    }

    void setLinkNodeOuterBondIdx(int idx, int bondIdx) {
        int secondBond;
        int firstBond;
        if (bondIdx < -1 || bondIdx > 65534) {
            throw new IllegalArgumentException("illegal link node outer bond " + bondIdx);
        }
        if (idx == 0) {
            firstBond = bondIdx + 1;
            secondBond = this.linkNodeOuterBonds & 0xFFFF0000;
        } else if (idx == 1) {
            firstBond = this.linkNodeOuterBonds & 0xFFFF;
            secondBond = bondIdx + 1 << 16;
        } else {
            throw new IllegalArgumentException("illegal link node outer bond index " + idx);
        }
        this.linkNodeOuterBonds = firstBond | secondBond;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExtraAtomProperties)) {
            return false;
        }
        ExtraAtomProperties p = (ExtraAtomProperties)other;
        return ExtraAtomProperties.compareObjects(this.qprops, p.qprops) && ExtraAtomProperties.compareObjects(this.querystr, p.querystr) && ExtraAtomProperties.compareObjects(this.aliasstr, p.aliasstr) && ExtraAtomProperties.compareObjects(this.extrastr, p.extrastr) && ExtraAtomProperties.compareObjects(this.list, p.list) && this.extrargbs == p.extrargbs && this.flags == p.flags && this.rgroupId == p.rgroupId && this.countFlags == p.countFlags && this.repetitionBits == p.repetitionBits && this.linkNodeOuterBonds == p.linkNodeOuterBonds && this.electronProp == p.electronProp && this.order == p.order;
    }

    private static boolean compareObjects(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a instanceof Map) {
                if (!(b instanceof Map)) {
                    return false;
                }
                Map ha = (Map)a;
                Map hb = (Map)b;
                if (ha.size() != hb.size()) {
                    return false;
                }
                for (Object key : ha.keySet()) {
                    Object val2;
                    Object val = ha.get(key);
                    if (val.equals(val2 = hb.get(key))) continue;
                    return false;
                }
                return true;
            }
            if (a instanceof int[]) {
                if (!(b instanceof int[])) {
                    return false;
                }
                int[] x = (int[])a;
                int[] y = (int[])b;
                if (x.length != y.length) {
                    return false;
                }
                for (int i = 0; i < x.length; ++i) {
                    if (x[i] == y[i]) continue;
                    return false;
                }
                return true;
            }
            return a.equals(b);
        }
        return false;
    }

    public Object clone() {
        ExtraAtomProperties p = new ExtraAtomProperties();
        p.valence1 = this.valence1;
        p.qprops = this.qprops != null ? new LinkedHashMap<String, Object>(this.qprops) : null;
        p.list = this.getList();
        p.querystr = this.querystr;
        p.aliasstr = this.aliasstr;
        p.extrastr = this.extrastr;
        p.extrargbs = this.extrargbs;
        p.countFlags = this.countFlags;
        p.flags = this.flags;
        p.rgroupId = this.rgroupId;
        p.repetitionBits = this.repetitionBits;
        p.linkNodeOuterBonds = this.linkNodeOuterBonds;
        p.electronProp = this.electronProp;
        p.order = this.order;
        return p;
    }

    public void merge(ExtraAtomProperties other) {
        if (other == null) {
            return;
        }
        if (this.valence1 == 0) {
            this.valence1 = other.valence1;
        }
        if (this.list == null) {
            this.list = other.getList();
        }
        if (this.querystr == null) {
            this.querystr = other.querystr;
        }
        if (this.aliasstr == null) {
            this.aliasstr = other.aliasstr;
        }
        if (this.extrastr == null) {
            this.extrastr = other.extrastr;
        }
        if (this.extrargbs == 0L) {
            this.extrargbs = other.extrargbs;
        }
        if (this.getCharge() == 0) {
            this.setCharge(other.getCharge());
        }
        if (this.getImplicitHcount() == 0 && !this.qprops.containsKey("H")) {
            this.setImplicitHcount(other.getImplicitHcount());
        }
        if (this.getStereoGroupType() <= 1) {
            this.setStereoGroupNumber(other.getStereoGroupNumber());
        }
        if (this.getRgroup() == 0) {
            this.setRgroup(other.getRgroup());
        }
        if (this.getAttach() == 0) {
            this.setAttach(other.getAttach());
        }
        if (this.getReactionStereo() == 0) {
            this.setReactionStereo(other.getReactionStereo());
        }
        if (this.getStereoGroupType() == 0) {
            this.setStereoGroupType(other.getStereoGroupType());
        }
        if (this.repetitionBits == 0) {
            this.repetitionBits = other.repetitionBits;
            this.linkNodeOuterBonds = other.linkNodeOuterBonds;
        }
        if (this.electronProp == -3) {
            this.electronProp = other.electronProp;
        }
        if (this.order == 0) {
            this.order = other.order;
        }
        if (other.qprops != null) {
            if (this.qprops == null) {
                this.qprops = new LinkedHashMap<String, Object>(other.qprops);
            } else {
                for (String propName : other.qprops.keySet()) {
                    if (this.qprops.containsKey(propName)) continue;
                    this.setQProp(propName, other.getQProp(propName));
                }
            }
        }
        this.qprops = this.qprops != null ? new LinkedHashMap<String, Object>(this.qprops) : null;
    }

    public int getElectronProp() {
        return this.electronProp;
    }

    public void setElectronProp(int eProp) {
        this.electronProp = eProp;
    }

    public void storeTemporaryObject(String key, Object val) {
        Map<String, Object> map = this.temporaryObjects;
        if (val == null) {
            if (map != null) {
                map.remove(key);
                if (map.isEmpty()) {
                    this.temporaryObjects = null;
                }
            }
        } else {
            if (map == null) {
                this.temporaryObjects = map = new LinkedHashMap<String, Object>();
            }
            map.put(key, val);
        }
    }

    public Object getTemporaryObject(String key) {
        return this.temporaryObjects != null ? this.temporaryObjects.get(key) : null;
    }

    public BicycloStereoDescriptor[] getBicycloStereo() {
        return this.bicycloStereoDescriptors;
    }

    public void setBicycloStereo(BicycloStereoDescriptor[] descriptors) {
        this.bicycloStereoDescriptors = descriptors;
    }

    public static void mergeProperties(MolAtom atom1, MolAtom atom2) {
        ExtraAtomProperties oldExtraProperties = atom2.extraProperties;
        atom2.set(atom1);
        if (atom2.extraProperties != oldExtraProperties) {
            atom2.extraProperties.merge(oldExtraProperties);
        }
    }
}

