/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.ColorParser;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public abstract class MObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2435517510938087080L;
    public static final int PAINT_ANTIALIAS = 1;
    public static final int PAINT_FOCUSED = 2;
    public static final int TRANSFORM_DISTORT = 1;
    private transient Color color;
    private transient Color lineColor;
    private transient Color background;
    private transient boolean selected;

    protected MObject(Color c, Color lc, Color bg) {
        this.color = c;
        this.lineColor = lc;
        this.background = bg;
        this.selected = false;
    }

    protected MObject(MObject o) {
        this.color = o.color;
        this.lineColor = o.lineColor;
        this.background = o.background;
        this.selected = o.selected;
    }

    public abstract Object clone();

    public boolean isEmpty() {
        return false;
    }

    public boolean isChildOf(MObject o) {
        return false;
    }

    public boolean checkValidity(MDocument doc, Collection<MolAtom> invec) {
        return true;
    }

    public void removeChild(MObject o) {
    }

    public boolean containsAtom(MolAtom a) {
        return false;
    }

    public void replaceAtom(MolAtom orig, MolAtom a) {
    }

    public boolean isTransformable() {
        return true;
    }

    public boolean isInternalSelectable() {
        return false;
    }

    public boolean isSelectableNow() {
        return true;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public abstract int getPointCount();

    public abstract MPoint getPoint(int var1);

    public int getPointRefCount() {
        return 0;
    }

    public void updateBoundingRect(double[] xyminm, CTransform3D pretrf) {
        int n = this.getPointRefCount();
        for (int i = 0; i < n; ++i) {
            DPoint3 p = this.getPointRef(i, pretrf).getLocation();
            pretrf.transform(p);
            if (p.x < xyminm[0]) {
                xyminm[0] = p.x;
            }
            if (p.y < xyminm[1]) {
                xyminm[1] = p.y;
            }
            if (p.x > xyminm[2]) {
                xyminm[2] = p.x;
            }
            if (!(p.y > xyminm[3])) continue;
            xyminm[3] = p.y;
        }
    }

    public MPoint getPointRef(int i, CTransform3D trot) {
        throw new ArrayIndexOutOfBoundsException("No point references in object");
    }

    public void addAttributeKeys(List<String> l) {
        l.add("color");
        l.add("background");
        l.add("lineColor");
        if (this.isSelected()) {
            l.add("isSelected");
        }
    }

    public void addCdataAttributeKeys(List<String> l) {
    }

    public String getAttribute(String s) {
        if (s.equalsIgnoreCase("color")) {
            return ColorParser.toString(this.color);
        }
        if (s.equalsIgnoreCase("background")) {
            return ColorParser.toString(this.background);
        }
        if (s.equalsIgnoreCase("lineColor")) {
            return ColorParser.toString(this.lineColor);
        }
        if (s.equalsIgnoreCase("isSelected")) {
            return String.valueOf(this.isSelected());
        }
        return null;
    }

    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("color")) {
            this.color = MObject.makeColor(v);
        } else if (s.equalsIgnoreCase("background")) {
            this.background = MObject.makeColor(v);
        } else if (s.equalsIgnoreCase("lineColor")) {
            this.lineColor = MObject.makeColor(v);
        } else if (s.equalsIgnoreCase("isSelected")) {
            this.selected = v.equals("true");
        }
    }

    public abstract void transform(CTransform3D var1, int var2, CTransform3D var3);

    public abstract void calcCenter(DPoint3 var1, CTransform3D var2);

    public double distanceFrom(double x, double y) {
        return this.distanceFrom(x, y, null);
    }

    public abstract double distanceFrom(double var1, double var3, CTransform3D var5);

    public boolean containsPoint(DPoint3 p, CTransform3D trot) {
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public boolean isReactionArrow(MoleculeGraph mol) {
        return false;
    }

    public void unselectContents() {
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    public boolean hasColor() {
        return false;
    }

    public boolean hasLineColor() {
        return false;
    }

    public boolean hasBackground() {
        return false;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c) {
        this.background = c;
    }

    public void finishCloning(MDocument olddoc, MDocument newdoc) {
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        return i >= 0 ? s.substring(i + 1) : s;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        byte f = 0;
        if (this.color != null) {
            f = (byte)(f | 1);
        }
        if (this.lineColor != null) {
            f = (byte)(f | 2);
        }
        if (this.background != null) {
            f = (byte)(f | 4);
        }
        oos.writeByte(f);
        if ((f & 1) != 0) {
            oos.writeInt(this.color.getRGB());
        }
        if ((f & 2) != 0) {
            oos.writeInt(this.lineColor.getRGB());
        }
        if ((f & 4) != 0) {
            oos.writeInt(this.background.getRGB());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int rgb;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize paintable object with future version (" + version + ")");
        }
        byte f = ois.readByte();
        if ((f & 1) == 0) {
            this.color = null;
        } else {
            rgb = ois.readInt();
            this.color = new Color(rgb);
        }
        if ((f & 2) == 0) {
            this.lineColor = null;
        } else {
            rgb = ois.readInt();
            this.lineColor = new Color(rgb);
        }
        if ((f & 4) == 0) {
            this.background = null;
        } else {
            rgb = ois.readInt();
            this.background = new Color(rgb);
        }
    }

    protected static Color makeColor(String s) {
        if (s.startsWith("#")) {
            try {
                int rgb = Integer.parseInt(s.substring(1), 16);
                return new Color(rgb);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("bad color value " + s);
    }

    public void removeAtom(MolAtom atom) {
    }

    public void fixClonedPoints(MObject[] objarr0, MObject[] objarr, int i) {
    }
}

