/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MPoint
extends MObject {
    private static final long serialVersionUID = -3067277054033050963L;
    private transient DPoint3 location;

    public MPoint(double x, double y, double z) {
        super(null, null, null);
        this.location = new DPoint3(x, y, z);
    }

    public MPoint(double x, double y) {
        this(x, y, 0.0);
    }

    public MPoint(DPoint3 p) {
        this(p.x, p.y, p.z);
    }

    public MPoint(MPoint p) {
        super(p);
        this.location = new DPoint3(p.location);
    }

    public boolean equals(MPoint o) {
        return this.location.equals(o.location);
    }

    public boolean equals(Object o) {
        return o instanceof MPoint && this.equals((MPoint)o);
    }

    @Override
    public boolean isChildOf(MObject o) {
        for (int i = 0; i < o.getPointRefCount(); ++i) {
            MPoint p = o.getPointRef(i, null);
            if (p != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInternalSelectable() {
        return true;
    }

    @Override
    public Object clone() {
        return new MPoint(this);
    }

    public void getLocation(DPoint3 p, CTransform3D t) {
        p.x = this.location.x;
        p.y = this.location.y;
        p.z = this.location.z;
        if (t != null) {
            t.transform(p);
        }
    }

    public final DPoint3 getLocation(CTransform3D t) {
        DPoint3 p = new DPoint3(0.0, 0.0, 0.0);
        this.getLocation(p, t);
        return p;
    }

    public final DPoint3 getLocation() {
        DPoint3 p = new DPoint3(0.0, 0.0, 0.0);
        this.getLocation(p, null);
        return p;
    }

    public void setLocation(DPoint3 p, CTransform3D t) {
        this.location.set(p);
        if (t != null) {
            CTransform3D invt = new CTransform3D(t);
            invt.invert();
            invt.transform(this.location);
        }
    }

    @Override
    public int getPointCount() {
        return 1;
    }

    @Override
    public MPoint getPoint(int i) {
        return new MPoint(this.getPointRef(i, null));
    }

    @Override
    public int getPointRefCount() {
        return 1;
    }

    @Override
    public MPoint getPointRef(int i, CTransform3D trot) {
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException("MPoint stores only one point");
        }
        return this;
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        t.transform(this.location);
    }

    @Override
    public final void calcCenter(DPoint3 p, CTransform3D t) {
        this.getLocation(p, t);
    }

    @Override
    public final double distanceFrom(double x, double y, CTransform3D t) {
        DPoint3 p = this.getLocation(t);
        double dx = p.x - x;
        double dy = p.y - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeDouble(this.location.x);
        oos.writeDouble(this.location.y);
        oos.writeDouble(this.location.z);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize point object with future version (" + version + ")");
        }
        double x = ois.readDouble();
        double y = ois.readDouble();
        double z = ois.readDouble();
        this.location = new DPoint3(x, y, z);
    }
}

