/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MProp;
import chemaxon.struc.MTransformable;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.prop.MCollectionProp;
import chemaxon.struc.prop.MHashProp;
import chemaxon.struc.prop.MListProp;
import chemaxon.struc.prop.MPropFactory;
import chemaxon.struc.prop.MStringProp;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MPropertyContainer
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = -2575268570438177098L;
    private transient ArrayList<String> propertyKeys;
    private transient HashMap<String, MProp> properties;
    private transient HashSet<MTransformable> transformableProperties;
    MoleculeGraph molecule;

    public MPropertyContainer() {
        this.propertyKeys = null;
        this.properties = null;
        this.transformableProperties = null;
    }

    MPropertyContainer(MPropertyContainer p, Set xprops) {
        ArrayList<String> keys = p.propertyKeys;
        HashMap<String, MProp> props = p.properties;
        HashSet<MTransformable> tprops = p.transformableProperties;
        this.propertyKeys = keys != null ? (ArrayList)keys.clone() : null;
        this.properties = props != null ? (HashMap)props.clone() : null;
        HashSet<MTransformable> hashSet = this.transformableProperties = tprops != null ? (HashSet<MTransformable>)tprops.clone() : null;
        if (this.properties != null) {
            for (Map.Entry<String, MProp> e : this.properties.entrySet()) {
                MProp newval;
                String key = e.getKey();
                MProp val = e.getValue();
                if (xprops != null && xprops.contains(val)) continue;
                if (val instanceof MCollectionProp) {
                    MCollectionProp cprop = (MCollectionProp)val;
                    newval = cprop.cloneCollectionProp(xprops);
                } else {
                    newval = val.cloneProp();
                }
                this.properties.put(key, newval);
                if (this.transformableProperties == null || !this.transformableProperties.contains(val)) continue;
                this.transformableProperties.remove(val);
                this.transformableProperties.add((MTransformable)((Object)newval));
            }
        }
    }

    public void clear() {
        ArrayList<String> v = this.propertyKeys;
        if (v != null) {
            v.clear();
            this.propertyKeys = null;
        }
        this.properties = null;
        this.transformableProperties = null;
    }

    public int size() {
        ArrayList<String> v = this.propertyKeys;
        return v != null ? v.size() : 0;
    }

    public String[] getKeys() {
        ArrayList<String> v = this.propertyKeys;
        if (v == null) {
            return new String[0];
        }
        String[] keys = new String[v.size()];
        v.toArray(keys);
        return keys;
    }

    Enumeration getKeyEnumeration() {
        ArrayList<String> v = this.propertyKeys;
        return v != null ? Collections.enumeration(v) : Collections.enumeration(new ArrayList());
    }

    public String getKey(int i) {
        ArrayList<String> v = this.propertyKeys;
        return v != null ? (String)v.get(i) : null;
    }

    public String getString(String key) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, key);
    }

    public MProp get(String key) {
        HashMap<String, MProp> p = this.properties;
        return p != null ? p.get(key.toLowerCase()) : null;
    }

    public void setString(String key, String value) {
        this.set(key, value != null ? new MStringProp(value) : null);
    }

    public void set(String key, MProp value) {
        this.set(key, value, 0);
    }

    public void set(String key, MProp value, int opts) {
        String lkey = key.toLowerCase();
        HashMap<String, MProp> p = this.properties;
        if (value != null) {
            if (this.molecule != null && ((opts & 1) != 0 || value.isCoordDependent())) {
                value.setCoordDependent(this.molecule.getGrinvCC());
            }
            if (p == null) {
                p = new HashMap();
                this.properties = p;
            }
            int l = p.size();
            MProp oldval = p.get(lkey);
            p.put(lkey, value);
            if (p.size() != l && this.findKey(key) < 0) {
                ArrayList<String> v = this.propertyKeys;
                if (v == null) {
                    this.propertyKeys = v = new ArrayList();
                }
                v.add(key);
            }
            if (value instanceof MTransformable) {
                HashSet<MTransformable> tprops = this.transformableProperties;
                if (tprops == null) {
                    this.transformableProperties = tprops = new HashSet();
                }
                if (oldval != null) {
                    tprops.remove(value);
                }
                tprops.add((MTransformable)((Object)value));
            }
        } else if (p != null) {
            int l = p.size();
            MProp oldval = p.get(lkey);
            p.remove(lkey);
            if (p.size() != l) {
                int i = this.findKey(key);
                if (i >= 0) {
                    ArrayList<String> v = this.propertyKeys;
                    v.remove(i);
                }
                if (oldval instanceof MTransformable) {
                    HashSet<MTransformable> tprops = this.transformableProperties;
                    tprops.remove(oldval);
                    if (tprops.size() == 0) {
                        this.transformableProperties = null;
                    }
                }
            }
            if (p.size() == 0) {
                this.properties = null;
            }
        }
    }

    public void remove(MProp p) {
        this.replace(p, null);
    }

    public void replace(MProp oldp, MProp newp) {
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp prop = this.get(key);
            if (prop == oldp) {
                if (newp != null) {
                    this.properties.put(key.toLowerCase(), newp);
                    continue;
                }
                this.propertyKeys.remove(i);
                this.properties.remove(key.toLowerCase());
                --i;
                continue;
            }
            if (!(prop instanceof MCollectionProp)) continue;
            ((MCollectionProp)prop).replace(oldp, newp);
        }
        HashSet<MTransformable> tprops = this.transformableProperties;
        if (tprops != null) {
            int l = tprops.size();
            tprops.remove(oldp);
            if (tprops.size() != l) {
                tprops.add((MTransformable)((Object)newp));
            }
        }
    }

    public boolean contains(MProp p) {
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp prop = this.get(key);
            if (prop == p) {
                return true;
            }
            if (!(prop instanceof MCollectionProp) || !((MCollectionProp)prop).contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(MProp prop) {
        if (this.molecule != null && prop.isCoordDependent()) {
            return prop.getGrinvCC() == this.molecule.getGrinvCC();
        }
        return true;
    }

    public boolean isSelfReference(MProp p) {
        return this.molecule != null && this.molecule.isSelfReference(p);
    }

    public boolean isHierarchic() {
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp val = this.get(key);
            if (!(val instanceof MCollectionProp)) continue;
            return true;
        }
        return false;
    }

    public String hierarchize() {
        String key;
        int i;
        ArrayList<String> newKeys = new ArrayList<String>();
        HashMap<String, MProp> newProps = new HashMap<String, MProp>();
        for (i = 0; i < this.size(); ++i) {
            key = this.getKey(i);
            Object[] path = MPropertyContainer.getRDFPropPath(key);
            MProp prop = this.get(key);
            MPropertyContainer.hierarchize(path, prop, newKeys, newProps);
        }
        this.propertyKeys = newKeys;
        this.properties = newProps;
        for (i = 0; i < this.size(); ++i) {
            key = this.getKey(i);
            MProp p = this.get(key);
            if (!(p instanceof MHashProp)) continue;
            return key;
        }
        return null;
    }

    private static Object[] getRDFPropPath(String key) {
        StringTokenizer st = new StringTokenizer(key, ":");
        ArrayList<Object> path = new ArrayList<Object>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String name = MPropertyContainer.getRDFPropName(token);
            int arrindex = MPropertyContainer.getRDFArrayIndex(token, name);
            if (name.length() == 0) {
                if (arrindex < 0) {
                    throw new IllegalArgumentException("invalid RDF property name \"" + key + "\"");
                }
            } else {
                path.add(name);
            }
            if (arrindex < 0) continue;
            path.add(new Integer(arrindex));
        }
        return path.toArray();
    }

    private static void hierarchize(Object[] path, MProp prop, ArrayList<String> newKeys, Map<String, MProp> newProps) {
        String name0 = (String)path[0];
        for (int i = 0; i < newKeys.size(); ++i) {
            String key = newKeys.get(i);
            if (!key.equalsIgnoreCase(name0)) continue;
            if (path.length == 1) {
                newKeys.set(i, name0);
                newProps.put(name0.toLowerCase(), prop);
            } else {
                MProp container = newProps.get(key.toLowerCase());
                MPropertyContainer.hierarchize(path, prop, container);
            }
            return;
        }
        newKeys.add(name0);
        MCollectionProp container = null;
        if (path.length == 1) {
            newProps.put(path[0].toString().toLowerCase(), prop);
            return;
        }
        container = path[1] instanceof Integer ? new MListProp() : new MHashProp();
        newProps.put(name0.toLowerCase(), container);
        MPropertyContainer.hierarchize(path, prop, container);
    }

    private static void hierarchize(Object[] path, MProp prop, MProp prevcontainer) {
        int off;
        for (off = 1; off < path.length - 1; ++off) {
            MProp nextcontainer = MPropertyContainer.nextContainer(prevcontainer, path, off);
            prevcontainer = nextcontainer;
        }
        if (prevcontainer instanceof MListProp) {
            MListProp listp = (MListProp)prevcontainer;
            if (!(path[off] instanceof Integer)) {
                String name = MPropertyContainer.getRDFPropPathAsString(path, off);
                throw new IllegalArgumentException("RDF list element \"" + name + "\" specified with invalid index or " + "without index");
            }
            int index = (Integer)path[off];
            List<MProp> list = listp.getList();
            for (int i = list.size(); i < index; ++i) {
                list.add(null);
            }
            if (list.size() == index) {
                list.add(prop);
            } else {
                list.set(index, prop);
            }
        } else if (prevcontainer instanceof MHashProp) {
            MHashProp hashp = (MHashProp)prevcontainer;
            if (path[off] instanceof Integer) {
                String name = MPropertyContainer.getRDFPropPathAsString(path, off);
                throw new IllegalArgumentException("RDF hash map element \"" + name + "\" specified as list element");
            }
            hashp.put((String)path[off], prop);
        } else {
            String name = MPropertyContainer.getRDFPropPathAsString(path, off);
            throw new IllegalArgumentException("RDF property container element " + name + "=" + prevcontainer + " is neither list nor hash map");
        }
    }

    private static MProp nextContainer(MProp container, Object[] path, int pos) {
        MHashProp hashp;
        MListProp list;
        int index;
        MProp nextcontainer = null;
        if (container instanceof MListProp) {
            index = (Integer)path[pos];
            if (index < (list = (MListProp)container).size()) {
                nextcontainer = list.get(index);
            } else {
                for (int i = list.size(); i <= index; ++i) {
                    list.add(null);
                }
            }
        } else {
            String name = (String)path[pos];
            hashp = (MHashProp)container;
            nextcontainer = hashp.get(name);
        }
        if (nextcontainer == null) {
            nextcontainer = path[pos + 1] instanceof Integer ? new MListProp() : new MHashProp();
        }
        if (container instanceof MListProp) {
            index = (Integer)path[pos];
            list = (MListProp)container;
            list.set(index, nextcontainer);
        } else {
            String name = (String)path[pos];
            hashp = (MHashProp)container;
            hashp.put(name, nextcontainer);
        }
        return nextcontainer;
    }

    private static String getRDFPropPathAsString(Object[] path, int n) {
        StringBuffer sb = new StringBuffer((String)path[0]);
        for (int i = 1; i < n; ++i) {
            if (path[i] instanceof Integer) {
                int index = (Integer)path[i];
                sb.append("(");
                sb.append(index + 1);
                sb.append(")");
                continue;
            }
            sb.append(":");
            sb.append((String)path[i]);
        }
        return sb.toString();
    }

    private static String getRDFPropName(String name) {
        if (!name.endsWith(")")) {
            return name;
        }
        int k = name.lastIndexOf(40);
        if (k > 0) {
            try {
                int n = Integer.parseInt(name.substring(k + 1, name.length() - 1));
                if (n > 0) {
                    return name.substring(0, k);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return name;
    }

    private static int getRDFArrayIndex(String name, String propname) {
        int k = propname.length();
        if (k == name.length()) {
            return -1;
        }
        try {
            int n = Integer.parseInt(name.substring(k + 1, name.length() - 1));
            return n - 1;
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public void flatten() {
        ArrayList<String> newKeys = new ArrayList<String>();
        HashMap<String, MProp> newProps = new HashMap<String, MProp>();
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp prop = this.get(key);
            this.flatten(key, prop, newKeys, newProps);
        }
        this.propertyKeys = newKeys;
        this.properties = newProps;
    }

    private void flatten(String key, MProp prop, List<String> newKeys, Map<String, MProp> newProps) {
        if (prop instanceof MListProp) {
            MListProp list = (MListProp)prop;
            for (int i = 0; i < list.size(); ++i) {
                MProp p = list.get(i);
                this.flatten(key + "(" + (i + 1) + ")", p, newKeys, newProps);
            }
        } else if (prop instanceof MHashProp) {
            MHashProp hash = (MHashProp)prop;
            for (int i = 0; i < hash.size(); ++i) {
                String s = hash.getKey(i);
                MProp p = hash.get(i);
                this.flatten(key + ":" + s, p, newKeys, newProps);
            }
        } else {
            int n = newProps.size();
            newProps.put(key.toLowerCase(), prop);
            if (newProps.size() != n) {
                newKeys.add(key);
            }
        }
    }

    public List<MProp> getPropList() {
        ArrayList<MProp> set = new ArrayList<MProp>();
        this.collectProps(set);
        return set;
    }

    private void collectProps(Collection<MProp> set) {
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp prop = this.get(key);
            this.collectProps(prop, set);
        }
    }

    private void collectProps(MProp prop, Collection<MProp> set) {
        if (prop instanceof MListProp) {
            MListProp list = (MListProp)prop;
            for (int i = 0; i < list.size(); ++i) {
                MProp p = list.get(i);
                this.collectProps(p, set);
            }
        } else if (prop instanceof MHashProp) {
            MHashProp hash = (MHashProp)prop;
            for (int i = 0; i < hash.size(); ++i) {
                MProp p = hash.get(i);
                this.collectProps(p, set);
            }
        } else {
            set.add(prop);
        }
    }

    void revalidateCoordDependents() {
        HashMap<String, MProp> props = this.properties;
        MoleculeGraph m = this.molecule;
        if (props != null && m != null) {
            long grinvCC = m.getGrinvCC();
            for (Map.Entry<String, MProp> entry : props.entrySet()) {
                MProp p = entry.getValue();
                if (!p.isCoordDependent()) continue;
                p.setCoordDependent(grinvCC);
            }
        }
    }

    public Object getObject(String key) {
        MProp p = this.get(key);
        if (p != null) {
            return p.getPropValue();
        }
        return null;
    }

    public void setObject(String key, Object val) {
        this.set(key, val != null ? MPropFactory.getMProp(val) : null);
    }

    void transform(CTransform3D t) {
        HashSet<MTransformable> tprops = this.transformableProperties;
        if (tprops != null) {
            for (MTransformable prop : tprops) {
                prop.transform(t);
            }
        }
    }

    public Object clone() {
        return new MPropertyContainer(this, null);
    }

    MPropertyContainer clonePropertyContainer(Set excludedProps) {
        return new MPropertyContainer(this, excludedProps);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        if (n != 0) {
            this.propertyKeys = new ArrayList();
            this.properties = new HashMap();
        }
        for (int i = 0; i < n; ++i) {
            String key = (String)in.readObject();
            String lkey = key.toLowerCase();
            Object val = in.readObject();
            MProp p = MPropFactory.getMProp(val);
            this.propertyKeys.add(key);
            this.properties.put(lkey, p);
            if (!(p instanceof MTransformable)) continue;
            HashSet<MTransformable> tprops = this.transformableProperties;
            if (tprops == null) {
                this.transformableProperties = tprops = new HashSet();
            }
            tprops.add((MTransformable)((Object)p));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int n = this.size();
        out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            String key = this.getKey(i);
            MProp val = this.get(key);
            out.writeObject(key);
            out.writeObject(val);
        }
    }

    private int findKey(String key) {
        ArrayList<String> v = this.propertyKeys;
        if (v != null) {
            for (int i = v.size() - 1; i >= 0; --i) {
                String k = (String)v.get(i);
                if (!k.equalsIgnoreCase(key)) continue;
                return i;
            }
        }
        return -1;
    }
}

