/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MChemicalStruct;

public class MSelectionDocument
extends MDocument {
    private static final long serialVersionUID = 2379294894434293119L;

    public MSelectionDocument(SelectionMolecule m) {
        super(m);
    }

    public MSelectionDocument(MSelectionDocument doc) {
        super(doc, false);
        for (int i = 0; i < this.objects.size(); ++i) {
            MObject o0 = (MObject)this.objects.get(i);
            if (!(o0 instanceof MChemicalStruct)) continue;
            MChemicalStruct mm0 = (MChemicalStruct)o0;
            MChemicalStruct mm = (MChemicalStruct)mm0.clone();
            this.objects.set(i, mm);
            if (mm0.getMoleculeGraph().theDocument == doc) {
                mm.getMoleculeGraph().theDocument = this;
            }
            if (mm0 == doc.mainMChemicalStruct) {
                this.mainMChemicalStruct = mm;
            }
            MoleculeGraph mol0 = mm0.getMoleculeGraph();
            MoleculeGraph mol = mm.getMoleculeGraph();
            mol.clear();
            mol.fuse(mol0);
        }
    }

    @Override
    public MDocument cloneDocument() {
        return new MSelectionDocument(this);
    }

    @Override
    public void addObject(MObject o) {
        this.objects.add(o);
    }

    @Override
    public void removeObject(MObject o) {
        int i = this.objects.indexOf(o);
        if (i >= 0) {
            this.removeObject(i);
        }
    }

    @Override
    public void removeObject(int i) {
        MObject o = this.getObject(i);
        if (o == this.mainMChemicalStruct) {
            this.mainMChemicalStruct = null;
        }
        this.objects.remove(i);
        this.unhighlight(o);
    }

    @Override
    public void setObject(MObject o, int i) {
        MObject old = this.getObject(i);
        if (old != o) {
            this.unhighlight(old);
            this.objects.set(i, o);
        }
    }

    @Override
    public void clear() {
        this.objectContainingSelection = null;
        this.objects.clear();
        this.objects.add(this.mainMChemicalStruct);
        this.mainMChemicalStruct.getMoleculeGraph().removeAll();
        this.unhighlightAll();
    }

    public Sgroup findSelectedSgroup() {
        MoleculeGraph mg = this.getMainMoleculeGraph();
        Molecule p = (Molecule)mg.getAtom(0).getParent();
        int n = mg.getAtomCount();
        for (int i = 0; i < n; ++i) {
            Sgroup sg = p.findSmallestSgroupContaining(mg.getAtom(i));
            if (sg == null) continue;
            return sg;
        }
        return null;
    }
}

