/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.GeomCalc;
import chemaxon.core.spi.HydrogenizeIface;
import chemaxon.core.util.PDBResidues;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeIterators;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.StaticMolecule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MacroMolecule {
    public static final int HYDROGENIZE_NO = 0;
    public static final int HYDROGENIZE_LIGAND = 1;
    public static final int HYDROGENIZE_ALL = 3;
    public static final int HYDROGENIZE_OPT = 7;
    public static final int HYDROGENIZE_REMOVE = 16;
    public static final int ADD_LP = 32;
    private String classification = new String();
    private String depDate = new String();
    private String idCode = new String();
    private String title = new String();
    private String source = new String();
    private String keywords = new String();
    private String expData = new String();
    private String author = new String();
    private int modelCount = 1;
    private Hashtable chains = null;
    private int[] residueCountPerChain = null;
    private int[] atomCountPerChain = null;
    private Hashtable heteroGroups = null;
    private int[] atomCountPerHeteroGroup = null;
    private Vector compounds = new Vector();
    private Vector components = new Vector();
    private boolean waterDefined = false;
    private int molId = 0;
    private String name = null;
    private int currentModelSerialNumber = 1;
    private Component currentComponent = null;
    private Polymer currentPolymer = null;
    private HeteroComponent currentHetero = null;
    private int totalAtomCount = 0;
    private int totalDefinedAtomCount = 0;
    private int hCount = 0;

    static double sqr(double v) {
        return v * v;
    }

    static double distance(MolAtom a1, MolAtom a2) {
        return Math.sqrt(MacroMolecule.sqr(a1.getX() - a2.getX()) + MacroMolecule.sqr(a1.getY() - a2.getY()) + MacroMolecule.sqr(a1.getZ() - a2.getZ()));
    }

    public MacroMolecule(int modelCount, Hashtable chains, int[] residueCountPerChain, int[] atomCountPerChain, Hashtable heteroGroups, int[] atomCountPerHeteroGroup) {
        this.modelCount = modelCount;
        this.chains = chains;
        this.residueCountPerChain = residueCountPerChain;
        this.atomCountPerChain = atomCountPerChain;
        this.heteroGroups = heteroGroups;
        this.atomCountPerHeteroGroup = atomCountPerHeteroGroup;
    }

    public void addHeader(String classification, String depDate, String idCode) {
        this.classification = classification;
        this.depDate = depDate;
        this.idCode = idCode;
    }

    public void addTitle(String title) {
        this.title = this.title + title + " ";
    }

    public void addSource(String source) {
        this.source = this.source + source + " ";
    }

    public void addKeywords(String keywords) {
        this.keywords = this.keywords + keywords + " ";
    }

    public void addExpData(String expData) {
        this.expData = this.expData + expData + " ";
    }

    public void addAuthor(String author) {
        this.author = this.author + author + " ";
    }

    public void addMolId(int molId) throws BadMoleculeException {
        if (this.molId == molId) {
            throw new BadMoleculeException("Bad molecule id " + molId + ", this id has already been defined.");
        }
        if (this.molId + 1 != molId) {
            throw new BadMoleculeException("Bad molecule id " + molId + ", MOL_ID " + (this.molId + 1) + " has not been defined.");
        }
        this.molId = molId;
    }

    public void addMolName(String molName) throws BadMoleculeException {
        if (this.name == null) {
            this.name = new String(molName);
        } else {
            this.name.concat(molName).concat(" ");
        }
    }

    public void addCompound(String molName) throws BadMoleculeException {
        if (this.name == null) {
            this.name = new String(molName);
        }
        this.compounds.addElement(new Compound(this.molId, molName));
    }

    public void addChain(String chainId) throws BadMoleculeException {
        Compound c = (Compound)this.compounds.elementAt(this.compounds.size() - 1);
        c.addChain(chainId);
    }

    public void addSeqNoRange(String chainId, int seqBegin, int seqEnd) throws BadMoleculeException {
        this.selectPolymer(chainId);
        if (this.currentPolymer == null) {
            this.addPolymer(chainId, 0, true);
        }
        this.currentPolymer.addSeqRange(seqBegin, seqEnd);
    }

    public boolean addSeqres(String chainId, int residueCount, String resName) throws BadMoleculeException {
        boolean amino = PDBResidues.isAminoAcid(resName);
        boolean nucleic = PDBResidues.isNucleicAcid(resName);
        if (!amino && !nucleic) {
            return false;
        }
        this.selectPolymer(chainId);
        if (this.currentPolymer == null && (amino || nucleic)) {
            this.addPolymer(chainId, residueCount, amino);
        } else if (this.currentPolymer != null && this.currentPolymer.getSequenceResidueCount() == 0) {
            this.currentPolymer.setSequenceResidueCount(residueCount);
        }
        return true;
    }

    public void addSeqres(int residueTypeId) throws BadMoleculeException {
        if (this.currentPolymer == null) {
            throw new BadMoleculeException("Bad usage: Chain id has not been defined in SEQRES");
        }
        this.currentPolymer.addSequenceResidue(residueTypeId);
    }

    public void addHet(String hetId, String chainId, int seqNum, char iCode, int numHetAtoms) {
        if (!this.selectHeteroComponent(hetId, 1, chainId, iCode, seqNum)) {
            this.currentHetero = new HeteroComponent(hetId, this.currentModelSerialNumber, chainId, seqNum, iCode, numHetAtoms);
            this.components.addElement(this.currentHetero);
        }
    }

    public void addHetNam(String hetId, String name) {
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            HeteroComponent h;
            Component c = it.next();
            if (!(c instanceof HeteroComponent) || !(h = (HeteroComponent)c).getHetId().equals(hetId)) continue;
            h.setName(name);
        }
    }

    public void addHelix(int serNum, String helixId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode, int helixClass, int length) {
        this.selectPolymer(chainId);
        if (this.currentPolymer == null) {
            this.addPolymer(chainId, 0, true);
        }
        if (!(this.currentPolymer instanceof Protein)) {
            throw new RuntimeException("No such protein chain:" + chainId);
        }
        ((Protein)this.currentPolymer).addHelix(serNum, helixId, chainId, initSeqNum, initICode, endSeqNum, endICode, helixClass, length);
    }

    public void addSheet(int serNum, String sheetId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode, int sense, int numStrands) {
        this.selectPolymer(chainId);
        if (this.currentPolymer == null) {
            throw new RuntimeException("No such protein chain:" + chainId);
        }
        if (!(this.currentPolymer instanceof Protein)) {
            throw new RuntimeException("No such protein chain:" + chainId);
        }
        ((Protein)this.currentPolymer).addSheet(serNum, sheetId, chainId, initSeqNum, initICode, endSeqNum, endICode, sense, numStrands);
    }

    public void addTurn(int seq, String sheetId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode) {
        this.selectPolymer(chainId);
        if (this.currentPolymer == null) {
            throw new RuntimeException("No such protein chain:" + chainId);
        }
        if (!(this.currentPolymer instanceof Protein)) {
            throw new RuntimeException("No such protein chain:" + chainId);
        }
        ((Protein)this.currentPolymer).addTurn(seq, sheetId, chainId, initSeqNum, initICode, endSeqNum, endICode);
    }

    private void addPolymer(String chainId, int residueCount, boolean amino) {
        int chainNo = (Integer)this.chains.get(chainId);
        if (this.currentModelSerialNumber == 1) {
            this.currentPolymer = amino ? new Protein(chainId, this.modelCount, this.residueCountPerChain[chainNo], this.atomCountPerChain[chainNo]) : new NucleicAcid(chainId, this.modelCount, this.residueCountPerChain[chainNo], this.atomCountPerChain[chainNo]);
            this.currentComponent = this.currentPolymer;
            this.components.addElement(this.currentComponent);
        } else {
            this.selectPolymer(chainId);
        }
        if (residueCount != 0) {
            this.currentPolymer.setSequenceResidueCount(residueCount);
        }
    }

    public void beginModel(int serialNumber) throws BadMoleculeException {
        this.currentModelSerialNumber = serialNumber;
    }

    public void endModel() throws BadMoleculeException {
    }

    public void addAtom(int serial, String name, char altLoc, String resName, String chainId, int resSeqNo, char iCode, float x, float y, float z, String element, int charge, boolean hetero, float bFactor) throws BadMoleculeException {
        if (name == null) {
            return;
        }
        int resTypeId = PDBResidues.getResidueTypeId(resName);
        if (!hetero && resTypeId != -1) {
            this.selectPolymer(chainId);
            if (this.currentPolymer == null) {
                this.addPolymer(chainId, 0, !PDBResidues.isNucleicAcid(resName));
            }
            int resAtomId = PDBResidues.getResidueAtomIndex(resTypeId, name);
            if (this.currentModelSerialNumber == 1) {
                this.currentPolymer.addAtom(serial, resTypeId, resAtomId, name, resSeqNo, iCode, x, y, z, bFactor);
            } else {
                this.currentPolymer.addModelAtom(this.currentModelSerialNumber, resTypeId, resAtomId, name, resSeqNo, iCode, x, y, z, bFactor);
            }
        } else {
            int resId;
            this.selectHeteroComponent(resName, this.currentModelSerialNumber, chainId, iCode, resSeqNo);
            if (this.currentHetero == null) {
                if (!this.heteroGroups.containsKey(resName)) {
                    throw new RuntimeException("FORMUL record is missing, cannot add water (or other hetero group).");
                }
                if (PDBResidues.isModRes(resName)) {
                    resId = PDBResidues.getResidueTypeId(resName);
                    this.currentHetero = new HeteroComponent(resName, this.currentModelSerialNumber, chainId, resSeqNo, iCode, PDBResidues.getResidueAtomCount(resId));
                    this.components.addElement(this.currentHetero);
                } else {
                    int hetId = (Integer)this.heteroGroups.get(resName);
                    this.currentHetero = new HeteroComponent(resName, this.currentModelSerialNumber, chainId, resSeqNo, iCode, this.atomCountPerHeteroGroup[hetId]);
                    this.components.addElement(this.currentHetero);
                }
            }
            resId = PDBResidues.getResidueTypeId(resName);
            if (PDBResidues.isModRes(resName) && this.currentHetero.getDefinedAtomCount() == 0) {
                this.currentPolymer.addModRes(resTypeId, PDBResidues.getResidueAtomCount(resId), resSeqNo);
            }
            this.currentHetero.addAtom(serial, name, resSeqNo, iCode, x, y, z, element, charge);
        }
    }

    public int findParentAtom(float x, float y, float z) {
        return this.currentPolymer.findParentAtom(x, y, z);
    }

    public void addBond(int[] atomIndex) {
        int i;
        int[] componentIndex = new int[5];
        boolean[] hetero = new boolean[5];
        componentIndex[0] = this.findHeteroComponent(atomIndex[0]);
        if (componentIndex[0] == -1) {
            return;
        }
        for (i = 1; i < 5; ++i) {
            componentIndex[i] = this.findHeteroComponent(atomIndex[i]);
            hetero[i] = componentIndex[i] != -1;
        }
        this.currentHetero = (HeteroComponent)this.components.elementAt(componentIndex[0]);
        for (i = 1; i < 5; ++i) {
            if (componentIndex[0] != componentIndex[i]) continue;
            this.currentHetero.addBond(atomIndex[0], atomIndex[i]);
        }
        String chainId = this.currentHetero.getChainId();
    }

    public void addWater(String hetId, int oCount, int hCount) {
        this.components.addElement(new Water(hetId, oCount, hCount));
        this.waterDefined = true;
    }

    public boolean hasWater() {
        return this.waterDefined;
    }

    public void addTer() {
    }

    public void end(int hydrogenizeMode, boolean fixBondTypes) {
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            Component c = it.next();
            if (!(c instanceof HeteroComponent)) continue;
            HeteroComponent h = (HeteroComponent)c;
            boolean hydrHet = (hydrogenizeMode & 1) != 0;
            boolean addLP = (hydrogenizeMode & 0x20) != 0;
            h.fixBonds(fixBondTypes, hydrHet, addLP);
        }
        if (this.components.elementAt(0) instanceof Water) {
            this.components.add(this.components.elementAt(0));
            this.components.remove(0);
        }
    }

    public ComponentIterator getIterator() {
        return new ComponentIterator(this.components);
    }

    public String getName() {
        return this.name;
    }

    public String getHeader() {
        return this.classification + ", deposited on " + this.depDate + ", idCode: " + this.idCode;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSource() {
        return this.source;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getExpData() {
        return this.expData;
    }

    public String getAuthor() {
        return this.author;
    }

    public Polymer getChain(String chainId) {
        this.selectPolymer(chainId);
        return this.currentPolymer;
    }

    private void selectPolymer(String chainId) {
        if (this.currentComponent != null && this.currentComponent instanceof Polymer && ((Polymer)this.currentComponent).hasChain(chainId)) {
            return;
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            Polymer p;
            Component c = it.next();
            if (!(c instanceof Polymer) || !(p = (Polymer)c).hasChain(chainId)) continue;
            this.currentPolymer = p;
            this.currentComponent = this.currentPolymer;
            return;
        }
        this.currentPolymer = null;
        this.currentComponent = null;
    }

    private boolean selectHeteroComponent(String hetId, int modelSerial, String chainId, char iCode, int seqNum) {
        if (this.currentHetero != null && this.currentHetero.getHetId().equals(hetId) && (hetId == null || this.currentHetero instanceof Water || this.currentHetero.getSeqNum() == seqNum && this.currentHetero.getChainId().equals(chainId) && this.currentHetero.getICode() == iCode && this.currentHetero.getModelSerial() == modelSerial)) {
            return true;
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            HeteroComponent h;
            Component c = it.next();
            if (!(c instanceof HeteroComponent) || !(h = (HeteroComponent)c).getHetId().equals(hetId) || !(h instanceof Water) && (h.getSeqNum() != seqNum || !h.getChainId().equals(chainId) || h.getICode() != iCode || h.getModelSerial() != modelSerial)) continue;
            this.currentHetero = h;
            this.currentComponent = this.currentHetero;
            return true;
        }
        this.currentHetero = null;
        this.currentComponent = null;
        return false;
    }

    private int findHeteroComponent(int atomSerialNumber) {
        return this.findComponent(atomSerialNumber, HeteroComponent.class);
    }

    private int findPolymer(int atomSerialNumber, String chainId) {
        int r;
        int ci = this.findComponent(atomSerialNumber, Protein.class);
        int n = r = ci != -1 && ((Component)this.components.elementAt(ci)).getChainId().equals(chainId) ? ci : -1;
        if (ci == -1) {
            ci = this.findComponent(atomSerialNumber, NucleicAcid.class);
            r = ci != -1 && ((Component)this.components.elementAt(ci)).getChainId().equals(chainId) ? ci : -1;
        }
        return r;
    }

    private int findComponent(int atomSerialNumber, Class componentType) {
        for (int i = 0; i < this.components.size(); ++i) {
            Component c = (Component)this.components.elementAt(i);
            if (!c.getClass().equals(componentType) || !c.containsAtom(atomSerialNumber)) continue;
            return i;
        }
        return -1;
    }

    private void selectHeteroComponent(int atomSerialNumber) {
        if (this.currentHetero != null && this.currentHetero.containsAtom(atomSerialNumber)) {
            return;
        }
        int ci = this.findHeteroComponent(atomSerialNumber);
        if (ci != -1) {
            this.currentHetero = (HeteroComponent)this.components.elementAt(ci);
            this.currentComponent = this.currentHetero;
        } else {
            this.currentHetero = null;
            this.currentComponent = null;
        }
    }

    private boolean selectHeteroComponent(String hetId) {
        if (this.currentHetero != null && this.currentHetero.getHetId().equals(hetId)) {
            return true;
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            HeteroComponent h;
            Component c = it.next();
            if (!(c instanceof HeteroComponent) || !(h = (HeteroComponent)c).getHetId().equals(hetId)) continue;
            this.currentHetero = h;
            this.currentComponent = this.currentHetero;
            return true;
        }
        this.currentHetero = null;
        this.currentComponent = null;
        return false;
    }

    private boolean isHeteroGroupOnChain(char chainId) {
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            Component c = it.next();
            if (!(c instanceof HeteroComponent)) continue;
            return true;
        }
        return false;
    }

    public int getAtomCount() {
        if (this.totalAtomCount != 0) {
            return this.totalAtomCount;
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            Component c = it.next();
            this.totalAtomCount += c.getAtomCount();
        }
        return this.totalAtomCount;
    }

    public int getDefinedAtomCount() {
        if (this.totalDefinedAtomCount != 0) {
            return this.totalDefinedAtomCount;
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            Component c = it.next();
            this.totalDefinedAtomCount += c.getDefinedAtomCount();
        }
        return this.totalDefinedAtomCount;
    }

    public int getHydrogenCount() {
        if (this.hCount != 0) {
            return this.hCount;
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            Component c = it.next();
            this.hCount += c.getHydrogenCount();
        }
        return this.hCount;
    }

    public void toMolecule(Molecule mol) {
        ComponentIterator ci = this.getIterator();
        while (ci.hasNext()) {
            Component c = ci.next();
            c.addToMolecule(mol);
        }
        mol.setDim(3);
        mol.setProperty("pdb.classification", this.classification);
        mol.setProperty("pdb.idcode", this.idCode);
        mol.setProperty("pdb.title", this.title);
        mol.setProperty("pdb.source", this.source);
        mol.setProperty("pdb.keywds", this.keywords);
        mol.setProperty("pdb.expdta", this.expData);
        mol.setProperty("pdb.author", this.author);
    }

    void dump() {
        Object c;
        for (int i = 0; i < this.compounds.size(); ++i) {
            c = (Compound)this.compounds.elementAt(i);
            ((Compound)c).dump();
        }
        ComponentIterator it = this.getIterator();
        while (it.hasNext()) {
            c = it.next();
            ((Component)c).dump();
        }
    }

    public class ComponentIterator {
        private int current = -1;
        private Vector components = null;

        protected ComponentIterator(Vector components) {
            this.components = components;
            this.current = -1;
        }

        public boolean hasNext() {
            return this.current + 1 < this.components.size();
        }

        public Component current() {
            return (Component)this.components.elementAt(this.current);
        }

        public Component next() {
            return (Component)this.components.elementAt(++this.current);
        }
    }

    public class NucleicAcid
    extends Polymer {
        protected int[][] backBoneAtomIndex;
        protected int[] residueIndex;
        protected int backBoneAtomCount;
        protected int currentBackBoneAtomIndex;
        protected int lastModelSerial;

        public NucleicAcid(String chainId, int modelCount, int residueCount, int atomCount) {
            super(chainId, modelCount, residueCount, atomCount);
            this.backBoneAtomCount = 0;
            this.lastModelSerial = -1;
            this.backBoneAtomIndex = new int[modelCount + 1][residueCount * 2];
            this.residueIndex = new int[residueCount * 2];
        }

        @Override
        public void addAtom(int serial, int residueTypeId, int residueAtomIndex, String name, int resSeqNo, char iCode, float x, float y, float z, float bFactor) throws BadMoleculeException {
            super.addAtom(serial, residueTypeId, residueAtomIndex, name, resSeqNo, iCode, x, y, z, bFactor);
            String atomName = PDBResidues.getResidueAtomName(residueTypeId, residueAtomIndex);
            if (this.lastModelSerial != this.currentModelSerial) {
                this.currentBackBoneAtomIndex = 0;
            }
            this.lastModelSerial = this.currentModelSerial;
            if (atomName != null && atomName.equals("P") || name.equals("P")) {
                this.backBoneAtomIndex[this.currentModelSerial][this.currentBackBoneAtomIndex] = this.residueOffset[this.currentResidueIndex] + residueAtomIndex;
                ++this.backBoneAtomCount;
                if (this.currentModelSerial == 1) {
                    this.residueIndex[this.currentBackBoneAtomIndex] = this.currentResidueIndex;
                }
                ++this.currentBackBoneAtomIndex;
            }
        }

        @Override
        public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
            return new AtomProperty();
        }

        public BackboneAtomIterator getBackboneAtomIterator() {
            return new BackboneAtomIterator();
        }

        @Override
        void dump() {
            System.out.print("NucleicAcid:: ");
            super.dump();
        }

        public class AtomProperty
        extends Polymer.AtomProperty {
            @Override
            public int getSecondaryStructureType(int atomIndex) {
                return 4;
            }
        }

        public class BackboneAtomIterator
        extends Polymer.AtomIterator {
            boolean P;
            public static final int SECONDARY_NUCLEIC = 4;

            public BackboneAtomIterator() {
                this.P = false;
            }

            public BackboneAtomIterator(int fromResidue, char fromICode, int toResidue, char toICode) {
                super(fromResidue, fromICode, toResidue, toICode);
                this.P = false;
            }

            @Override
            public int getCount() {
                return NucleicAcid.this.backBoneAtomCount;
            }

            @Override
            public void reset() {
                super.reset();
                NucleicAcid.this.currentModelSerial = 1;
                NucleicAcid.this.currentBackBoneAtomIndex = 0;
                this.currentResidue = NucleicAcid.this.residueIndex[NucleicAcid.this.currentBackBoneAtomIndex];
                this.currentAtom = NucleicAcid.this.backBoneAtomIndex[NucleicAcid.this.currentModelSerial][NucleicAcid.this.currentBackBoneAtomIndex];
            }

            @Override
            public boolean hasNext() {
                return NucleicAcid.this.currentBackBoneAtomIndex < NucleicAcid.this.backBoneAtomCount;
            }

            @Override
            public int current() {
                return this.currentAtom;
            }

            @Override
            public int next() {
                if (++NucleicAcid.this.currentBackBoneAtomIndex == NucleicAcid.this.backBoneAtomCount) {
                    return -1;
                }
                this.currentResidue = NucleicAcid.this.residueIndex[NucleicAcid.this.currentBackBoneAtomIndex];
                this.currentAtom = NucleicAcid.this.backBoneAtomIndex[NucleicAcid.this.currentModelSerial][NucleicAcid.this.currentBackBoneAtomIndex];
                return this.currentAtom;
            }

            public int getAtom(String name) {
                int atomOffset = PDBResidues.getResidueAtomIndex(NucleicAcid.this.residues[this.currentResidue], name);
                return atomOffset == -1 ? -1 : NucleicAcid.this.residueOffset[this.currentResidue] + atomOffset;
            }

            @Override
            public int getSecondaryStructureType() {
                return 4;
            }
        }
    }

    public class Protein
    extends Polymer {
        protected Vector helixes;
        protected Vector sheets;
        protected Vector turns;

        private boolean findSecondaryStructureType(Vector structure, int seqNo, char iCode) {
            for (int si = 0; si < structure.size(); ++si) {
                SecondaryStructure s = (SecondaryStructure)structure.elementAt(si);
                if (!s.containsResidue(seqNo, iCode)) continue;
                return true;
            }
            return false;
        }

        public Protein(String chainId, int modelCount, int residueCount, int atomCount) {
            super(chainId, modelCount, residueCount, atomCount);
            this.helixes = new Vector();
            this.sheets = new Vector();
            this.turns = new Vector();
        }

        public void addHelix(int serNum, String helixId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode, int helixClass, int length) {
            int hc;
            switch (helixClass) {
                case 1: {
                    hc = 17;
                    break;
                }
                case 2: {
                    hc = 33;
                    break;
                }
                case 3: {
                    hc = 65;
                    break;
                }
                case 4: {
                    hc = 129;
                    break;
                }
                case 5: {
                    hc = 257;
                    break;
                }
                case 6: {
                    hc = 18;
                    break;
                }
                case 7: {
                    hc = 34;
                    break;
                }
                case 8: {
                    hc = 130;
                    break;
                }
                case 9: {
                    hc = 512;
                    break;
                }
                case 10: {
                    hc = 1024;
                    break;
                }
                default: {
                    hc = 17;
                }
            }
            Helix h = new Helix(serNum, helixId, chainId, initSeqNum, initICode, endSeqNum, endICode, hc, length);
            this.helixes.addElement(h);
        }

        public void addSheet(int serNum, String sheetId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode, int sense, int numStrands) {
            int ss = 0;
            switch (sense) {
                case 0: {
                    ss = 1;
                    break;
                }
                case 1: {
                    ss = 2;
                    break;
                }
                case -1: {
                    ss = 4;
                    break;
                }
            }
            Sheet s = new Sheet(serNum, sheetId, chainId, initSeqNum, initICode, endSeqNum, endICode, ss, numStrands);
            this.sheets.addElement(s);
        }

        public void addTurn(int seq, String sheetId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode) {
            Turn t = new Turn(seq, sheetId, chainId, initSeqNum, initICode, endSeqNum, endICode);
            this.turns.addElement(t);
        }

        public AtomIterator getAtomIterator() {
            return new AtomIterator();
        }

        public CAlphaAtomIterator getCAlphaAtomIterator() {
            return new CAlphaAtomIterator();
        }

        public BondIterator getBondIterator() {
            return new BondIterator();
        }

        @Override
        public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogens) {
            return new AtomIterator(enumerateHydrogens);
        }

        @Override
        public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogens) {
            return new BondIterator(enumerateHydrogens);
        }

        @Override
        public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
            return new AtomProperty();
        }

        public HelixIterator getHelixIterator() {
            return new HelixIterator();
        }

        public SheetIterator getSheetIterator() {
            return new SheetIterator();
        }

        public TurnIterator getTurnIterator() {
            return new TurnIterator();
        }

        @Override
        void dump() {
            SecondaryStructure sh;
            System.out.print("Protein:: ");
            super.dump();
            HelixIterator hit = this.getHelixIterator();
            while (hit.hasNext()) {
                Helix h = hit.next();
                h.dump();
            }
            SheetIterator shit = this.getSheetIterator();
            while (shit.hasNext()) {
                sh = shit.next();
                ((Sheet)sh).dump();
            }
            TurnIterator tit = this.getTurnIterator();
            while (tit.hasNext()) {
                sh = tit.next();
                ((Turn)sh).dump();
            }
        }

        public class TurnIterator {
            private int current = 0;

            public boolean hasNext() {
                return this.current + 1 < Protein.this.turns.size();
            }

            public Turn next() {
                return (Turn)Protein.this.turns.elementAt(this.current++);
            }
        }

        public class SheetIterator {
            private int current = 0;

            public boolean hasNext() {
                return this.current < Protein.this.sheets.size();
            }

            public Sheet next() {
                return (Sheet)Protein.this.sheets.elementAt(this.current++);
            }
        }

        public class HelixIterator {
            private int current = 0;

            public boolean hasNext() {
                return this.current < Protein.this.helixes.size();
            }

            public Helix next() {
                return (Helix)Protein.this.helixes.elementAt(this.current++);
            }
        }

        public class Turn
        extends SecondaryStructure {
            private int seq;

            public Turn() {
            }

            public Turn(int seq, String turnId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode) {
                super(turnId, chainId, initSeqNum, initICode, endSeqNum, endICode);
                this.seq = seq;
            }

            void dump() {
                System.out.println("TURN serNum=" + this.seq + " sheetId=" + this.id + " chainId=" + this.chainId + " initSeqNum=" + this.initSeqNum + " initICode=" + this.initICode + " endSeqNum=" + this.endSeqNum + " endICode=" + this.endICode);
            }
        }

        public class Sheet
        extends SecondaryStructure {
            public static final int FIRST = 1;
            public static final int PARALLEL = 2;
            public static final int ANTIPARALLEL = 4;
            private int serNum;
            private int sense;
            private int numStrands;

            public Sheet() {
            }

            public Sheet(int serNum, String sheetId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode, int sense, int numStrands) {
                super(sheetId, chainId, initSeqNum, initICode, endSeqNum, endICode);
                this.serNum = serNum;
                this.sense = sense;
                this.numStrands = numStrands;
            }

            @Override
            public String getLabel() {
                String l = "";
                switch (this.sense) {
                    case 1: {
                        l = l + "First";
                        break;
                    }
                    case 2: {
                        l = l + "Parallel";
                        break;
                    }
                    case 4: {
                        l = l + "Anti-parallel";
                    }
                }
                return l + "\n" + super.getLabel();
            }

            void dump() {
                System.out.println("SHEET serNum=" + this.serNum + " sheetId=" + this.id + " chainId=" + this.chainId + " initSeqNum=" + this.initSeqNum + " initICode=" + this.initICode + " endSeqNum=" + this.endSeqNum + " endICode=" + this.endICode + " sense=" + this.sense + " numStrands=" + this.numStrands);
            }
        }

        public class Helix
        extends SecondaryStructure {
            public static final int RIGHT_HANDED = 1;
            public static final int LEFT_HANDED = 2;
            public static final int ALPHA = 16;
            public static final int OMEGA = 32;
            public static final int PI = 64;
            public static final int GAMMA = 128;
            public static final int H310 = 256;
            public static final int RIBBON27 = 512;
            public static final int POLYPROLINE = 1024;
            private int serNum;
            private int helixClass;
            private int length;

            public Helix() {
            }

            public Helix(int serNum, String helixId, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode, int helixClass, int length) {
                super(helixId, chainId, initSeqNum, initICode, endSeqNum, endICode);
                this.serNum = serNum;
                this.helixClass = helixClass;
                this.length = length;
            }

            @Override
            public String getLabel() {
                return this.getHelixClass() + "\n" + super.getLabel();
            }

            void dump() {
                System.out.println("HELIX serNum=" + this.serNum + " helixId=" + this.id + " chainId=" + this.chainId + " initSeqNum=" + this.initSeqNum + " initICode=" + this.initICode + " endSeqNum=" + this.endSeqNum + " endICode=" + this.endICode + " helixClass=" + this.helixClass + " length=" + this.length);
            }

            private String getHelixClass() {
                String hc = (this.helixClass & 1) != 0 ? "Right-handed " : "Left-handed ";
                switch (this.helixClass & 0xFFFF0) {
                    case 16: {
                        hc = hc + "alpha";
                        break;
                    }
                    case 32: {
                        hc = hc + "omega";
                        break;
                    }
                    case 64: {
                        hc = hc + "pi";
                        break;
                    }
                    case 128: {
                        hc = hc + "gamma";
                        break;
                    }
                    case 256: {
                        hc = hc + "310";
                        break;
                    }
                    case 512: {
                        hc = hc + "ribbon 27";
                        break;
                    }
                    case 1024: {
                        hc = hc + "polyproline";
                        break;
                    }
                }
                return hc;
            }
        }

        public class SecondaryStructure {
            protected String id;
            protected String chainId;
            protected int initSeqNum;
            protected char initICode;
            protected int endSeqNum;
            protected char endICode;

            public SecondaryStructure() {
            }

            public SecondaryStructure(String id, String chainId, int initSeqNum, char initICode, int endSeqNum, char endICode) {
                this.id = id;
                this.chainId = chainId;
                this.initSeqNum = initSeqNum;
                this.initICode = initICode;
                this.endSeqNum = endSeqNum;
                this.endICode = endICode;
            }

            public CAlphaAtomIterator getCAlphaAtomIterator() {
                return new CAlphaAtomIterator(this.initSeqNum, this.initICode, this.endSeqNum, this.endICode);
            }

            public boolean containsResidue(int sequenceNumber, char iCode) {
                boolean seqIn;
                boolean bl = seqIn = this.initSeqNum <= sequenceNumber && sequenceNumber <= this.endSeqNum;
                return iCode == ' ' && this.initICode == ' ' && this.endICode == ' ' ? seqIn : seqIn && this.initICode <= iCode && iCode <= this.endICode;
            }

            public String getLabel() {
                return " (" + this.chainId + ") " + PDBResidues.getResidueName(Protein.this.residues[Protein.this.findResidue(this.initSeqNum)]) + this.initSeqNum + this.initICode + " " + PDBResidues.getResidueName(Protein.this.residues[Protein.this.findResidue(this.endSeqNum)]) + this.endSeqNum + this.endICode;
            }
        }

        public class AtomProperty
        extends Polymer.AtomProperty {
            @Override
            public int getSecondaryStructureType(int atomIndex) {
                this.findAtom(atomIndex);
                if (Protein.this.findSecondaryStructureType(Protein.this.sheets, Protein.this.seqNo[this.residueIndex], Protein.this.iCode[this.residueIndex])) {
                    return 3;
                }
                if (Protein.this.findSecondaryStructureType(Protein.this.turns, Protein.this.seqNo[this.residueIndex], Protein.this.iCode[this.residueIndex])) {
                    return 1;
                }
                if (Protein.this.findSecondaryStructureType(Protein.this.helixes, Protein.this.seqNo[this.residueIndex], Protein.this.iCode[this.residueIndex])) {
                    return 2;
                }
                return 0;
            }
        }

        public class BondIterator
        extends Polymer.BondIterator {
            public BondIterator() {
            }

            public BondIterator(boolean includeH) {
                super(includeH);
            }

            @Override
            public int getSecondaryStructureType(int whichAtom) {
                if (this.findSecondaryStructureType(Protein.this.sheets, whichAtom)) {
                    return 3;
                }
                if (this.findSecondaryStructureType(Protein.this.turns, whichAtom)) {
                    return 1;
                }
                if (this.findSecondaryStructureType(Protein.this.helixes, whichAtom)) {
                    return 2;
                }
                return 0;
            }

            private boolean findSecondaryStructureType(Vector structure, int whichAtom) {
                for (int si = 0; si < structure.size(); ++si) {
                    int ri;
                    SecondaryStructure s = (SecondaryStructure)structure.elementAt(si);
                    if (!s.containsResidue(Protein.this.seqNo[ri = this.currentResidue + (this.polymerBond ? whichAtom - 1 : 0)], Protein.this.iCode[ri])) continue;
                    return true;
                }
                return false;
            }
        }

        public class AtomIterator
        extends Polymer.AtomIterator {
            public static final int SECONDARY_TURN = 1;
            public static final int SECONDARY_HELIX = 2;
            public static final int SECONDARY_SHEET = 3;

            public AtomIterator() {
            }

            public AtomIterator(boolean includeH) {
                super(includeH);
            }

            public AtomIterator(int fromResidue, char fromICode, int toResidue, char toICode) {
                super(fromResidue, fromICode, toResidue, toICode);
            }

            @Override
            public int getSecondaryStructureType() {
                if (Protein.this.findSecondaryStructureType(Protein.this.sheets, Protein.this.seqNo[this.currentResidue], Protein.this.iCode[this.currentResidue])) {
                    return 3;
                }
                if (Protein.this.findSecondaryStructureType(Protein.this.turns, Protein.this.seqNo[this.currentResidue], Protein.this.iCode[this.currentResidue])) {
                    return 1;
                }
                if (Protein.this.findSecondaryStructureType(Protein.this.helixes, Protein.this.seqNo[this.currentResidue], Protein.this.iCode[this.currentResidue])) {
                    return 2;
                }
                return 0;
            }
        }

        public class CAlphaAtomIterator
        extends AtomIterator {
            private int caCount;
            private int cacoCount;

            public CAlphaAtomIterator() {
            }

            public CAlphaAtomIterator(int fromResidue, char fromICode, int toResidue, char toICode) {
                super(fromResidue, fromICode, toResidue, toICode);
            }

            @Override
            public int getCount() {
                if (this.caCount != 0) {
                    return this.caCount;
                }
                this.reset();
                while (this.hasNext()) {
                    if (this.getX() != Float.POSITIVE_INFINITY) {
                        ++this.caCount;
                    }
                    this.next();
                }
                return this.caCount;
            }

            public int getCaCoCount() {
                if (this.cacoCount != 0) {
                    return this.cacoCount;
                }
                this.reset();
                while (this.hasNext()) {
                    if (this.getX() != Float.POSITIVE_INFINITY && this.getCarbonylOxygen() != -1) {
                        ++this.cacoCount;
                    }
                    this.next();
                }
                return this.cacoCount;
            }

            @Override
            public void reset() {
                this.currentResidue = this.fromResidue;
                this.currentAtom = Protein.this.residueOffset[this.currentResidue] + 1;
                this.lastResidue = false;
            }

            @Override
            public boolean hasNext() {
                return !this.lastResidue;
            }

            @Override
            public int current() {
                return this.currentAtom;
            }

            @Override
            public int next() {
                if (this.lastResidue || this.currentResidue == this.toResidue) {
                    this.lastResidue = true;
                    return -1;
                }
                this.currentAtom = Protein.this.residueOffset[++this.currentResidue] + 1;
                return this.currentAtom;
            }

            public int getCarbonylOxygen() {
                return Protein.this.models[1].xCoords[Protein.this.residueOffset[this.currentResidue] + 3] != Float.POSITIVE_INFINITY ? Protein.this.residueOffset[this.currentResidue] + 3 : -1;
            }

            public int getNitrogen() {
                return Protein.this.models[1].xCoords[Protein.this.residueOffset[this.currentResidue] + 2] != Float.POSITIVE_INFINITY ? Protein.this.residueOffset[this.currentResidue] + 2 : -1;
            }

            public int getCarbon() {
                return Protein.this.models[1].xCoords[Protein.this.residueOffset[this.currentResidue]] != Float.POSITIVE_INFINITY ? Protein.this.residueOffset[this.currentResidue] : -1;
            }

            @Override
            protected void dump() {
                System.out.println("--> Protein::CAlphaAtomIterator.dump");
                super.dump();
                System.out.println("    fromICode = " + this.fromICode);
                System.out.println("    toIcode = " + this.toIcode);
                System.out.println("<-- Protein::CAlphaAtomIterator.dump");
            }
        }
    }

    public class Polymer
    extends Component {
        protected int molId;
        protected int seqBegin;
        protected int seqEnd;
        protected int[] sequence;
        protected int[] residues;
        protected int[] seqNo;
        protected char[] iCode;
        protected int[] residueOffset;
        protected Model[] models;
        protected int currentModelSerial;
        protected int currentSequenceIndex;
        protected int currentResidueIndex;
        protected int currentResidueType;
        protected int currentSeqNo;
        protected char currentICode;
        private int atomCountExclH;

        public Polymer(String chainId, int modelCount, int residueCount, int atomCount) {
            super("Chain " + chainId);
            this.molId = 1;
            this.seqBegin = 0;
            this.seqEnd = -1;
            this.sequence = null;
            this.residues = null;
            this.seqNo = null;
            this.iCode = null;
            this.residueOffset = null;
            this.models = null;
            this.currentModelSerial = 1;
            this.currentSequenceIndex = -1;
            this.currentResidueIndex = -1;
            this.currentResidueType = -1;
            this.currentSeqNo = -1;
            this.currentICode = (char)32;
            this.atomCountExclH = 0;
            this.chainId = chainId;
            this.residues = new int[residueCount];
            this.seqNo = new int[residueCount];
            this.residueOffset = new int[residueCount];
            this.iCode = new char[residueCount];
            this.models = new Model[modelCount + 1];
            this.models[1] = new Model(atomCount, 1);
            this.currentResidueIndex = -1;
            this.currentSequenceIndex = 0;
            this.serials = new int[atomCount];
        }

        public void setSequenceResidueCount(int residueCount) {
            this.sequence = new int[residueCount];
            if (this.seqBegin == 0) {
                this.seqBegin = 1;
                this.seqEnd = residueCount - 1;
                this.currentSequenceIndex = -1;
            }
        }

        public void addSeqRange(int seqBegin, int seqEnd) {
            this.seqBegin = seqBegin;
            this.seqEnd = seqEnd;
            this.currentSequenceIndex = -1;
        }

        public void addSequenceResidue(int residueTypeId) {
            this.sequence[++this.currentSequenceIndex] = residueTypeId;
        }

        public void addModRes(int residueTypeId, int residueAtomCount, int resSeqNo) {
            this.residues[++this.currentResidueIndex] = residueTypeId;
            this.currentResidueType = residueTypeId;
            this.currentSeqNo = this.seqNo[this.currentResidueIndex] = resSeqNo;
            this.residueOffset[this.currentResidueIndex] = this.residueOffset[this.currentResidueIndex - 1] + residueAtomCount;
            this.atomCount += PDBResidues.getResidueAtomCount(residueTypeId);
            this.bondCount += PDBResidues.getResidue(residueTypeId).getBondCount() + 1;
        }

        public void addAtom(int serial, int residueTypeId, int residueAtomIndex, String name, int resSeqNo, char iCode, float x, float y, float z, float bFactor) throws BadMoleculeException {
            if (residueAtomIndex == -1) {
                return;
            }
            if (this.currentSeqNo != resSeqNo || this.currentICode != iCode || this.currentResidueType != residueTypeId) {
                ++this.currentResidueIndex;
                this.residues[this.currentResidueIndex] = residueTypeId;
                this.currentResidueType = residueTypeId;
                this.currentSeqNo = this.seqNo[this.currentResidueIndex] = resSeqNo;
                this.currentICode = this.iCode[this.currentResidueIndex] = iCode;
                this.residueOffset[this.currentResidueIndex] = this.currentResidueIndex == 0 ? 0 : this.residueOffset[this.currentResidueIndex - 1] + PDBResidues.getResidueAtomCount(this.residues[this.currentResidueIndex - 1]);
                this.atomCount += PDBResidues.getResidueAtomCount(residueTypeId);
                this.bondCount += PDBResidues.getResidue(residueTypeId).getBondCount() + 1;
            }
            this.serials[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = serial;
            this.models[1].xCoords[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = x;
            this.models[1].yCoords[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = y;
            this.models[1].zCoords[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = z;
            this.models[1].bFactor[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = bFactor;
            ++this.definedAtomCount;
            this.atomCountExclH += PDBResidues.isHydrogen(residueTypeId, residueAtomIndex) ? 0 : 1;
        }

        public void addModelAtom(int modelSerial, int residueTypeId, int residueAtomIndex, String name, int resSeqNo, char iCode, float x, float y, float z, float bFactor) throws BadMoleculeException {
            if (residueAtomIndex == -1) {
                return;
            }
            if (this.currentSeqNo != resSeqNo || this.currentICode != iCode || this.currentResidueType != residueTypeId) {
                ++this.currentResidueIndex;
                this.currentResidueType = residueTypeId;
                this.currentSeqNo = resSeqNo;
                this.currentICode = iCode;
            }
            if (this.models[modelSerial] == null) {
                this.currentResidueIndex = 0;
                this.models[modelSerial] = new Model(this.models[1].xCoords.length, modelSerial);
            }
            this.models[modelSerial].xCoords[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = x;
            this.models[modelSerial].yCoords[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = y;
            this.models[modelSerial].zCoords[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = z;
            this.models[modelSerial].bFactor[this.residueOffset[this.currentResidueIndex] + residueAtomIndex] = bFactor;
        }

        private int findParentAtom(float x, float y, float z) {
            int n = PDBResidues.getResidueHeavyAtomCount(this.currentResidueType);
            int o = this.residueOffset[this.currentResidueIndex];
            float d = this.calcEucl2(this.models[this.currentModelSerial].xCoords[o], this.models[this.currentModelSerial].yCoords[o], this.models[this.currentModelSerial].zCoords[o], x, y, z);
            int ri = 0;
            for (int i = 1; i < n; ++i) {
                float td;
                if (!((td = this.calcEucl2(this.models[this.currentModelSerial].xCoords[++o], this.models[this.currentModelSerial].yCoords[o], this.models[this.currentModelSerial].zCoords[o], x, y, z)) < d)) continue;
                ri = i;
                d = td;
            }
            return ri;
        }

        private float calcEucl2(float x1, float y1, float z1, float x2, float y2, float z2) {
            if (x1 == Float.POSITIVE_INFINITY) {
                return Float.POSITIVE_INFINITY;
            }
            return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1);
        }

        public boolean hasChain(String chainId) {
            return this.chainId.equals(chainId);
        }

        public int getSequenceResidueCount() {
            return this.sequence == null ? 0 : this.sequence.length;
        }

        public int getResidueCount() {
            return this.residues == null ? 0 : this.residues.length;
        }

        @Override
        public String getAtomLabel(int atomIndex) {
            int res = this.findResidueOfAtom(atomIndex);
            if (res == -1) {
                return null;
            }
            int ai = atomIndex - this.residueOffset[res];
            return PDBResidues.getResidueAtomLabel(ai, this.seqNo[res], this.iCode[res], this.residues[res]);
        }

        public float getX(int index) {
            return this.models[this.currentModelSerial].xCoords[index];
        }

        public float getY(int index) {
            return this.models[this.currentModelSerial].yCoords[index];
        }

        public float getZ(int index) {
            return this.models[this.currentModelSerial].zCoords[index];
        }

        @Override
        public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogens) {
            return new AtomIterator(enumerateHydrogens);
        }

        public MoleculeIterators.AtomIteratorInterface getAtomIterator(int fromResidue, int toResidue) {
            return new AtomIterator(fromResidue, toResidue);
        }

        @Override
        public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogens) {
            return new BondIterator(enumerateHydrogens);
        }

        @Override
        public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
            return new AtomProperty();
        }

        private int findResidueOfAtom(int atomIndex) {
            int h;
            int l = -1;
            int i = h = this.residueOffset.length;
            while (l + 1 != h) {
                i = (l + h) / 2;
                if (this.residueOffset[i] < atomIndex) {
                    l = i;
                    continue;
                }
                h = i;
            }
            if (i >= this.residueOffset.length) {
                return -1;
            }
            if (this.residueOffset[i] == atomIndex) {
                return i;
            }
            if (i > 0 && this.residueOffset[i - 1] < atomIndex && atomIndex < this.residueOffset[i]) {
                return i - 1;
            }
            if (i + 1 < this.residueOffset.length && this.residueOffset[i] < atomIndex && atomIndex < this.residueOffset[i + 1]) {
                return i;
            }
            return i + 1 == this.residueOffset.length ? i : i + 1;
        }

        int findResidue(int seqResNo) {
            for (int i = 0; i < this.residues.length; ++i) {
                if (this.seqNo[i] != seqResNo) continue;
                return i;
            }
            return 0;
        }

        int findResidue(int seqResNo, char toICode) {
            for (int i = 0; i < this.residues.length; ++i) {
                if (this.iCode[i] != toICode || this.seqNo[i] != seqResNo) continue;
                return i;
            }
            return 0;
        }

        @Override
        void dump() {
            int i;
            System.out.print("Polymer:: chainId: " + this.chainId + " modelSerialNumber: " + this.currentModelSerial + " atomCount: " + this.atomCount + " sequence: ");
            for (i = 0; this.sequence != null && i < this.sequence.length; ++i) {
                System.out.print(PDBResidues.getResidueName(this.sequence[i]) + " ");
            }
            System.out.println();
            for (i = 0; i < this.seqNo.length; ++i) {
                System.out.println(PDBResidues.getResidueName(this.residues[i]) + ", " + this.seqNo[i] + ", " + this.residueOffset[i]);
            }
            for (i = 0; i < this.models[this.currentModelSerial].xCoords.length; ++i) {
                System.out.println(this.models[this.currentModelSerial].xCoords[i]);
            }
            super.dump();
            System.out.println();
        }

        public class AtomProperty
        implements MoleculeIterators.AtomPropertyInterface {
            protected int residueIndex;
            private int residueType;
            private int atomIndexInResidue;

            protected void findAtom(int atomIndex) {
                this.residueIndex = Polymer.this.findResidueOfAtom(atomIndex);
                if (this.residueIndex != -1) {
                    this.residueType = Polymer.this.residues[this.residueIndex];
                    this.atomIndexInResidue = atomIndex - Polymer.this.residueOffset[this.residueIndex];
                }
            }

            @Override
            public void setMolecule(Object mol) {
            }

            @Override
            public int getType(int atomIndex) {
                this.findAtom(atomIndex);
                return PDBResidues.getResidueAtomType(this.residueType, this.atomIndexInResidue);
            }

            @Override
            public String getLabel(int atomIndex) {
                this.findAtom(atomIndex);
                return PDBResidues.getResidueAtomLabel(this.atomIndexInResidue, Polymer.this.seqNo[this.residueIndex], Polymer.this.iCode[this.residueIndex], this.residueType);
            }

            @Override
            public float getCharge(int atomIndex) {
                this.findAtom(atomIndex);
                return 0.0f;
            }

            @Override
            public float getBFactor(int atomIndex) {
                return Polymer.this.models[Polymer.this.currentModelSerial].bFactor[atomIndex];
            }

            @Override
            public float getPartialAtomCharge(int atomIndex) throws Exception {
                this.findAtom(atomIndex);
                return PDBResidues.getPartialAtomCharge(this.residueType, this.atomIndexInResidue);
            }

            @Override
            public int getResidueTypeId(int atomIndex) {
                this.findAtom(atomIndex);
                return this.residueType;
            }

            @Override
            public int getSecondaryStructureType(int atomIndex) {
                return 0;
            }

            @Override
            public float getX(int atomIndex) {
                return Polymer.this.models[Polymer.this.currentModelSerial].xCoords[atomIndex];
            }

            @Override
            public float getY(int atomIndex) {
                return Polymer.this.models[Polymer.this.currentModelSerial].yCoords[atomIndex];
            }

            @Override
            public float getZ(int atomIndex) {
                return Polymer.this.models[Polymer.this.currentModelSerial].zCoords[atomIndex];
            }
        }

        public class BondIterator
        implements MoleculeIterators.BondIteratorInterface {
            protected MoleculeIterators.MoleculeBondIterator bit = null;
            protected boolean polymerBond = false;
            protected int fromResidue = -1;
            protected int toResidue = -1;
            protected int currentResidue = 0;
            private boolean includeH = false;

            public BondIterator() {
                this.includeH = false;
                this.bit = new MoleculeIterators().getMoleculeBondIterator();
                this.fromResidue = 0;
                this.toResidue = Polymer.this.residues.length - 1;
                this.init();
            }

            public BondIterator(boolean includeH) {
                this.includeH = includeH;
                this.bit = new MoleculeIterators().getMoleculeBondIterator();
                this.bit.setIncludeH(this.includeH);
                this.fromResidue = 0;
                this.toResidue = Polymer.this.residues.length - 1;
                this.init();
            }

            @Override
            public int getModelCount() {
                return MacroMolecule.this.modelCount;
            }

            @Override
            public void setModel(int modelSerialNumber) {
                Polymer.this.currentModelSerial = modelSerialNumber;
            }

            @Override
            public void reset() {
                this.init();
                this.bit.reset();
                this.polymerBond = false;
                while (this.bit.end() && this.hasNext()) {
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                return !this.polymerBond || this.currentResidue + 1 <= this.toResidue;
            }

            @Override
            public void next() {
                if (this.polymerBond) {
                    ++this.currentResidue;
                    while (this.currentResidue + 1 < this.toResidue && (Polymer.this.seqNo[this.currentResidue] + 1 < Polymer.this.seqNo[this.currentResidue + 1] || this.getX(1) == Float.POSITIVE_INFINITY || this.getX(2) == Float.POSITIVE_INFINITY || this.peptideBondTooLong())) {
                        ++this.currentResidue;
                    }
                    return;
                }
                if (this.bit.hasNext()) {
                    this.bit.next();
                    while (this.bit.hasNext()) {
                        if (this.getX(1) != Float.POSITIVE_INFINITY && this.getX(2) != Float.POSITIVE_INFINITY) {
                            return;
                        }
                        this.bit.next();
                    }
                }
                if (++this.currentResidue <= this.toResidue) {
                    this.bit.setMolecule(PDBResidues.getResidue(Polymer.this.residues[this.currentResidue]), this.includeH);
                    this.bit.reset();
                    return;
                }
                this.polymerBond = true;
                this.currentResidue = 0;
                while (this.currentResidue + 1 < this.toResidue && (Polymer.this.seqNo[this.currentResidue] + 1 < Polymer.this.seqNo[this.currentResidue + 1] || this.getX(1) == Float.POSITIVE_INFINITY || this.getX(2) == Float.POSITIVE_INFINITY)) {
                    ++this.currentResidue;
                }
            }

            private void init() {
                this.currentResidue = this.fromResidue;
                this.polymerBond = false;
                this.bit.setMolecule(PDBResidues.getResidue(Polymer.this.residues[this.currentResidue]), this.includeH);
            }

            @Override
            public int getBondType() {
                return this.polymerBond ? 1 : this.bit.getBondType();
            }

            @Override
            public int getResidueType(int whichAtom) {
                return this.polymerBond ? Polymer.this.residues[this.currentResidue + whichAtom - 1] : Polymer.this.residues[this.currentResidue];
            }

            @Override
            public boolean sameResidue(int alphaCarbonAtomId, int whichAtom) {
                return Polymer.this.findResidueOfAtom(alphaCarbonAtomId) == (this.polymerBond ? this.currentResidue + whichAtom - 1 : this.currentResidue);
            }

            @Override
            public int getSecondaryStructureType(int whichAtom) {
                return 0;
            }

            @Override
            public int getCount() {
                return this.includeH ? Polymer.this.bondCount : Polymer.this.bondCount - (Polymer.this.atomCount - Polymer.this.atomCountExclH);
            }

            @Override
            public int getAtomIndex(int whichAtom) {
                if (whichAtom == 0) {
                    return -1;
                }
                return this.polymerBond ? Polymer.this.residueOffset[this.currentResidue + whichAtom - 1] + PDBResidues.getPolymerAtomIndex(Polymer.this.residues[this.currentResidue + whichAtom - 1], whichAtom) : Polymer.this.residueOffset[this.currentResidue] + this.bit.getAtomIndex(whichAtom);
            }

            @Override
            public int getAtomType(int whichAtom) {
                return this.polymerBond ? PDBResidues.getPolymerAtomType(Polymer.this.residues[this.currentResidue + whichAtom - 1], whichAtom) : this.bit.getAtomType(whichAtom);
            }

            @Override
            public float getX(int whichAtom) {
                return this.getCoord(Polymer.this.models[Polymer.this.currentModelSerial].xCoords, whichAtom);
            }

            @Override
            public float getY(int whichAtom) {
                return this.getCoord(Polymer.this.models[Polymer.this.currentModelSerial].yCoords, whichAtom);
            }

            @Override
            public float getZ(int whichAtom) {
                return this.getCoord(Polymer.this.models[Polymer.this.currentModelSerial].zCoords, whichAtom);
            }

            private float getCoord(float[] coords, int whichAtom) {
                if (whichAtom == 0) {
                    return this.polymerBond ? coords[Polymer.this.residueOffset[this.currentResidue] + PDBResidues.getPolymerAtomNeighborIndex(Polymer.this.residues[this.currentResidue])] : coords[Polymer.this.residueOffset[this.currentResidue] + this.bit.getNeighborIndex()];
                }
                return this.polymerBond ? coords[Polymer.this.residueOffset[this.currentResidue + whichAtom - 1] + PDBResidues.getPolymerAtomIndex(Polymer.this.residues[this.currentResidue + whichAtom - 1], whichAtom)] : coords[Polymer.this.residueOffset[this.currentResidue] + this.bit.getAtomIndex(whichAtom)];
            }

            private boolean peptideBondTooLong() {
                if (Math.abs(this.getX(1) - this.getX(2)) > 2.0f) {
                    return true;
                }
                if (Math.abs(this.getY(1) - this.getY(2)) > 2.0f) {
                    return true;
                }
                return Math.abs(this.getZ(1) - this.getZ(2)) > 2.0f;
            }
        }

        public class AtomIterator
        implements MoleculeIterators.AtomIteratorInterface {
            protected int currentAtom = -1;
            protected int nextAtom = -1;
            protected int currentResidue = -1;
            protected int nextResidue = -1;
            protected char currentICode = '\u0000';
            protected char nextICode = '\u0000';
            protected boolean has = false;
            protected boolean lastResidue = false;
            protected boolean includeH = false;
            protected int fromResidue = -1;
            protected int toResidue = -1;
            protected char fromICode = (char)32;
            protected char toIcode = (char)32;

            public AtomIterator() {
                this.fromResidue = 0;
                this.toResidue = Polymer.this.residues.length - 1;
                this.currentResidue = 0;
            }

            public AtomIterator(boolean includeH) {
                this.includeH = includeH;
                this.fromResidue = 0;
                this.toResidue = Polymer.this.residues.length - 1;
                this.currentResidue = 0;
            }

            public AtomIterator(int fromResidue, int toResidue) {
                this.fromResidue = Polymer.this.findResidue(fromResidue);
                this.toResidue = Polymer.this.findResidue(toResidue);
                this.currentResidue = this.fromResidue;
                if (this.currentResidue < Polymer.this.residues.length) {
                    this.nextAtom = Polymer.this.residueOffset[this.currentResidue] - 1;
                }
            }

            public AtomIterator(int fromResidue, char fromICode, int toResidue, char toICode) {
                this.fromICode = fromICode;
                this.toIcode = toICode;
                this.fromResidue = fromICode == ' ' ? Polymer.this.findResidue(fromResidue) : Polymer.this.findResidue(fromResidue, fromICode);
                this.toResidue = toICode == ' ' ? Polymer.this.findResidue(toResidue) : Polymer.this.findResidue(toResidue, toICode);
                this.currentResidue = this.fromResidue;
                if (this.currentResidue < Polymer.this.residues.length) {
                    this.nextAtom = Polymer.this.residueOffset[this.currentResidue] - 1;
                }
            }

            public void setIncludeHydrogens(boolean includeH) {
                this.includeH = includeH;
            }

            @Override
            public int getModelCount() {
                return MacroMolecule.this.modelCount;
            }

            @Override
            public void setModel(int modelSerialNumber) {
                Polymer.this.currentModelSerial = modelSerialNumber;
            }

            @Override
            public void reset() {
                Polymer.this.currentModelSerial = 1;
                this.nextResidue = this.currentResidue = this.fromResidue;
                this.nextICode = this.currentICode = this.fromICode;
                this.currentAtom = Polymer.this.residueOffset[this.currentResidue] - 1;
                this.nextAtom = Polymer.this.residueOffset[this.currentResidue] - 1;
                this.lastResidue = false;
                this.has = this.findNext();
                this.currentAtom = this.nextAtom;
                this.currentResidue = this.nextResidue;
            }

            public boolean end() {
                return this.currentAtom == Polymer.this.models[Polymer.this.currentModelSerial].xCoords.length || !this.has;
            }

            @Override
            public boolean hasNext() {
                return !this.end();
            }

            @Override
            public int current() {
                return this.currentAtom;
            }

            @Override
            public int getCurrentAtomId() {
                return this.currentAtom;
            }

            @Override
            public int getCount() {
                return this.includeH ? Polymer.this.definedAtomCount : Polymer.this.atomCountExclH;
            }

            @Override
            public int getMaxIndex() {
                return Polymer.this.models[Polymer.this.currentModelSerial].xCoords.length;
            }

            @Override
            public int next() {
                this.has = this.findNext();
                this.currentAtom = this.nextAtom;
                this.currentResidue = this.nextResidue;
                return this.currentAtom;
            }

            private boolean findNext() {
                this.nextAtom = this.currentAtom;
                boolean found = false;
                while (this.nextAtom + 1 != Polymer.this.models[Polymer.this.currentModelSerial].xCoords.length && !found) {
                    found = this.goodAtom(this.nextAtom + 1);
                    this.inc();
                }
                return found;
            }

            private boolean goodAtom(int ai) {
                int ri;
                if (Polymer.this.models[Polymer.this.currentModelSerial].xCoords[ai] == Float.POSITIVE_INFINITY) {
                    return false;
                }
                int n = ri = this.nextResidue + 1 < Polymer.this.residueOffset.length && Polymer.this.residueOffset[this.nextResidue + 1] <= ai ? this.nextResidue + 1 : this.nextResidue;
                if (ri > this.toResidue) {
                    return false;
                }
                boolean isH = PDBResidues.isHydrogen(Polymer.this.residues[ri], ai - Polymer.this.residueOffset[ri]);
                return this.includeH || !isH;
            }

            private void inc() {
                ++this.nextAtom;
                if (this.nextResidue + 1 < Polymer.this.residueOffset.length && Polymer.this.residueOffset[this.nextResidue + 1] <= this.nextAtom) {
                    ++this.nextResidue;
                }
            }

            public int getSeqNo() {
                return Polymer.this.seqNo[this.currentResidue];
            }

            public int getResidueType() {
                return Polymer.this.residues[this.currentResidue];
            }

            @Override
            public String getResidueAtomLabel() {
                return PDBResidues.getResidueAtomLabel(this.currentAtom - Polymer.this.residueOffset[this.currentResidue], Polymer.this.seqNo[this.currentResidue], Polymer.this.iCode[this.currentResidue], Polymer.this.residues[this.currentResidue]);
            }

            @Override
            public boolean sameResidue(int atomId1, int atomId2) {
                return Polymer.this.findResidueOfAtom(atomId1) == Polymer.this.findResidueOfAtom(atomId2);
            }

            @Override
            public int getSecondaryStructureType() {
                return 0;
            }

            public char getICode() {
                return Polymer.this.iCode[this.currentResidue];
            }

            @Override
            public int getAtomType() {
                return PDBResidues.getResidueAtomType(Polymer.this.residues[this.currentResidue], this.currentAtom - Polymer.this.residueOffset[this.currentResidue]);
            }

            @Override
            public int getNeighborCount() {
                return -1;
            }

            public float getPartialAtomCharge() {
                return this.hasHydrogens() ? PDBResidues.getPartialAtomCharge(Polymer.this.residues[this.currentResidue], this.currentAtom - Polymer.this.residueOffset[this.currentResidue]) : PDBResidues.getCummulatedPartialAtomCharge(Polymer.this.residues[this.currentResidue], this.currentAtom - Polymer.this.residueOffset[this.currentResidue]);
            }

            private boolean hasHydrogens() {
                if (!this.includeH) {
                    return false;
                }
                int ri = Polymer.this.residues[this.currentResidue];
                int ai = this.currentAtom - Polymer.this.residueOffset[this.currentResidue];
                for (int i = 0; i < PDBResidues.getHydrogenCountOfAtom(ri, ai); ++i) {
                    int hi = PDBResidues.getHydrogenIndex(ri, ai, i);
                    if (Polymer.this.models[Polymer.this.currentModelSerial].xCoords[Polymer.this.residueOffset[this.currentResidue] + hi] == Float.POSITIVE_INFINITY) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void getCoords(float[] xyz) {
                xyz[0] = Polymer.this.models[Polymer.this.currentModelSerial].xCoords[this.currentAtom];
                xyz[1] = Polymer.this.models[Polymer.this.currentModelSerial].yCoords[this.currentAtom];
                xyz[2] = Polymer.this.models[Polymer.this.currentModelSerial].zCoords[this.currentAtom];
            }

            @Override
            public float getX() {
                return Polymer.this.models[Polymer.this.currentModelSerial].xCoords[this.currentAtom];
            }

            @Override
            public float getY() {
                return Polymer.this.models[Polymer.this.currentModelSerial].yCoords[this.currentAtom];
            }

            @Override
            public float getZ() {
                return Polymer.this.models[Polymer.this.currentModelSerial].zCoords[this.currentAtom];
            }

            protected void dump() {
                System.out.println("--> Polymer.AtomIterator.dump");
                System.out.println("    currentAtom = " + this.currentAtom);
                System.out.println("    nextAtom = " + this.nextAtom);
                System.out.println("    currentResidue = " + this.currentResidue);
                System.out.println("    nextResidue = " + this.nextResidue);
                System.out.println("    fromResidue = " + this.fromResidue);
                System.out.println("    toResidue = " + this.toResidue);
                System.out.println("<-- Polymer.AtomIterator.dump");
            }
        }

        public class Model {
            protected int modelSerialNumber;
            public float[] xCoords = null;
            public float[] yCoords = null;
            public float[] zCoords = null;
            public float[] bFactor = null;

            public Model(int atomCount, int modelSerialNumber) {
                this.modelSerialNumber = modelSerialNumber;
                this.xCoords = new float[atomCount];
                this.yCoords = new float[atomCount];
                this.zCoords = new float[atomCount];
                for (int i = 0; i < atomCount; ++i) {
                    this.xCoords[i] = Float.POSITIVE_INFINITY;
                }
                this.bFactor = new float[atomCount];
            }
        }
    }

    public class Water
    extends HeteroComponent {
        int oCount;
        int hCount;
        StaticMolecule smol;
        public float[] xCoords;
        public float[] yCoords;
        public float[] zCoords;

        public Water(String resName, int oCount, int hCount) {
            super(resName);
            this.xCoords = null;
            this.yCoords = null;
            this.zCoords = null;
            this.oCount = oCount;
            this.hCount = hCount;
            this.hetId = resName;
            this.smol = new StaticMolecule(oCount + hCount, oCount + hCount, 1);
            this.name = resName;
            this.smol.setName(this.name);
            this.xCoords = new float[oCount + hCount];
            this.yCoords = new float[oCount + hCount];
            this.zCoords = new float[oCount + hCount];
        }

        @Override
        public boolean isWater() {
            return true;
        }

        @Override
        protected void fixBonds(boolean fixBondTypes, boolean hydrogenize, boolean addLP) {
            if (this.oCount + this.hCount > 3000) {
                return;
            }
            int[] hohVoteCount = null;
            for (int a1 = 0; a1 < this.smol.getAtomCount(); ++a1) {
                if (this.smol.getAtomType(a1) != 8) continue;
                for (int a2 = a1 + 1; a2 < this.smol.getAtomCount(); ++a2) {
                    double dist = GeomCalc.distance(this.xCoords[a1], this.yCoords[a1], this.zCoords[a1], this.xCoords[a2], this.yCoords[a2], this.zCoords[a2]);
                    if (!(dist < 1.0)) continue;
                    if (this.smol.getAtomType(a2) == 8) {
                        if (hohVoteCount == null) {
                            hohVoteCount = new int[this.smol.getAtomCount()];
                        }
                        int n = a1;
                        hohVoteCount[n] = hohVoteCount[n] + true;
                        int n2 = a2;
                        hohVoteCount[n2] = hohVoteCount[n2] + 1;
                    }
                    if (this.smol.areNeighbors(a1, a2)) continue;
                    this.smol.addBond(a1, a2, 0);
                }
            }
            if (hohVoteCount != null) {
                for (int i = 0; i < hohVoteCount.length; ++i) {
                    if (hohVoteCount[i] != true) continue;
                    this.smol.setAtomType(i, (byte)1);
                }
            }
        }

        @Override
        public String getAtomLabel(int atomIndex) {
            int an = this.smol.getAtomType(atomIndex);
            if (an == 130) {
                return "LP";
            }
            return PeriodicSystem.getSymbol(an);
        }

        @Override
        public void addAtom(int serial, String name, int resSeqNo, char iCode, float x, float y, float z, String element, int charge) {
            int eType = PeriodicSystem.getAtomicNumber(element);
            this.smol.addAtom((byte)eType);
            this.xCoords[this.atomCount] = x;
            this.yCoords[this.atomCount] = y;
            this.zCoords[this.atomCount] = z;
            ++this.atomCount;
            ++this.definedAtomCount;
        }

        @Override
        protected void addBond(int atom, int bondedTo) {
            if (bondedTo == -1) {
                return;
            }
            if (!this.smol.areNeighbors(atom, bondedTo)) {
                this.smol.addBond(atom, bondedTo, 0);
            }
        }

        @Override
        public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogen) {
            MoleculeIterators.SmoleculeAtomIterator sai = new MoleculeIterators().getSmoleculeAtomIterator();
            sai.setXCoords(this.xCoords);
            sai.setYCoords(this.yCoords);
            sai.setZCoords(this.zCoords);
            sai.setMolecule(this.smol, enumerateHydrogen);
            return sai;
        }

        @Override
        public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogen) {
            MoleculeIterators.SmoleculeBondIterator sbi = new MoleculeIterators().getSmoleculeBondIterator();
            sbi.setXCoords(this.xCoords);
            sbi.setYCoords(this.yCoords);
            sbi.setZCoords(this.zCoords);
            sbi.setMolecule(this.smol, enumerateHydrogen);
            return sbi;
        }

        @Override
        public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
            try {
                Class<?> c = Class.forName("chemaxon.marvin.space.AtomProperty");
                Object api = c.newInstance();
                Method gap = api.getClass().getMethod("getSmoleculeAtomProperty", null);
                Object prop = gap.invoke(api, (Object[])null);
                Class[] smParamType = new Class[]{Object.class};
                Method sm = prop.getClass().getMethod("setMolecule", smParamType);
                Object[] smParam = new Object[]{this.smol};
                sm.invoke(prop, smParam);
                Class[] cParamType = new Class[]{Object.class, Integer.TYPE};
                Method sc = prop.getClass().getMethod("setCoordinates", cParamType);
                sc.invoke(prop, this.xCoords, new Integer(0));
                sc.invoke(prop, this.yCoords, new Integer(1));
                sc.invoke(prop, this.zCoords, new Integer(2));
                return (MoleculeIterators.AtomPropertyInterface)prop;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void dump() {
            System.out.println("--> Water.dump()");
            System.out.println("oCount = " + this.oCount);
            System.out.println("<-- Water.dump()");
        }
    }

    public class HeteroComponent
    extends Component {
        private static final int LIGAND = 1;
        private static final int ION = 2;
        private static final int HETERO_GROUP = 8;
        protected int modelSerial;
        protected String hetId;
        private int seqNum;
        private char iCode;
        protected Molecule mol;
        private int numHetAtoms;
        private Hashtable serialToId;
        private int type;

        public HeteroComponent(String name) {
            super(name);
            this.modelSerial = 1;
            this.hetId = null;
            this.mol = null;
            this.numHetAtoms = 0;
            this.serialToId = new Hashtable();
            this.type = 8;
            this.hetId = new String(name);
        }

        public Molecule fixThis(Molecule mol) {
            HeteroComponent h = new HeteroComponent(mol.getName());
            h.mol = mol;
            h.fixBonds(true, false, false);
            return h.mol;
        }

        public HeteroComponent(String hetId, int modelSerial, String chainId, int seqNum, char iCode, int numHetAtoms) {
            super(hetId, chainId, iCode);
            this.modelSerial = 1;
            this.hetId = null;
            this.mol = null;
            this.numHetAtoms = 0;
            this.serialToId = new Hashtable();
            this.type = 8;
            this.modelSerial = modelSerial;
            this.hetId = new String(hetId);
            this.seqNum = seqNum;
            this.iCode = iCode;
            this.numHetAtoms = numHetAtoms;
            this.type = this.numHetAtoms == 1 ? 2 : 1;
            this.mol = new Molecule();
            this.mol.setName(this.name);
            this.serials = new int[numHetAtoms];
        }

        @Override
        public void setName(String name) {
            if (name == null || name.length() == 0) {
                super.setName(name);
                this.mol.setName(name);
            } else {
                super.setName(this.name + " (" + name + ")");
                this.mol.setName(this.mol.getName() + " (" + name + ")");
            }
        }

        public int getModelSerial() {
            return this.modelSerial;
        }

        @Override
        public String getAtomLabel(int atomIndex) {
            MolAtom a = this.mol.getAtom(atomIndex);
            int an = a.getAtno();
            if (an == 130) {
                return "LP";
            }
            String l = a.getAliasstr();
            return l != null ? l : PeriodicSystem.getSymbol(an);
        }

        public void addAtom(int serial, String name, int resSeqNo, char iCode, float x, float y, float z, String element, int charge) {
            int eType = PeriodicSystem.getAtomicNumber(element);
            MolAtom a = new MolAtom(eType, x, y, z);
            a.setCharge(charge);
            a.setAliasstr(name);
            a.setResidueSeq(resSeqNo);
            this.mol.add(a);
            int id = this.mol.indexOf(a);
            if (this.type == 1) {
                this.serials[id] = serial;
                this.serialToId.put(new Integer(serial), new Integer(id));
            }
            ++this.atomCount;
            ++this.definedAtomCount;
        }

        protected void addBond(int atom, int bondedTo) {
            int atomId = (Integer)this.serialToId.get(new Integer(atom));
            if (bondedTo == -1) {
                return;
            }
            Integer bt = (Integer)this.serialToId.get(new Integer(bondedTo));
            if (bt == null) {
                return;
            }
            int bondedAtomId = bt;
            if (this.areNeighbours(atomId, bondedAtomId)) {
                return;
            }
            MolBond b = new MolBond(this.mol.getAtom(atomId), this.mol.getAtom(bondedAtomId), 0);
            this.mol.add(b);
        }

        public void merge(HeteroComponent newPart, int myAtom, int otherAtom) {
            int i;
            Hashtable l = newPart.serialToId;
            this.expand(newPart.mol.getAtomCount());
            for (i = 0; i < newPart.mol.getAtomCount(); ++i) {
                MolAtom a = (MolAtom)newPart.mol.getAtom(i).clone();
                this.mol.add(a);
                int id = this.mol.indexOf(a);
                int ser = newPart.serials[i];
                this.serialToId.put(new Integer(ser), new Integer(id));
                this.serials[id] = ser;
            }
            for (i = 0; i < newPart.mol.getBondCount(); ++i) {
                MolBond b = newPart.mol.getBond(i);
                this.mol.add(b);
            }
            this.setName(this.name + "+" + newPart.name);
        }

        private void expand(int newAtomCount) {
            int[] newSerials = new int[this.serials.length + newAtomCount];
            for (int i = 0; i < this.serials.length; ++i) {
                newSerials[i] = this.serials[i];
            }
            this.serials = newSerials;
        }

        private boolean areNeighbours(int a1, int a2) {
            MolAtom ma1 = this.mol.getAtom(a1);
            int bc = ma1.getBondCount();
            for (int i = 0; i < bc; ++i) {
                MolBond e = ma1.getBond(i);
                if (this.mol.indexOf(e.getAtom1()) != a2 && this.mol.indexOf(e.getAtom2()) != a2) continue;
                return true;
            }
            return false;
        }

        protected void fixBonds(boolean fixBondTypes, boolean hydrogenize, boolean addLP) {
            if (hydrogenize || addLP || fixBondTypes) {
                BondMaker bm = new BondMaker(this.mol);
                this.mol = bm.getFixed(fixBondTypes, hydrogenize, addLP);
            }
        }

        public Molecule getMolecule() {
            return this.mol;
        }

        public String getHetId() {
            return this.hetId;
        }

        public int getSeqNum() {
            return this.seqNum;
        }

        @Override
        public boolean containsAtom(int atomSerialNumber) {
            return this.serialToId.containsKey(new Integer(atomSerialNumber));
        }

        public boolean isLigand() {
            return (this.type & 1) != 0;
        }

        public boolean isWater() {
            return false;
        }

        public boolean isIon() {
            return (this.type & 2) != 0;
        }

        @Override
        public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean enumerateHydrogen) {
            MoleculeIterators.MoleculeAtomIterator mai = new MoleculeIterators().getMoleculeAtomIterator();
            mai.setMolecule(this.mol, enumerateHydrogen);
            return mai;
        }

        @Override
        public MoleculeIterators.BondIteratorInterface getBondIterator(boolean enumerateHydrogen) {
            MoleculeIterators.MoleculeBondIterator mbi = new MoleculeIterators().getMoleculeBondIterator();
            mbi.setMolecule(this.mol, enumerateHydrogen);
            return mbi;
        }

        @Override
        public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
            try {
                Class<?> c = Class.forName("chemaxon.marvin.space.AtomProperty");
                Object api = c.newInstance();
                Method gap = api.getClass().getMethod("getAtomProperty", null);
                Object prop = gap.invoke(api, (Object[])null);
                Class[] smParamType = new Class[]{Object.class};
                Method sm = prop.getClass().getMethod("setMolecule", smParamType);
                Object[] smParam = new Object[]{this.mol};
                sm.invoke(prop, smParam);
                return (MoleculeIterators.AtomPropertyInterface)prop;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void dump() {
            System.out.println("--> HeteroGroup.dump()");
            switch (this.type) {
                case 1: {
                    System.out.println("LIGAND " + this.name + " " + this.hetId + " " + this.chainId + " " + this.seqNum + " " + this.mol.getAtomCount() + " atoms, " + this.mol.getBondCount() + " bonds (" + this.mol.toFormat("smiles") + ")");
                    break;
                }
                case 2: {
                    System.out.println("ION " + this.name + " " + PeriodicSystem.getName(this.mol.getAtom(0).getAtno()));
                    break;
                }
                case 8: {
                    System.out.println("HETERO_GROUP ...");
                }
            }
            System.out.println("<-- HeteroGroup.dump()");
        }
    }

    public static class BondMaker {
        private static final int[][] FREE_ELECTRON_COUNT = new int[][]{{1, 3, 11}, {12, 30}, {5}, {6, 14}, {7, 15}, {8, 16}, {9, 17, 35, 53}};
        private static final String STANDARD_BOND_LENGTHS = "C  C  1 1.54   C  C  2 1.34   C  C  3 1.20   C  C  4 1.40 C  N  1 1.47   C  N  2 1.29   C  N  3 1.16   C  N  4 1.34 C  F  1 1.34 C  P  1 1.87 C  O  1 1.43   C  O  2 1.21   C  O  3 1.13   C  O  4 1.29 C  S  1 1.82   C  S  2 1.60 N  N  1 1.45   N  N  2 1.25   N  N  3 1.10   N  N  4 1.35 N  O  1 1.40   N  O  2 1.21   N  O  4 1.24 N  S  1 1.59   P  O  1 1.63   P  O  2 1.50   P  S  2 1.86 O  O  1 1.48   O  O  2 1.21   O  S  2 1.43   O  H  1 0.96 S  S  1 2.05   S  S  2 1.49 ";
        private static final String STANDARD_H_BOND_LENGTHS = "B 1.19  C 1.09  N 1.01  P 1.44  O 0.96  S 1.34  F 0.92  Cl 1.27 Br 1.41  I 1.61 ";
        static float[][][] standardBondLengths = new float[16][16][4];
        static float[] standardHBondLengths = new float[53];
        private Molecule mol;
        private boolean fixBondTypes = false;
        private boolean hydrogenize = false;
        private boolean addLP = false;
        private int[][] sssr;
        private HydrogenizeIface hmodule;

        public BondMaker() {
        }

        public BondMaker(Molecule mol) {
            this.mol = mol;
        }

        public void setMolecule(Molecule mol) {
            this.mol = mol;
        }

        public Molecule getFixed() {
            this.sssr = this.mol.getAtomCount() > 100 ? (int[][])null : this.mol.getSSSR();
            this.createBonds();
            if (this.fixBondTypes) {
                this.correctBondTypes();
            }
            if (this.hydrogenize) {
                this.addHydrogen(this.addLP);
            }
            return this.mol;
        }

        public Molecule getFixed(boolean fixBondTypes, boolean hydrogenize, boolean addLP) {
            this.fixBondTypes = fixBondTypes;
            this.hydrogenize = hydrogenize;
            this.addLP = addLP;
            return this.getFixed();
        }

        public void setFixBondTypes(boolean fixBondTypes) {
            this.fixBondTypes = fixBondTypes;
        }

        public void setHydrogenize(boolean hydrogenize) {
            this.hydrogenize = hydrogenize;
        }

        public void setAddLP(boolean addLP) {
            this.addLP = addLP;
        }

        public static Molecule fixIt(Molecule mol) {
            BondMaker bm = new BondMaker(mol);
            return bm.mol;
        }

        private int getBondType(int atomType1, int atomType2, double bondLength) {
            if (--atomType1 >= standardBondLengths.length || --atomType2 >= standardBondLengths.length) {
                return this.doWildGuess(atomType1, atomType2, bondLength);
            }
            float[] bl = standardBondLengths[atomType1][atomType2];
            int nearest = -1;
            double minDist = Double.MAX_VALUE;
            for (int i = 0; i < bl.length; ++i) {
                double d;
                if (bl[i] == 0.0f || Math.abs(bondLength - (double)bl[i]) > (double)bl[i] * 0.2 || !((d = Math.abs((double)bl[i] - bondLength)) < minDist)) continue;
                nearest = i;
                minDist = d;
            }
            return nearest + 1;
        }

        private int doWildGuess(int atomType1, int atomType2, double bondLength) {
            return bondLength > 3.0 ? 0 : 1;
        }

        private float getHBlength(int atomType) {
            return --atomType >= standardHBondLengths.length ? 1.0f : standardHBondLengths[atomType];
        }

        private void createBonds() {
            if (this.mol.getBondCount() > 0) {
                return;
            }
            for (int a1 = 0; a1 < this.mol.getAtomCount(); ++a1) {
                for (int a2 = a1 + 1; a2 < this.mol.getAtomCount(); ++a2) {
                    MolAtom atom1 = this.mol.getAtom(a1);
                    MolAtom atom2 = this.mol.getAtom(a2);
                    int bt = this.getBondType(atom1.getAtno(), atom2.getAtno(), MacroMolecule.distance(atom1, atom2));
                    if (bt == 0) continue;
                    if (atom1.getAtno() == 1 || atom2.getAtno() == 1) {
                        bt = 1;
                    }
                    if (!this.fixBondTypes) {
                        bt = 131;
                    }
                    this.mol.add(new MolBond(atom1, atom2, bt));
                }
            }
        }

        private void correctBondTypes() {
            MolBond b;
            int i;
            for (i = 0; i < this.mol.getBondCount(); ++i) {
                b = this.mol.getBond(i);
                if (b.getAtom1().getAtno() == 6 && b.getAtom2().getAtno() == 6 && (b.getAtom1().getBondCount() == 4 || b.getAtom2().getBondCount() == 4)) {
                    b.setType(1);
                    continue;
                }
                if (b.getAtom2().getAtno() == 1 || b.getAtom1().getAtno() == 1) {
                    b.setType(1);
                    continue;
                }
                int newBondType = this.getBondType(b.getAtom1().getAtno(), b.getAtom2().getAtno(), b.getLength());
                if (newBondType == 0) continue;
                b.setType(this.isPeptideBond(b.getAtom1(), b.getAtom2()) ? 1 : newBondType);
            }
            for (i = 0; i < this.mol.getBondCount(); ++i) {
                b = this.mol.getBond(i);
                if (!this.isNormalisedCXChainBond(b)) continue;
                b.setType(2);
            }
            for (i = 0; i < this.mol.getAtomCount(); ++i) {
                MolAtom na;
                MolBond b2;
                int j;
                int vc;
                MolAtom ai = this.mol.getAtom(i);
                if (ai.getAtno() != 6 || this.getRingSize(this.sssr, ai) > 0 || (vc = this.valence(i)) == 4) continue;
                for (j = 0; j < ai.getBondCount(); ++j) {
                    b2 = ai.getBond(j);
                    if (b2.getType() != 2 && b2.getType() != 4) continue;
                    MolAtom molAtom = na = b2.getAtom1() == ai ? b2.getAtom2() : b2.getAtom1();
                    if (na.getAtno() != 6) continue;
                    vc -= b2.getType() - 1;
                    b2.setType(1);
                }
                for (j = 0; vc > 4 && j < ai.getBondCount(); ++j) {
                    b2 = ai.getBond(j);
                    if (b2.getType() != 2 && b2.getType() != 4) continue;
                    na = b2.getAtom1() == ai ? b2.getAtom2() : b2.getAtom1();
                    na.setHybridizationState(3);
                    vc -= b2.getType() - 1;
                    b2.setType(1);
                }
            }
        }

        private boolean isNormalisedCXChainBond(MolBond b) {
            if (b.getType() != 4) {
                return false;
            }
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            if (!(a1.getAtno() == 6 && a2.getAtno() != 6 && a2.getAtno() != 1 || a2.getAtno() == 6 && a1.getAtno() != 6 && a1.getAtno() != 1)) {
                return false;
            }
            return this.getRingSize(this.sssr, a1) == 0 && this.getRingSize(this.sssr, a2) == 0;
        }

        private int valence(int a) {
            int vc = 0;
            MolAtom c = this.mol.getAtom(a);
            for (int j = 0; j < c.getBondCount(); ++j) {
                vc += c.getBond(j).getType();
            }
            return vc;
        }

        private boolean isPeptideBond(MolAtom a1, MolAtom a2) {
            return a1.getAtno() == 6 && a2.getAtno() == 7 && this.hasONeighbour(a1) || a2.getAtno() == 6 && a1.getAtno() == 7 && this.hasONeighbour(a2);
        }

        private boolean hasONeighbour(MolAtom a) {
            for (int i = 0; i < a.getBondCount(); ++i) {
                MolBond b = a.getBond(i);
                if (b.getAtom2().getAtno() == 8) {
                    return true;
                }
                if (b.getAtom1().getAtno() != 8) continue;
                return true;
            }
            return false;
        }

        private void addHydrogen(boolean addLP) {
            block5: for (int i = 0; i < this.mol.getAtomCount(); ++i) {
                MolAtom a = this.mol.getAtom(i);
                float bo = 0.0f;
                boolean arom = false;
                for (int j = 0; j < a.getBondCount(); ++j) {
                    MolBond b = a.getBond(j);
                    int t = b.getType();
                    bo = (float)((double)bo + (t == 4 ? 1.5 : (double)t));
                    arom = arom || t == 4 || this.isPeptideBond(b.getAtom1(), b.getAtom2());
                }
                switch (this.getValenceElectronCount(a.getAtno())) {
                    case 4: {
                        this.addHToC(a, bo, arom);
                        continue block5;
                    }
                    case 5: {
                        this.addHToN(a, bo, arom, this.getRingSize(this.sssr, a), addLP);
                        continue block5;
                    }
                    case 6: {
                        this.addHToO(a, bo, arom, addLP);
                    }
                }
            }
        }

        private int getRingSize(int[][] sssr, MolAtom atom) {
            if (sssr == null) {
                return 0;
            }
            int ai = this.mol.indexOf(atom);
            for (int i = 0; i < sssr.length; ++i) {
                int[] r = sssr[i];
                for (int j = 0; j < r.length; ++j) {
                    if (r[j] != ai) continue;
                    return r.length;
                }
            }
            return 0;
        }

        private void addHToC(MolAtom a, float bondOrder, boolean hasAromBond) {
            if ((int)Math.ceil(4.0 - (double)bondOrder) > 0) {
                this.loadHydrogenizeModule();
                this.hmodule.hydr3d(1, this.mol, a, (int)Math.ceil(4.0 - (double)bondOrder), this.getHBlength(a.getAtno()));
            }
        }

        private void addHToN(MolAtom a, float bondOrder, boolean hasAromBond, int ringSize, boolean addLP) {
            this.loadHydrogenizeModule();
            if (hasAromBond) {
                if (bondOrder == 2.0f) {
                    if (ringSize == 5) {
                        this.hmodule.hydr3d(1, this.mol, a, 1, this.getHBlength(a.getAtno()));
                    } else if (ringSize == 6 && addLP) {
                        this.hmodule.hydr3d(130, this.mol, a, 1, 1.2);
                    }
                } else if (bondOrder == 1.0f) {
                    this.hmodule.hydr3d(1, this.mol, a, 2, this.getHBlength(a.getAtno()));
                }
            } else {
                if (bondOrder == 3.0f) {
                    if (a.getHybridizationState() == 3) {
                        return;
                    }
                    this.hmodule.hydr3d(1, this.mol, a, 1, 0.99);
                } else if (bondOrder == 1.0f && a.getHybridizationState() == 3) {
                    this.hmodule.hydr3d(1, this.mol, a, 2, this.getHBlength(a.getAtno()));
                }
                this.hmodule.hydr3d(1, this.mol, a, (int)Math.ceil(4.0 - (double)bondOrder), this.getHBlength(a.getAtno()));
            }
        }

        private void loadHydrogenizeModule() {
            if (this.hmodule == null) {
                this.hmodule = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil");
            }
        }

        private void addHToO(MolAtom a, float bondOrder, boolean hasAromBond, boolean addLP) {
            this.loadHydrogenizeModule();
            if (bondOrder % 2.0f == 1.0f || bondOrder == 0.0f) {
                this.hmodule.hydr3d(1, this.mol, a, bondOrder == 0.0f ? 2 : 1, this.getHBlength(a.getAtno()));
                bondOrder += bondOrder == 0.0f ? 2.0f : 1.0f;
            }
            if (bondOrder != 6.0f && addLP) {
                this.hmodule.hydr3d(130, this.mol, a, (int)Math.ceil((6.0 - (double)bondOrder) / 2.0), 1.2);
            }
        }

        private int getValenceElectronCount(int atno) {
            for (int i = 0; i < FREE_ELECTRON_COUNT.length; ++i) {
                int[] r = FREE_ELECTRON_COUNT[i];
                for (int j = 0; j < r.length; ++j) {
                    if (r[j] != atno) continue;
                    return i + 1;
                }
            }
            return 0;
        }

        static {
            StringTokenizer st = new StringTokenizer(STANDARD_BOND_LENGTHS);
            while (st.hasMoreTokens()) {
                String a1 = st.nextToken();
                String a2 = st.nextToken();
                int bo = Integer.parseInt(st.nextToken()) - 1;
                float bl = Float.valueOf(st.nextToken()).floatValue();
                int at1 = PeriodicSystem.getAtomicNumber(a1) - 1;
                int at2 = PeriodicSystem.getAtomicNumber(a2) - 1;
                float f = bl;
                BondMaker.standardBondLengths[at2][at1][bo] = f;
                BondMaker.standardBondLengths[at1][at2][bo] = f;
            }
            for (int i = 0; i < standardHBondLengths.length; ++i) {
                BondMaker.standardHBondLengths[i] = 1.0f;
            }
            st = new StringTokenizer(STANDARD_H_BOND_LENGTHS);
            while (st.hasMoreTokens()) {
                float bl;
                String a = st.nextToken();
                BondMaker.standardHBondLengths[PeriodicSystem.getAtomicNumber((String)a) - 1] = bl = Float.valueOf(st.nextToken()).floatValue();
            }
        }
    }

    public class Component {
        protected String name = null;
        protected String chainId;
        protected char iCode;
        protected int atomCount = 0;
        protected int hCount = 0;
        protected int definedAtomCount = 0;
        protected int definedHCount = 0;
        protected int bondCount = 0;
        int[] serials = null;

        public Component(String name) {
            this.name = name;
            this.chainId = new String(" ");
        }

        public Component(String name, String chainId, char iCode) {
            this.name = name;
            this.chainId = chainId;
            this.iCode = iCode;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getAtomLabel(int atomIndex) {
            return "";
        }

        public String getChainId() {
            return this.chainId;
        }

        public char getICode() {
            return this.iCode;
        }

        public int getAtomCount() {
            return this.atomCount;
        }

        public int getDefinedAtomCount() {
            return this.definedAtomCount;
        }

        public int getHydrogenCount() {
            return this.hCount;
        }

        public boolean containsAtom(int atomSerialNumber) {
            for (int i = 0; i < this.serials.length; ++i) {
                if (this.serials[i] != atomSerialNumber) continue;
                return true;
            }
            return false;
        }

        public MoleculeIterators.AtomIteratorInterface getAtomIterator(boolean inclH) {
            return null;
        }

        public MoleculeIterators.BondIteratorInterface getBondIterator(boolean inclH) {
            return null;
        }

        public MoleculeIterators.AtomPropertyInterface getAtomProperty() {
            return null;
        }

        public void addToMolecule(Molecule mol) {
            MoleculeIterators.AtomIteratorInterface ai = this.getAtomIterator(true);
            if (ai == null) {
                return;
            }
            MolAtom[] atoms = new MolAtom[ai.getMaxIndex()];
            ai.reset();
            while (ai.hasNext()) {
                MolAtom molAtom = new MolAtom(ai.getAtomType(), ai.getX(), ai.getY(), ai.getZ());
                atoms[ai.getCurrentAtomId()] = molAtom;
                MolAtom a = molAtom;
                mol.add(a);
                ai.next();
            }
            MoleculeIterators.BondIteratorInterface bi = this.getBondIterator(true);
            bi.reset();
            while (bi.hasNext()) {
                int ai1 = bi.getAtomIndex(1);
                int ai2 = bi.getAtomIndex(2);
                if (atoms[ai1] != null && atoms[ai2] != null) {
                    MolBond b = new MolBond(atoms[ai1], atoms[ai2], bi.getBondType());
                    mol.add(b);
                }
                bi.next();
            }
        }

        void dump() {
            System.out.println("Component:: name: " + this.name);
        }
    }

    public class Compound {
        private int molId;
        private String name = null;
        private String[] chains = null;

        public Compound(int molId, String name) {
            this.molId = molId;
            this.name = name;
        }

        public void addChain(String chainId) {
            if (this.chains == null) {
                this.chains = new String[1];
                this.chains[0] = chainId;
            } else {
                String[] temp = this.chains;
                this.chains = new String[this.chains.length + 1];
                for (int i = 0; i < temp.length; ++i) {
                    this.chains[i] = temp[i];
                }
                this.chains[this.chains.length - 1] = chainId;
                Object var2_2 = null;
            }
        }

        public boolean hasChain(String chainId) {
            for (int i = 0; i < this.chains.length; ++i) {
                if (!this.chains[i].equals(chainId)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        void dump() {
            System.out.print("Compound:: molId: " + this.molId + " name: " + this.name);
            if (this.chains != null) {
                System.out.print(" chains: " + this.chains[0]);
                for (int i = 1; i < this.chains.length; ++i) {
                    System.out.print("," + this.chains[i]);
                }
            }
            System.out.println();
        }
    }

    public class BadMoleculeException
    extends Exception {
        public BadMoleculeException(String msg) {
            super(msg);
        }
    }
}

