/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CEdge;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.StereoConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class MolBond
implements StereoConstants,
Serializable,
CEdge {
    private static final long serialVersionUID = 3656012871856958335L;
    public static final double CCLENGTH = 1.54;
    public static final int ANY = 0;
    public static final int TYPE_MASK = 15;
    public static final int AROMATIC = 4;
    public static final int SINGLE_OR_DOUBLE = 5;
    public static final int SINGLE_OR_AROMATIC = 6;
    public static final int DOUBLE_OR_AROMATIC = 7;
    public static final int CONJUGATED = 8;
    public static final int COORDINATE = 9;
    public static final int UP = 16;
    public static final int DOWN = 32;
    public static final int WAVY = 48;
    public static final int STEREO1_MASK = 48;
    public static final int STEREO2_CARE = 512;
    public static final int STEREO_MASK = 1008;
    public static final int TOPOLOGY_RING = 1024;
    public static final int TOPOLOGY_CHAIN = 2048;
    public static final int TOPOLOGY_MASK = 3072;
    public static final int RC_REACTING_CENTER = 4096;
    public static final int RC_MAKE_OR_BREAK = 8192;
    public static final int RC_CHANGE = 12288;
    public static final int RC_MAKE_AND_CHANGE = 16384;
    public static final int RC_NOT_CENTER = 20480;
    public static final int RC_NOT_MODIFIED = 24576;
    public static final int RC_UNMAPPED = 28672;
    public static final int REACTING_CENTER_MASK = 61440;
    public static final int SETSEQ_OFF = 24;
    public static final int SETSEQ_MAX = 63;
    public static final int ARROW = 0x40000000;
    public static final int BOLD = 0x40000000;
    public static final int HASHED = Integer.MIN_VALUE;
    static final int[] NUMELECTRONS = new int[]{2, 2, 4, 6, 3, 3, 2, 4, 2, 2};
    static final boolean[] CAN_BE_CTSINGLE = new boolean[]{true, true, false, false, true, false, true, false, false, false};
    static final boolean[] CAN_BE_CTDOUBLE = new boolean[]{false, false, true, false, false, false, false, true, false, false};
    private static double[][][] desiredLengths = null;
    private transient MoleculeGraph parentGraph;
    transient int index = 0;
    transient MolAtom theAtom1;
    transient MolAtom theAtom2;
    private transient int flags;
    private static final String[] bondNames = new String[]{"~", "-", "=", "#", ":", "-,=", "-,:", "=,:", "CONJ", "COORD"};

    public MolBond(MolAtom a1, MolAtom a2, int f) {
        this.theAtom1 = a1;
        this.theAtom2 = a2;
        this.flags = f;
    }

    protected MolBond(MolBond b) {
        this.theAtom1 = b.getAtom1();
        this.theAtom2 = b.getAtom2();
        this.flags = b.flags;
    }

    public MolBond(MolAtom a1, MolAtom a2) {
        this(a1, a2, 1);
    }

    public final MoleculeGraph getParent() {
        return this.parentGraph;
    }

    public void swap() {
        MolAtom a = this.theAtom1;
        this.theAtom1 = this.theAtom2;
        this.theAtom2 = a;
        this.resetGrinv();
    }

    public MolAtom getAtom1() {
        return this.theAtom1;
    }

    public MolAtom getAtom2() {
        return this.theAtom2;
    }

    public final MolAtom getOtherAtom(MolAtom atom) {
        return this.theAtom1 == atom ? this.theAtom2 : this.theAtom1;
    }

    public final double getLength() {
        if (this.theAtom1 == null || this.theAtom2 == null) {
            return 0.0;
        }
        MolAtom a1 = this.theAtom1;
        MolAtom a2 = this.theAtom2;
        double dx = a1.xCoordinate - a2.xCoordinate;
        double dy = a1.yCoordinate - a2.yCoordinate;
        double dz = a1.zCoordinate - a2.zCoordinate;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final int getFlags() {
        return this.flags;
    }

    public void setFlags(int f) {
        this.flags = f;
        this.resetGrinv();
    }

    public void setFlags(int f, int mask) {
        this.flags = this.flags & ~mask | f & mask;
        this.resetGrinv();
    }

    public final int getType() {
        int bondType = this.flags & 0xF;
        return bondType;
    }

    public void setType(int t) {
        int oldType = this.getType();
        this.flags = this.flags & 0xFFFFFFF0 | t & 0xF;
        if (t != 2 && t != 5 && t != 7 && t != 0) {
            this.flags &= 0xFFFFFE3F;
        }
        if (this.theAtom1 != null && this.theAtom2 != null) {
            this.theAtom1.valenceCheck();
            this.theAtom2.valenceCheck();
            this.resetGrinv();
        }
        if (this.parentGraph != null && oldType != this.getType()) {
            this.parentGraph.update(this);
        }
    }

    public final int getSetSeq() {
        return this.flags >> 24 & 0x3F;
    }

    public final void setSetSeq(int g) {
        this.flags = this.flags & 0xC0FFFFFF | (g & 0x3F) << 24;
    }

    public final boolean isConjugated() {
        return this.getType() == 8;
    }

    public final boolean isCoordinative() {
        return this.getType() == 9;
    }

    public final boolean isCoordinate() {
        return this.getType() == 9;
    }

    public final boolean isPositionVariation() {
        return !this.isCoordinate() && (this.getAtom1().getAtno() == 137 || this.getAtom2().getAtno() == 137);
    }

    public final boolean isArrow() {
        return false;
    }

    public final boolean isBold() {
        return (this.flags & 0x40000000) != 0;
    }

    public final boolean isHashed() {
        return (this.flags & Integer.MIN_VALUE) != 0;
    }

    public int calcOrderFromLength() {
        double r = this.getLength();
        int a1 = this.getAtom1().getAtno();
        int a2 = this.getAtom2().getAtno();
        if (a1 < 0 || a1 >= 54 || a2 < 0 || a2 >= 54) {
            return 1;
        }
        boolean[] allowed = MolAtom.IS_BOND_ALLOWED[a1][a2];
        if (allowed[3]) {
            if (r < 0.0) {
                return 3;
            }
        } else if (!allowed[2]) {
            return 1;
        }
        if (r < 0.0) {
            return 2;
        }
        return 1;
    }

    public final int calcOrderFromValence() {
        int bad;
        int dorder2;
        int dorder1;
        int a1 = this.theAtom1.getAtno();
        int a2 = this.theAtom2.getAtno();
        if (PeriodicSystem.isNobleGas(this.theAtom1.getAtno()) || PeriodicSystem.isNobleGas(this.theAtom2.getAtno())) {
            return 0;
        }
        if (a1 == 1 || a2 == 1) {
            return 1;
        }
        int relneg1 = this.theAtom1.getRelativeNegativity();
        int relneg2 = this.theAtom2.getRelativeNegativity();
        if (relneg1 == 0) {
            relneg1 = -relneg2;
        }
        if (relneg2 == 0) {
            relneg2 = -relneg1;
        }
        int val1 = this.theAtom1.getValence();
        int val2 = this.theAtom2.getValence();
        int chg1 = this.theAtom1.getCharge();
        int chg2 = this.theAtom2.getCharge();
        if (relneg1 < 0) {
            int negox = -MolAtom.negOxOf(a1);
            dorder1 = chg1 - val1 + negox;
        } else {
            int posox = MolAtom.posOxOf(a1);
            dorder1 = posox - chg1 - val1;
        }
        if (relneg2 < 0) {
            int negox = -MolAtom.negOxOf(a2);
            dorder2 = chg2 - val2 + negox;
        } else {
            int posox = MolAtom.posOxOf(a2);
            dorder2 = posox - chg2 - val2;
        }
        int oldOrder = this.getType();
        int newOrder1 = oldOrder + dorder1;
        int newOrder2 = oldOrder + dorder2;
        int n = bad = newOrder1 < 1 || newOrder1 > 3 ? 1 : 0;
        if (newOrder2 < 1 || newOrder2 > 3) {
            bad |= 2;
        }
        int meanOrder = (newOrder1 + newOrder2) / 2;
        if (bad == 3) {
            return meanOrder < 1 ? 1 : 3;
        }
        return bad == 2 ? newOrder1 : (bad == 1 ? newOrder2 : meanOrder);
    }

    public MolBond cloneBond(MolAtom a1, MolAtom a2) {
        return new MolBond(a1, a2, this.flags);
    }

    public Object clone() {
        return new MolBond(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static double desiredLength(int atno1, int atno2, int type, int dim) {
        if (dim < 3) {
            return 1.54;
        }
        double[][][] lengths = desiredLengths;
        if (lengths == null) {
            Class<MolBond> clazz = MolBond.class;
            // MONITORENTER : chemaxon.struc.MolBond.class
            lengths = desiredLengths;
            if (desiredLengths == null) {
                MolBond.initDesiredLengths3D();
                lengths = desiredLengths;
            }
            // MONITOREXIT : clazz
        }
        double l = -1.0;
        if (atno1 < 1 || atno1 >= lengths.length) {
            atno1 = 6;
        }
        if (atno2 >= 1) {
            if (atno2 < lengths[atno1].length) return lengths[atno1][atno2][type & 7];
        }
        atno2 = 6;
        return lengths[atno1][atno2][type & 7];
    }

    public final int getStereo1(MolAtom o) {
        int f = this.flags & 0x30;
        if (o == this.theAtom2) {
            if (f == 16) {
                f = 32;
            } else if (f == 32) {
                f = 16;
            }
        }
        return f;
    }

    public final MolAtom getCTAtom1() {
        MolAtom a = null;
        int nb = this.theAtom1.getBondCount();
        if (nb > 0 && (a = this.theAtom1.getLigand(0)) == this.theAtom2) {
            a = nb > 1 ? this.theAtom1.getLigand(1) : null;
        }
        return a;
    }

    public final MolAtom getCTAtom4() {
        MolAtom a = null;
        int nb = this.theAtom2.getBondCount();
        if (nb > 0 && (a = this.theAtom2.getLigand(0)) == this.theAtom1) {
            a = nb > 1 ? this.theAtom2.getLigand(1) : null;
        }
        return a;
    }

    public void setStereo2Flags(MolAtom a1, MolAtom a4, int stereo2) {
        stereo2 = this.transformCT(a1, a4, stereo2 & 0x1C0);
        this.flags = this.flags & 0xFFFFFE3F | stereo2;
        this.resetGrinv();
    }

    public int transformCT(MolAtom a1, MolAtom a4, int f) {
        int ct = f & 0xC0;
        if (ct == 128 || ct == 64) {
            MolAtom a10 = this.getCTAtom1();
            MolAtom a40 = this.getCTAtom4();
            if (!this.getAtom1().isBoundTo(a1) || !this.getAtom2().isBoundTo(a4)) {
                MolAtom t = a1;
                a1 = a4;
                a4 = t;
            }
            if (a10 == a40 && (a1 == a10 && a4 != a10 || a1 != a10 && a4 == a10)) {
                ct ^= 0xC0;
            } else {
                if (a10 != a1) {
                    ct ^= 0xC0;
                }
                if (a40 != a4) {
                    ct ^= 0xC0;
                }
            }
        }
        return f & 0xFFFFFF3F | ct;
    }

    public int calcStereo2() {
        return this.calcStereo2(this.getCTAtom1(), this.getCTAtom4());
    }

    public int calcStereo2(MolAtom atom1, MolAtom atom4) {
        MolAtom atom2 = this.theAtom1;
        MolAtom atom3 = this.theAtom2;
        return MolBond.calcStereo2(atom1, atom2, atom3, atom4);
    }

    public static int calcStereo2(MolAtom atom1, MolAtom atom2, MolAtom atom3, MolAtom atom4) {
        if (atom1 == null || atom2 == null || atom3 == null || atom4 == null) {
            return 0;
        }
        double ax = atom1.xCoordinate - atom2.xCoordinate;
        double bx = atom3.xCoordinate - atom2.xCoordinate;
        double ay = atom1.yCoordinate - atom2.yCoordinate;
        double by = atom3.yCoordinate - atom2.yCoordinate;
        double az = atom1.zCoordinate - atom2.zCoordinate;
        double bz = atom3.zCoordinate - atom2.zCoordinate;
        double ab = ax * bx + ay * by + az * bz;
        double cx = atom4.xCoordinate - atom3.xCoordinate;
        double cy = atom4.yCoordinate - atom3.yCoordinate;
        double cz = atom4.zCoordinate - atom3.zCoordinate;
        double bc = bx * cx + by * cy + bz * cz;
        double ac = ax * cx + ay * cy + az * cz;
        double bb = bx * bx + by * by + bz * bz;
        double scalar = ab * bc - ac * bb;
        double normsq = bb * bb * (ax * ax + ay * ay + az * az) * (cx * cx + cy * cy + cz * cz);
        double epsilon = 5.77E-5;
        return scalar * scalar < normsq * epsilon ? 192 : (scalar > 0.0 ? 64 : 128);
    }

    public boolean stepWedge() {
        if ((this.flags & 0x30) == 16) {
            this.setFlags(32, 48);
        } else {
            if ((this.flags & 0x30) == 32) {
                this.setFlags(0, 48);
                return false;
            }
            this.setFlags(16, 48);
        }
        return true;
    }

    public static boolean stepWedge(MolBond[] bs) {
        int i;
        if (bs.length == 0) {
            return false;
        }
        for (i = 0; i < bs.length && (bs[i].flags & 0x30) == 0; ++i) {
        }
        if (i == bs.length) {
            i = 0;
        }
        if (!bs[i].stepWedge()) {
            if (i < bs.length - 1) {
                bs[i + 1].stepWedge();
            } else {
                return false;
            }
        }
        return true;
    }

    public String getQuerystr() {
        return null;
    }

    public boolean haveEqualProperties(MolBond b) {
        return this.flags == b.flags;
    }

    protected boolean overridesAtMerge(MolBond e) {
        int t = this.getType();
        if (t == 4) {
            return true;
        }
        if (t < 4) {
            int t2 = e.getType();
            return t > t2;
        }
        return false;
    }

    public final boolean isQuery() {
        int bFlags = this.getFlags();
        int bType = this.getType();
        String qs = this.getQuerystr();
        if ((bType < 1 || bType > 4) && bType != 9 || (bFlags & 0xC00) != 0 || (bFlags & 0x200) != 0) {
            return true;
        }
        if (qs == null) {
            return false;
        }
        return !qs.equals("NONAROMATIC");
    }

    public boolean isCollinear(MolAtom atom) {
        double epsilon;
        double d2LengthSq;
        double d1LengthSq;
        double d1xd2z;
        double d1x;
        double d2x;
        double d1xd2y;
        double d2y;
        double z3;
        double d1z;
        double d2z;
        double x1 = this.theAtom1.getX();
        double y1 = this.theAtom1.getY();
        double z1 = this.theAtom1.getZ();
        double x2 = this.theAtom2.getX();
        double y2 = this.theAtom2.getY();
        double z2 = this.theAtom2.getZ();
        double x3 = atom.getX();
        double y3 = atom.getY();
        double d1y = y1 - y3;
        double d1xd2x = d1y * (d2z = z1 - z2) - (d1z = z1 - (z3 = atom.getZ())) * (d2y = y1 - y2);
        double d1xd2LengthSq = d1xd2x * d1xd2x + (d1xd2y = d1z * (d2x = x1 - x2) - (d1x = x1 - x3) * d2z) * d1xd2y + (d1xd2z = d1x * d2y - d1y * d2x) * d1xd2z;
        return d1xd2LengthSq < (d1LengthSq = d1x * d1x + d1y * d1y + d1z * d1z) * (d2LengthSq = d2x * d2x + d2y * d2y + d2z * d2z) * (epsilon = 0.0076);
    }

    private static void initDesiredLengths3D() {
        double[][][] blens3 = new double[109][109][8];
        for (int k = 0; k < 8; ++k) {
            for (int i = 0; i < blens3.length; ++i) {
                double l1 = MolAtom.covalentRadiusOf(i, k);
                blens3[i][i][k] = 2.0 * l1;
                for (int j = i + 1; j < blens3[i].length; ++j) {
                    double l2 = MolAtom.covalentRadiusOf(j, k);
                    blens3[i][j][k] = l1 + l2;
                }
            }
        }
        blens3[1][1][1] = 0.74;
        blens3[1][6][1] = 1.09;
        blens3[1][7][1] = 1.01;
        blens3[1][17][1] = 1.27;
        blens3[1][35][1] = 1.41;
        blens3[1][53][1] = 1.61;
        blens3[7][7][1] = 1.45;
        blens3[8][8][1] = 1.48;
        blens3[8][8][2] = 1.21;
        blens3[9][9][1] = 1.42;
        blens3[6][7][2] = 1.32;
        blens3[6][7][3] = 1.16;
        for (int i = 0; i < blens3.length; ++i) {
            for (int j = i + 1; j < blens3[i].length; ++j) {
                for (int k = 0; k < blens3[i][j].length; ++k) {
                    blens3[j][i][k] = blens3[i][j][k];
                }
            }
        }
        desiredLengths = blens3;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int type;
        oos.writeByte(3);
        oos.writeObject(this.getAtom1());
        oos.writeObject(this.getAtom2());
        oos.writeInt(this.index);
        oos.writeObject(this.parentGraph);
        int f = this.getFlags();
        byte stereo = 0;
        if ((f & 0x10) != 0) {
            stereo = (byte)(stereo | 1);
        }
        if ((f & 0x20) != 0) {
            stereo = (byte)(stereo | 2);
        }
        if ((f & 0x80) != 0) {
            stereo = (byte)(stereo | 4);
        }
        if ((f & 0x40) != 0) {
            stereo = (byte)(stereo | 8);
        }
        if ((f & 0x100) != 0) {
            stereo = (byte)(stereo | 0x10);
        }
        if ((f & 0x200) != 0) {
            stereo = (byte)(stereo | 0x20);
        }
        int extra = 0;
        if ((f & 0x400) != 0) {
            extra |= 1;
        }
        if ((f & 0x800) != 0) {
            extra |= 2;
        }
        if ((f & 0x40000000) != 0) {
            extra |= 4;
        }
        if ((type = f & 0xF) == 8) {
            extra |= 8;
        }
        if (type == 9) {
            extra |= 0x10;
        }
        if ((f & 0xF000) > 0) {
            if ((f & 0x3000) > 0) {
                extra |= 0x20;
            } else if ((f & 0x4000) > 0) {
                extra |= 0x40;
            } else if ((f & 0x2000) > 0) {
                extra |= 0x60;
            } else if ((f & 0x5000) > 0) {
                extra |= 0x80;
            } else if ((f & 0x6000) > 0) {
                extra |= 0x100;
            } else if ((f & 0x1000) > 0) {
                extra |= 0x120;
            } else if ((f & 0x7000) > 0) {
                extra |= 0x140;
            }
        }
        if ((f & Integer.MIN_VALUE) != 0) {
            extra |= 0x200;
        }
        int setseq = this.getSetSeq();
        if (stereo == 0 && extra == 0 && setseq == 0) {
            oos.writeByte(type);
        } else {
            oos.writeByte(type | 0x80);
            int control = 0;
            if (stereo != 0) {
                control |= 1;
            }
            if (extra != 0) {
                control |= 2;
            }
            if (setseq != 0) {
                control |= 4;
            }
            oos.writeByte(control);
            if ((control & 1) != 0) {
                oos.writeByte(stereo);
            }
            if ((control & 2) != 0) {
                oos.writeInt(extra);
            }
            if ((control & 4) != 0) {
                oos.writeInt(setseq);
            }
        }
    }

    void resetGrinv() {
        MoleculeGraph p;
        MolAtom a = this.theAtom1;
        if (a != null && (p = a.getParent()) != null) {
            do {
                p.incGrinvCC();
            } while ((p = p.getParent()) != null);
        }
    }

    void setAtom1(MolAtom node) {
        this.theAtom1 = node;
    }

    void setAtom2(MolAtom node) {
        this.theAtom2 = node;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int i) {
        this.index = i;
    }

    void setParent(MoleculeGraph g) {
        this.parentGraph = g;
    }

    protected final Object getLock() {
        MoleculeGraph p = this.parentGraph;
        return p != null ? p.getLock() : this;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 3) {
            throw new IOException("Cannot deserialize bond with future version (" + version + ")");
        }
        this.theAtom1 = (MolAtom)ois.readObject();
        this.theAtom2 = (MolAtom)ois.readObject();
        this.index = ois.readInt();
        this.parentGraph = (MoleculeGraph)ois.readObject();
        byte f0 = ois.readByte();
        int f = f0 & 0xF;
        int control = 0;
        if (version <= 2) {
            control = version == 0 ? 3 : 7;
        } else if ((f0 & 0x80) != 0) {
            control = ois.readByte();
        }
        if ((control & 1) != 0) {
            byte stereo = ois.readByte();
            if ((stereo & 1) != 0) {
                f |= 0x10;
            }
            if ((stereo & 2) != 0) {
                f |= 0x20;
            }
            if ((stereo & 4) != 0) {
                f |= 0x80;
            }
            if ((stereo & 8) != 0) {
                f |= 0x40;
            }
            if ((stereo & 0x10) != 0) {
                f |= 0x100;
            }
            if ((stereo & 0x20) != 0) {
                f |= 0x200;
            }
        }
        if ((control & 2) != 0) {
            int rcFlags;
            int extra;
            int n = extra = version <= 1 ? ois.readByte() : ois.readInt();
            if ((extra & 1) != 0) {
                f |= 0x400;
            }
            if ((extra & 2) != 0) {
                f |= 0x800;
            }
            if ((extra & 4) != 0) {
                f |= 0x40000000;
            }
            if ((extra & 8) != 0) {
                f |= 8;
            }
            if ((extra & 0x10) != 0) {
                f |= 9;
            }
            if ((rcFlags = extra & 0x1E0) > 0) {
                if (32 == rcFlags) {
                    f |= 0x3000;
                } else if (64 == rcFlags) {
                    f |= 0x4000;
                } else if (96 == rcFlags) {
                    f |= 0x2000;
                } else if (128 == rcFlags) {
                    f |= 0x5000;
                } else if (256 == rcFlags) {
                    f |= 0x6000;
                } else if (288 == rcFlags) {
                    f |= 0x1000;
                } else if (320 == rcFlags) {
                    f |= 0x7000;
                }
            }
            if ((extra & 0x200) != 0) {
                f |= Integer.MIN_VALUE;
            }
        }
        if ((control & 4) != 0) {
            int setseq = ois.readInt();
            f |= (setseq & 0x3F) << 24;
        }
        this.setFlags(f);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MolBond) {
            MolBond bond = (MolBond)obj;
            MolAtom a = bond.theAtom1;
            MolAtom b = bond.theAtom2;
            return a == this.theAtom1 && b == this.theAtom2 || a == this.theAtom2 && b == this.theAtom1;
        }
        return false;
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        StringBuffer sb = new StringBuffer(s);
        sb.append('[');
        int t = this.getType();
        if (t < bondNames.length) {
            sb.append(bondNames[t]);
        } else {
            sb.append("?(").append(t).append(")");
        }
        if (this.getSetSeq() != 0) {
            sb.append(",set");
            sb.append(this.getSetSeq());
        }
        sb.append(']');
        return sb.toString();
    }

    public final MolAtom getNode1() {
        return this.getAtom1();
    }

    public final MolAtom getNode2() {
        return this.getAtom2();
    }

    public final MolAtom getOtherNode(MolAtom node) {
        return this.getOtherAtom(node);
    }

    public final MolBond cloneEdge(MolAtom a1, MolAtom a2) {
        return this.cloneBond(a1, a2);
    }
}

