/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.IntVector;
import chemaxon.core.spi.HydrogenizeIface;
import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.core.spi.StructureExporterIface;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MObjectContainer;
import chemaxon.struc.MProp;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.gearch.MoleculeGearch;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;

public class Molecule
extends MoleculeGraph
implements MObjectContainer {
    private static final long serialVersionUID = 7275486436840296305L;
    private transient SelectionMolecule unifiedStructure = null;
    private transient long unifiedStructureCC = 0L;
    private transient ArrayList<Sgroup> sgroupVector = null;
    private transient long fileStartPosition = 0L;
    private transient long fileEndPosition = 0L;
    private transient String moleculeName = "";
    private transient String moleculeComment = "";
    private transient String inputFormat = null;
    public static final int RMCLEANUP_SGROUPATOMS = 8;
    public static final int RMCLEANUP_FROMSGROUPS = 16;
    protected static final int RMSG_DEFAULT = 0;
    protected static final int RMSG_KEEP_CHILDREN = 1;
    protected static final int RMSG_KEEP_PARENT = 2;
    protected static final int RMSG_KEEP_MULTICENTER = 3;
    public static final int RECURSIVE_UNGROUP = 1;
    public static final int DEFAULT_UNGROUP = 0;

    public Molecule(Molecule p, int na, int nb) {
        super(p, na, nb);
        String informat;
        if (p != null && (informat = p.getInputFormat()) != null) {
            this.inputFormat = informat;
        }
    }

    public Molecule(Molecule p, MolAtom a) {
        this(p, 1, 0);
        this.add(a);
    }

    public Molecule(Molecule p, MolBond b) {
        this(p, 0, 1);
        this.add(b);
    }

    public Molecule() {
        this(null, 32, 32);
    }

    @Override
    public void setDim(int d) {
        if (this.getSgroupCount() > 0) {
            SelectionMolecule u = this.getGraphUnionAsSelection();
            u.setDim(d);
        } else {
            super.setDim(d);
        }
        this.setFlags(this.getFlags() & 0xFFFFFFFC | d & 3);
        this.resetGrinvInParents();
    }

    @Override
    public void clear() {
        super.clear();
        this.fileStartPosition = 0L;
    }

    @Override
    public void clearForImport(String format2) {
        this.setInputFormat(format2);
        super.clearForImport(format2);
        this.fileEndPosition = 0L;
        this.sgroupVector = null;
        this.moleculeName = "";
        this.moleculeComment = "";
        if (this.unifiedStructure != null) {
            this.unifiedStructure.removeAll();
        }
    }

    public long getStartPosition() {
        return this.fileStartPosition;
    }

    public void setStartPosition(long off) {
        this.fileStartPosition = off;
    }

    public long getEndPosition() {
        return this.fileEndPosition;
    }

    public void setEndPosition(long off) {
        this.fileEndPosition = off;
    }

    @Override
    public String getName() {
        return this.moleculeName;
    }

    public void setName(String s) {
        this.moleculeName = s != null ? s : "";
    }

    public String getComment() {
        return this.moleculeComment;
    }

    public void setComment(String s) {
        this.moleculeComment = s != null ? s : "";
    }

    public final String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String format2) {
        this.inputFormat = format2;
    }

    public void clearProperties() {
        this.properties().clear();
    }

    public int getPropertyCount() {
        return this.properties().size();
    }

    public Enumeration getPropertyKeys() {
        return this.properties().getKeyEnumeration();
    }

    public String getPropertyKey(int i) {
        return this.properties().getKey(i);
    }

    @Deprecated
    public String getProperty(String key) {
        MPropHandlerIface PIface = null;
        try {
            PIface = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (PIface != null) {
            return PIface.convertToString(this.properties(), key);
        }
        return "";
    }

    public Object getPropertyObject(String key) {
        return this.properties().getObject(key);
    }

    public void setProperty(String key, String value) {
        this.properties().setString(key, value);
    }

    public void setPropertyObject(String key, Object value) {
        this.properties().setObject(key, value);
    }

    public static int residueTypeOf(String name) {
        return MolAtom.residueTypeOf(name);
    }

    public static String residueSymbolOf(int id) {
        return MolAtom.residueSymbolOf(id);
    }

    @Override
    protected void setAtom0(int i, MolAtom node) {
        SgroupAtom sgatom;
        SuperatomSgroup sg;
        MolAtom orig = this.getAtom(i);
        super.setAtom0(i, node);
        if (node instanceof SgroupAtom && this.indexOf(sg = (sgatom = (SgroupAtom)node).getSgroup()) < 0) {
            boolean consistent = sg.getSuperAtom() == sgatom;
            this.addSgroup(sg, consistent);
            sg.updateAttachmentPoints();
        }
        if (orig != null && this.sgroupVector != null) {
            boolean oldg = false;
            int origi = -1;
            for (int j = this.sgroupVector.size() - 1; j >= 0; --j) {
                Sgroup sg2 = this.sgroupVector.get(j);
                if (!(sg2 instanceof SuperatomSgroup)) continue;
                SuperatomSgroup supsg = (SuperatomSgroup)sg2;
                SgroupAtom sa = supsg.getSuperAtom();
                if (sa == node) {
                    oldg = true;
                } else if (sa == orig) {
                    origi = j;
                }
                int k = sg2.indexOf(orig);
                if (k < 0) continue;
                sg2.setAtom(k, node);
            }
            if (!oldg && origi >= 0) {
                if (node instanceof SgroupAtom) {
                    this.setSgroupAt(((SgroupAtom)node).getSgroup(), origi);
                } else {
                    this.removeSgroupAt(origi, 0);
                }
            }
        }
    }

    @Override
    public void removeAtom(MolAtom atom, int cleanupFlags) {
        int i = this.indexOf(atom);
        if (i >= 0) {
            this.removeAtom0(i, cleanupFlags);
        }
    }

    @Override
    public void removeAtom(int i, int cleanupFlags) {
        this.removeAtom0(i, cleanupFlags);
    }

    private void removeAtom0(int i, int cleanupFlags) {
        MolAtom a = this.getAtom(i);
        if (this.getSgroupCount() > 0) {
            if ((cleanupFlags & 8) != 0 && a instanceof SgroupAtom) {
                int j = this.sgroupVector.indexOf(((SgroupAtom)a).getSgroup());
                this.removeSgroupAt(j, 0);
            }
            if ((cleanupFlags & 0x10) != 0) {
                int k = 1;
                for (int j = this.getSgroupCount() - 1; j >= 0; j -= k) {
                    Sgroup sg = this.getSgroup(j);
                    if (sg.indexOf(a) == -1) continue;
                    sg.removeAtom(a);
                    k = 1;
                    if (!sg.isEmpty()) continue;
                    int c = this.getSgroupCount();
                    boolean isToRemove = true;
                    if (sg instanceof MulticenterSgroup) {
                        boolean bl = isToRemove = ((MulticenterSgroup)sg).getCentralAtom() == null;
                    }
                    if (!isToRemove) continue;
                    this.removeSgroupAt(j, 0);
                    k = c - this.getSgroupCount();
                }
            }
            if (this.sgroupVector.isEmpty()) {
                this.sgroupVector = null;
            }
        }
        super.removeAtom(i, cleanupFlags);
    }

    @Override
    protected void removeBond(MolBond bond, int cleanupFlags) {
        int n = this.bondCount;
        for (int i = 0; i < n; ++i) {
            if (this.theBonds[i] != bond) continue;
            this.removeBond0(i, cleanupFlags);
            return;
        }
    }

    @Override
    protected void removeBond(int i, int cleanupFlags) {
        this.removeBond0(i, cleanupFlags);
    }

    private void removeBond0(int i, int cleanupFlags) {
        if (this.sgroupVector != null && (cleanupFlags & 1) != 0) {
            SuperatomSgroup sg;
            MolBond b = this.theBonds[i];
            MolAtom a = b.getAtom1();
            if (a instanceof SgroupAtom) {
                sg = ((SgroupAtom)a).getSgroup();
                ((Sgroup)sg).removeBond(b);
            }
            if ((a = b.getAtom2()) instanceof SgroupAtom) {
                sg = ((SgroupAtom)a).getSgroup();
                ((Sgroup)sg).removeBond(b);
            }
            if ((cleanupFlags & 0x10) != 0) {
                for (int j = this.getSgroupCount() - 1; j >= 0; --j) {
                    this.getSgroup(j).removeBond(b);
                }
            }
        }
        super.removeBond(i, cleanupFlags);
    }

    @Override
    public void removeAllBonds() {
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                Sgroup sg = this.sgroupVector.get(i);
                sg.removeBonds();
            }
        }
        super.removeAllBonds();
    }

    @Override
    public void removeAll() {
        this.sgroupVector = null;
        super.removeAll();
    }

    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getSgroupCount(); ++i) {
            if (this.getSgroup(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void aromatize(int method) {
        this.aromatize(method, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aromatize(int method, boolean checkAmbiguity) {
        boolean hascg = this.isGUIContracted();
        if (hascg) {
            this.setGUIContracted(false);
        }
        try {
            super.aromatize(method, checkAmbiguity);
        }
        finally {
            if (hascg) {
                this.setGUIContracted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dearomatize() {
        boolean hascg = this.isGUIContracted();
        boolean r = false;
        if (hascg) {
            this.setGUIContracted(false);
        }
        try {
            r = super.dearomatize();
        }
        finally {
            if (hascg) {
                this.setGUIContracted(true);
            }
        }
        return r;
    }

    @Override
    public void clonecopy(MoleculeGraph g) {
        if (g instanceof Molecule) {
            Molecule m = (Molecule)g;
            this.clonecopyWithoutSgroups(m);
            this.clonecopySgroups(null, m, null);
        } else {
            super.clonecopy(g);
        }
    }

    @Override
    protected boolean fixSelfReferringProperty(MProp prop) {
        if (super.fixSelfReferringProperty(prop)) {
            return true;
        }
        MMoleculeProp newprop = new MMoleculeProp(this);
        this.propertyContainer.replace(prop, newprop);
        return true;
    }

    private void addChildSgroupClonesRecursively(Sgroup origsg, Sgroup newsg) {
        Sgroup origchild;
        int i;
        int n = newsg.getChildSgroupCount();
        Molecule origm = origsg.getParentMolecule();
        for (i = 0; i < n; ++i) {
            origchild = origsg.getChildSgroup(i);
            int k = origm.indexOf(origchild);
            Sgroup newchild = newsg.getChildSgroup(i);
            newchild.setParentMolecule(newsg.getParentMolecule());
            if (this.sgroupVector.get(k) == newchild) continue;
            this.sgroupVector.set(k, newchild);
        }
        for (i = 0; i < n; ++i) {
            origchild = origsg.getChildSgroup(i);
            Sgroup newchild = newsg.getChildSgroup(i);
            this.addChildSgroupClonesRecursively(origchild, newchild);
        }
    }

    protected final void addSgroupClones(Molecule origparentm, Molecule origm, Molecule newm) {
        int n = origparentm.getSgroupCount();
        if (n != 0) {
            int i;
            if (this.sgroupVector == null) {
                this.sgroupVector = new ArrayList(n);
                for (i = 0; i < n; ++i) {
                    this.sgroupVector.add(null);
                }
            } else if (this.sgroupVector.size() < n) {
                for (i = n - this.sgroupVector.size(); i > 0; --i) {
                    this.sgroupVector.add(null);
                }
            } else if (this.sgroupVector.size() > n) {
                for (i = this.sgroupVector.size() - 1; i >= n; --i) {
                    Sgroup sg = this.sgroupVector.get(i);
                    this.removeMulticenter(sg);
                    this.sgroupVector.remove(i);
                }
            }
            for (i = 0; i < n; ++i) {
                Sgroup origsg = origparentm.getSgroup(i);
                int k = origm.indexOf(origsg);
                if (k < 0) continue;
                this.sgroupVector.set(i, newm.getSgroup(k));
            }
        }
    }

    @Override
    public void clonecopy(int[] iatoms, MoleculeGraph g) {
        super.clonecopy(iatoms, g);
        if (g instanceof Molecule) {
            Molecule m = (Molecule)g;
            if (iatoms == null) {
                this.clonecopySgroups(null, m, null);
            } else if (iatoms != null) {
                IntVector sgvec = new IntVector();
                int na = iatoms.length;
                for (int i = 0; i < na; ++i) {
                    MolAtom a = this.theAtoms[iatoms[i]];
                    this.addSgroupIndices(a, iatoms, na, sgvec);
                }
                sgvec.sort();
                this.clonecopySgroups(sgvec, m, iatoms);
            }
        }
    }

    private void addSgroupIndices(MolAtom a, int[] iatoms, int na, IntVector sgvec) {
        int k;
        Sgroup sg = this.findSgroupOf(a);
        int n = k = sg != null ? this.indexOf(sg) : -1;
        while (k >= 0 && !sgvec.contains(k)) {
            sgvec.add(k);
            if (!(sg instanceof Expandable) || ((Expandable)((Object)sg)).isExpanded()) {
                for (int j = 0; j < sg.getAtomCount(); ++j) {
                    MolAtom aa = sg.getAtom(j);
                    if (Molecule.findInArray(this.theAtoms, iatoms, na, aa) >= 0) continue;
                    throw new IllegalArgumentException(sg.toString() + " cannot be cloned" + " without cloning " + aa + " also");
                }
            }
            k = (sg = sg.getParentSgroup()) != null ? this.indexOf(sg) : -1;
        }
    }

    protected void clonecopyWithoutSgroups(Molecule m) {
        super.clonecopy(m);
        m.fileStartPosition = this.fileStartPosition;
        m.fileEndPosition = this.fileEndPosition;
        m.moleculeName = this.moleculeName;
        m.moleculeComment = this.moleculeComment;
        m.inputFormat = this.inputFormat;
    }

    private void clonecopySgroups(IntVector sgvec, Molecule m, int[] atomIndexMap) {
        if (this.sgroupVector != null) {
            int i;
            int n;
            int n2 = n = sgvec != null ? sgvec.size() : this.sgroupVector.size();
            if (m.sgroupVector == null) {
                m.sgroupVector = new ArrayList(n);
            } else {
                m.sgroupVector.clear();
            }
            for (i = 0; i < n; ++i) {
                m.sgroupVector.add(null);
            }
            if (sgvec != null) {
                for (i = 0; i < n; ++i) {
                    this.addSgroupClone(i, sgvec.get(i), m, atomIndexMap);
                }
            } else {
                for (i = 0; i < n; ++i) {
                    this.addSgroupClone(i, i, m, atomIndexMap);
                }
            }
            for (i = 0; i < m.getSgroupCount(); ++i) {
                if (m.getSgroup(i) != null) continue;
                throw new RuntimeException("sgroups[" + i + "] == null " + "in clonecopy");
            }
        }
    }

    private void addSgroupClone(int i, int origi, Molecule m, int[] atomIndexMap) {
        Sgroup sg = this.sgroupVector.get(origi);
        if (sg.getParentMolecule() != this) {
            throw new RuntimeException("" + this + " is not a parent of child S-group: " + sg + ".parentMolecule=" + sg.getParentMolecule());
        }
        if (sg.getParentSgroup() == null) {
            Sgroup newsg = sg.cloneSgroup(m, null, atomIndexMap);
            m.sgroupVector.set(i, newsg);
            m.addChildSgroupClonesRecursively(sg, newsg);
        }
    }

    @Override
    public void clonelesscopy(MoleculeGraph g) {
        super.clonelesscopy(g);
        if (g instanceof Molecule) {
            Molecule m = (Molecule)g;
            m.fileStartPosition = this.fileStartPosition;
            m.fileEndPosition = this.fileEndPosition;
            m.moleculeName = this.moleculeName;
            m.moleculeComment = this.moleculeComment;
            m.inputFormat = this.inputFormat;
            if (m.getAtomCount() != 0) {
                this.clonecopySgroups(null, m, null);
            }
        }
    }

    public Molecule cloneMoleculeWithDocument() {
        MDocument doc = this.getDocument();
        return doc != null ? doc.cloneMainMolecule() : this.cloneMolecule();
    }

    public Molecule cloneMolecule() {
        Molecule m = new Molecule(null, this.atomCount, this.bondCount);
        this.clonecopy(m);
        return m;
    }

    @Override
    public final Object clone() {
        return this.cloneMolecule();
    }

    @Deprecated
    public final String toFormat(String fmt) {
        try {
            return this.exportToFormat(fmt);
        }
        catch (MolExportException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public final String exportToFormat(String fmt) throws MolExportException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.exportToFormat(this, fmt);
        }
        catch (MolExportException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    @Deprecated
    public final byte[] toBinFormat(String fmt) {
        try {
            return this.exportToBinFormat(fmt);
        }
        catch (MolExportException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public final byte[] exportToBinFormat(String fmt) throws MolExportException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.exportToBinFormat(this, fmt);
        }
        catch (MolExportException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    @Deprecated
    public Object toObject(String fmt) {
        try {
            return this.exportToObject(fmt);
        }
        catch (MolExportException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public Object exportToObject(String fmt) throws MolExportException {
        try {
            StructureExporterIface exporter = (StructureExporterIface)MarvinModule.load("chemaxon.formats.StructureExporterUtil");
            return exporter.exportToObject(this, fmt);
        }
        catch (MolExportException e) {
            throw e;
        }
        catch (IOException e) {
            throw new MolExportException(e);
        }
    }

    public MolAtom reuseAtom(int z, int i) {
        MolAtom a;
        MolAtom[] v = this.theAtoms;
        if (this.atomCount > i) {
            a = v[i];
            if (z == 135) {
                v[i] = a = new SgroupAtom(null);
            } else if (a.getClass() == MolAtom.class) {
                a.parentGraph = this;
                a.index = i;
                a.clear(z);
            } else {
                v[i] = a = new MolAtom(z);
            }
        } else {
            a = z == 135 ? new SgroupAtom(null) : new MolAtom(z);
            this.addAtom0(a);
        }
        return a;
    }

    public void endReuse(int n) {
        this.atomCount = n;
        this.resetCtab();
    }

    @Override
    public MoleculeGraph newInstance() {
        Molecule m = new Molecule();
        this.makeItSimilar(m);
        return m;
    }

    public SelectionMolecule newSelectionMolecule() {
        return new SelectionMolecule();
    }

    @Override
    protected void makeItSimilar(MoleculeGraph g) {
        super.makeItSimilar(g);
        if (g instanceof Molecule) {
            Molecule m = (Molecule)g;
            m.inputFormat = this.inputFormat;
        }
    }

    public final Molecule getSimplifiedMolecule() {
        MDocument doc = this.getDocument();
        boolean nodoc = doc == null || doc != null && doc.isSimpleMolecule();
        return nodoc ? this.getMostSimplifiedMolecule() : this;
    }

    protected Molecule getMostSimplifiedMolecule() {
        return this;
    }

    @Override
    public boolean isMolecule() {
        return true;
    }

    public boolean isReaction() {
        return false;
    }

    public boolean canBeReactionComponent() {
        return true;
    }

    public boolean isSgroup() {
        if (this.getSgroupCount() == 1) {
            Sgroup sg = this.getSgroup(0);
            MoleculeGraph umol = this.getGraphUnion();
            if (umol.getAtomCount() == 1 && umol.getAtom(0) instanceof SgroupAtom) {
                return true;
            }
            for (int i = 0; i < umol.getAtomCount(); ++i) {
                MolAtom a = umol.getAtom(i);
                if (sg.indexOf(a) >= 0) continue;
                if (sg instanceof SuperatomSgroup) {
                    if (((SuperatomSgroup)sg).isLegalAttachment(a)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public MolAtom[] getSgroupLigands() {
        if (this.getSgroupCount() == 1) {
            MoleculeGraph umol = this.getGraphUnion();
            ArrayList<MolAtom> v = new ArrayList<MolAtom>();
            for (int i = 0; i < umol.getAtomCount(); ++i) {
                MolAtom a = umol.getAtom(i);
                Sgroup sg = this.findSgroupOf(a);
                if (sg != null) continue;
                if (a.getBondCount() != 1) {
                    return null;
                }
                MolAtom aa = a.getLigand(0);
                if (this.findSgroupOf(aa) == null) {
                    return null;
                }
                v.add(a);
            }
            MolAtom[] ligands = new MolAtom[v.size()];
            v.toArray(ligands);
            return ligands;
        }
        return null;
    }

    public final Sgroup findExpandableSgroup() {
        if (this.sgroupVector != null) {
            for (int i = this.sgroupVector.size() - 1; i >= 0; --i) {
                Sgroup sg = this.sgroupVector.get(i);
                if (!(sg instanceof Expandable) || ((Expandable)((Object)sg)).isExpanded()) continue;
                return sg;
            }
        }
        return null;
    }

    public final Sgroup findContractableSgroup() {
        if (this.sgroupVector != null) {
            for (int i = this.sgroupVector.size() - 1; i >= 0; --i) {
                Sgroup sg = this.sgroupVector.get(i);
                if (!(sg instanceof Expandable) || !((Expandable)((Object)sg)).isExpanded()) continue;
                return sg;
            }
        }
        return null;
    }

    public final Sgroup[] getSgroupArray() {
        if (this.sgroupVector == null) {
            return new Sgroup[0];
        }
        Sgroup[] arr = new Sgroup[this.sgroupVector.size()];
        this.sgroupVector.toArray(arr);
        return arr;
    }

    public final int getSgroupCount() {
        return this.sgroupVector == null ? 0 : this.sgroupVector.size();
    }

    public final int countExpandableContractableSgroups() {
        int count = 0;
        for (int i = 0; i < this.getSgroupCount(); ++i) {
            Sgroup sg = this.getSgroup(i);
            if (!(sg instanceof Expandable)) continue;
            ++count;
        }
        return count;
    }

    public final int countOrderedComponentSgroups() {
        int count = 0;
        if (this.sgroupVector != null) {
            int n = this.getSgroupCount();
            for (int i = 0; i < n; ++i) {
                if (!this.getSgroup(i).isOrderedComponentSgroup()) continue;
                ++count;
            }
        }
        return count;
    }

    public final Sgroup getSgroup(int i) {
        return this.sgroupVector.get(i);
    }

    public final Sgroup[] getSortedSgroups() {
        if (this.sgroupVector == null) {
            return new Sgroup[0];
        }
        Sgroup[] sgroups = new Sgroup[this.sgroupVector.size()];
        this.sgroupVector.toArray(sgroups);
        Sgroup.sort(sgroups, 1);
        return sgroups;
    }

    public final Sgroup[] getRootSgroups() {
        if (this.sgroupVector == null) {
            return new Sgroup[0];
        }
        Sgroup[] roots = new Sgroup[this.sgroupVector.size()];
        int nRoots = 0;
        for (int i = 0; i < this.sgroupVector.size(); ++i) {
            Sgroup sg = this.sgroupVector.get(i);
            if (sg.getParentSgroup() != null) continue;
            roots[nRoots++] = sg;
        }
        Sgroup[] toReturn = new Sgroup[nRoots];
        System.arraycopy(roots, 0, toReturn, 0, nRoots);
        return toReturn;
    }

    public void sortSgroupXBonds() {
        for (int j = 0; j < this.getSgroupCount(); ++j) {
            Sgroup sg = this.getSgroup(j);
            if (sg.getType() != 0) continue;
            ((SuperatomSgroup)sg).sortXBonds();
        }
    }

    public final int indexOf(Sgroup sg) {
        return this.sgroupVector != null ? this.sgroupVector.indexOf(sg) : -1;
    }

    public final Sgroup findSgroupOf(MolAtom a) {
        for (int i = this.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = this.getSgroup(i);
            if ((sg = sg.findSmallestSgroupOf(a)) == null) continue;
            return sg;
        }
        return null;
    }

    public final Sgroup findSgroupContaining(MolAtom a) {
        for (int i = this.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = this.getSgroup(i);
            if (sg.indexOf(a) < 0) continue;
            for (Sgroup psg = sg.getParentSgroup(); psg != null && psg.indexOf(a) >= 0; psg = psg.getParentSgroup()) {
                sg = psg;
            }
            return sg;
        }
        return null;
    }

    public final Sgroup findSmallestSgroupContaining(MolAtom a) {
        for (int i = this.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = this.getSgroup(i);
            if ((sg = sg.findSmallestSgroupContaining(a)) == null) continue;
            return sg;
        }
        return null;
    }

    public Sgroup[] findAllSgroupContaining(MolAtom a) {
        HashSet<Sgroup> set = new HashSet<Sgroup>();
        for (int i = this.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = this.getSgroup(i);
            if ((sg = sg.findSmallestSgroupContaining(a)) == null) continue;
            set.add(sg);
        }
        Sgroup[] sg = new Sgroup[set.size()];
        set.toArray(sg);
        return sg;
    }

    @Override
    public boolean contains(MolAtom atom) {
        boolean contains = super.contains(atom);
        if (!contains) {
            contains = this.isParentOf(atom);
        }
        return contains;
    }

    private boolean isParentOf(MolAtom atom) {
        boolean hasParent;
        boolean bl = hasParent = this.indexOf(atom) > -1;
        if (!hasParent) {
            for (int i = 0; i < this.getSgroupCount() && !hasParent; ++i) {
                SgroupAtom superAtom;
                if (atom instanceof SgroupAtom && (superAtom = (SgroupAtom)atom).getSgroup() == this.getSgroup(i) || this.getSgroup(i).getType() != 0 || this.getSgroup(i).getXState() == 1) continue;
                hasParent = this.getSgroup(i).hasAtom(atom);
            }
        }
        return hasParent;
    }

    public void setSgroupParent(MolAtom a, Sgroup sg, boolean set) {
        int atc;
        if (!this.isParentOf(a)) {
            throw new IllegalArgumentException("Molecule does not contain atom " + a);
        }
        if (set) {
            this.addSgroup(sg, true);
            if (sg.indexOf(a) < 0) {
                sg.add(a);
                for (int i = 0; i < a.getBondCount(); ++i) {
                    MolBond b = a.getBond(i);
                    MolAtom aa = b.getOtherAtom(a);
                    if (!sg.sgroupGraph.contains(aa) || sg.sgroupGraph.contains(b)) continue;
                    sg.sgroupGraph.add(b);
                }
            }
        } else {
            sg.removeAtom(a);
        }
        if ((atc = a.getAttach()) != 0) {
            Sgroup attachParentSgroup = null;
            if (set) {
                for (attachParentSgroup = sg; attachParentSgroup != null && attachParentSgroup.getType() == 10; attachParentSgroup = attachParentSgroup.getParentSgroup()) {
                }
            }
            a.setAttach(atc, attachParentSgroup);
        }
    }

    private void removeSgroup(Sgroup sg) {
        if (sg == null) {
            return;
        }
        int j = this.sgroupVector.indexOf(sg);
        if (j >= 0) {
            this.removeSgroupAt(j, 1);
            if (this.sgroupVector.size() == 0) {
                this.sgroupVector = null;
            }
        }
    }

    protected final void reparentSgroups(Molecule p) {
        for (int i = 0; i < p.getAtomCount(); ++i) {
            MolAtom a = p.getAtom(i);
            Sgroup sg = this.findSgroupOf(a);
            if (sg == null) continue;
            p.addSgroup(sg, true);
        }
    }

    @Override
    public void mergeAtoms(MolAtom that, MolAtom node) {
        if (that == node) {
            return;
        }
        MolAtom a = node;
        Sgroup[] sgs = this.findAllSgroupContaining(a);
        for (int j = 0; j < sgs.length; ++j) {
            Sgroup sg = sgs[j];
            if (that instanceof SgroupAtom && sg != null) {
                sg.addChildSgroup(((SgroupAtom)that).getSgroup());
            }
            if (sg == null) continue;
            sg.replaceAtom(a, that);
        }
        SuperatomSgroup nsg = null;
        if (a instanceof SgroupAtom) {
            int i;
            nsg = ((SgroupAtom)a).getSgroup();
            int n = i = nsg != null ? this.indexOf(nsg) : -1;
            if (i >= 0) {
                this.removeSgroupAt(i, 0);
                nsg = null;
            }
        }
        super.mergeAtoms(that, node);
        if (nsg != null) {
            this.setSgroupParent(that, nsg, true);
        }
        for (int j = 0; j < sgs.length; ++j) {
            Sgroup sg = sgs[j];
            if (sg == null) continue;
            this.setSgroupParent(that, sg, true);
        }
    }

    @Override
    protected void addAtom0(MolAtom node) {
        MoleculeGraph p;
        Sgroup sg;
        if (node instanceof SgroupAtom) {
            SgroupAtom sgatom = (SgroupAtom)node;
            sg = sgatom.getSgroup();
            boolean consistent = ((SuperatomSgroup)sg).getSuperAtom() == sgatom;
            this.addSgroup(sg, consistent);
        }
        if ((p = node.getParent()) != null && p instanceof Molecule) {
            sg = ((Molecule)p).findSgroupContaining(node);
            if (sg != null) {
                this.addSgroup(sg, true);
            }
            Sgroup[] sgroups = ((Molecule)p).findAllSgroupContaining(node);
            for (int i = 0; i < sgroups.length; ++i) {
                sg = sgroups[i];
                if (sg.getType() != 10) continue;
                this.addSgroup(sg, true);
            }
        }
        super.addAtom0(node);
    }

    @Override
    protected void addAtomToFragment(MolAtom atom) {
        if (atom instanceof SgroupAtom) {
            SgroupAtom sgatom = (SgroupAtom)atom;
            SuperatomSgroup sg = sgatom.getSgroup();
            boolean consistent = sg.getSuperAtom() == sgatom;
            this.addSgroup(sg, consistent);
        }
        MoleculeGraph p = atom.getParent();
        super.addAtom0(atom);
        if (!(atom instanceof SgroupAtom) && p != null && p instanceof Molecule && p != this) {
            this.addAllContainedSgroups((Molecule)p, atom);
        }
    }

    private boolean containsSgroupAtoms(Sgroup sg) {
        if (sg instanceof MulticenterSgroup) {
            return this.contains(sg.sgroupGraph) && this.contains(((MulticenterSgroup)sg).getCentralAtom());
        }
        if (sg instanceof SuperatomSgroup) {
            return this.contains(sg.sgroupGraph) || this.contains(((SuperatomSgroup)sg).getSuperAtom());
        }
        return this.contains(sg.sgroupGraph);
    }

    private void addAllContainedSgroups(Molecule molecule, MolAtom atom) {
        MulticenterSgroup msg = molecule.findContainingMulticenterSgroup(atom);
        if (msg != null && this.containsSgroupAtoms(msg)) {
            this.addSgroup(msg, true);
        }
        Sgroup[] sgroups = molecule.findAllSgroupContaining(atom);
        for (int i = 0; i < sgroups.length; ++i) {
            Sgroup biggestContainingSgroup = null;
            for (Sgroup sg = sgroups[i]; sg != null && this.containsSgroupAtoms(sg); sg = sg.getParentSgroup()) {
                biggestContainingSgroup = sg;
            }
            if (biggestContainingSgroup == null) continue;
            this.addSgroup(biggestContainingSgroup, true);
        }
    }

    @Override
    protected void addBond0(MolBond bond) {
        block2: {
            Sgroup sg2;
            Sgroup sg1;
            block3: {
                super.addBond0(bond);
                MolAtom a1 = bond.getAtom1();
                MolAtom a2 = bond.getAtom2();
                sg1 = this.findSmallestSgroupContaining(a1);
                sg2 = this.findSmallestSgroupContaining(a2);
                if (sg1 == null || sg2 == null) break block2;
                if (sg1 != sg2 && !sg1.isDescendantOf(sg2) || sg1.sgroupGraph.contains(bond)) break block3;
                sg1.sgroupGraph.add(bond);
                Sgroup psg = sg1;
                while ((psg = psg.getParentSgroup()) != null) {
                    if (psg.sgroupGraph.contains(bond)) continue;
                    psg.sgroupGraph.add(bond);
                }
                break block2;
            }
            if (!sg2.isDescendantOf(sg1) || sg2.sgroupGraph.contains(bond)) break block2;
            sg2.sgroupGraph.add(bond);
            Sgroup psg = sg2;
            while ((psg = psg.getParentSgroup()) != null) {
                if (psg.sgroupGraph.contains(bond)) continue;
                psg.sgroupGraph.add(bond);
            }
        }
    }

    public final boolean contractSgroups() {
        return this.contractSgroups(0);
    }

    private final boolean contractSgroups(int opts) {
        if (!this.isGUIContracted()) {
            this.setGUIContracted(true);
        }
        boolean success = false;
        if (this.sgroupVector != null) {
            long[] oldGrinvCC = null;
            if ((opts & 2) != 0) {
                oldGrinvCC = this.saveGrinvCC();
            }
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                Sgroup sg = this.sgroupVector.get(i);
                if (!(sg instanceof Expandable) || sg.getParentSgroup() != null || !sg.isVisible()) continue;
                Expandable x = (Expandable)((Object)sg);
                success = x.contract(opts) || success;
            }
            if ((opts & 2) != 0) {
                this.restoreGrinvCC(oldGrinvCC);
            }
        }
        if ((opts & 2) != 0) {
            this.restoreCache(0);
        }
        return success;
    }

    public final boolean expandSgroups() {
        return this.expandSgroups(0);
    }

    public final boolean expandSgroups(int opts) {
        boolean success = false;
        if ((opts & 2) != 0) {
            this.saveCache(0);
        }
        if (this.sgroupVector != null) {
            long[] oldGrinvCC = null;
            if ((opts & 2) != 0) {
                oldGrinvCC = this.saveGrinvCC();
            }
            this.setGUIContracted(true);
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                Sgroup sg = this.sgroupVector.get(i);
                if (sg.getParentSgroup() != null) continue;
                boolean r = sg.expandRecursively(opts);
                success |= r;
            }
            if ((opts & 2) != 0) {
                this.restoreGrinvCC(oldGrinvCC);
            }
        }
        return success;
    }

    public final boolean isExpandable(int opts) {
        for (int i = 0; i < this.getSgroupCount(); ++i) {
            Sgroup sg = this.getSgroup(i);
            if (!(sg instanceof Expandable)) continue;
            Expandable xsg = (Expandable)((Object)sg);
            if (!xsg.isExpanded()) {
                return true;
            }
            if (sg.getXState() != 3 || (opts & 2) != 0) continue;
            return true;
        }
        return false;
    }

    public final void setGUIContracted(boolean v) {
        this.setGUIContracted(v, 0);
    }

    public final void setGUIContracted(boolean v, int opts) {
        long[] saved = null;
        int nsg = this.getSgroupCount();
        for (int i = 0; i < nsg; ++i) {
            Sgroup sg = this.getSgroup(v ? nsg - i - 1 : i);
            if (sg.getParentSgroup() != null) continue;
            if (saved == null) {
                saved = this.saveGrinvCC();
            }
            if (!sg.setGUIStateRecursively(v, opts)) continue;
            this.unifiedStructure = null;
        }
        if (saved != null) {
            this.restoreGrinvCC(saved);
        }
    }

    public final boolean isGUIContracted() {
        for (int i = 0; i < this.getSgroupCount(); ++i) {
            Sgroup sg = this.getSgroup(i);
            if (sg.getXState() != 2) continue;
            return true;
        }
        return false;
    }

    public final boolean ungroupSgroup(Sgroup sg) {
        return this.ungroupSgroup(sg, 1);
    }

    public final boolean ungroupSgroup(Sgroup sg, int opts) {
        int i;
        int n = i = this.sgroupVector != null ? this.sgroupVector.indexOf(sg) : -1;
        if (i >= 0) {
            Molecule pmol = sg.getParentMolecule();
            if (pmol == this) {
                return this.ungroupSgroup(i, opts);
            }
            return pmol.ungroupSgroup(sg, opts);
        }
        return false;
    }

    public final boolean ungroupSgroup(int i) {
        return this.ungroupSgroup(i, 1);
    }

    public final boolean ungroupSgroups(int type) {
        int sgroupCount = this.getSgroupCount();
        int k = 0;
        for (int i = this.getSgroupCount() - 1; i >= 0; i -= k) {
            k = 1;
            Sgroup s = this.getSgroup(i);
            if (s.getType() != type) continue;
            int c = this.getSgroupCount();
            this.ungroupSgroup(s);
            k = c - this.getSgroupCount();
        }
        return sgroupCount != this.getSgroupCount();
    }

    public final boolean ungroupSgroup(int i, int opts) {
        if (this.sgroupVector != null) {
            int j;
            Sgroup sg = this.sgroupVector.get(i);
            if (sg instanceof Expandable) {
                ((Expandable)((Object)sg)).expand(4);
            }
            int k = 0;
            if ((opts & 1) != 0) {
                for (j = this.sgroupVector.size() - 1; j >= 0; j -= k) {
                    Sgroup sg2 = this.sgroupVector.get(j);
                    k = 1;
                    if (sg2.getParentSgroup() != sg) continue;
                    if (sg2 instanceof Expandable) {
                        int c = this.sgroupVector.size();
                        this.ungroupSgroup(j);
                        k = c - this.sgroupVector.size();
                        continue;
                    }
                    sg.removeChildSgroup(sg2);
                }
            }
            if (sg.getType() != 10) {
                for (j = 0; j < sg.getAtomCount(); ++j) {
                    MolAtom a = sg.getAtom(j);
                    if (a.getAttach() == 0) continue;
                    a.setAttach(0);
                    a.valenceCheck();
                }
            }
            if ((opts & 1) != 0) {
                this.removeSgroupAt(this.indexOf(sg), 0);
            } else {
                Sgroup parent = sg.getParentSgroup();
                for (int j2 = sg.getChildSgroupCount() - 1; j2 >= 0; --j2) {
                    Sgroup child = sg.getChildSgroup(j2);
                    sg.removeChildSgroup(child);
                    if (parent == null) continue;
                    parent.addChildSgroup(child);
                }
                this.removeSgroupAt(this.indexOf(sg), 1);
            }
            return true;
        }
        return false;
    }

    private long[] saveGrinvCC() {
        MoleculeGraph p = this;
        int n = 1;
        while ((p = p.getParent()) != null) {
            ++n;
        }
        long[] oldGrinvCC = new long[n];
        p = this;
        for (int i = 0; i < n; ++i) {
            oldGrinvCC[i] = p.getGrinvCC();
            p = p.getParent();
        }
        return oldGrinvCC;
    }

    private void restoreGrinvCC(long[] oldGrinvCC) {
        MoleculeGraph p = this;
        for (int i = 0; i < oldGrinvCC.length; ++i) {
            p.setGrinvCC(oldGrinvCC[i]);
            p = p.getParent();
        }
    }

    public final boolean ungroupSgroups() {
        boolean expanded = this.expandSgroups();
        MoleculeGraph u = this.getGraphUnion();
        int nsg = this.getSgroupCount();
        for (int i = 0; i < u.getAtomCount(); ++i) {
            boolean insg;
            MolAtom a = u.getAtom(i);
            Sgroup sg = this.findSmallestSgroupContaining(a);
            boolean bl = insg = sg != null;
            if (a.getAtno() == 137) {
                this.removeSgroup(this.findContainingMulticenterSgroup(a));
            }
            while (sg != null) {
                Sgroup psg = sg.getParentSgroup();
                this.setSgroupParent(a, sg, false);
                sg = psg;
            }
            if (!insg || a.getAttach() == 0) continue;
            a.setAttach(0);
            a.valenceCheck();
        }
        if (this.sgroupVector != null) {
            this.sgroupVector.clear();
        }
        return expanded || this.getSgroupCount() != nsg;
    }

    protected final void addSgroupsOf(Molecule m) {
        ArrayList<Sgroup> v = m.sgroupVector;
        if (v != null) {
            if (this.sgroupVector == null) {
                this.sgroupVector = new ArrayList();
            }
            for (int i = 0; i < v.size(); ++i) {
                Sgroup sg = v.get(i);
                if (this.sgroupVector.contains(sg)) continue;
                this.sgroupVector.add(sg);
            }
            if (this.parentGraph != null && this.parentGraph instanceof Molecule) {
                Molecule p = (Molecule)this.parentGraph;
                p.addSgroupsOf(m);
            }
        }
    }

    protected final void removeSgroupsOf(Molecule m, int rmflags) {
        ArrayList<Sgroup> v = m.sgroupVector;
        if (v != null) {
            for (int i = v.size() - 1; i >= 0 && this.sgroupVector != null; --i) {
                Sgroup sg = v.get(i);
                int j = this.sgroupVector.indexOf(sg);
                if (j < 0) continue;
                this.removeSgroupAt(j, rmflags);
            }
        }
    }

    protected final void removeSgroupsOf(Molecule m) {
        this.removeSgroupsOf(m, 0);
    }

    protected void removeAllSgroups() {
        this.sgroupVector = null;
    }

    protected void removeSgroupFromList(Sgroup sg) {
        ArrayList<Sgroup> v = this.sgroupVector;
        if (v != null) {
            v.remove(sg);
        }
    }

    public void addSgroup(Sgroup sg, boolean setparent) {
        if (setparent) {
            Molecule oldParent = sg.getParentMolecule();
            sg.setParentMolecule(this);
            if (oldParent != null && oldParent.indexOf(sg) != -1) {
                if (oldParent != this) {
                    oldParent.removeChildSgroupsRecursively(sg, 3);
                }
                oldParent.removeSgroupAt(oldParent.indexOf(sg), 3);
            }
        }
        this.addSgroup0(sg);
        sg.sgroupGraph.setDim(this.getDim());
        this.resetCtab();
    }

    private void addSgroup0(Sgroup sg) {
        if (this.sgroupVector == null) {
            this.sgroupVector = new ArrayList();
        }
        if (!this.sgroupVector.contains(sg)) {
            this.sgroupVector.add(sg);
        }
        this.addChildSgroupsRecursively(sg);
        if (this.parentGraph != null && this.parentGraph instanceof Molecule) {
            Molecule p = (Molecule)this.parentGraph;
            p.addSgroup0(sg);
        }
    }

    private void addChildSgroupsRecursively(Sgroup sg) {
        Sgroup child;
        int i;
        int n = sg.getChildSgroupCount();
        for (i = 0; i < n; ++i) {
            child = sg.getChildSgroup(i);
            child.setParentMolecule(sg.getParentMolecule());
            if (this.sgroupVector.contains(child)) continue;
            this.sgroupVector.add(child);
        }
        for (i = 0; i < n; ++i) {
            child = sg.getChildSgroup(i);
            this.addChildSgroupsRecursively(child);
        }
    }

    private void setSgroupAt(Sgroup sg, int i) {
        Sgroup old = this.sgroupVector.get(i);
        this.sgroupVector.set(i, sg);
        this.removeChildSgroupsRecursively(old, 0);
        this.addChildSgroupsRecursively(sg);
        if (this.parentGraph != null && this.parentGraph instanceof Molecule) {
            Molecule p = (Molecule)this.parentGraph;
            p.setSgroupAt(sg, p.sgroupVector.indexOf(old));
        }
    }

    private void removeMulticenter(Sgroup sg) {
        MolAtom center;
        if (sg instanceof MulticenterSgroup && (center = ((MulticenterSgroup)sg).getCentralAtom()) != null) {
            super.removeAtom(center, 1);
            ((MulticenterSgroup)sg).setCentralAtom(null);
        }
    }

    private void removeSgroupAt(int i, int rmflags) {
        Sgroup sg = this.getSgroup(i);
        this.removeSgroupRecursivelyAt(i, rmflags);
        Sgroup p = sg.getParentSgroup();
        if (p != null && (rmflags & 2) == 0) {
            p.removeChildSgroup(sg);
        }
        if ((rmflags & 1) == 0) {
            sg.removeChildren();
        }
    }

    private void removeSgroupRecursivelyAt(int i, int rmflags) {
        if (this.sgroupVector != null) {
            Sgroup sg = this.sgroupVector.get(i);
            if ((rmflags & 3) == 0) {
                this.removeMulticenter(sg);
            }
            this.sgroupVector.remove(i);
            if ((rmflags & 1) == 0) {
                this.removeChildSgroupsRecursively(sg, rmflags);
            }
            if (this.parentGraph != null && this.parentGraph instanceof Molecule) {
                Molecule p = (Molecule)this.parentGraph;
                if (p.sgroupVector != null) {
                    int k = p.sgroupVector.indexOf(sg);
                    if (k >= 0) {
                        p.removeSgroupRecursivelyAt(k, rmflags);
                    }
                    if ((rmflags & 1) == 0) {
                        p.removeChildSgroupsRecursively(sg, rmflags);
                    }
                }
            }
        }
    }

    private void removeChildSgroupsRecursively(Sgroup sg, int rmflags) {
        for (int i = sg.getChildSgroupCount() - 1; i >= 0; --i) {
            Sgroup child = sg.getChildSgroup(i);
            this.removeChildSgroupsRecursively(child, rmflags);
            if ((rmflags & 3) == 0) {
                this.removeMulticenter(child);
            }
            this.sgroupVector.remove(child);
            if ((rmflags & 1) != 0) continue;
            if (this.parentGraph != null && this.parentGraph instanceof Molecule) {
                Molecule p = (Molecule)this.parentGraph;
                int k = p.sgroupVector.indexOf(sg);
                if (k >= 0) continue;
                sg.removeChildSgroup(child);
                continue;
            }
            sg.removeChildSgroup(child);
        }
    }

    protected final SelectionMolecule getGraphUnionAsSelection() {
        SelectionMolecule m = this.unifiedStructure;
        if (m == null || this.grinvCC != this.unifiedStructureCC || m.getGrinvCC() != this.unifiedStructureCC) {
            this.unifiedStructure = m = new SelectionMolecule();
            this.fillSelectionMolecule(m);
            this.unifiedStructureCC = m.grinvCC = this.grinvCC;
        }
        m.setFlags(this.getFlags());
        m.setLocation(this.getLocation());
        return m;
    }

    @Override
    public double bondlength() {
        MoleculeGraph m = this.getGraphUnion();
        return m == this ? super.bondlength() : m.bondlength();
    }

    public final Molecule[] convertToFrags() {
        this.setGUIContracted(false);
        return (Molecule[])this.findFrags(Molecule.class, 1);
    }

    public final SelectionMolecule[] findFrags() {
        return (SelectionMolecule[])this.findFrags(SelectionMolecule.class, 1);
    }

    protected void fillSelectionMolecule(SelectionMolecule s) {
        s.setFlags(this.getFlags());
        this.addAtomsAndBondsTo(s);
    }

    public void clearExtraLabels() {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            this.getAtom(i).clearExtraLabel();
        }
    }

    @Override
    public void checkConsistency() {
        super.checkConsistency();
        this.checkSgroupConsistency();
    }

    protected void checkSgroupConsistency() {
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                SuperatomSgroup superatomSgroup;
                Sgroup sg = this.sgroupVector.get(i);
                if (sg.getParentMolecule() != this) {
                    String msg = "" + sg + ".parent=" + sg.getParentMolecule() + " != this=" + this;
                    throw new RuntimeException(msg);
                }
                if (sg.getType() == 0 && (superatomSgroup = (SuperatomSgroup)sg).isContracted()) {
                    MolAtom[] atoms = superatomSgroup.getAtomArray();
                    for (int j = 0; j < atoms.length; ++j) {
                        if (this.isParentOf(atoms[j])) continue;
                        String msg = "this=" + this + " is not a parent of atom=" + atoms[j] + " in " + sg;
                        throw new RuntimeException(msg);
                    }
                }
                if (sg.getType() == 10) continue;
                for (int j = i + 1; j < this.sgroupVector.size(); ++j) {
                    Sgroup otherGroup = this.sgroupVector.get(j);
                    if (otherGroup.getType() == 10) continue;
                    if (sg.containsAllAtomsOf(otherGroup)) {
                        if (otherGroup.containsAllAtomsOf(sg) || otherGroup.isDescendantOf(sg)) continue;
                        String msg = "Embedding error in Molecule " + this + " S-group " + otherGroup + " should be descendant of " + sg;
                        throw new RuntimeException(msg);
                    }
                    if (otherGroup.containsAllAtomsOf(sg)) {
                        if (sg.containsAllAtomsOf(otherGroup) || sg.isDescendantOf(otherGroup)) continue;
                        String msg = "Embedding error in Molecule " + this + " S-group " + sg + " should be descendant of " + otherGroup;
                        throw new RuntimeException(msg);
                    }
                    this.checkOverlapping(sg, otherGroup);
                }
            }
        }
    }

    private void checkOverlapping(Sgroup sg, Sgroup otherGroup) {
        if (sg.getType() == 14 && otherGroup.getType() == 14) {
            if (this.checkLigandOverlapping((MulticenterSgroup)sg, (MulticenterSgroup)otherGroup)) {
                String msg = "In Molecule " + this + " the ligand connected to multicenters of S-groups " + sg + " and " + otherGroup + " overlap.";
                throw new RuntimeException(msg);
            }
        } else {
            for (int k = 0; k < otherGroup.getAtomCount(); ++k) {
                int l;
                if (!sg.hasAtom(otherGroup.getAtom(k))) continue;
                System.out.println(sg + " atoms ");
                for (l = 0; l < sg.getAtomCount(); ++l) {
                    System.out.print(sg.getAtom(l) + " ");
                }
                System.out.println();
                System.out.println(otherGroup + " atoms ");
                for (l = 0; l < otherGroup.getAtomCount(); ++l) {
                    System.out.print(otherGroup.getAtom(l) + " ");
                }
                System.out.println();
                String msg = "In Molecule " + this + " S-groups " + sg + " and " + otherGroup + " overlap.";
                throw new RuntimeException(msg);
            }
        }
    }

    private boolean checkLigandOverlapping(MulticenterSgroup sg, MulticenterSgroup otherGroup) {
        return sg.getCentralAtom().getBondCount() == 1 && otherGroup.getCentralAtom().getBondCount() == 1 && sg.getCentralAtom().getLigand(0) == otherGroup.getCentralAtom().getLigand(0) && sg.hasNonCoordinateBond() && otherGroup.hasNonCoordinateBond();
    }

    @Override
    public double[] getVisibleCoords(MolAtom ma) {
        if (ma instanceof SgroupAtom) {
            return new double[]{ma.getX(), ma.getY(), ma.getZ()};
        }
        for (int i = 0; i < this.getSgroupCount(); ++i) {
            int xState;
            Sgroup sgroup = this.getSgroup(i);
            if (sgroup.getType() != 0 || (xState = sgroup.getXState()) != 3 && xState != 2 && xState != 0 || !sgroup.hasAtom(ma)) continue;
            return this.getVisibleCoords(((SuperatomSgroup)sgroup).getSuperAtom());
        }
        return new double[]{ma.getX(), ma.getY(), ma.getZ()};
    }

    @Override
    public void transform(CTransform3D t, boolean incg) {
        super.transform(t, incg);
        for (int i = 0; i < this.getSgroupCount(); ++i) {
            Sgroup sg = this.sgroupVector.get(i);
            if (sg.getParentMolecule() != this) continue;
            sg.transformByParent(t, incg);
        }
    }

    public MulticenterSgroup findContainingMulticenterSgroup(MolAtom atom) {
        for (int i = this.getSgroupCount() - 1; i >= 0; --i) {
            MulticenterSgroup msg;
            Sgroup sg = this.getSgroup(i);
            if (!(sg instanceof MulticenterSgroup) || (msg = (MulticenterSgroup)sg).getCentralAtom() != atom) continue;
            return msg;
        }
        return null;
    }

    @Override
    protected MoleculeGraphGearch createGearch() {
        return new MoleculeGearch(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        oos.writeLong(this.getStartPosition());
        oos.writeLong(this.getEndPosition());
        oos.writeObject(this.getInputFormat());
        oos.writeObject(this.getName());
        oos.writeObject(this.getComment());
        int n = this.getSgroupCount();
        oos.writeInt(n);
        for (int i = 0; i < n; ++i) {
            oos.writeObject(this.getSgroup(i));
        }
        int opts = 0;
        oos.writeByte(opts);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int n;
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize molecule with future version (" + version + ")");
        }
        this.fileStartPosition = ois.readLong();
        this.fileEndPosition = ois.readLong();
        this.inputFormat = (String)ois.readObject();
        this.moleculeName = (String)ois.readObject();
        this.moleculeComment = (String)ois.readObject();
        if (version == 0) {
            this.propertyContainer.clear();
            this.propertyContainer.readExternal(ois);
        }
        if ((n = ois.readInt()) != 0) {
            this.sgroupVector = new ArrayList();
        }
        for (int i = 0; i < n; ++i) {
            Sgroup sg = (Sgroup)ois.readObject();
            this.sgroupVector.add(sg);
            SelectionMolecule g = sg.sgroupGraph;
            if (sg.getParentMolecule() != this || g.getBondCount() != 0) continue;
            g.regenBonds();
        }
    }

    @Override
    public void clearObjects() {
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                this.sgroupVector.get(i).clearObjects();
            }
        }
    }

    @Override
    public int getObjectCount() {
        int count = 0;
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                count += this.sgroupVector.get(i).getBracketCount();
            }
        }
        return count;
    }

    @Override
    public void removeObject(MObject mo) {
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                this.sgroupVector.get(i).removeObject(mo);
            }
        }
    }

    @Override
    public void selectAllObjects(boolean s) {
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                this.sgroupVector.get(i).selectAllObjects(s);
            }
        }
    }

    @Override
    public List<MObject> getAllObjects() {
        ArrayList<MObject> list = new ArrayList<MObject>();
        if (this.sgroupVector != null) {
            for (int i = 0; i < this.sgroupVector.size(); ++i) {
                if (this.sgroupVector.get(i).getBracketCount() == 0 || !this.sgroupVector.get(i).isVisible() || this.sgroupVector.get(i) instanceof Expandable && this.sgroupVector.get(i).getXState() != 2) continue;
                list.addAll(this.sgroupVector.get(i).getBrackets());
            }
        }
        return list;
    }

    public void replaceSgroup(Sgroup sgroup, Sgroup newSgroup) {
        Sgroup parent;
        int index = this.sgroupVector.indexOf(sgroup);
        this.sgroupVector.set(index, newSgroup);
        if (this.parentGraph != null && this.parentGraph instanceof Molecule) {
            Molecule p = (Molecule)this.parentGraph;
            p.replaceSgroup(sgroup, newSgroup);
        }
        if ((parent = sgroup.getParentSgroup()) != null && !newSgroup.isDescendantOf(parent)) {
            parent.addChildSgroup(newSgroup);
            parent.removeChildSgroup(sgroup);
        }
        for (int i = sgroup.getChildSgroupCount() - 1; i >= 0; --i) {
            Sgroup child = sgroup.getChildSgroup(i);
            sgroup.removeChildSgroup(child);
            newSgroup.addChildSgroup(child);
        }
    }

    @Override
    protected boolean implicitizeHydrogens0(int f, MolAtom[] atoms, boolean check) {
        HydrogenizeIface hydrogenize = null;
        try {
            hydrogenize = (HydrogenizeIface)MarvinModule.load("chemaxon.calculations.hydrogenize.HydrogenizeUtil");
        }
        catch (SecurityException sex) {
            throw sex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (hydrogenize != null) {
            BitSet h = null;
            if ((f & 0x100) == 0) {
                h = this.convertPolymerEndHtoPseudo();
            }
            boolean success = hydrogenize.removeHAtoms(this, atoms, f, check);
            if (h != null && (f & 0x100) == 0) {
                int j = h.nextSetBit(0);
                while (j >= 0) {
                    if (j < this.getAtomCount()) {
                        MolAtom H = this.getAtom(j);
                        H.setAtno(1);
                    }
                    j = h.nextSetBit(j + 1);
                }
            }
            return success;
        }
        return false;
    }

    private BitSet convertPolymerEndHtoPseudo() {
        BitSet changed = new BitSet(this.getAtomCount());
        int l = this.getSgroupCount();
        for (int i = 0; i < l; ++i) {
            Sgroup sg = this.getSgroup(i);
            if (sg.getType() == 0 || sg.getType() == 10) continue;
            for (int j = sg.getAtomCount() - 1; j >= 0; --j) {
                MolAtom a = sg.getAtom(j);
                for (int k = a.getBondCount() - 1; k >= 0; --k) {
                    MolAtom ligand = a.getLigand(k);
                    if (ligand.getAtno() != 1 || sg.indexOf(ligand) >= 0) continue;
                    ligand.setAtno(136);
                    changed.set(this.indexOf(ligand));
                }
            }
        }
        return changed;
    }

    @Override
    @Deprecated
    public void mergeFrags() {
        this.gearch.mergeFrags(1);
    }

    @Override
    void update(MolBond bond) {
        if (this.isAutomaticUngroup()) {
            this.ungroupRemoveableSgroups(this.findAllSgroupContaining(bond.theAtom1));
            this.ungroupRemoveableSgroups(this.findAllSgroupContaining(bond.theAtom2));
        }
    }

    private void ungroupRemoveableSgroups(Sgroup[] sg) {
        for (int i = 0; i < sg.length; ++i) {
            if (!sg[i].isRemovable()) continue;
            this.ungroupSgroup(sg[i], 0);
        }
    }

    @Override
    void update(MolAtom atom) {
        if (this.isAutomaticUngroup()) {
            this.ungroupRemoveableSgroups(this.findAllSgroupContaining(atom));
        }
    }

    void setAutomaticUngroup(boolean on) {
        this.setFlags(16, 16);
    }

    boolean isAutomaticUngroup() {
        return (this.getFlags() & 0x10) != 0;
    }

    int calcAtomCountWithExpandedSgroups() {
        int atomCount = this.getAtomCount();
        if (this.sgroupVector != null && this.isGUIContracted()) {
            for (Sgroup group : this.sgroupVector) {
                if (group.getXState() != 2) continue;
                if (group.getType() == 1) {
                    atomCount += this.getExpandedAtomCount((MultipleSgroup)group);
                }
                if (group.getType() != 0) continue;
                atomCount += this.getExpandedAtomCount((SuperatomSgroup)group);
            }
        }
        return atomCount;
    }

    private int getExpandedAtomCount(MultipleSgroup group) {
        int count = 0;
        int extendedCount = (group.getMultiplier() - 1) * group.getAtomCount();
        count += extendedCount;
        MultipleSgroup parent = this.getContractedMultipleSgroupParent(group);
        if (parent != null) {
            count += (parent.getMultiplier() - 1) * extendedCount;
        }
        return count;
    }

    private MultipleSgroup getContractedMultipleSgroupParent(Sgroup group) {
        Sgroup parent;
        for (parent = group.getParentSgroup(); parent != null && (parent.getType() != 1 || parent.getXState() != 2); parent = parent.getParentSgroup()) {
        }
        return (MultipleSgroup)parent;
    }

    private int getExpandedAtomCount(SuperatomSgroup group) {
        int count = 0;
        int extendedCount = group.getAtomCount() - 1;
        count += extendedCount;
        MultipleSgroup parent = this.getContractedMultipleSgroupParent(group);
        if (parent != null) {
            count += (parent.getMultiplier() - 1) * extendedCount;
        }
        return count;
    }
}

