/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class QueryBond
extends MolBond {
    private static final long serialVersionUID = -5025485107616067648L;
    private transient String querystr = null;

    public QueryBond(MolAtom a1, MolAtom a2) {
        this(a1, a2, null);
    }

    public QueryBond(MolAtom a1, MolAtom a2, int flags) {
        super(a1, a2, flags);
    }

    public QueryBond(MolAtom a1, MolAtom a2, String s) {
        super(a1, a2, 0);
        this.querystr = s;
    }

    public QueryBond(QueryBond b) {
        super(b);
        this.querystr = b.querystr;
    }

    @Override
    public String getQuerystr() {
        return this.querystr;
    }

    public void setQuerystr(String s) {
        this.querystr = s == null || s.length() == 0 ? null : s;
    }

    @Override
    public boolean haveEqualProperties(MolBond e) {
        if (!(e instanceof QueryBond) && !super.haveEqualProperties(e)) {
            return false;
        }
        QueryBond b = (QueryBond)e;
        return this.querystr == null && b.querystr == null || this.querystr != null && b.querystr != null && !this.querystr.equals(b.querystr);
    }

    @Override
    public MolBond cloneBond(MolAtom a1, MolAtom a2) {
        QueryBond newQueryBond = new QueryBond(a1, a2, this.getFlags());
        newQueryBond.setQuerystr(this.getQuerystr());
        return newQueryBond;
    }

    @Override
    public Object clone() {
        return new QueryBond(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        int f = this.querystr != null ? 1 : 0;
        oos.writeByte(f);
        if ((f & 1) != 0) {
            oos.writeObject(this.querystr);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize QueryBond with future version (" + version + ")");
        }
        byte f = ois.readByte();
        if ((f & 1) != 0) {
            this.querystr = (String)ois.readObject();
        }
    }
}

