/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.core.util.BondTable;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import chemaxon.struc.gearch.SelectionMoleculeGearch;
import java.util.Arrays;
import java.util.HashMap;

public class SelectionMolecule
extends MoleculeGraph {
    @Override
    protected boolean isRealAtomParent() {
        return false;
    }

    @Override
    public void setBond(int i, MolBond bond) {
        this.theBonds[i] = bond;
        this.resetCtab();
    }

    @Override
    public void add(MolBond bond) {
        this.addBond0(bond);
        this.resetCtab();
    }

    public void swapAtoms(int i, int j) {
        MolAtom a = this.theAtoms[i];
        this.theAtoms[i] = this.theAtoms[j];
        this.theAtoms[j] = a;
    }

    @Override
    public void removeAtom(MolAtom atom) {
        this.removeAtom(atom, 0);
    }

    @Override
    public void removeAtom(int i) {
        this.removeAtom(i, 0);
    }

    @Override
    public void removeBond(MolBond bond) {
        this.removeBond(bond, 0);
    }

    @Override
    public void removeBond(int i) {
        this.removeBond(i, 0);
    }

    @Override
    protected void addAtom0(MolAtom atom) {
        this.addAtomWithoutChangingIt(atom);
        this.resetCtab();
    }

    @Override
    protected void setAtom0(int i, MolAtom atom) {
        this.theAtoms[i] = atom;
    }

    @Override
    protected void addBond0(MolBond bond) {
        this.addBondWithoutChangingIt(bond);
        this.resetCtab();
    }

    @Override
    protected void regenCtabs() {
        int na = this.atomCount;
        this.ctab = new int[na][];
        this.btab = BondTable.createBondTable(na);
        int[] tmp = new int[na];
        HashMap<MolBond, Integer> bondMap = this.createBondMap();
        for (int i = 0; i < na; ++i) {
            MolBond[] bonds;
            MolAtom a = this.theAtoms[i];
            int k = 0;
            for (MolBond b : bonds = this.getBonds(a)) {
                int iaa;
                int ib;
                Arrays.asList(bonds).indexOf(b);
                MolAtom aa = b.getOtherAtom(a);
                int n = ib = bondMap.containsKey(b) ? bondMap.get(b) : -1;
                if (ib < 0 || (iaa = this.findAtom(aa)) < 0) continue;
                tmp[k++] = iaa;
                this.btab.setBondIndex(i, iaa, ib);
            }
            this.ctab[i] = new int[k];
            System.arraycopy(tmp, 0, this.ctab[i], 0, k);
        }
    }

    private HashMap<MolBond, Integer> createBondMap() {
        int nb = this.bondCount;
        HashMap<MolBond, Integer> bondMap = new HashMap<MolBond, Integer>(nb);
        for (int i = 0; i < nb; ++i) {
            bondMap.put(this.theBonds[i], i);
        }
        return bondMap;
    }

    @Override
    protected void fuse0(MoleculeGraph g, boolean check) {
        int j;
        int i;
        if (g instanceof MoleculeGraph) {
            this.updateDim(g);
        }
        int na = this.atomCount;
        int nb = this.bondCount;
        for (i = 0; i < g.getAtomCount(); ++i) {
            MolAtom node = g.getAtom(i);
            int n = j = check ? this.indexOf(node) : -1;
            if (j >= 0) continue;
            this.addAtom0(node);
        }
        for (i = 0; i < g.getBondCount(); ++i) {
            MolBond edge = g.getBond(i);
            int n = j = check ? this.indexOf(edge) : -1;
            if (j >= 0) continue;
            this.addBond0(edge);
        }
        if (this.atomCount != na || this.bondCount != nb) {
            this.resetCtab();
        }
    }

    @Override
    public void transform(CTransform3D t) {
        this.transform(t, true);
    }

    @Override
    public void clonecopy(MoleculeGraph graph) {
        super.clonecopy(graph);
        this.fixParents(graph);
    }

    @Override
    protected boolean clonecopyMoleculeGraphWithoutSgroups(int[] iatoms, MolBond[] cbonds, int nb, MoleculeGraph g) {
        boolean xbondFound = super.clonecopyMoleculeGraphWithoutSgroups(iatoms, cbonds, nb, g);
        this.fixParents(g);
        return xbondFound;
    }

    private void fixParents(MoleculeGraph graph) {
        int i = 0;
        while (i < graph.getAtomCount()) {
            MolAtom a = graph.getAtom(i);
            a.parentGraph = graph;
            a.index = i++;
        }
        for (i = 0; i < graph.getBondCount(); ++i) {
            MolBond e = graph.getBond(i);
            e.setParent(graph);
            e.setIndex(i);
        }
    }

    @Override
    public Object clone() {
        SelectionMolecule g = new SelectionMolecule();
        this.clonecopy(g);
        return g;
    }

    @Override
    protected boolean isGrinvCCValid() {
        return false;
    }

    @Override
    protected void checkBondConsistency() {
    }

    @Override
    protected MoleculeGraphGearch createGearch() {
        return new SelectionMoleculeGearch(this);
    }
}

