/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class Sgroup
implements Serializable {
    private static final long serialVersionUID = -6209766549185582411L;
    public static final int SGROUP_TYPE_COUNT = 16;
    public static final int ST_SUPERATOM = 0;
    public static final int ST_MULTIPLE = 1;
    public static final int ST_SRU = 2;
    public static final int ST_MONOMER = 3;
    public static final int ST_MER = 4;
    public static final int ST_COPOLYMER = 5;
    public static final int ST_CROSSLINK = 6;
    public static final int ST_MODIFICATION = 7;
    public static final int ST_MIXTURE = 8;
    public static final int ST_FORMULATION = 9;
    public static final int ST_DATA = 10;
    public static final int ST_ANY = 11;
    public static final int ST_GENERIC = 12;
    public static final int ST_COMPONENT = 13;
    public static final int ST_MULTICENTER = 14;
    public static final int ST_GRAFT = 15;
    public static final int SST_ALTERNATING = 1;
    public static final int SST_RANDOM = 2;
    public static final int SST_BLOCK = 3;
    public static final int SCN_EITHER_UNKNOWN = 0;
    public static final int SCN_HEAD_TO_HEAD = 1;
    public static final int SCN_HEAD_TO_TAIL = 2;
    public static final int XSTATE_NONE = 0;
    public static final int XSTATE_X = 1;
    public static final int XSTATE_C = 2;
    public static final int XSTATE_XC = 3;
    public static final int SORT_PARENT_CHILD = 1;
    public static final int SORT_CHILD_PARENT = 2;
    public static final int PR_ATSYMS = 1;
    protected static final int RA_IN_EXPAND = 1;
    protected static final int RA_REMOVE_EXCEPT_RU = 2;
    public static final int CHARGE_ON_ATOMS = 1;
    public static final int CHARGE_ON_GROUP = 2;
    private transient Molecule parentMolecule;
    protected transient Sgroup parentSgroup;
    private transient Sgroup[] children;
    protected transient int sgroupType;
    private transient int sgroupSubType = 0;
    private transient String sgroupSubscript = null;
    protected transient SelectionMolecule sgroupGraph = new SelectionMolecule();
    private transient int sgroupConnectivity = 0;
    private transient int expandedState = 0;
    protected transient ArrayList<MBracket> brackets = null;
    private transient int attributes = 1;

    public Sgroup(Molecule parent, int t) {
        this(parent, t, 1);
    }

    public Sgroup(Molecule parent, int t, int xstate) {
        this.parentMolecule = parent;
        this.sgroupType = t;
        this.expandedState = xstate;
    }

    protected Sgroup(Sgroup sg, Molecule m, Sgroup psg) {
        this(sg, m, psg, null);
    }

    protected Sgroup(Sgroup sg, Molecule m, Sgroup psg, int[] iatoms) {
        int k;
        int j;
        if (psg != null && psg.getParentMolecule() != m) {
            throw new IllegalArgumentException("new parent molecule differs from the new parent S-group's parent molecule");
        }
        int[] atomIndexMap = null;
        if (iatoms != null && sg.getParentMolecule() != null) {
            int i;
            atomIndexMap = new int[sg.getParentMolecule().getAtomCount()];
            for (i = 0; i < atomIndexMap.length; ++i) {
                atomIndexMap[i] = -1;
            }
            for (i = 0; i < iatoms.length; ++i) {
                atomIndexMap[iatoms[i]] = i;
            }
        }
        boolean partialCloning = iatoms != null && atomIndexMap != null && iatoms.length != atomIndexMap.length;
        this.sgroupGraph = sg.cloneStructure();
        if (sg.brackets != null) {
            this.brackets = new ArrayList();
            int n = sg.brackets.size();
            for (int i = 0; i < n; ++i) {
                this.brackets.add((MBracket)sg.brackets.get(i).clone());
            }
        }
        this.sgroupType = sg.sgroupType;
        this.sgroupSubType = sg.sgroupSubType;
        this.sgroupConnectivity = sg.sgroupConnectivity;
        this.sgroupSubscript = sg.sgroupSubscript;
        this.attributes = sg.attributes;
        this.parentMolecule = m;
        this.parentSgroup = psg;
        this.expandedState = sg.expandedState;
        for (j = 0; j < sg.sgroupGraph.getAtomCount(); ++j) {
            MolAtom aa;
            MolAtom a;
            block23: {
                block22: {
                    a = sg.sgroupGraph.getAtom(j);
                    k = sg.parentMolecule != null ? sg.parentMolecule.indexOf(a) : -1;
                    aa = null;
                    if (k < 0) break block22;
                    if (m == null) break block23;
                    if (atomIndexMap == null) {
                        aa = m.getAtom(k);
                    } else if (atomIndexMap[k] != -1) {
                        aa = m.getAtom(atomIndexMap[k]);
                    }
                    if (aa == null) break block23;
                    this.sgroupGraph.setAtom(j, aa);
                    break block23;
                }
                if (sg.parentSgroup != null && (k = sg.parentSgroup.indexOf(a)) >= 0) {
                    aa = this.parentSgroup.getAtom(k);
                    this.sgroupGraph.setAtom(j, aa);
                } else {
                    aa = this.getAtom(j);
                    for (k = 0; k < aa.getBondCount(); ++k) {
                        MolBond b = aa.getBond(k);
                        int l = sg.sgroupGraph.indexOf(b);
                        if (l < 0) continue;
                        aa.theBonds[k] = this.sgroupGraph.getBond(l);
                    }
                }
            }
            if (aa == null || a.getAttachParentSgroup() != sg) continue;
            aa.setAttach(aa.getAttach(), this);
        }
        if (m != null) {
            if (!partialCloning) {
                for (j = 0; j < sg.sgroupGraph.getBondCount(); ++j) {
                    MolBond b = sg.sgroupGraph.getBond(j);
                    int n = k = sg.parentMolecule != null ? sg.parentMolecule.indexOf(b) : -1;
                    if (k < 0) continue;
                    this.sgroupGraph.theBonds[j] = m.getBond(k);
                }
            } else {
                for (j = 0; j < this.getAtomCount(); ++j) {
                    MolAtom atom = this.getAtom(j);
                    for (k = 0; k < atom.getBondCount(); ++k) {
                        MolBond bond = atom.getBond(k);
                        if (this.indexOf(bond) != -1 || this.indexOf(bond.getOtherAtom(atom)) == -1) continue;
                        this.sgroupGraph.add(bond);
                    }
                }
            }
        }
        if (sg.children == null) {
            this.children = null;
        } else {
            this.children = new Sgroup[sg.children.length];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = sg.children[i].cloneSgroup(m, this, iatoms);
            }
        }
    }

    public void setSgroupGraph(SelectionMolecule smol) {
        this.sgroupGraph = smol;
        for (int i = 0; i < smol.getAtomCount(); ++i) {
            MolAtom a = smol.getAtom(i);
            int atc = a.getAttach();
            if (atc == 0) continue;
            a.setAttach(atc, this);
        }
    }

    public SelectionMolecule getSgroupGraph() {
        SelectionMolecule smol = new SelectionMolecule();
        smol.fuse(this.sgroupGraph);
        return smol;
    }

    protected final void setParentMolecule(Molecule p) {
        this.parentMolecule = p;
    }

    public final Molecule getParentMolecule() {
        return this.parentMolecule;
    }

    public final int getChildSgroupCount() {
        return this.children != null ? this.children.length : 0;
    }

    public final Sgroup getChildSgroup(int i) {
        return this.children[i];
    }

    public final void addChildSgroup(Sgroup sg) {
        Sgroup[] tmp;
        if (sg.parentSgroup == null) {
            if (this.children == null) {
                tmp = new Sgroup[]{sg};
            } else {
                tmp = new Sgroup[this.children.length + 1];
                System.arraycopy(this.children, 0, tmp, 0, tmp.length - 1);
                tmp[tmp.length - 1] = sg;
            }
        } else {
            if (sg.parentSgroup == this) {
                throw new IllegalArgumentException("Sgroup already added");
            }
            throw new IllegalArgumentException("Sgroup cannot be added to more than one parent");
        }
        this.children = tmp;
        sg.parentSgroup = this;
        sg.parentMolecule = this.parentMolecule;
    }

    public final void removeChildSgroup(Sgroup sg) {
        if (sg.parentSgroup == this) {
            int k = -1;
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] != sg) continue;
                    k = i;
                    break;
                }
            }
            if (k < 0) {
                throw new IllegalArgumentException("Sgroup cannot be found in children list of its parent");
            }
            if (this.children.length == 1) {
                this.children = null;
            } else {
                Sgroup[] tmp = new Sgroup[this.children.length - 1];
                System.arraycopy(this.children, 0, tmp, 0, k);
                System.arraycopy(this.children, k + 1, tmp, k, tmp.length - k);
                this.children = tmp;
            }
        } else {
            if (sg.parentSgroup == null) {
                throw new IllegalArgumentException("Sgroup already removed");
            }
            throw new IllegalArgumentException("Sgroup cannot be removed from children list of non-parent group");
        }
        sg.parentSgroup = null;
    }

    void removeChildren() {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Sgroup child = this.children[i];
                if (child.parentSgroup != this) continue;
                child.parentSgroup = null;
            }
            this.children = null;
        }
    }

    public final Sgroup findSmallestSgroupContaining(MolAtom a) {
        if (this.indexOf(a) < 0) {
            return null;
        }
        for (int i = 0; i < this.getChildSgroupCount(); ++i) {
            Sgroup child = this.getChildSgroup(i);
            Sgroup sg = child.findSmallestSgroupContaining(a);
            if (sg == null) continue;
            return sg;
        }
        return this;
    }

    public final Sgroup findSmallestSgroupOf(MolAtom a) {
        if (!this.hasAtom(a)) {
            return null;
        }
        for (int i = 0; i < this.getChildSgroupCount(); ++i) {
            Sgroup child = this.getChildSgroup(i);
            Sgroup sg = child.findSmallestSgroupOf(a);
            if (sg == null) continue;
            return sg;
        }
        return this;
    }

    public final Sgroup getParentSgroup() {
        return this.parentSgroup;
    }

    public final int getXState() {
        return this.expandedState;
    }

    public final void setXState(int state) {
        this.setXState(state, 0);
    }

    public final void setXState(int state, int opts) throws IllegalArgumentException {
        int old = this.getXState();
        if (old == state) {
            return;
        }
        if (old == 2) {
            if (state == 1) {
                this.expand(4);
            } else if (state == 3) {
                this.expand(6 | opts);
            }
        } else if (old == 1) {
            if (state == 2) {
                this.contract(4);
            } else if (state == 3) {
                this.contract(4);
                this.expand(6);
            }
        } else if (old == 3) {
            if (state == 2) {
                this.contract(6);
            } else if (state == 1) {
                this.contract(4);
                this.expand(4);
            }
        }
    }

    protected void setXState0(int state) {
        this.expandedState = state;
    }

    boolean expandRecursively(int opts) throws IllegalArgumentException {
        boolean changed = this.expand(opts);
        for (int i = 0; i < this.getChildSgroupCount(); ++i) {
            Sgroup sg = this.getChildSgroup(i);
            changed |= sg.expandRecursively(opts);
        }
        return changed;
    }

    public boolean setGUIStateRecursively(boolean v) {
        return this.setGUIStateRecursively(v, 0);
    }

    public boolean setGUIStateRecursively(boolean v, int opts) throws IllegalArgumentException {
        boolean changed = false;
        if (v) {
            for (int i = 0; i < this.getChildSgroupCount(); ++i) {
                Sgroup sg = this.getChildSgroup(i);
                changed |= sg.setGUIStateRecursively(v, opts);
            }
            if (this.getXState() == 3) {
                this.setXState(2);
                changed = true;
            }
        } else {
            if (this.getXState() == 2) {
                this.setXState(3, opts);
                changed = true;
            }
            for (int i = 0; i < this.getChildSgroupCount(); ++i) {
                Sgroup sg = this.getChildSgroup(i);
                changed |= sg.setGUIStateRecursively(v, opts);
            }
        }
        return changed;
    }

    protected boolean expand(int f) throws IllegalArgumentException {
        this.expandedState = this.expandedState != 1 && (f & 1) != 0 ? 0 : ((f & 2) != 0 ? 3 : 1);
        return true;
    }

    protected boolean contract(int opts) throws IllegalArgumentException {
        this.expandedState = 2;
        return true;
    }

    public String getSuperscript() {
        if (this.sgroupConnectivity == 1) {
            return "hh";
        }
        if (this.sgroupConnectivity == 2) {
            return "ht";
        }
        if (this.sgroupConnectivity == 0) {
            return "";
        }
        return "";
    }

    public boolean isOrderedComponentSgroup() {
        if (this.getType() == 13) {
            if (this.sgroupSubscript == null) {
                return false;
            }
            return !this.sgroupSubscript.substring(1).equals("");
        }
        return false;
    }

    public String getSubscript() {
        if (this.sgroupType == 13) {
            return this.sgroupSubscript == null ? "c" : this.sgroupSubscript;
        }
        if (this.sgroupType == 8) {
            return "mix";
        }
        if (this.sgroupType == 9) {
            return "f";
        }
        if (this.sgroupType == 5 && this.sgroupSubType == 2) {
            return "ran";
        }
        if (this.sgroupType == 5 && this.sgroupSubType == 1) {
            return "alt";
        }
        if (this.sgroupType == 5 && this.sgroupSubType == 3) {
            return "blk";
        }
        if (this.sgroupType == 5 && this.sgroupSubType == 0) {
            return "co";
        }
        if (this.sgroupType == 11) {
            return "any";
        }
        if (this.sgroupType == 6) {
            return "xl";
        }
        if (this.sgroupType == 15) {
            return "grf";
        }
        if (this.sgroupType == 4) {
            return "mer";
        }
        if (this.sgroupType == 7) {
            return "mod";
        }
        if (this.sgroupType == 3) {
            return "mon";
        }
        if (this.sgroupSubscript != null) {
            return this.sgroupSubscript;
        }
        if (this.sgroupType == 12) {
            return "";
        }
        if (this.sgroupType == 10) {
            return "";
        }
        if (this.sgroupType == 2 && this.sgroupSubscript == null) {
            return "n";
        }
        return "";
    }

    public void setSubscript(String s) {
        this.sgroupSubscript = s;
    }

    public int getType() {
        return this.sgroupType;
    }

    public int getSubType() {
        return this.sgroupSubType;
    }

    public void setSubType(int t) {
        this.sgroupSubType = t;
    }

    public int getConnectivity() {
        return this.sgroupConnectivity;
    }

    public void setConnectivity(int c) {
        this.sgroupConnectivity = c;
    }

    public boolean hasBrackets() {
        return true;
    }

    public final SelectionMolecule cloneStructure() {
        return (SelectionMolecule)this.sgroupGraph.clone();
    }

    public Molecule createMolecule() {
        Molecule m = new Molecule();
        this.createMolecule(m);
        return m;
    }

    public Sgroup createMolecule(Molecule m) {
        Sgroup sg2 = this.cloneSgroup(null, null);
        m.fuse(sg2.sgroupGraph);
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            m.setSgroupParent(a, sg2, true);
        }
        return sg2;
    }

    public final MolAtom[] getAtomArray() {
        return this.sgroupGraph.getAtomArray();
    }

    public final MolAtom getAtom(int i) {
        return this.sgroupGraph.getAtom(i);
    }

    public final int countAllAtoms() {
        int n = 0;
        for (int i = this.sgroupGraph.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = this.sgroupGraph.getAtom(i);
            n += a.countAllAtoms();
        }
        return n;
    }

    public final boolean isEmpty() {
        return this.sgroupGraph.getAtomCount() == 0;
    }

    public final Sgroup cloneSgroup(Molecule m, Sgroup psg) {
        return this.cloneSgroup(m, psg, null);
    }

    protected Sgroup cloneSgroup(Molecule m, Sgroup psg, int[] atomIndexMap) {
        return new Sgroup(this, m, psg, atomIndexMap);
    }

    public final int getAtomCount() {
        return this.sgroupGraph.getAtomCount();
    }

    public int indexOf(MolAtom a) {
        return this.sgroupGraph.indexOf(a);
    }

    public int indexOf(MolBond b) {
        return this.sgroupGraph.indexOf(b);
    }

    public boolean hasAtom(MolAtom a) {
        if (this.indexOf(a) >= 0) {
            return true;
        }
        for (int i = 0; i < this.getAtomCount(); ++i) {
            SgroupAtom superAtom;
            MolAtom atom = this.getAtom(i);
            if (atom.getAtno() != 135 || !(superAtom = (SgroupAtom)atom).getSgroup().hasAtom(a)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAllAtomsOf(Sgroup sg) {
        int n = sg.getAtomCount();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            MolAtom a = sg.getAtom(i);
            if (this.hasAtom(a)) continue;
            return false;
        }
        return true;
    }

    public void add(MolAtom a) {
        if (this.indexOf(a) == -1) {
            this.sgroupGraph.add(a);
        }
    }

    public void setAtom(int i, MolAtom a) {
        this.sgroupGraph.setAtom(i, a);
    }

    public void removeBonds() {
        this.sgroupGraph.removeAllBonds();
    }

    public final void removeAtom(MolAtom a) {
        this.removeAtom(a, 0);
    }

    protected void removeAtom(MolAtom a, int opts) {
        for (int i = 0; i < a.getBondCount(); ++i) {
            this.sgroupGraph.removeBond(a.getBond(i));
        }
        this.sgroupGraph.removeAtom(a);
    }

    protected static void removeAtom(Sgroup sg, MolAtom a, int opts) {
        sg.removeAtom(a, opts);
    }

    protected void removeBond(MolBond b) {
        this.sgroupGraph.removeBond(b);
    }

    public final void replaceAtom(MolAtom olda, MolAtom newa) {
        this.replaceAtom(olda, newa, 0);
    }

    public void replaceAtom(MolAtom olda, MolAtom newa, int opts) {
        if ((opts & 2) != 0) {
            this.removeAtom(olda, opts & 0xFFFFFFFD);
        } else {
            int i = this.sgroupGraph.indexOf(olda);
            if (i >= 0) {
                this.sgroupGraph.setAtom(i, newa);
            }
            if (this.parentSgroup != null) {
                this.parentSgroup.replaceAtom(olda, newa, opts);
            }
        }
    }

    public MolBond[] findCrossingBonds() {
        ArrayList<MolBond> vb = new ArrayList<MolBond>();
        for (int i = 0; i < this.sgroupGraph.getAtomCount(); ++i) {
            MolAtom a = this.sgroupGraph.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                if (this.sgroupGraph.contains(aa)) continue;
                vb.add(b);
            }
        }
        MolBond[] crossingBonds = new MolBond[vb.size()];
        vb.toArray(crossingBonds);
        return crossingBonds;
    }

    public boolean isBracketCrossingBond(MolBond bond) {
        DPoint3 p1 = bond.getAtom1().getLocation();
        DPoint3 p2 = bond.getAtom2().getLocation();
        for (MBracket bracket : this.brackets) {
            DPoint3 p3 = bracket.getPoint(0).getLocation();
            DPoint3 p4 = bracket.getPoint(3).getLocation();
            if (Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y)) {
                return true;
            }
            if (bracket.getBracketOrientation() != 5) continue;
            p3 = bracket.getPoint(1).getLocation();
            p4 = bracket.getPoint(2).getLocation();
            if (!Line2D.linesIntersect(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y, p4.x, p4.y)) continue;
            return true;
        }
        return false;
    }

    public MolAtom[] getCrossingAtoms(MolBond[] xbonds) throws IllegalArgumentException {
        MolAtom[] atoms = new MolAtom[xbonds.length];
        for (int i = 0; i < atoms.length; ++i) {
            MolBond b = xbonds[i];
            MolAtom a1 = b.getAtom1();
            MolAtom a2 = b.getAtom2();
            if (this.sgroupGraph.contains(a1)) {
                if (this.sgroupGraph.contains(a2)) {
                    throw new IllegalArgumentException("bond[" + i + "]=" + b + " is not a crossing bond, the group contains both " + a1 + " and " + a2);
                }
                atoms[i] = a1;
                continue;
            }
            if (this.sgroupGraph.contains(a2)) {
                atoms[i] = a2;
                continue;
            }
            throw new IllegalArgumentException("bond[" + i + "]=" + b + " is not a crossing bond, the group contains neither " + a1 + " nor " + a2);
        }
        return atoms;
    }

    protected static void removeGroupedAtom(MoleculeGraph m, MolAtom a, MolBond[] v, int opts) {
        m.removeAtom(a, opts);
        if (v == null) {
            a.removeAllBonds();
        } else {
            for (int i = 0; i < v.length; ++i) {
                a.removeBond(v[i]);
            }
        }
    }

    public boolean areChildSgroupsVisible() {
        return this.getParentSgroup() == null || this.getParentSgroup().areChildSgroupsVisible();
    }

    public final boolean isVisible() {
        return this.getParentSgroup() == null || this.getParentSgroup().areChildSgroupsVisible();
    }

    public boolean isBracketVisible() {
        return this.sgroupType != 10;
    }

    protected void transformByParent(CTransform3D t, boolean incg) {
        if (this.brackets != null) {
            for (int i = 0; i < this.brackets.size(); ++i) {
                this.brackets.get(i).transform(t, 0, null);
            }
        }
    }

    public static void sort(Sgroup[] sgroups, int o) {
        for (int i = 0; i < sgroups.length; ++i) {
            int k = i;
            Sgroup m = sgroups[i];
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int j = i + 1; j < sgroups.length; ++j) {
                    Sgroup g = sgroups[j];
                    if ((o != 1 || m.getParentSgroup() != g) && (o != 2 || g.getParentSgroup() != m)) continue;
                    k = j;
                    m = g;
                    changed = true;
                }
            }
            sgroups[k] = sgroups[i];
            sgroups[i] = m;
        }
    }

    public final String toString() {
        return this.toString(0);
    }

    public String toString(int opts) {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((opts & 1) != 0) {
            s = s + "[" + Sgroup.getAtomSymbolListAsString(this.sgroupGraph.getAtomArray()) + "]";
        }
        return s;
    }

    protected static String getAtomSymbolListAsString(MolAtom[] atoms) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < atoms.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(atoms[i].getSymbol());
            if (atoms[i].getAtno() != 135) continue;
            SgroupAtom sa = (SgroupAtom)atoms[i];
            sb.append("@" + Integer.toString(sa.getSgroup().hashCode(), 16));
        }
        return sb.toString();
    }

    private static boolean hasNullBond(MoleculeGraph g) {
        for (int i = 0; i < g.getAtomCount(); ++i) {
            MolAtom a = g.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                if (a.getBond(j) != null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDescendantOf(Sgroup psg) {
        for (int i = psg.getChildSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = psg.getChildSgroup(i);
            if (sg != this && !this.isDescendantOf(sg)) continue;
            return true;
        }
        return false;
    }

    public boolean isRemovable() {
        return this.sgroupType == 1 && ((MultipleSgroup)this).isExpanded() || this.sgroupType == 0;
    }

    public boolean isSelected(MoleculeGraph sel) {
        if (sel == null) {
            return false;
        }
        for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            if (this.indexOf(sel.getAtom(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean isTotalSelected(MoleculeGraph sel) {
        int i;
        if (sel == null) {
            return false;
        }
        int nAtoms = this.getAtomCount();
        for (i = 0; i < nAtoms && sel.indexOf(this.getAtom(i)) != -1; ++i) {
        }
        if (i != nAtoms) {
            return false;
        }
        for (i = 0; i < this.brackets.size() && this.brackets.get(i).isSelected(); ++i) {
        }
        return i == this.brackets.size();
    }

    public boolean isPartSelected(MoleculeGraph sel) {
        return !this.isTotalSelected(sel) && this.isSelected(sel);
    }

    public void clearObjects() {
        this.brackets = null;
    }

    public void removeObject(MObject mo) {
        if (this.brackets != null) {
            this.brackets.remove(mo);
        }
    }

    public void selectAllObjects(boolean s) {
        if (this.brackets != null) {
            for (int i = 0; i < this.brackets.size(); ++i) {
                this.brackets.get(i).setSelected(s);
            }
        }
    }

    public void addBracket(MBracket bracket) {
        if (this.brackets == null) {
            this.brackets = new ArrayList();
        }
        this.brackets.add(bracket);
    }

    public void initBrackets() {
        if (this.brackets == null) {
            this.brackets = new ArrayList();
        } else {
            this.brackets.clear();
        }
    }

    public int getBracketCount() {
        return this.brackets == null ? 0 : this.brackets.size();
    }

    public ArrayList<MBracket> getBrackets() {
        return this.brackets;
    }

    public int getChargeLocation() {
        return this.attributes;
    }

    public void setChargeLocation(int location) {
        this.attributes = location;
    }

    public int getTotalCharge() {
        int charge = 0;
        for (int i = this.getAtomCount() - 1; i > -1; --i) {
            charge += this.getAtom(i).getCharge();
        }
        return charge;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int i;
        int f;
        oos.writeByte(4);
        oos.writeObject(this.parentMolecule);
        int n = f = this.parentSgroup != null ? 1 : 0;
        if (this.children != null) {
            f = (byte)(f | 2);
        }
        oos.writeByte(f);
        if ((f & 1) != 0) {
            oos.writeObject(this.parentSgroup);
        }
        if ((f & 2) != 0) {
            oos.writeInt(this.children.length);
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                oos.writeObject(this.children[i2]);
            }
        }
        oos.writeByte(this.getType());
        oos.writeByte(this.getSubType());
        oos.writeObject(this.sgroupSubscript);
        oos.writeShort(this.getConnectivity());
        int n2 = this.sgroupGraph.getAtomCount();
        oos.writeInt(n2);
        for (i = 0; i < n2; ++i) {
            oos.writeObject(this.sgroupGraph.getAtom(i));
        }
        oos.writeInt(this.expandedState);
        oos.writeInt(this.attributes);
        n2 = this.brackets == null ? 0 : this.brackets.size();
        oos.writeInt(n2);
        for (i = 0; i < n2; ++i) {
            oos.writeObject(this.brackets.get(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int i;
        byte version = ois.readByte();
        if (version > 4) {
            throw new IOException("Cannot deserialize Sgroup with future version (" + version + ")");
        }
        this.setParentMolecule((Molecule)ois.readObject());
        if (version != 0) {
            byte f = ois.readByte();
            if ((f & 1) != 0) {
                this.parentSgroup = (Sgroup)ois.readObject();
            }
            if ((f & 2) != 0) {
                int n = ois.readInt();
                this.children = new Sgroup[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    this.children[i2] = (Sgroup)ois.readObject();
                }
            }
        }
        this.sgroupType = ois.readByte();
        this.sgroupSubType = ois.readByte();
        this.sgroupSubscript = (String)ois.readObject();
        this.sgroupConnectivity = ois.readShort();
        if (version == 0) {
            ois.readObject();
        }
        int n = ois.readInt();
        this.sgroupGraph = new SelectionMolecule();
        for (i = 0; i < n; ++i) {
            MolAtom a = (MolAtom)ois.readObject();
            this.sgroupGraph.add(a);
        }
        if (!Sgroup.hasNullBond(this.sgroupGraph)) {
            this.sgroupGraph.regenBonds();
        }
        if (version > 1) {
            this.expandedState = ois.readInt();
        }
        if (version > 2) {
            this.attributes = ois.readInt();
        }
        if (version > 3) {
            n = ois.readInt();
            if (n > 0) {
                this.brackets = new ArrayList();
            }
            for (i = 0; i < n; ++i) {
                MBracket bracket = (MBracket)ois.readObject();
                this.brackets.add(bracket);
            }
        }
    }
}

