/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CIPStereoDescriptorIface;
import chemaxon.struc.StereoActivePart;
import java.util.Arrays;

public class TetrahedralStereoDescriptor
implements CIPStereoDescriptorIface {
    private final StereoActivePart[] activeParts = new StereoActivePart[1];
    private final CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue stereoValue;

    public TetrahedralStereoDescriptor(CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue value, StereoActivePart activePart) {
        this.activeParts[0] = activePart;
        this.stereoValue = value;
    }

    @Override
    public StereoActivePart[] getStereoActiveParts() {
        return this.activeParts;
    }

    @Override
    public CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue getStereoValue() {
        return this.stereoValue;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TetrahedralStereoDescriptor)) {
            return false;
        }
        TetrahedralStereoDescriptor other = (TetrahedralStereoDescriptor)o;
        return this.stereoValue == other.getStereoValue() && this.activeParts[0] != null && other.activeParts[0] != null && this.activeParts[0].equals(other.activeParts[0]);
    }

    @Override
    public boolean equalsTo(Object o, int[] map) {
        if (o == null || !(o instanceof TetrahedralStereoDescriptor)) {
            return false;
        }
        TetrahedralStereoDescriptor other = (TetrahedralStereoDescriptor)o;
        if (!this.activeParts[0].equalsTo(other.activeParts[0], map)) {
            return false;
        }
        if (this.stereoValue == CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.UNKNOWN || other.stereoValue == CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.UNKNOWN || this.stereoValue == CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.WIGGLY || other.stereoValue == CIPStereoDescriptorIface.CIPValue.TetrahedralStereoValue.WIGGLY) {
            return this.stereoValue == other.stereoValue;
        }
        int[] mappedLigands = new int[this.activeParts[0].getLigands().length];
        int[] activeParts0_ligands = (int[])this.activeParts[0].getLigands().clone();
        Arrays.sort(activeParts0_ligands);
        for (int i = 0; i < activeParts0_ligands.length; ++i) {
            mappedLigands[i] = map[activeParts0_ligands[i]];
        }
        int inversion = 0;
        for (int i = 0; i < mappedLigands.length - 1; ++i) {
            for (int j = i; j < mappedLigands.length; ++j) {
                if (mappedLigands[i] <= mappedLigands[j]) continue;
                ++inversion;
            }
        }
        if (inversion % 2 == 0) {
            return this.stereoValue == other.stereoValue;
        }
        return this.stereoValue != other.stereoValue;
    }

    public int hashCode() {
        int result = 97;
        switch (this.stereoValue) {
            case ODD: {
                break;
            }
            case EVEN: {
                result *= 2;
                break;
            }
            case UNKNOWN: {
                result *= 3;
                break;
            }
            case WIGGLY: {
                result *= 4;
                break;
            }
        }
        for (StereoActivePart sap : this.activeParts) {
            result += sap.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TH: ");
        sb.append(this.activeParts[0]);
        sb.append(" ");
        sb.append(this.stereoValue);
        return sb.toString();
    }
}

