/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.gearch;

import chemaxon.core.calculations.GraphInvariants;
import chemaxon.core.calculations.SSSR;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.gearch.ConnectedComponents;
import chemaxon.struc.gearch.SmoleculeGearch;
import java.util.ArrayList;
import java.util.List;

public class MoleculeGraphGearch
extends SmoleculeGearch {
    private MoleculeGraph molecule;
    private transient GraphInvariants grinvModule = null;
    protected transient int[] grinv;
    protected int grinvOptions;
    protected transient int nGrinv;

    public MoleculeGraphGearch(MoleculeGraph m) {
        super(m.smol());
        this.molecule = m;
        this.grinv = null;
        this.grinvOptions = m.getGrinvOptions();
        this.nGrinv = 0;
    }

    public MoleculeGraphGearch(MoleculeGraphGearch other, MoleculeGraph m, boolean hasxbond) {
        super(other, m.smol(), hasxbond);
        this.molecule = m;
        if (other.grinv != null) {
            this.grinv = new int[other.grinv.length];
            System.arraycopy(other.grinv, 0, this.grinv, 0, other.grinv.length);
        } else {
            this.grinv = null;
        }
        this.grinvOptions = other.grinvOptions;
        this.nGrinv = other.nGrinv;
    }

    public final int[][] getSSSR() {
        if (this.sssr == null) {
            this.regenSSSR();
        }
        return this.sssr;
    }

    public final int[][] getCSSR() {
        if (this.cssr == null) {
            this.regenCSSR();
            this.cssr = this.sssrModule.getRings();
        }
        return this.cssr;
    }

    protected synchronized void regenCSSR() {
        if (this.sssrModule == null) {
            this.sssrModule = new SSSR();
        }
        this.sssrModule.setGraph(this.molecule.smol());
        this.sssrModule.startRingSearch(true);
        this.cssr = this.sssrModule.getRings();
    }

    public final int[][] getSSSRBonds() {
        this.regenSSSR();
        int[][] sssrBondIdxes = this.sssrModule.getBondIndexes();
        return sssrBondIdxes;
    }

    public int[][] getSSSRIdxesForAtoms() {
        int i;
        if (this.sssr2idx != null) {
            return this.sssr2idx;
        }
        if (this.sssr == null) {
            this.sssr = this.getSSSR();
        }
        int sssrl = this.sssr.length;
        int nc = this.molecule.getAtomCount();
        this.sssr2idx = new int[nc][];
        int[] rl = new int[nc];
        for (i = 0; i < sssrl; ++i) {
            int[] r = this.sssr[i];
            int ringl = r.length;
            for (int j = 0; j < ringl; ++j) {
                int idx;
                int n = idx = r[j];
                rl[n] = rl[n] + 1;
            }
        }
        for (i = 0; i < nc; ++i) {
            this.sssr2idx[i] = new int[rl[i]];
            rl[i] = 0;
        }
        for (i = 0; i < sssrl; ++i) {
            for (int idx : this.sssr[i]) {
                this.sssr2idx[idx][rl[idx]] = i;
                int n = idx;
                rl[n] = rl[n] + 1;
            }
        }
        return this.sssr2idx;
    }

    public int[] getSSSRBondSet() {
        this.regenSSSR();
        return this.sssrModule.getBondSetInt();
    }

    public long[] getSSSRBondSetInLong() {
        if (this.sssrBondSetInLong == null) {
            this.regenSSSR();
            this.sssrBondSetInLong = this.sssrModule.getBondSet();
        }
        return this.sssrBondSetInLong;
    }

    public int[] getSmallestRingSizeForIdx() {
        if (this.sssrl2idx != null) {
            return this.sssrl2idx;
        }
        if (this.sssr == null) {
            this.sssr = this.getSSSR();
        }
        this.sssrl2idx = new int[this.molecule.getAtomCount()];
        for (int[] r : this.sssr) {
            int rl = r.length;
            for (int j = 0; j < rl; ++j) {
                int idx = r[j];
                this.sssrl2idx[idx] = this.sssrl2idx[idx] == 0 || this.sssrl2idx[idx] > rl ? rl : this.sssrl2idx[idx];
            }
        }
        return this.sssrl2idx;
    }

    public boolean isRingBond(int idx) {
        if (this.sssrModule == null || this.sssrBondSetInLong == null) {
            this.getSSSRBondSetInLong();
        }
        return (this.sssrBondSetInLong[idx / 64] & 1L << 63 - idx % 64) != 0L;
    }

    protected MoleculeGraph getMoleculeGraphForGrinv() {
        return this.molecule;
    }

    @Override
    public final synchronized int getGrinv(int[] gi, int options) {
        MoleculeGraph mol = this.getMoleculeGraphForGrinv();
        if (this.grinv != null && (this.grinvOptions & 0x27) == (options & 0x27)) {
            if (gi != null) {
                System.arraycopy(this.grinv, 0, gi, 0, this.grinv.length);
            }
            return this.nGrinv;
        }
        if (gi == null) {
            gi = new int[mol.getAtomCount()];
        }
        GraphInvariants gm = this.getGrinvModule();
        Object[] args = new Object[]{mol, gi, new Integer(options)};
        int grinvNum = gm.calculate(mol, gi, options);
        if ((options & 8) == 0) {
            if (this.grinv == null) {
                this.grinv = new int[mol.getAtomCount()];
            }
            System.arraycopy(gi, 0, this.grinv, 0, this.grinv.length);
            this.grinvOptions = options;
            this.nGrinv = grinvNum;
        }
        return grinvNum;
    }

    public final int[] getGrinv() {
        if (this.grinv == null) {
            this.getGrinv(null, this.grinvOptions);
        }
        return this.grinv;
    }

    public void clearResults() {
        for (int i = 0; i < this.connComps.length; ++i) {
            this.connComps[i] = null;
        }
        this.grinv = null;
        this.nGrinv = 0;
        this.sssr = null;
        this.cssr = null;
        this.sssrl2idx = null;
        this.sssr2idx = null;
    }

    public final Object saveCache() {
        ArrayList<Object> list = new ArrayList<Object>();
        this.saveCache(list);
        return list;
    }

    public final void restoreCache(Object list) {
        List l = (List)list;
        this.restoreCache(l);
    }

    protected void saveCache(List<Object> list) {
        for (int i = 0; i < this.connComps.length; ++i) {
            list.add(this.connComps[i]);
        }
        list.add(this.grinv);
        list.add(new Integer(this.nGrinv));
        list.add(this.sssr);
        list.add(this.cssr);
        list.add(this.sssrBondSetInLong);
    }

    protected int restoreCache(List<Object> list) {
        int k = 0;
        for (int i = 0; i < this.connComps.length; ++i) {
            this.connComps[i] = (ConnectedComponents)list.get(i);
            ++k;
        }
        this.grinv = (int[])list.get(k++);
        this.nGrinv = (Integer)list.get(k++);
        this.sssr = (int[][])list.get(k++);
        this.cssr = (int[][])list.get(k++);
        this.sssrBondSetInLong = (long[])list.get(k++);
        return k;
    }

    protected boolean isGrinvCCValid() {
        return true;
    }

    @Override
    public void resetGrinv() {
        super.resetGrinv();
        this.grinv = null;
        this.nGrinv = 0;
    }

    public void clonelesscopy(MoleculeGraphGearch mgg) {
        mgg.grinv = this.grinv;
        mgg.nGrinv = this.nGrinv;
        mgg.grinvOptions = this.grinvOptions;
    }

    public void setGrinvOptions(int opts) {
        this.grinvOptions = opts;
    }

    public int getGrinvOptions() {
        return this.grinvOptions;
    }

    private GraphInvariants getGrinvModule() {
        GraphInvariants m = this.grinvModule;
        if (m == null) {
            this.grinvModule = m = new GraphInvariants();
        }
        return m;
    }

    public MoleculeGraphGearch cloneMoleculeGraphGearch(MoleculeGraph m, boolean hasxbond) {
        return new MoleculeGraphGearch(this, m, hasxbond);
    }

    public void clear(int opts) {
        for (int i = 0; i < this.connComps.length; ++i) {
            this.connComps[i] = null;
        }
        if (opts == 0 || (opts & 4) != 0) {
            this.grinvModule = null;
            this.grinv = null;
            this.nGrinv = 0;
        }
        if (opts == 0 || (opts & 0x10) != 0) {
            this.sssrModule = null;
            this.sssrBondSetInLong = null;
        }
    }

    public int mergeFrags(int id1, int id2, int fragmentationType) {
        int connCompid2;
        if (id1 == -1 || id2 == -1) {
            return -1;
        }
        int connCompid1 = this.connComps[fragmentationType].getCC(id1);
        if (connCompid1 != (connCompid2 = this.connComps[fragmentationType].getCC(id2))) {
            return this.connComps[fragmentationType].mergeFrags(connCompid1, connCompid2);
        }
        return -1;
    }
}

