/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MPolyline;
import java.util.ArrayList;

public class MAssigner
extends MPolyline {
    private int order = 0;

    public MAssigner(MPoint p1, MPoint p2) {
        super(p1, p2);
        this.setArrowWidth(MPolyline.HEAD, 0.3);
        this.setArrowLength(MPolyline.HEAD, 0.5);
    }

    public MAssigner() {
        this.setArrowWidth(MPolyline.HEAD, 0.3);
        this.setArrowLength(MPolyline.HEAD, 0.5);
    }

    protected MAssigner(MAssigner a) {
        super(a);
        this.order = a.order;
    }

    @Override
    public Object clone() {
        return new MAssigner(this);
    }

    public void setOrder(int i) {
        this.order = i;
    }

    public int getOrder() {
        return this.order;
    }

    public MolAtom[] getAssignedAtoms() {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        for (int i = 0; i < this.getPointCount(); ++i) {
            MPoint p = this.getPoint(i);
            if (!(p instanceof MAtomSetPoint)) continue;
            MolAtom[] atoms = ((MAtomSetPoint)p).getAtoms();
            for (int j = 0; j < atoms.length; ++j) {
                list.add(atoms[j]);
            }
        }
        MolAtom[] atomArray = new MolAtom[list.size()];
        list.toArray(atomArray);
        return atomArray;
    }

    public void copyProperties(MAssigner l) {
        super.copyProperties(l);
        l.order = this.order;
    }
}

