/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class MAtomSetPoint
extends MPoint {
    private static final long serialVersionUID = 5932389976054063500L;
    private transient MultiFaceAtom[] atoms;
    private transient double[] weights = null;
    private transient double sumWeights = 0.0;

    public MAtomSetPoint() {
        super(0.0, 0.0, 0.0);
        this.atoms = new MultiFaceAtom[0];
    }

    public MAtomSetPoint(MolAtom[] a) {
        super(0.0, 0.0, 0.0);
        this.setAtoms(a);
    }

    public MAtomSetPoint(MAtomSetPoint p) {
        super(p);
        this.atoms = new MultiFaceAtom[p.atoms.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i] = new MultiFaceAtom(p.atoms[i].faces);
        }
        this.setWeights(p.weights);
    }

    public boolean equals(MAtomSetPoint o) {
        if (this.atoms.length != o.atoms.length) {
            return false;
        }
        for (int i = 0; i < this.atoms.length; ++i) {
            if (this.atoms[i].equals(o.atoms[i])) continue;
            return false;
        }
        return super.equals(o);
    }

    @Override
    public boolean equals(MPoint o) {
        return o instanceof MAtomSetPoint && this.equals((MAtomSetPoint)o);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MAtomSetPoint && this.equals((MAtomSetPoint)o);
    }

    @Override
    public Object clone() {
        return new MAtomSetPoint(this);
    }

    public void setAtoms(MolAtom[] a) {
        this.atoms = new MultiFaceAtom[a.length];
        for (int i = 0; i < a.length; ++i) {
            this.atoms[i] = new MultiFaceAtom(a[i]);
        }
    }

    public MolAtom[] getAtoms() {
        MolAtom[] a = new MolAtom[this.atoms.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.atoms[i].getVisible();
        }
        return a;
    }

    @Override
    public boolean containsAtom(MolAtom a) {
        for (int i = 0; i < this.atoms.length; ++i) {
            if (!this.atoms[i].contains(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void replaceAtom(MolAtom orig, MolAtom a) {
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i].replace(orig, a);
        }
    }

    @Override
    public void getLocation(DPoint3 q, CTransform3D trot) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] ww = this.weights;
        if (ww != null) {
            for (int i = 0; i < this.atoms.length; ++i) {
                MolAtom a = this.atoms[i].getVisible();
                double w = i < ww.length ? ww[i] / this.sumWeights : 0.0;
                x += w * a.getX();
                y += w * a.getY();
                z += w * a.getZ();
            }
        } else {
            for (int i = 0; i < this.atoms.length; ++i) {
                MolAtom a = this.atoms[i].getVisible();
                x += a.getX();
                y += a.getY();
                z += a.getZ();
            }
            x /= (double)this.atoms.length;
            y /= (double)this.atoms.length;
            z /= (double)this.atoms.length;
        }
        q.x = x;
        q.y = y;
        q.z = z;
        if (trot != null) {
            trot.transform(q);
        }
    }

    @Override
    public void setLocation(DPoint3 p, CTransform3D trot) {
        DPoint3 myloc = this.getLocation(null);
        if (trot != null) {
            CTransform3D tinvrot = new CTransform3D(trot);
            tinvrot.invert();
            p = new DPoint3(p);
            tinvrot.transform(p);
        }
        double dx = p.x - myloc.x;
        double dy = p.y - myloc.y;
        double dz = p.z - myloc.z;
        for (int i = 0; i < this.atoms.length; ++i) {
            MolAtom a = this.atoms[i].getVisible();
            a.setXYZ(a.getX() + dx, a.getY() + dy, a.getZ() + dz);
        }
    }

    @Override
    public MPoint getPoint(int i) {
        return new MAtomSetPoint(this);
    }

    public double[] getWeights() {
        double[] w = this.weights;
        if (w != null) {
            double[] w2 = new double[w.length];
            System.arraycopy(w, 0, w2, 0, w.length);
            return w2;
        }
        return null;
    }

    public void setWeights(double[] w) {
        if (w != null) {
            double sum = 0.0;
            this.weights = new double[w.length];
            System.arraycopy(w, 0, this.weights, 0, w.length);
            for (int i = 0; i < w.length; ++i) {
                sum += w[i];
            }
            this.sumWeights = sum;
        } else {
            this.weights = null;
            this.sumWeights = 0.0;
        }
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
    }

    @Override
    public boolean isTransformable() {
        return false;
    }

    @Override
    public boolean checkValidity(MDocument doc, Collection<MolAtom> invec) {
        boolean ret = true;
        for (int i = 0; i < this.atoms.length; ++i) {
            boolean found = false;
            MolAtom a = this.atoms[i].getVisible();
            for (int j = 0; j < doc.getObjectCount() && !found; ++j) {
                MObject mo = doc.getObject(j);
                found = mo instanceof MChemicalStruct && mo.containsAtom(a);
            }
            if (found) continue;
            if (invec != null && !invec.contains(a)) {
                invec.add(a);
            }
            ret = false;
        }
        return ret;
    }

    @Override
    public void finishCloning(MDocument olddoc, MDocument newdoc) {
        block0: for (int i = 0; i < this.atoms.length; ++i) {
            for (int j = 0; j < olddoc.getObjectCount(); ++j) {
                MObject mo = olddoc.getObject(j);
                if (!(mo instanceof MChemicalStruct)) continue;
                MoleculeGraph m = ((MChemicalStruct)mo).getMoleculeGraph();
                int k = (m = m.getGraphUnion()).indexOf(this.atoms[i].getVisible());
                if (k < 0) continue;
                MChemicalStruct mcs = (MChemicalStruct)newdoc.getObject(j);
                m = mcs.getMoleculeGraph().getGraphUnion();
                MolAtom a = m.getAtom(k);
                this.atoms[i] = new MultiFaceAtom(a);
                continue block0;
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(2);
        int f = this.weights != null ? 1 : 0;
        oos.writeByte(f);
        oos.writeInt(this.atoms.length);
        for (int i = 0; i < this.atoms.length; ++i) {
            oos.writeObject(this.atoms[i]);
        }
        if ((f & 1) != 0) {
            int n = this.weights.length;
            oos.writeInt(n);
            for (int i = 0; i < n; ++i) {
                oos.writeDouble(this.weights[i]);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 2) {
            throw new IOException("Cannot deserialize point object with future version (" + version + ")");
        }
        byte f = 0;
        if (version >= 2) {
            f = ois.readByte();
        }
        int n = ois.readInt();
        this.atoms = new MultiFaceAtom[n];
        for (int i = 0; i < n; ++i) {
            this.atoms[i] = version == 0 ? new MultiFaceAtom((MolAtom)ois.readObject()) : (MultiFaceAtom)ois.readObject();
        }
        if ((f & 1) != 0) {
            n = ois.readInt();
            double[] w = new double[n];
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                w[i] = ois.readDouble();
                sum += w[i];
            }
            this.weights = w;
            this.sumWeights = sum;
        } else {
            this.weights = null;
            this.sumWeights = 0.0;
        }
    }

    static class MultiFaceAtom
    implements Externalizable {
        private transient MolAtom[] faces;

        public MultiFaceAtom(MolAtom a) {
            if (MultiFaceAtom.getSgroupOf(a) != null) {
                this.initSgroupAtom(a);
            } else {
                this.faces = new MolAtom[1];
                this.faces[0] = a;
            }
        }

        public MultiFaceAtom(MolAtom[] a) {
            this.faces = new MolAtom[a.length];
            System.arraycopy(a, 0, this.faces, 0, a.length);
        }

        public MolAtom getVisible() {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i].getParent() == null) continue;
                return this.faces[i];
            }
            throw new RuntimeException("MultiFaceAtom does not have any visible face");
        }

        public boolean contains(MolAtom a) {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] != a) continue;
                return true;
            }
            return false;
        }

        public void replace(MolAtom orig, MolAtom a) {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] != orig) continue;
                this.faces[i] = a;
            }
        }

        public boolean equals(MultiFaceAtom a) {
            int n = this.faces.length;
            if (n != a.faces.length) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                boolean found = false;
                for (int j = 0; j < n; ++j) {
                    if (a.faces[j] != this.faces[i]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            return o == this || o != null && o instanceof MultiFaceAtom && this.equals((MultiFaceAtom)o);
        }

        private void initSgroupAtom(MolAtom a) {
            SuperatomSgroup ssg = MultiFaceAtom.getSgroupOf(a);
            this.faces = new MolAtom[2];
            this.faces[0] = a;
            this.faces[1] = ssg.isContracted() ? ssg.findAttachAtom() : ssg.getSuperAtom();
        }

        private static SuperatomSgroup getSgroupOf(MolAtom a) {
            Molecule m;
            Sgroup sg;
            MoleculeGraph g = a.getParent();
            if (g instanceof Molecule && (sg = (m = (Molecule)g).findSgroupOf(a)) instanceof SuperatomSgroup) {
                return (SuperatomSgroup)sg;
            }
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeByte((byte)this.faces.length);
            for (int i = 0; i < this.faces.length; ++i) {
                out.writeObject(this.faces[i]);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte version = in.readByte();
            if (version > 0) {
                throw new IOException("Cannot deserialize MultiFacePoint object with future version (" + version + ")");
            }
            byte n = in.readByte();
            this.faces = new MolAtom[n];
            for (int i = 0; i < this.faces.length; ++i) {
                this.faces[i] = (MolAtom)in.readObject();
            }
        }
    }
}

